/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzdyp;
import com.google.android.gms.internal.zzdyq;
import com.google.android.gms.internal.zzdyt;
import com.google.android.gms.internal.zzdzb;
import com.google.android.gms.internal.zzdze;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class zzdyo<K, V>
extends zzdyq<K, V> {
    private final K[] zzmhk;
    private final V[] zzmhl;
    private final Comparator<K> zzmhm;

    public static <A, B, C> zzdyo<A, C> zza(List<A> list, Map<B, C> map, zzdyt<A, B> zzdyt2, Comparator<A> comparator) {
        Collections.sort(list, comparator);
        int n = list.size();
        Object[] objectArray = new Object[n];
        Object[] objectArray2 = new Object[n];
        int n2 = 0;
        for (A a : list) {
            objectArray[n2] = a;
            C c = map.get(zzdyt2.zzbj(a));
            objectArray2[n2] = c;
            ++n2;
        }
        return new zzdyo<Object, Object>(comparator, objectArray, objectArray2);
    }

    public zzdyo(Comparator<K> comparator) {
        this.zzmhk = new Object[0];
        this.zzmhl = new Object[0];
        this.zzmhm = comparator;
    }

    private zzdyo(Comparator<K> comparator, K[] KArray, V[] VArray) {
        this.zzmhk = KArray;
        this.zzmhl = VArray;
        this.zzmhm = comparator;
    }

    @Override
    public final boolean containsKey(K k) {
        return this.zzbi(k) != -1;
    }

    @Override
    public final V get(K k) {
        int n = this.zzbi(k);
        if (n != -1) {
            return this.zzmhl[n];
        }
        return null;
    }

    @Override
    public final zzdyq<K, V> zzbe(K k) {
        int n = this.zzbi(k);
        if (n == -1) {
            return this;
        }
        K[] KArray = zzdyo.zza(this.zzmhk, n);
        V[] VArray = zzdyo.zza(this.zzmhl, n);
        return new zzdyo<K, V>(this.zzmhm, KArray, VArray);
    }

    @Override
    public final zzdyq<K, V> zzf(K k, V v) {
        int n = this.zzbi(k);
        if (n != -1) {
            if (this.zzmhk[n] == k && this.zzmhl[n] == v) {
                return this;
            }
            K[] KArray = zzdyo.zzb(this.zzmhk, n, k);
            V[] VArray = zzdyo.zzb(this.zzmhl, n, v);
            return new zzdyo<K, V>(this.zzmhm, KArray, VArray);
        }
        if (this.zzmhk.length > 25) {
            HashMap<K, V> hashMap = new HashMap<K, V>(this.zzmhk.length + 1);
            for (int i = 0; i < this.zzmhk.length; ++i) {
                hashMap.put(this.zzmhk[i], this.zzmhl[i]);
            }
            hashMap.put(k, v);
            return zzdze.zzb(hashMap, this.zzmhm);
        }
        int n2 = this.zzbh(k);
        K[] KArray = zzdyo.zza(this.zzmhk, n2, k);
        V[] VArray = zzdyo.zza(this.zzmhl, n2, v);
        return new zzdyo<K, V>(this.zzmhm, KArray, VArray);
    }

    @Override
    public final K zzbri() {
        if (this.zzmhk.length > 0) {
            return this.zzmhk[0];
        }
        return null;
    }

    @Override
    public final K zzbrj() {
        if (this.zzmhk.length > 0) {
            return this.zzmhk[this.zzmhk.length - 1];
        }
        return null;
    }

    @Override
    public final int size() {
        return this.zzmhk.length;
    }

    @Override
    public final boolean isEmpty() {
        return this.zzmhk.length == 0;
    }

    @Override
    public final void zza(zzdzb<K, V> zzdzb2) {
        for (int i = 0; i < this.zzmhk.length; ++i) {
            zzdzb2.zzg(this.zzmhk[i], this.zzmhl[i]);
        }
    }

    private final Iterator<Map.Entry<K, V>> zzj(int n, boolean bl) {
        return new zzdyp(this, n, bl);
    }

    @Override
    public final Iterator<Map.Entry<K, V>> iterator() {
        return this.zzj(0, false);
    }

    @Override
    public final Iterator<Map.Entry<K, V>> zzbf(K k) {
        int n = this.zzbh(k);
        return this.zzj(n, false);
    }

    @Override
    public final Iterator<Map.Entry<K, V>> zzbrk() {
        return this.zzj(this.zzmhk.length - 1, true);
    }

    @Override
    public final K zzbg(K k) {
        int n = this.zzbi(k);
        if (n == -1) {
            throw new IllegalArgumentException("Can't find predecessor of nonexistent key");
        }
        if (n > 0) {
            return this.zzmhk[n - 1];
        }
        return null;
    }

    @Override
    public final int indexOf(K k) {
        return this.zzbi(k);
    }

    @Override
    public final Comparator<K> getComparator() {
        return this.zzmhm;
    }

    private static <T> T[] zza(T[] TArray, int n) {
        int n2 = TArray.length - 1;
        Object[] objectArray = new Object[n2];
        System.arraycopy(TArray, 0, objectArray, 0, n);
        System.arraycopy(TArray, n + 1, objectArray, n, n2 - n);
        return objectArray;
    }

    private static <T> T[] zza(T[] TArray, int n, T t) {
        int n2 = TArray.length + 1;
        Object[] objectArray = new Object[n2];
        System.arraycopy(TArray, 0, objectArray, 0, n);
        objectArray[n] = t;
        System.arraycopy(TArray, n, objectArray, n + 1, n2 - n - 1);
        return objectArray;
    }

    private static <T> T[] zzb(T[] TArray, int n, T t) {
        int n2 = TArray.length;
        Object[] objectArray = new Object[n2];
        System.arraycopy(TArray, 0, objectArray, 0, n2);
        objectArray[n] = t;
        return objectArray;
    }

    private final int zzbh(K k) {
        int n;
        for (n = 0; n < this.zzmhk.length && this.zzmhm.compare(this.zzmhk[n], k) < 0; ++n) {
        }
        return n;
    }

    private final int zzbi(K k) {
        int n = 0;
        K[] KArray = this.zzmhk;
        int n2 = this.zzmhk.length;
        for (int i = 0; i < n2; ++i) {
            K k2 = KArray[i];
            if (this.zzmhm.compare(k, k2) == 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    static /* synthetic */ Object[] zza(zzdyo zzdyo2) {
        return zzdyo2.zzmhk;
    }

    static /* synthetic */ Object[] zzb(zzdyo zzdyo2) {
        return zzdyo2.zzmhl;
    }
}

