/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzbe;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.common.internal.zzby;
import com.google.android.gms.common.util.zzt;
import com.google.firebase.zzc;
import java.util.Arrays;

public final class FirebaseOptions {
    private final String zzbVh;
    private final String zzaoM;
    private final String zzbVi;
    private final String zzbVj;
    private final String zzbVk;
    private final String zzbVl;
    private final String zzbVm;

    private FirebaseOptions(@NonNull String string, @NonNull String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6, @Nullable String string7) {
        zzbo.zza((!zzt.zzcL((String)string) ? 1 : 0) != 0, (Object)"ApplicationId must be set.");
        this.zzaoM = string;
        this.zzbVh = string2;
        this.zzbVi = string3;
        this.zzbVj = string4;
        this.zzbVk = string5;
        this.zzbVl = string6;
        this.zzbVm = string7;
    }

    public static FirebaseOptions fromResource(Context context) {
        zzby zzby2 = new zzby(context);
        String string = zzby2.getString("google_app_id");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return new FirebaseOptions(string, zzby2.getString("google_api_key"), zzby2.getString("firebase_database_url"), zzby2.getString("ga_trackingId"), zzby2.getString("gcm_defaultSenderId"), zzby2.getString("google_storage_bucket"), zzby2.getString("project_id"));
    }

    public final String getApiKey() {
        return this.zzbVh;
    }

    public final String getApplicationId() {
        return this.zzaoM;
    }

    public final String getDatabaseUrl() {
        return this.zzbVi;
    }

    public final String getGcmSenderId() {
        return this.zzbVk;
    }

    public final String getStorageBucket() {
        return this.zzbVl;
    }

    public final String getProjectId() {
        return this.zzbVm;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof FirebaseOptions)) {
            return false;
        }
        FirebaseOptions firebaseOptions = (FirebaseOptions)object;
        return zzbe.equal((Object)this.zzaoM, (Object)firebaseOptions.zzaoM) && zzbe.equal((Object)this.zzbVh, (Object)firebaseOptions.zzbVh) && zzbe.equal((Object)this.zzbVi, (Object)firebaseOptions.zzbVi) && zzbe.equal((Object)this.zzbVj, (Object)firebaseOptions.zzbVj) && zzbe.equal((Object)this.zzbVk, (Object)firebaseOptions.zzbVk) && zzbe.equal((Object)this.zzbVl, (Object)firebaseOptions.zzbVl) && zzbe.equal((Object)this.zzbVm, (Object)firebaseOptions.zzbVm);
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzaoM, this.zzbVh, this.zzbVi, this.zzbVj, this.zzbVk, this.zzbVl, this.zzbVm});
    }

    public final String toString() {
        return zzbe.zzt((Object)this).zzg("applicationId", (Object)this.zzaoM).zzg("apiKey", (Object)this.zzbVh).zzg("databaseUrl", (Object)this.zzbVi).zzg("gcmSenderId", (Object)this.zzbVk).zzg("storageBucket", (Object)this.zzbVl).zzg("projectId", (Object)this.zzbVm).toString();
    }

    /* synthetic */ FirebaseOptions(String string, String string2, String string3, String string4, String string5, String string6, String string7, zzc zzc2) {
        this(string, string2, string3, string4, string5, string6, string7);
    }

    public static final class Builder {
        private String zzbVh;
        private String zzaoM;
        private String zzbVi;
        private String zzbVj;
        private String zzbVk;
        private String zzbVl;
        private String zzbVm;

        public Builder() {
        }

        public Builder(FirebaseOptions firebaseOptions) {
            this.zzaoM = firebaseOptions.zzaoM;
            this.zzbVh = firebaseOptions.zzbVh;
            this.zzbVi = firebaseOptions.zzbVi;
            this.zzbVj = firebaseOptions.zzbVj;
            this.zzbVk = firebaseOptions.zzbVk;
            this.zzbVl = firebaseOptions.zzbVl;
            this.zzbVm = firebaseOptions.zzbVm;
        }

        public final Builder setApiKey(@NonNull String string) {
            this.zzbVh = zzbo.zzh((String)string, (Object)"ApiKey must be set.");
            return this;
        }

        public final Builder setApplicationId(@NonNull String string) {
            this.zzaoM = zzbo.zzh((String)string, (Object)"ApplicationId must be set.");
            return this;
        }

        public final Builder setDatabaseUrl(@Nullable String string) {
            this.zzbVi = string;
            return this;
        }

        public final Builder setGcmSenderId(@Nullable String string) {
            this.zzbVk = string;
            return this;
        }

        public final Builder setStorageBucket(@Nullable String string) {
            this.zzbVl = string;
            return this;
        }

        public final Builder setProjectId(@Nullable String string) {
            this.zzbVm = string;
            return this;
        }

        public final FirebaseOptions build() {
            return new FirebaseOptions(this.zzaoM, this.zzbVh, this.zzbVi, this.zzbVj, this.zzbVk, this.zzbVl, this.zzbVm, null);
        }
    }
}

