/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.firebase-auth-api.zzadg;
import com.google.android.gms.internal.firebase-auth-api.zzaep;
import com.google.android.gms.internal.firebase-auth-api.zzafb;
import com.google.android.gms.internal.firebase-auth-api.zzagh;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.android.play.core.integrity.IntegrityManager;
import com.google.android.play.core.integrity.IntegrityManagerFactory;
import com.google.android.play.core.integrity.IntegrityTokenResponse;
import com.google.android.recaptcha.RecaptchaAction;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseAuthException;
import com.google.firebase.auth.FirebaseAuthMissingActivityForRecaptchaException;
import com.google.firebase.auth.internal.zzae;
import com.google.firebase.auth.internal.zzav;
import com.google.firebase.auth.internal.zzb;
import com.google.firebase.auth.internal.zzbm;
import com.google.firebase.auth.internal.zzc;
import com.google.firebase.auth.internal.zzcf;
import com.google.firebase.auth.internal.zzd;
import com.google.firebase.auth.internal.zze;
import com.google.firebase.auth.internal.zzf;
import com.google.firebase.auth.internal.zzg;
import com.google.firebase.auth.internal.zzh;
import com.google.firebase.auth.internal.zzi;
import com.google.firebase.auth.internal.zzk;
import com.google.firebase.auth.internal.zzo;

public class zza {
    private static final String zza = zza.class.getSimpleName();
    private static final zza zzb = new zza();
    private String zzc;

    public final Task<zzh> zza(FirebaseAuth firebaseAuth, @Nullable String string, @Nullable Activity activity, boolean bl, boolean bl2, boolean bl3, RecaptchaAction recaptchaAction) {
        RecaptchaAction recaptchaAction2 = recaptchaAction;
        zzcf zzcf2 = zzcf.zzc();
        boolean bl4 = bl3;
        boolean bl5 = bl2;
        boolean bl6 = bl;
        Activity activity2 = activity;
        String string2 = string;
        zzae zzae2 = (zzae)firebaseAuth.getFirebaseAuthSettings();
        FirebaseAuth firebaseAuth2 = firebaseAuth;
        zza zza2 = this;
        if (zzafb.zza(firebaseAuth2.getApp()) || zzae2.zze()) {
            return Tasks.forResult((Object)((zzk)new zzo()).zza());
        }
        boolean bl7 = zzae2.zzc();
        boolean bl8 = bl5;
        Log.i((String)zza, (String)("ForceRecaptchaV2Flow from phoneAuthOptions = " + bl8 + ", ForceRecaptchav2Flow from firebaseSettings = " + bl7));
        boolean bl9 = bl5 || zzae2.zzc();
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Task<String> task = zzcf2.zzb();
        if (task != null) {
            if (task.isSuccessful()) {
                return Tasks.forResult((Object)((zzk)new zzo()).zzc((String)task.getResult()).zza());
            }
            String string3 = task.getException().getMessage();
            Log.e((String)zza, (String)("Error in previous reCAPTCHAV2 flow: " + string3));
            Log.e((String)zza, (String)"Continuing with application verification as normal");
        }
        if (bl9 || bl4) {
            zza2.zza(firebaseAuth2, string2, activity2, bl6, bl9, zzcf2, (TaskCompletionSource<zzh>)taskCompletionSource);
        } else {
            zzcf zzcf3 = zzcf2;
            boolean bl10 = bl6;
            Activity activity3 = activity2;
            String string4 = string2;
            RecaptchaAction recaptchaAction3 = recaptchaAction2;
            FirebaseAuth firebaseAuth3 = firebaseAuth2;
            TaskCompletionSource taskCompletionSource2 = taskCompletionSource;
            zza zza3 = zza2;
            firebaseAuth2.initializeRecaptchaConfig().addOnCompleteListener((OnCompleteListener)new zzc(zza3, taskCompletionSource2, firebaseAuth3, recaptchaAction3, string4, activity3, bl10, false, zzcf3));
        }
        return taskCompletionSource.getTask();
    }

    public static zza zza() {
        return zzb;
    }

    static /* bridge */ /* synthetic */ String zzb() {
        return zza;
    }

    static /* bridge */ /* synthetic */ void zza(zza zza2, String string) {
        zza2.zzc = string;
    }

    static /* bridge */ /* synthetic */ void zza(zza zza2, FirebaseAuth firebaseAuth, String string, Activity activity, boolean bl, boolean bl2, zzcf zzcf2, TaskCompletionSource taskCompletionSource) {
        zza2.zza(firebaseAuth, string, activity, bl, bl2, zzcf2, (TaskCompletionSource<zzh>)taskCompletionSource);
    }

    private zza() {
    }

    private final void zza(FirebaseAuth firebaseAuth, zzcf zzcf2, Activity activity, TaskCompletionSource<zzh> taskCompletionSource) {
        Task task;
        if (activity == null) {
            taskCompletionSource.setException((Exception)((Object)new FirebaseAuthMissingActivityForRecaptchaException()));
            return;
        }
        FirebaseAuth firebaseAuth2 = firebaseAuth;
        zzbm.zza(firebaseAuth.getApp().getApplicationContext(), firebaseAuth2);
        Activity activity2 = activity;
        FirebaseAuth firebaseAuth3 = firebaseAuth;
        Preconditions.checkNotNull((Object)activity2);
        firebaseAuth2 = new TaskCompletionSource();
        if (!zzav.zza().zza(activity2, (TaskCompletionSource<String>)firebaseAuth2)) {
            task = Tasks.forException((Exception)zzadg.zza(new Status(17057, "reCAPTCHA flow already in progress")));
        } else {
            new zzaep(firebaseAuth3, activity2).zza();
            task = firebaseAuth2.getTask();
        }
        task.addOnSuccessListener((OnSuccessListener)new zzi(this, taskCompletionSource)).addOnFailureListener((OnFailureListener)new zzf(this, taskCompletionSource));
    }

    final /* synthetic */ void zza(TaskCompletionSource taskCompletionSource, FirebaseAuth firebaseAuth, zzcf zzcf2, Activity activity, Task task) {
        String string;
        if (task.isSuccessful() && task.getResult() != null && !TextUtils.isEmpty((CharSequence)((IntegrityTokenResponse)task.getResult()).token())) {
            taskCompletionSource.setResult((Object)((zzk)new zzo()).zza(((IntegrityTokenResponse)task.getResult()).token()).zza());
            return;
        }
        String string2 = string = task.getException() == null ? "" : task.getException().getMessage();
        Log.e((String)zza, (String)("Play Integrity Token fetch failed, falling back to Recaptcha" + string2));
        this.zza(firebaseAuth, zzcf2, activity, (TaskCompletionSource<zzh>)taskCompletionSource);
    }

    final /* synthetic */ void zza(TaskCompletionSource taskCompletionSource, FirebaseAuth firebaseAuth, RecaptchaAction recaptchaAction, String string, Activity activity, boolean bl, boolean bl2, zzcf zzcf2, Task task) {
        if (!task.isSuccessful()) {
            String string2 = task.getException().getMessage();
            Log.e((String)zza, (String)("Failed to initialize reCAPTCHA config: " + string2));
        }
        zzcf zzcf3 = zzcf2;
        boolean bl3 = bl2;
        boolean bl4 = bl;
        Activity activity2 = activity;
        String string3 = string;
        RecaptchaAction recaptchaAction2 = recaptchaAction;
        FirebaseAuth firebaseAuth2 = firebaseAuth;
        TaskCompletionSource taskCompletionSource2 = taskCompletionSource;
        zza zza2 = this;
        if (firebaseAuth2.zzb() != null && firebaseAuth2.zzb().zzb("PHONE_PROVIDER")) {
            firebaseAuth2.zzb().zza(firebaseAuth2.getTenantId(), false, recaptchaAction2).addOnSuccessListener((OnSuccessListener)new zzd(zza2, taskCompletionSource2)).addOnFailureListener((OnFailureListener)new zze(zza2, firebaseAuth2, string3, activity2, bl4, bl3, zzcf3, taskCompletionSource2));
            return;
        }
        zza2.zza(firebaseAuth2, string3, activity2, bl4, bl3, zzcf3, (TaskCompletionSource<zzh>)taskCompletionSource2);
    }

    private final void zza(FirebaseAuth firebaseAuth, String string, Activity activity, boolean bl, boolean bl2, zzcf zzcf2, TaskCompletionSource<zzh> taskCompletionSource) {
        if (bl && !bl2) {
            IntegrityManager integrityManager = IntegrityManagerFactory.create((Context)firebaseAuth.getApp().getApplicationContext());
            String string2 = string;
            IntegrityManager integrityManager2 = integrityManager;
            FirebaseAuth firebaseAuth2 = firebaseAuth;
            zza zza2 = this;
            Task task = !TextUtils.isEmpty((CharSequence)zza2.zzc) ? Tasks.forResult((Object)new zzagh(zza2.zzc)) : firebaseAuth2.zza();
            Activity activity2 = activity;
            zzcf zzcf3 = zzcf2;
            FirebaseAuth firebaseAuth3 = firebaseAuth;
            TaskCompletionSource<zzh> taskCompletionSource2 = taskCompletionSource;
            zza zza3 = this;
            task.continueWithTask(firebaseAuth2.zzf(), (Continuation)new zzg(zza2, string2, integrityManager2)).addOnCompleteListener((OnCompleteListener)new zzb(zza3, taskCompletionSource2, firebaseAuth3, zzcf3, activity2));
            return;
        }
        this.zza(firebaseAuth, zzcf2, activity, taskCompletionSource);
    }

    public static boolean zza(Exception exception) {
        return exception instanceof FirebaseAuthMissingActivityForRecaptchaException || exception instanceof FirebaseAuthException && ((FirebaseAuthException)exception).getErrorCode().endsWith("UNAUTHORIZED_DOMAIN");
    }
}

