/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.annotation.SuppressLint;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.firebase-auth-api.zzzh;
import com.google.firebase.auth.MultiFactorInfo;
import com.google.firebase.auth.zzaq;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Class(creator="PhoneMultiFactorInfoCreator")
public class PhoneMultiFactorInfo
extends MultiFactorInfo {
    @NonNull
    public static final Parcelable.Creator<PhoneMultiFactorInfo> CREATOR = new zzaq();
    @SafeParcelable.Field(id=1, getter="getUid")
    private final String zza;
    @SafeParcelable.Field(id=2, getter="getDisplayName")
    @Nullable
    private final String zzb;
    @SafeParcelable.Field(id=3, getter="getEnrollmentTimestamp")
    private final long zzc;
    @SafeParcelable.Field(id=4, getter="getPhoneNumber")
    private final String zzd;

    @Override
    public long getEnrollmentTimestamp() {
        return this.zzc;
    }

    @NonNull
    public static PhoneMultiFactorInfo zza(@NonNull JSONObject jSONObject) {
        if (!jSONObject.has("enrollmentTimestamp")) {
            throw new IllegalArgumentException("An enrollment timestamp in seconds of UTC time since Unix epoch is required to build a PhoneMultiFactorInfo instance.");
        }
        String string = jSONObject.optString("uid");
        String string2 = jSONObject.optString("displayName");
        long l = jSONObject.optLong("enrollmentTimestamp");
        String string3 = jSONObject.optString("phoneNumber");
        return new PhoneMultiFactorInfo(string, string2, l, string3);
    }

    @Override
    @Nullable
    public String getDisplayName() {
        return this.zzb;
    }

    @Override
    @NonNull
    public String getFactorId() {
        return "phone";
    }

    @NonNull
    public String getPhoneNumber() {
        return this.zzd;
    }

    @Override
    @NonNull
    public String getUid() {
        return this.zza;
    }

    @Override
    @Nullable
    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.putOpt("factorIdKey", (Object)"phone");
            jSONObject.putOpt("uid", (Object)this.zza);
            jSONObject.putOpt("displayName", (Object)this.zzb);
            jSONObject.putOpt("enrollmentTimestamp", (Object)this.zzc);
            jSONObject.putOpt("phoneNumber", (Object)this.zzd);
            return jSONObject;
        }
        catch (JSONException jSONException) {
            Log.d((String)"PhoneMultiFactorInfo", (String)"Failed to jsonify this object");
            throw new zzzh(jSONException);
        }
    }

    @SafeParcelable.Constructor
    public PhoneMultiFactorInfo(@SafeParcelable.Param(id=1) @NonNull String string, @SafeParcelable.Param(id=2) @Nullable String string2, @SafeParcelable.Param(id=3) long l, @SafeParcelable.Param(id=4) @NonNull String string3) {
        this.zza = Preconditions.checkNotEmpty((String)string);
        this.zzb = string2;
        this.zzc = l;
        this.zzd = Preconditions.checkNotEmpty((String)string3);
    }

    @SuppressLint(value={"FirebaseUnknownNullness"})
    public void writeToParcel(@NonNull Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PhoneMultiFactorInfo phoneMultiFactorInfo = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)1, (String)((MultiFactorInfo)phoneMultiFactorInfo).getUid(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)((MultiFactorInfo)phoneMultiFactorInfo).getDisplayName(), (boolean)false);
        SafeParcelWriter.writeLong((Parcel)parcel2, (int)3, (long)((MultiFactorInfo)phoneMultiFactorInfo).getEnrollmentTimestamp());
        SafeParcelWriter.writeString((Parcel)parcel2, (int)4, (String)phoneMultiFactorInfo.getPhoneNumber(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }
}

