/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.app.Activity;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.MultiFactorSession;
import com.google.firebase.auth.PhoneAuthProvider;
import com.google.firebase.auth.PhoneMultiFactorInfo;
import com.google.firebase.auth.internal.zzao;
import com.google.firebase.auth.zzap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public final class PhoneAuthOptions {
    private final FirebaseAuth zza;
    private Long zzb;
    private PhoneAuthProvider.OnVerificationStateChangedCallbacks zzc;
    private Executor zzd;
    @Nullable
    private String zze;
    private Activity zzf;
    @Nullable
    private PhoneAuthProvider.ForceResendingToken zzg;
    @Nullable
    private MultiFactorSession zzh;
    @Nullable
    private PhoneMultiFactorInfo zzi;
    private boolean zzj;
    private boolean zzk;
    private boolean zzl;

    @Nullable
    public final Activity zza() {
        return this.zzf;
    }

    @NonNull
    public final FirebaseAuth zzb() {
        return this.zza;
    }

    @Nullable
    public final MultiFactorSession zzc() {
        return this.zzh;
    }

    @NonNull
    public static Builder newBuilder() {
        return new Builder(FirebaseAuth.getInstance());
    }

    @NonNull
    public static Builder newBuilder(@NonNull FirebaseAuth firebaseAuth) {
        return new Builder(firebaseAuth);
    }

    @Nullable
    public final PhoneAuthProvider.ForceResendingToken zzd() {
        return this.zzg;
    }

    @NonNull
    public final PhoneAuthProvider.OnVerificationStateChangedCallbacks zze() {
        return this.zzc;
    }

    @Nullable
    public final PhoneMultiFactorInfo zzf() {
        return this.zzi;
    }

    @NonNull
    public final Long zzg() {
        return this.zzb;
    }

    @Nullable
    public final String zzh() {
        return this.zze;
    }

    @NonNull
    public final Executor zzi() {
        return this.zzd;
    }

    private PhoneAuthOptions(FirebaseAuth firebaseAuth, Long l, PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks, Executor executor, @Nullable String string, @NonNull Activity activity, @Nullable PhoneAuthProvider.ForceResendingToken forceResendingToken, @Nullable MultiFactorSession multiFactorSession, @Nullable PhoneMultiFactorInfo phoneMultiFactorInfo, boolean bl) {
        this.zza = firebaseAuth;
        this.zze = string;
        this.zzb = l;
        this.zzc = onVerificationStateChangedCallbacks;
        this.zzf = activity;
        this.zzd = executor;
        this.zzg = forceResendingToken;
        this.zzh = multiFactorSession;
        this.zzi = phoneMultiFactorInfo;
        this.zzj = bl;
    }

    /* synthetic */ PhoneAuthOptions(FirebaseAuth firebaseAuth, Long l, PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks, Executor executor, String string, Activity activity, PhoneAuthProvider.ForceResendingToken forceResendingToken, MultiFactorSession multiFactorSession, PhoneMultiFactorInfo phoneMultiFactorInfo, boolean bl, zzap zzap2) {
        this(firebaseAuth, l, onVerificationStateChangedCallbacks, executor, string, activity, forceResendingToken, multiFactorSession, phoneMultiFactorInfo, bl);
    }

    public final void zza(boolean bl) {
        this.zzk = true;
    }

    public final void zzb(boolean bl) {
        this.zzl = true;
    }

    public final boolean zzj() {
        return this.zzk;
    }

    public final boolean zzk() {
        return this.zzj;
    }

    public final boolean zzl() {
        return this.zzl;
    }

    public final boolean zzm() {
        return this.zzh != null;
    }

    public static final class Builder {
        private final FirebaseAuth zza;
        private String zzb;
        private Long zzc;
        private PhoneAuthProvider.OnVerificationStateChangedCallbacks zzd;
        private Executor zze;
        private Activity zzf;
        @Nullable
        private PhoneAuthProvider.ForceResendingToken zzg;
        private MultiFactorSession zzh;
        private PhoneMultiFactorInfo zzi;
        private boolean zzj;

        @NonNull
        public final Builder requireSmsValidation(boolean bl) {
            this.zzj = bl;
            return this;
        }

        @NonNull
        public final Builder setActivity(@NonNull Activity activity) {
            this.zzf = activity;
            return this;
        }

        @NonNull
        public final Builder setCallbacks(@NonNull PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks) {
            this.zzd = onVerificationStateChangedCallbacks;
            return this;
        }

        @NonNull
        public final Builder setForceResendingToken(@NonNull PhoneAuthProvider.ForceResendingToken forceResendingToken) {
            this.zzg = forceResendingToken;
            return this;
        }

        @NonNull
        public final Builder setMultiFactorHint(@NonNull PhoneMultiFactorInfo phoneMultiFactorInfo) {
            this.zzi = phoneMultiFactorInfo;
            return this;
        }

        @NonNull
        public final Builder setMultiFactorSession(@NonNull MultiFactorSession multiFactorSession) {
            this.zzh = multiFactorSession;
            return this;
        }

        @NonNull
        public final Builder setPhoneNumber(@NonNull String string) {
            this.zzb = string;
            return this;
        }

        @NonNull
        public final Builder setTimeout(@NonNull Long l, @NonNull TimeUnit timeUnit) {
            this.zzc = TimeUnit.SECONDS.convert(l, timeUnit);
            return this;
        }

        @NonNull
        public final PhoneAuthOptions build() {
            Preconditions.checkNotNull((Object)this.zza, (Object)"FirebaseAuth instance cannot be null");
            Preconditions.checkNotNull((Object)this.zzc, (Object)"You must specify an auto-retrieval timeout; please call #setTimeout()");
            Preconditions.checkNotNull((Object)this.zzd, (Object)"You must specify callbacks on your PhoneAuthOptions. Please call #setCallbacks()");
            this.zze = this.zza.zzg();
            if (this.zzc < 0L || this.zzc > 120L) {
                throw new IllegalArgumentException("We only support 0-120 seconds for sms-auto-retrieval timeout");
            }
            if (this.zzh == null) {
                Preconditions.checkNotEmpty((String)this.zzb, (Object)"The given phoneNumber is empty. Please set a non-empty phone number with #setPhoneNumber()");
                Preconditions.checkArgument((!this.zzj ? 1 : 0) != 0, (Object)"You cannot require sms validation without setting a multi-factor session.");
                Preconditions.checkArgument((this.zzi == null ? 1 : 0) != 0, (Object)"A phoneMultiFactorInfo must be set for second factor sign-in.");
            } else {
                Builder builder = this;
                if (builder.zzh != null && ((zzao)builder.zzh).zzd()) {
                    Preconditions.checkNotEmpty((String)this.zzb);
                    Preconditions.checkArgument((this.zzi == null ? 1 : 0) != 0, (Object)"Invalid MultiFactorSession - use the getSession method in MultiFactorResolver to get a valid sign-in session.");
                } else {
                    Preconditions.checkArgument((this.zzi != null ? 1 : 0) != 0, (Object)"A phoneMultiFactorInfo must be set for second factor sign-in.");
                    Preconditions.checkArgument((this.zzb == null ? 1 : 0) != 0, (Object)"A phone number must not be set for MFA sign-in. A PhoneMultiFactorInfo should be set instead.");
                }
            }
            return new PhoneAuthOptions(this.zza, this.zzc, this.zzd, this.zze, this.zzb, this.zzf, this.zzg, this.zzh, this.zzi, this.zzj, null);
        }

        public Builder(@NonNull FirebaseAuth firebaseAuth) {
            this.zza = (FirebaseAuth)Preconditions.checkNotNull((Object)firebaseAuth);
        }
    }
}

