/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.app.Activity;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.internal.firebase-auth-api.zzagl;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.ActionCodeSettings;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.FederatedAuthProvider;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseUserMetadata;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.MultiFactor;
import com.google.firebase.auth.MultiFactorInfo;
import com.google.firebase.auth.PhoneAuthCredential;
import com.google.firebase.auth.UserInfo;
import com.google.firebase.auth.UserProfileChangeRequest;
import com.google.firebase.auth.zzag;
import com.google.firebase.auth.zzah;
import com.google.firebase.auth.zzai;
import com.google.firebase.auth.zzan;
import java.util.List;

public abstract class FirebaseUser
extends AbstractSafeParcelable
implements UserInfo {
    @Override
    @Nullable
    public abstract Uri getPhotoUrl();

    @NonNull
    public Task<Void> delete() {
        return FirebaseAuth.getInstance(this.zza()).zza(this);
    }

    @NonNull
    public Task<GetTokenResult> getIdToken(boolean bl) {
        return FirebaseAuth.getInstance(this.zza()).zza(this, bl);
    }

    @NonNull
    public Task<AuthResult> linkWithCredential(@NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)((Object)authCredential));
        return FirebaseAuth.getInstance(this.zza()).zza(this, authCredential);
    }

    @NonNull
    public Task<Void> reauthenticate(@NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)((Object)authCredential));
        return FirebaseAuth.getInstance(this.zza()).zzb(this, authCredential);
    }

    @NonNull
    public Task<AuthResult> reauthenticateAndRetrieveData(@NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)((Object)authCredential));
        return FirebaseAuth.getInstance(this.zza()).zzc(this, authCredential);
    }

    @NonNull
    public Task<Void> reload() {
        return FirebaseAuth.getInstance(this.zza()).zzb(this);
    }

    @NonNull
    public Task<Void> sendEmailVerification() {
        return FirebaseAuth.getInstance(this.zza()).zza(this, false).continueWithTask((Continuation)new zzah(this));
    }

    @NonNull
    public Task<Void> sendEmailVerification(@NonNull ActionCodeSettings actionCodeSettings) {
        return FirebaseAuth.getInstance(this.zza()).zza(this, false).continueWithTask((Continuation)new zzag(this, actionCodeSettings));
    }

    @NonNull
    public Task<AuthResult> startActivityForLinkWithProvider(@NonNull Activity activity, @NonNull FederatedAuthProvider federatedAuthProvider) {
        Preconditions.checkNotNull((Object)activity);
        Preconditions.checkNotNull((Object)federatedAuthProvider);
        return FirebaseAuth.getInstance(this.zza()).zza(activity, federatedAuthProvider, this);
    }

    @NonNull
    public Task<AuthResult> startActivityForReauthenticateWithProvider(@NonNull Activity activity, @NonNull FederatedAuthProvider federatedAuthProvider) {
        Preconditions.checkNotNull((Object)activity);
        Preconditions.checkNotNull((Object)federatedAuthProvider);
        return FirebaseAuth.getInstance(this.zza()).zzb(activity, federatedAuthProvider, this);
    }

    @NonNull
    public Task<AuthResult> unlink(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return FirebaseAuth.getInstance(this.zza()).zzb(this, string);
    }

    @Deprecated
    @NonNull
    public Task<Void> updateEmail(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return FirebaseAuth.getInstance(this.zza()).zzc(this, string);
    }

    @NonNull
    public Task<Void> updatePassword(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return FirebaseAuth.getInstance(this.zza()).zzd(this, string);
    }

    @NonNull
    public Task<Void> updatePhoneNumber(@NonNull PhoneAuthCredential phoneAuthCredential) {
        return FirebaseAuth.getInstance(this.zza()).zza(this, phoneAuthCredential);
    }

    @NonNull
    public Task<Void> updateProfile(@NonNull UserProfileChangeRequest userProfileChangeRequest) {
        Preconditions.checkNotNull((Object)((Object)userProfileChangeRequest));
        return FirebaseAuth.getInstance(this.zza()).zza(this, userProfileChangeRequest);
    }

    @NonNull
    public Task<Void> verifyBeforeUpdateEmail(@NonNull String string) {
        return this.verifyBeforeUpdateEmail(string, null);
    }

    @NonNull
    public Task<Void> verifyBeforeUpdateEmail(@NonNull String string, @Nullable ActionCodeSettings actionCodeSettings) {
        return FirebaseAuth.getInstance(this.zza()).zza(this, false).continueWithTask((Continuation)new zzai(this, string, actionCodeSettings));
    }

    @NonNull
    public abstract FirebaseApp zza();

    @NonNull
    public abstract FirebaseUser zzb();

    @NonNull
    public abstract FirebaseUser zza(@NonNull List<? extends UserInfo> var1);

    @Nullable
    public abstract FirebaseUserMetadata getMetadata();

    @NonNull
    public abstract MultiFactor getMultiFactor();

    @NonNull
    public abstract zzagl zzc();

    @NonNull
    public abstract String zzd();

    @Override
    @Nullable
    public abstract String getDisplayName();

    @Override
    @Nullable
    public abstract String getEmail();

    @Override
    @Nullable
    public abstract String getPhoneNumber();

    @Override
    @NonNull
    public abstract String getProviderId();

    @NonNull
    public abstract String zze();

    @Nullable
    public abstract String getTenantId();

    @Override
    @NonNull
    public abstract String getUid();

    @NonNull
    public abstract List<zzan> zzf();

    @NonNull
    public abstract List<? extends UserInfo> getProviderData();

    @Nullable
    public abstract List<String> zzg();

    public abstract void zza(@NonNull zzagl var1);

    public abstract void zzb(@Nullable List<zzan> var1);

    public abstract void zzc(@NonNull List<MultiFactorInfo> var1);

    public abstract boolean isAnonymous();
}

