/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import com.google.android.gms.internal.firebase-auth-api.zzil;
import com.google.android.gms.internal.firebase-auth-api.zzrg;
import com.google.android.gms.internal.firebase-auth-api.zzrq;
import com.google.android.gms.internal.firebase-auth-api.zzxv;
import com.google.android.gms.internal.firebase-auth-api.zzyu;
import com.google.android.gms.internal.firebase-auth-api.zzzb;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class zzyv
implements zzrq {
    private static final zzil.zza zza = zzil.zza.zza;
    private static final ThreadLocal<Cipher> zzb = new zzyu();
    private final SecretKey zzc;
    private byte[] zzd;
    private byte[] zze;

    private static Cipher zza() throws GeneralSecurityException {
        if (!zza.zza()) {
            throw new GeneralSecurityException("Can not use AES-CMAC in FIPS-mode.");
        }
        return zzb.get();
    }

    public zzyv(byte[] byArray) throws GeneralSecurityException {
        zzzb.zza(byArray.length);
        this.zzc = new SecretKeySpec(byArray, "AES");
        zzyv zzyv2 = this;
        Cipher cipher = zzyv.zza();
        cipher.init(1, zzyv2.zzc);
        byte[] byArray2 = new byte[16];
        byte[] byArray3 = cipher.doFinal(byArray2);
        zzyv2.zzd = zzrg.zzb(byArray3);
        zzyv2.zze = zzrg.zzb(zzyv2.zzd);
    }

    private static void zza(byte[] byArray, byte[] byArray2, int n, byte[] byArray3) {
        for (int i = 0; i < 16; ++i) {
            byArray3[i] = (byte)(byArray[i] ^ byArray2[i + n]);
        }
    }

    @Override
    public final byte[] zza(byte[] byArray, int n) throws GeneralSecurityException {
        if (n > 16) {
            throw new InvalidAlgorithmParameterException("outputLength too large, max is 16 bytes");
        }
        Cipher cipher = zzyv.zza();
        cipher.init(1, this.zzc);
        int n2 = byArray.length;
        int n3 = n2 == 0 ? 1 : (n2 - 1) / 16 + 1;
        byte[] byArray2 = n3 << 4 == byArray.length ? zzxv.zza(byArray, n3 - 1 << 4, this.zzd, 0, 16) : zzxv.zza(zzrg.zza(Arrays.copyOfRange(byArray, n3 - 1 << 4, byArray.length)), this.zze);
        byte[] byArray3 = new byte[16];
        byte[] byArray4 = new byte[16];
        for (int i = 0; i < n3 - 1; ++i) {
            zzyv.zza(byArray3, byArray, i << 4, byArray4);
            if (cipher.doFinal(byArray4, 0, 16, byArray3) == 16) continue;
            throw new IllegalStateException("Cipher didn't write full block");
        }
        zzyv.zza(byArray3, byArray2, 0, byArray4);
        if (cipher.doFinal(byArray4, 0, 16, byArray3) != 16) {
            throw new IllegalStateException("Cipher didn't write full block");
        }
        if (16 == n) {
            return byArray3;
        }
        return Arrays.copyOf(byArray3, n);
    }
}

