/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import com.google.android.gms.internal.firebase-auth-api.zzbg;
import com.google.android.gms.internal.firebase-auth-api.zzbq;
import com.google.android.gms.internal.firebase-auth-api.zzdh;
import com.google.android.gms.internal.firebase-auth-api.zzil;
import com.google.android.gms.internal.firebase-auth-api.zzpe;
import com.google.android.gms.internal.firebase-auth-api.zzpr;
import com.google.android.gms.internal.firebase-auth-api.zzxo;
import com.google.android.gms.internal.firebase-auth-api.zzxr;
import com.google.android.gms.internal.firebase-auth-api.zzzb;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class zzxp
implements zzbg {
    private static final zzil.zza zza = zzil.zza.zza;
    private static final ThreadLocal<Cipher> zzb = new zzxo();
    private static final ThreadLocal<Cipher> zzc = new zzxr();
    private final byte[] zzd;
    private final byte[] zze;
    private final byte[] zzf;
    private final SecretKeySpec zzg;
    private final int zzh;

    public static zzbg zza(zzdh zzdh2) throws GeneralSecurityException {
        if (!zza.zza()) {
            throw new GeneralSecurityException("Can not use AES-EAX in FIPS-mode.");
        }
        if (zzdh2.zzc().zzd() != 16) {
            int n = zzdh2.zzc().zzd();
            throw new GeneralSecurityException("AesEaxJce only supports 16 byte tag size, not " + n);
        }
        return new zzxp(zzdh2.zze().zza(zzbq.zza()), zzdh2.zzc().zzb(), zzdh2.zzd().zzb());
    }

    private zzxp(byte[] byArray, int n, byte[] byArray2) throws GeneralSecurityException {
        if (!zza.zza()) {
            throw new GeneralSecurityException("Can not use AES-EAX in FIPS-mode.");
        }
        if (n != 12 && n != 16) {
            throw new IllegalArgumentException("IV size should be either 12 or 16 bytes");
        }
        this.zzh = n;
        zzzb.zza(byArray.length);
        this.zzg = new SecretKeySpec(byArray, "AES");
        Cipher cipher = zzb.get();
        cipher.init(1, this.zzg);
        byte[] byArray3 = cipher.doFinal(new byte[16]);
        this.zzd = zzxp.zza(byArray3);
        this.zze = zzxp.zza(this.zzd);
        this.zzf = byArray2;
    }

    private static void zzc(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)(byArray[i] ^ byArray2[i]);
        }
    }

    @Override
    public final byte[] zza(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        int n = byArray.length - this.zzf.length - this.zzh - 16;
        if (n < 0) {
            throw new GeneralSecurityException("ciphertext too short");
        }
        if (!zzpr.zza(this.zzf, byArray)) {
            throw new GeneralSecurityException("Decryption failed (OutputPrefix mismatch).");
        }
        Cipher cipher = zzb.get();
        cipher.init(1, this.zzg);
        byte[] byArray3 = this.zza(cipher, 0, byArray, this.zzf.length, this.zzh);
        byte[] byArray4 = byArray2;
        if (byArray2 == null) {
            byArray4 = new byte[]{};
        }
        byte[] byArray5 = this.zza(cipher, 1, byArray4, 0, byArray4.length);
        byte[] byArray6 = this.zza(cipher, 2, byArray, this.zzf.length + this.zzh, n);
        int n2 = 0;
        int n3 = byArray.length - 16;
        for (int i = 0; i < 16; ++i) {
            n2 = (byte)(n2 | byArray[n3 + i] ^ byArray5[i] ^ byArray3[i] ^ byArray6[i]);
        }
        if (n2 != 0) {
            throw new AEADBadTagException("tag mismatch");
        }
        Cipher cipher2 = zzc.get();
        cipher2.init(1, (Key)this.zzg, new IvParameterSpec(byArray3));
        return cipher2.doFinal(byArray, this.zzf.length + this.zzh, n);
    }

    @Override
    public final byte[] zzb(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        if (byArray.length > Integer.MAX_VALUE - this.zzf.length - this.zzh - 16) {
            throw new GeneralSecurityException("plaintext too long");
        }
        byte[] byArray3 = Arrays.copyOf(this.zzf, this.zzf.length + this.zzh + byArray.length + 16);
        byte[] byArray4 = zzpe.zza(this.zzh);
        System.arraycopy(byArray4, 0, byArray3, this.zzf.length, this.zzh);
        Cipher cipher = zzb.get();
        cipher.init(1, this.zzg);
        byte[] byArray5 = this.zza(cipher, 0, byArray4, 0, byArray4.length);
        byte[] byArray6 = byArray2;
        if (byArray2 == null) {
            byArray6 = new byte[]{};
        }
        byte[] byArray7 = this.zza(cipher, 1, byArray6, 0, byArray6.length);
        Cipher cipher2 = zzc.get();
        cipher2.init(1, (Key)this.zzg, new IvParameterSpec(byArray5));
        cipher2.doFinal(byArray, 0, byArray.length, byArray3, this.zzf.length + this.zzh);
        byte[] byArray8 = this.zza(cipher, 2, byArray3, this.zzf.length + this.zzh, byArray.length);
        int n = this.zzf.length + byArray.length + this.zzh;
        for (int i = 0; i < 16; ++i) {
            byArray3[n + i] = (byte)(byArray7[i] ^ byArray5[i] ^ byArray8[i]);
        }
        return byArray3;
    }

    private static byte[] zza(byte[] byArray) {
        byte[] byArray2 = new byte[16];
        for (int i = 0; i < 15; ++i) {
            byArray2[i] = (byte)(byArray[i] << 1 ^ (byArray[i + 1] & 0xFF) >>> 7);
        }
        byArray2[15] = (byte)(byArray[15] << 1 ^ byArray[0] >> 7 & 0x87);
        return byArray2;
    }

    private final byte[] zza(Cipher cipher, int n, byte[] byArray, int n2, int n3) throws IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        byte[] byArray2;
        byte[] byArray3 = new byte[16];
        byte[] byArray4 = byArray3;
        byArray3[15] = (byte)n;
        if (n3 == 0) {
            zzxp.zzc(byArray4, this.zzd);
            return cipher.doFinal(byArray4);
        }
        byte[] byArray5 = new byte[16];
        cipher.doFinal(byArray4, 0, 16, byArray5);
        byte[] byArray6 = byArray4;
        byArray4 = byArray5;
        byArray5 = byArray6;
        int n4 = 0;
        while (n3 - n4 > 16) {
            for (int i = 0; i < 16; ++i) {
                int n5 = i;
                byArray4[n5] = (byte)(byArray4[n5] ^ byArray[n2 + n4 + i]);
            }
            cipher.doFinal(byArray4, 0, 16, byArray5);
            byArray6 = byArray4;
            byArray4 = byArray5;
            byArray5 = byArray6;
            n4 += 16;
        }
        int n6 = n2 + n3;
        int n7 = n2 + n4;
        byte[] byArray7 = byArray;
        zzxp zzxp2 = this;
        byte[] byArray8 = Arrays.copyOfRange(byArray7, n7, n6);
        if (byArray8.length == 16) {
            zzxp.zzc(byArray8, zzxp2.zzd);
            byArray2 = byArray8;
        } else {
            byte[] byArray9 = Arrays.copyOf(zzxp2.zze, 16);
            for (int i = 0; i < byArray8.length; ++i) {
                int n8 = i;
                byArray9[n8] = (byte)(byArray9[n8] ^ byArray8[i]);
            }
            byArray9[byArray8.length] = (byte)(byArray9[byArray8.length] ^ 0x80);
            byArray2 = byArray9;
        }
        byte[] byArray10 = byArray2;
        zzxp.zzc(byArray4, byArray10);
        cipher.doFinal(byArray4, 0, 16, byArray5);
        return byArray5;
    }
}

