/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import com.google.android.gms.internal.firebase-auth-api.zzjp;
import com.google.android.gms.internal.firebase-auth-api.zzkr;
import com.google.android.gms.internal.firebase-auth-api.zzmk;
import com.google.android.gms.internal.firebase-auth-api.zzog;
import com.google.android.gms.internal.firebase-auth-api.zzzc;
import java.security.GeneralSecurityException;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import javax.annotation.Nullable;

public final class zzjv
extends zzkr {
    private final zzjp zza;
    @Nullable
    private final ECPoint zzb;
    @Nullable
    private final zzzc zzc;
    private final zzzc zzd;
    @Nullable
    private final Integer zze;

    public final zzjp zzb() {
        return this.zza;
    }

    public static zzjv zza(zzjp zzjp2, zzzc zzzc2, @Nullable Integer n) throws GeneralSecurityException {
        if (!zzjp2.zzd().equals(zzjp.zzc.zzd)) {
            throw new GeneralSecurityException("createForCurveX25519 may only be called with parameters for curve X25519");
        }
        zzjv.zzb(zzjp2.zzg(), n);
        if (zzzc2.zza() != 32) {
            throw new GeneralSecurityException("Encoded public point byte length for X25519 curve must be 32");
        }
        zzzc zzzc3 = zzjv.zza(zzjp2.zzg(), n);
        return new zzjv(zzjp2, null, zzzc2, zzzc3, n);
    }

    public static zzjv zza(zzjp zzjp2, ECPoint eCPoint, @Nullable Integer n) throws GeneralSecurityException {
        EllipticCurve ellipticCurve;
        if (zzjp2.zzd().equals(zzjp.zzc.zzd)) {
            throw new GeneralSecurityException("createForNistCurve may only be called with parameters for NIST curve");
        }
        zzjv.zzb(zzjp2.zzg(), n);
        zzjp.zzc zzc2 = zzjp2.zzd();
        if (zzc2 == zzjp.zzc.zza) {
            ellipticCurve = zzmk.zza.getCurve();
        } else if (zzc2 == zzjp.zzc.zzb) {
            ellipticCurve = zzmk.zzb.getCurve();
        } else if (zzc2 == zzjp.zzc.zzc) {
            ellipticCurve = zzmk.zzc.getCurve();
        } else {
            String string = String.valueOf(zzc2);
            throw new IllegalArgumentException("Unable to determine NIST curve type for " + string);
        }
        zzmk.zza(eCPoint, ellipticCurve);
        zzzc zzzc2 = zzjv.zza(zzjp2.zzg(), n);
        return new zzjv(zzjp2, eCPoint, null, zzzc2, n);
    }

    private static zzzc zza(zzjp.zzd zzd2, @Nullable Integer n) {
        if (zzd2 == zzjp.zzd.zzc) {
            return zzog.zza;
        }
        if (n == null) {
            String string = String.valueOf(zzd2);
            throw new IllegalStateException("idRequirement must be non-null for EciesParameters.Variant: " + string);
        }
        if (zzd2 == zzjp.zzd.zzb) {
            return zzog.zza(n);
        }
        if (zzd2 == zzjp.zzd.zza) {
            return zzog.zzb(n);
        }
        String string = String.valueOf(zzd2);
        throw new IllegalStateException("Unknown EciesParameters.Variant: " + string);
    }

    @Override
    public final zzzc zzc() {
        return this.zzd;
    }

    @Nullable
    public final zzzc zzd() {
        return this.zzc;
    }

    @Override
    @Nullable
    public final Integer zza() {
        return this.zze;
    }

    @Nullable
    public final ECPoint zze() {
        return this.zzb;
    }

    private zzjv(zzjp zzjp2, @Nullable ECPoint eCPoint, @Nullable zzzc zzzc2, zzzc zzzc3, @Nullable Integer n) {
        this.zza = zzjp2;
        this.zzb = eCPoint;
        this.zzc = zzzc2;
        this.zzd = zzzc3;
        this.zze = n;
    }

    private static void zzb(zzjp.zzd zzd2, @Nullable Integer n) throws GeneralSecurityException {
        if (!zzd2.equals(zzjp.zzd.zzc) && n == null) {
            String string = String.valueOf(zzd2);
            throw new GeneralSecurityException("'idRequirement' must be non-null for " + string + " variant.");
        }
        if (zzd2.equals(zzjp.zzd.zzc) && n != null) {
            throw new GeneralSecurityException("'idRequirement' must be null for NO_PREFIX variant.");
        }
    }
}

