/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import com.google.android.gms.internal.firebase-auth-api.zzbg;
import com.google.android.gms.internal.firebase-auth-api.zzbq;
import com.google.android.gms.internal.firebase-auth-api.zzfv;
import com.google.android.gms.internal.firebase-auth-api.zzhc;
import com.google.android.gms.internal.firebase-auth-api.zzhk;
import com.google.android.gms.internal.firebase-auth-api.zzil;
import com.google.android.gms.internal.firebase-auth-api.zzpe;
import com.google.android.gms.internal.firebase-auth-api.zzpr;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class zzib
implements zzbg {
    private static final zzil.zza zza = zzil.zza.zza;
    private final byte[] zzb;
    private final byte[] zzc;

    public static zzbg zza(zzfv zzfv2) throws GeneralSecurityException {
        return new zzib(zzfv2.zzd().zza(zzbq.zza()), zzfv2.zzc().zzb());
    }

    private zzib(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        if (!zza.zza()) {
            throw new GeneralSecurityException("Can not use ChaCha20Poly1305 in FIPS-mode.");
        }
        if (!zzib.zza()) {
            throw new GeneralSecurityException("JCE does not support algorithm: ChaCha20-Poly1305");
        }
        if (byArray.length != 32) {
            throw new InvalidKeyException("The key length in bytes must be 32.");
        }
        this.zzb = byArray;
        this.zzc = byArray2;
    }

    public static boolean zza() {
        return zzhc.zza() != null;
    }

    @Override
    public final byte[] zza(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        if (byArray == null) {
            throw new NullPointerException("ciphertext is null");
        }
        if (byArray.length < this.zzc.length + 24 + 16) {
            throw new GeneralSecurityException("ciphertext too short");
        }
        if (!zzpr.zza(this.zzc, byArray)) {
            throw new GeneralSecurityException("Decryption failed (OutputPrefix mismatch).");
        }
        byte[] byArray3 = new byte[24];
        System.arraycopy(byArray, this.zzc.length, byArray3, 0, 24);
        byte[] byArray4 = zzhk.zza(this.zzb, byArray3);
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray4, "ChaCha20");
        IvParameterSpec ivParameterSpec = new IvParameterSpec(zzib.zza(byArray3));
        Cipher cipher = zzhc.zza();
        cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
        if (byArray2 != null && byArray2.length != 0) {
            cipher.updateAAD(byArray2);
        }
        int n = this.zzc.length + 24;
        int n2 = byArray.length - this.zzc.length - 24;
        return cipher.doFinal(byArray, n, n2);
    }

    @Override
    public final byte[] zzb(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        int n;
        if (byArray == null) {
            throw new NullPointerException("plaintext is null");
        }
        byte[] byArray3 = zzpe.zza(24);
        byte[] byArray4 = zzhk.zza(this.zzb, byArray3);
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray4, "ChaCha20");
        IvParameterSpec ivParameterSpec = new IvParameterSpec(zzib.zza(byArray3));
        Cipher cipher = zzhc.zza();
        cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
        if (byArray2 != null && byArray2.length != 0) {
            cipher.updateAAD(byArray2);
        }
        if ((n = cipher.getOutputSize(byArray.length)) > Integer.MAX_VALUE - this.zzc.length - 24) {
            throw new GeneralSecurityException("plaintext too long");
        }
        int n2 = this.zzc.length + 24 + n;
        byte[] byArray5 = Arrays.copyOf(this.zzc, n2);
        System.arraycopy(byArray3, 0, byArray5, this.zzc.length, 24);
        if (cipher.doFinal(byArray, 0, byArray.length, byArray5, this.zzc.length + 24) != n) {
            throw new GeneralSecurityException("not enough data written");
        }
        return byArray5;
    }

    private static byte[] zza(byte[] byArray) {
        byte[] byArray2 = new byte[12];
        System.arraycopy(byArray, 16, byArray2, 4, 8);
        return byArray2;
    }
}

