/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.app.Activity;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.logging.Logger;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseException;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.PhoneAuthCredential;
import com.google.firebase.auth.PhoneAuthOptions;
import com.google.firebase.auth.zzd;
import java.util.concurrent.TimeUnit;

public class PhoneAuthProvider {
    public static final String PROVIDER_ID = "phone";
    public static final String PHONE_SIGN_IN_METHOD = "phone";
    private FirebaseAuth zza;

    private PhoneAuthProvider(FirebaseAuth firebaseAuth) {
        this.zza = firebaseAuth;
    }

    @Deprecated
    @NonNull
    public static PhoneAuthProvider getInstance(@NonNull FirebaseAuth firebaseAuth) {
        PhoneAuthProvider phoneAuthProvider = new PhoneAuthProvider(firebaseAuth);
        return phoneAuthProvider;
    }

    @Deprecated
    @NonNull
    public static PhoneAuthProvider getInstance() {
        PhoneAuthProvider phoneAuthProvider = new PhoneAuthProvider(FirebaseAuth.getInstance(FirebaseApp.getInstance()));
        return phoneAuthProvider;
    }

    @Deprecated
    public void verifyPhoneNumber(@NonNull String string, long l, @NonNull TimeUnit timeUnit, @NonNull Activity activity, @NonNull OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks) {
        PhoneAuthOptions.Builder builder = PhoneAuthOptions.newBuilder(((PhoneAuthProvider)((Object)builder)).zza);
        builder.setPhoneNumber(string);
        builder.setTimeout(l, timeUnit);
        builder.setActivity(activity);
        builder.setCallbacks(onVerificationStateChangedCallbacks);
        PhoneAuthProvider.verifyPhoneNumber(builder.build());
    }

    @Deprecated
    public void verifyPhoneNumber(@NonNull String string, long l, @NonNull TimeUnit timeUnit, @NonNull Activity activity, @NonNull OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks, @Nullable ForceResendingToken forceResendingToken) {
        PhoneAuthOptions.Builder builder = PhoneAuthOptions.newBuilder(((PhoneAuthProvider)((Object)builder)).zza);
        builder.setPhoneNumber(string);
        builder.setTimeout(l, timeUnit);
        builder.setActivity(activity);
        builder.setCallbacks(onVerificationStateChangedCallbacks);
        builder.setForceResendingToken(forceResendingToken);
        PhoneAuthProvider.verifyPhoneNumber(builder.build());
    }

    public static void verifyPhoneNumber(@NonNull PhoneAuthOptions phoneAuthOptions) {
        Preconditions.checkNotNull((Object)phoneAuthOptions);
        phoneAuthOptions.zza().zzk(phoneAuthOptions);
    }

    @NonNull
    public static PhoneAuthCredential getCredential(@NonNull String string, @NonNull String string2) {
        return PhoneAuthCredential.zzb(string, string2);
    }

    @SafeParcelable.Class(creator="DefaultForceResendingTokenCreator")
    public static class ForceResendingToken
    extends AbstractSafeParcelable {
        public static final Parcelable.Creator<ForceResendingToken> CREATOR;

        @SafeParcelable.Constructor
        ForceResendingToken() {
        }

        public final void writeToParcel(Parcel parcel, int n) {
            SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)SafeParcelWriter.beginObjectHeader((Parcel)parcel));
        }

        static {
            zzd zzd2;
            CREATOR = zzd2 = new zzd();
        }

        public static ForceResendingToken zza() {
            ForceResendingToken forceResendingToken = new ForceResendingToken();
            return forceResendingToken;
        }
    }

    public static abstract class OnVerificationStateChangedCallbacks {
        private static final Logger zza;

        public abstract void onVerificationCompleted(@NonNull PhoneAuthCredential var1);

        public abstract void onVerificationFailed(@NonNull FirebaseException var1);

        public void onCodeSent(@NonNull String string, @NonNull ForceResendingToken forceResendingToken) {
        }

        public void onCodeAutoRetrievalTimeOut(@NonNull String string) {
            zza.i("Sms auto retrieval timed-out.", new Object[0]);
        }

        static {
            Logger logger;
            zza = logger = new Logger("PhoneAuthProvider", new String[0]);
        }
    }
}

