/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.firebase-auth-api.zzup;
import com.google.android.gms.internal.firebase-auth-api.zzvw;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.FederatedAuthProvider;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.internal.GenericIdpActivity;
import com.google.firebase.auth.zzab;
import com.google.firebase.auth.zze;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class OAuthProvider
extends FederatedAuthProvider {
    private final Bundle zza;

    @NonNull
    public static Builder newBuilder(@NonNull String string) {
        return OAuthProvider.newBuilder(string, FirebaseAuth.getInstance());
    }

    @NonNull
    public static Builder newBuilder(@NonNull String object, @NonNull FirebaseAuth firebaseAuth) {
        Preconditions.checkNotEmpty((String)object);
        Preconditions.checkNotNull((Object)firebaseAuth);
        if ("facebook.com".equals(object) && !zzvw.zzb(firebaseAuth.getApp())) {
            object = new IllegalArgumentException("Sign in with Facebook is not supported via this method; the Facebook TOS dictate that you must use the Facebook Android SDK for Facebook login.");
            throw object;
        }
        Builder builder = new Builder((String)object, firebaseAuth, null);
        return builder;
    }

    @Nullable
    public String getProviderId() {
        return this.zza.getString("com.google.firebase.auth.KEY_PROVIDER_ID", null);
    }

    @NonNull
    public static CredentialBuilder newCredentialBuilder(@NonNull String string) {
        CredentialBuilder credentialBuilder = new CredentialBuilder(Preconditions.checkNotEmpty((String)string), null);
        return credentialBuilder;
    }

    @Deprecated
    @NonNull
    public static AuthCredential getCredential(@NonNull String string, @NonNull String string2, @NonNull String string3) {
        return zze.zzb(string, string2, string3, null, null);
    }

    @Override
    public final void zza(Activity activity) {
        Intent intent = new Intent("com.google.firebase.auth.internal.NONGMSCORE_SIGN_IN");
        intent.setClass((Context)activity, GenericIdpActivity.class);
        intent.setPackage(activity.getPackageName());
        intent.putExtras(this.zza);
        activity.startActivity(intent);
    }

    @Override
    public final void zzb(Activity activity) {
        Intent intent = new Intent("com.google.firebase.auth.internal.NONGMSCORE_LINK");
        intent.setClass((Context)activity, GenericIdpActivity.class);
        intent.setPackage(activity.getPackageName());
        intent.putExtras(this.zza);
        activity.startActivity(intent);
    }

    @Override
    public final void zzc(Activity activity) {
        Intent intent = new Intent("com.google.firebase.auth.internal.NONGMSCORE_REAUTHENTICATE");
        intent.setClass((Context)activity, GenericIdpActivity.class);
        intent.setPackage(activity.getPackageName());
        intent.putExtras(this.zza);
        activity.startActivity(intent);
    }

    /* synthetic */ OAuthProvider(Bundle bundle, zzab zzab2) {
        this.zza = bundle;
    }

    public static class CredentialBuilder {
        private final String zza;
        @Nullable
        private String zzb;
        @Nullable
        private String zzc;
        @Nullable
        private String zzd;

        @KeepForSdk
        public String getIdToken() {
            return this.zzb;
        }

        @NonNull
        public CredentialBuilder setIdToken(@NonNull String string) {
            this.zzb = string;
            return this;
        }

        @NonNull
        public CredentialBuilder setIdTokenWithRawNonce(@NonNull String string, @Nullable String string2) {
            this.zzb = string;
            this.zzd = string2;
            return this;
        }

        @KeepForSdk
        public String getAccessToken() {
            return this.zzc;
        }

        @NonNull
        public CredentialBuilder setAccessToken(@NonNull String string) {
            this.zzc = string;
            return this;
        }

        @NonNull
        public AuthCredential build() {
            String string = ((CredentialBuilder)object).zza;
            String string2 = ((CredentialBuilder)object).zzb;
            String string3 = ((CredentialBuilder)object).zzc;
            Object object = ((CredentialBuilder)object).zzd;
            Preconditions.checkNotEmpty((String)string, (Object)"Must specify a non-empty providerId");
            if (TextUtils.isEmpty((CharSequence)string2) && TextUtils.isEmpty((CharSequence)string3)) {
                object = new IllegalArgumentException("Must specify an idToken or an accessToken.");
                throw object;
            }
            zze zze2 = new zze(string, string2, string3, null, null, null, (String)object);
            return zze2;
        }

        /* synthetic */ CredentialBuilder(String string, zzab zzab2) {
            this.zza = string;
        }
    }

    public static class Builder {
        private final FirebaseAuth zzb;
        @VisibleForTesting
        final Bundle zza;
        private final Bundle zzc;

        @KeepForSdk
        @NonNull
        public List<String> getScopes() {
            ArrayList arrayList = ((Builder)((Object)arrayList)).zza.getStringArrayList("com.google.firebase.auth.KEY_PROVIDER_SCOPES");
            if (arrayList != null) {
                return arrayList;
            }
            return Collections.emptyList();
        }

        @NonNull
        public Builder setScopes(@NonNull List<String> list) {
            Bundle bundle = this.zza;
            ArrayList<String> arrayList = new ArrayList<String>(list);
            bundle.putStringArrayList("com.google.firebase.auth.KEY_PROVIDER_SCOPES", arrayList);
            return this;
        }

        @NonNull
        public Builder addCustomParameter(@NonNull String string, @NonNull String string2) {
            this.zzc.putString(string, string2);
            return this;
        }

        @NonNull
        public Builder addCustomParameters(@NonNull Map<String, String> object) {
            for (Map.Entry entry : object.entrySet()) {
                this.zzc.putString((String)entry.getKey(), (String)entry.getValue());
            }
            return this;
        }

        @NonNull
        public OAuthProvider build() {
            OAuthProvider oAuthProvider = new OAuthProvider(this.zza, null);
            return oAuthProvider;
        }

        /* synthetic */ Builder(String string, FirebaseAuth firebaseAuth, zzab zzab2) {
            this.zza = zzab2;
            super();
            this.zzc = zzab2;
            this.zzb = firebaseAuth;
            this.zza.putString("com.google.firebase.auth.KEY_API_KEY", this.zzb.getApp().getOptions().getApiKey());
            this.zza.putString("com.google.firebase.auth.KEY_PROVIDER_ID", string);
            this.zza.putBundle("com.google.firebase.auth.KEY_PROVIDER_CUSTOM_PARAMS", this.zzc);
            this.zza.putString("com.google.firebase.auth.internal.CLIENT_VERSION", zzup.zzb().zza());
            this.zza.putString("com.google.firebase.auth.KEY_TENANT_ID", this.zzb.getTenantId());
            this.zza.putString("com.google.firebase.auth.KEY_FIREBASE_APP_NAME", this.zzb.getApp().getName());
        }
    }
}

