/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_auth;

import com.google.android.gms.internal.firebase_auth.zzed;
import com.google.android.gms.internal.firebase_auth.zzfv;
import com.google.android.gms.internal.firebase_auth.zzgb;
import com.google.android.gms.internal.firebase_auth.zzhn;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzfq
extends zzed<Float>
implements zzgb<Float>,
zzhn,
RandomAccess {
    private static final zzfq zzwu = new zzfq();
    private float[] zzwv;
    private int size;

    zzfq() {
        this(new float[10], 0);
    }

    private zzfq(float[] fArray, int n) {
        this.zzwv = fArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzew();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzwv, n2, this.zzwv, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzfq)) {
            return super.equals(object);
        }
        zzfq zzfq2 = (zzfq)object;
        if (this.size != zzfq2.size) {
            return false;
        }
        float[] fArray = zzfq2.zzwv;
        for (int i = 0; i < this.size; ++i) {
            if (Float.floatToIntBits(this.zzwv[i]) == Float.floatToIntBits(fArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + Float.floatToIntBits(this.zzwv[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzc(float f) {
        this.zzc(this.size, f);
    }

    private final void zzc(int n, float f) {
        this.zzew();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzi(n));
        }
        if (this.size < this.zzwv.length) {
            System.arraycopy(this.zzwv, n, this.zzwv, n + 1, this.size - n);
        } else {
            float[] fArray = new float[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzwv, 0, fArray, 0, n);
            System.arraycopy(this.zzwv, n, fArray, n + 1, this.size - n);
            this.zzwv = fArray;
        }
        this.zzwv[n] = f;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Float> collection) {
        this.zzew();
        zzfv.checkNotNull(collection);
        if (!(collection instanceof zzfq)) {
            return super.addAll(collection);
        }
        zzfq zzfq2 = (zzfq)collection;
        if (zzfq2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzfq2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzfq2.size;
        if (n > this.zzwv.length) {
            this.zzwv = Arrays.copyOf(this.zzwv, n);
        }
        System.arraycopy(zzfq2.zzwv, 0, this.zzwv, this.size, zzfq2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzew();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(Float.valueOf(this.zzwv[i]))) continue;
            System.arraycopy(this.zzwv, i + 1, this.zzwv, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzh(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzi(n));
        }
    }

    private final String zzi(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Float f = (Float)object;
        float f2 = f.floatValue();
        zzfq zzfq2 = this;
        zzfq2.zzew();
        zzfq2.zzh(n);
        float f3 = zzfq2.zzwv[n];
        zzfq2.zzwv[n] = f2;
        return Float.valueOf(f3);
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzfq zzfq2 = this;
        zzfq2.zzew();
        zzfq2.zzh(n);
        float f = zzfq2.zzwv[n];
        if (n < zzfq2.size - 1) {
            System.arraycopy(zzfq2.zzwv, n + 1, zzfq2.zzwv, n, zzfq2.size - n - 1);
        }
        --zzfq2.size;
        ++zzfq2.modCount;
        return Float.valueOf(f);
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Float f = (Float)object;
        this.zzc(n, f.floatValue());
    }

    @Override
    public final /* synthetic */ zzgb zzj(int n) {
        int n2 = n;
        zzfq zzfq2 = this;
        if (n2 < zzfq2.size) {
            throw new IllegalArgumentException();
        }
        return new zzfq(Arrays.copyOf(zzfq2.zzwv, n2), zzfq2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzfq zzfq2 = this;
        zzfq2.zzh(n);
        return Float.valueOf(zzfq2.zzwv[n]);
    }

    static {
        zzwu.zzev();
    }
}

