/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_auth;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.Strings;
import com.google.android.gms.internal.firebase_auth.zzaf;
import com.google.android.gms.internal.firebase_auth.zzda;
import com.google.android.gms.internal.firebase_auth.zzhc;
import com.google.android.gms.internal.firebase_auth.zzhm;
import com.google.android.gms.internal.firebase_auth.zzjm;
import com.google.firebase.auth.api.internal.zzdw;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="GetTokenResponseCreator")
public final class zzcz
extends AbstractSafeParcelable
implements zzdw<zzcz, zzjm.zzb> {
    public static final Parcelable.Creator<zzcz> CREATOR = new zzda();
    @SafeParcelable.Field(id=2, getter="getRefreshToken")
    private String zzid;
    @SafeParcelable.Field(id=3, getter="getAccessToken")
    private String zzgd;
    @SafeParcelable.Field(id=4, getter="getExpiresIn")
    private Long zzph;
    @SafeParcelable.Field(id=5, getter="getTokenType")
    private String zzpi;
    @SafeParcelable.Field(id=6, getter="getIssuedAt")
    private Long zzpj;

    public zzcz() {
        this.zzpj = System.currentTimeMillis();
    }

    public zzcz(String string, String string2, Long l, String string3) {
        this(string, string2, l, string3, System.currentTimeMillis());
    }

    @SafeParcelable.Constructor
    zzcz(@SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) String string2, @SafeParcelable.Param(id=4) Long l, @SafeParcelable.Param(id=5) String string3, @SafeParcelable.Param(id=6) Long l2) {
        this.zzid = string;
        this.zzgd = string2;
        this.zzph = l;
        this.zzpi = string3;
        this.zzpj = l2;
    }

    public final boolean isValid() {
        long l = this.zzpj + this.zzph * 1000L;
        return DefaultClock.getInstance().currentTimeMillis() + 300000L < l;
    }

    public final void zzce(@NonNull String string) {
        this.zzid = Preconditions.checkNotEmpty((String)string);
    }

    public final String zzr() {
        return this.zzid;
    }

    public final String zzdw() {
        return this.zzgd;
    }

    public final long zzs() {
        if (this.zzph == null) {
            return 0L;
        }
        return this.zzph;
    }

    @Nullable
    public final String zzdx() {
        return this.zzpi;
    }

    public final long zzdy() {
        return this.zzpj;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzcz zzcz2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)zzcz2.zzid, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)zzcz2.zzgd, (boolean)false);
        SafeParcelWriter.writeLongObject((Parcel)parcel2, (int)4, (Long)zzcz2.zzs(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)5, (String)zzcz2.zzpi, (boolean)false);
        SafeParcelWriter.writeLongObject((Parcel)parcel2, (int)6, (Long)zzcz2.zzpj, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @Override
    public final zzhm<zzjm.zzb> zzdj() {
        return zzjm.zzb.zzl();
    }

    public final String zzdz() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("refresh_token", (Object)this.zzid);
            jSONObject.put("access_token", (Object)this.zzgd);
            jSONObject.put("expires_in", (Object)this.zzph);
            jSONObject.put("token_type", (Object)this.zzpi);
            jSONObject.put("issued_at", (Object)this.zzpj);
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            Log.d((String)"GetTokenResponse", (String)"Failed to convert GetTokenResponse to JSON");
            throw new zzaf(jSONException);
        }
    }

    public static zzcz zzcf(@NonNull String string) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            zzcz zzcz2 = new zzcz();
            new zzcz().zzid = jSONObject.optString("refresh_token", null);
            zzcz2.zzgd = jSONObject.optString("access_token", null);
            zzcz2.zzph = jSONObject.optLong("expires_in");
            zzcz2.zzpi = jSONObject.optString("token_type", null);
            zzcz2.zzpj = jSONObject.optLong("issued_at");
            return zzcz2;
        }
        catch (JSONException jSONException) {
            Log.d((String)"GetTokenResponse", (String)"Failed to read GetTokenResponse from JSONObject");
            throw new zzaf(jSONException);
        }
    }

    @Override
    public final /* synthetic */ zzdw zza(zzhc zzhc2) {
        zzhc zzhc3 = zzhc2;
        zzcz zzcz2 = this;
        if (!(zzhc3 instanceof zzjm.zzb)) {
            throw new IllegalArgumentException("The passed proto must be an instance of GrantTokenResponse.");
        }
        zzjm.zzb zzb2 = (zzjm.zzb)zzhc3;
        zzcz2.zzid = Strings.emptyToNull((String)zzb2.zzr());
        zzcz2.zzgd = Strings.emptyToNull((String)zzb2.zzdw());
        zzcz2.zzph = zzb2.zzs();
        zzcz2.zzpi = Strings.emptyToNull((String)zzb2.zzdx());
        zzcz2.zzpj = System.currentTimeMillis();
        return zzcz2;
    }
}

