/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.firebase_auth.zzaf;
import com.google.android.gms.internal.firebase_auth.zzct;
import com.google.android.gms.internal.firebase_auth.zzdb;
import com.google.firebase.auth.UserInfo;
import com.google.firebase.auth.internal.zzi;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Class(creator="DefaultAuthUserInfoCreator")
public final class zzh
extends AbstractSafeParcelable
implements UserInfo {
    public static final Parcelable.Creator<zzh> CREATOR = new zzi();
    @SafeParcelable.Field(id=1, getter="getUid")
    @NonNull
    private String zzqq;
    @SafeParcelable.Field(id=2, getter="getProviderId")
    @NonNull
    private String zzgb;
    @SafeParcelable.Field(id=3, getter="getDisplayName")
    @Nullable
    private String zzhw;
    @SafeParcelable.Field(id=4, getter="getPhotoUrlString")
    @Nullable
    private String zzhx;
    @Nullable
    private Uri zzia;
    @SafeParcelable.Field(id=5, getter="getEmail")
    @Nullable
    private String zzgh;
    @SafeParcelable.Field(id=6, getter="getPhoneNumber")
    @Nullable
    private String zzhq;
    @SafeParcelable.Field(id=7, getter="isEmailVerified")
    private boolean zzpa;
    @SafeParcelable.Field(id=8, getter="getRawUserInfo")
    @Nullable
    private String zzpl;

    @VisibleForTesting
    @SafeParcelable.Constructor
    public zzh(@SafeParcelable.Param(id=1) @NonNull String string, @SafeParcelable.Param(id=2) @NonNull String string2, @SafeParcelable.Param(id=5) @Nullable String string3, @SafeParcelable.Param(id=4) @Nullable String string4, @SafeParcelable.Param(id=3) @Nullable String string5, @SafeParcelable.Param(id=6) @Nullable String string6, @SafeParcelable.Param(id=7) boolean bl, @SafeParcelable.Param(id=8) @Nullable String string7) {
        this.zzqq = string;
        this.zzgb = string2;
        this.zzgh = string3;
        this.zzhq = string4;
        this.zzhw = string5;
        this.zzhx = string6;
        if (!TextUtils.isEmpty((CharSequence)this.zzhx)) {
            this.zzia = Uri.parse((String)this.zzhx);
        }
        this.zzpa = bl;
        this.zzpl = string7;
    }

    public zzh(@NonNull zzct zzct2, @NonNull String string) {
        Preconditions.checkNotNull((Object)((Object)zzct2));
        Preconditions.checkNotEmpty((String)string);
        this.zzqq = Preconditions.checkNotEmpty((String)zzct2.getLocalId());
        this.zzgb = string;
        this.zzgh = zzct2.getEmail();
        this.zzhw = zzct2.getDisplayName();
        Uri uri = zzct2.getPhotoUri();
        if (uri != null) {
            this.zzhx = uri.toString();
            this.zzia = uri;
        }
        this.zzpa = zzct2.isEmailVerified();
        this.zzpl = null;
        this.zzhq = zzct2.getPhoneNumber();
    }

    public zzh(@NonNull zzdb zzdb2) {
        Preconditions.checkNotNull((Object)((Object)zzdb2));
        this.zzqq = zzdb2.zzbg();
        this.zzgb = Preconditions.checkNotEmpty((String)zzdb2.getProviderId());
        this.zzhw = zzdb2.getDisplayName();
        Uri uri = zzdb2.getPhotoUri();
        if (uri != null) {
            this.zzhx = uri.toString();
            this.zzia = uri;
        }
        this.zzgh = zzdb2.getEmail();
        this.zzhq = zzdb2.getPhoneNumber();
        this.zzpa = false;
        this.zzpl = zzdb2.getRawUserInfo();
    }

    @Override
    @NonNull
    public final String getUid() {
        return this.zzqq;
    }

    @Override
    @NonNull
    public final String getProviderId() {
        return this.zzgb;
    }

    @Override
    @Nullable
    public final String getDisplayName() {
        return this.zzhw;
    }

    @Override
    @Nullable
    public final Uri getPhotoUrl() {
        if (!TextUtils.isEmpty((CharSequence)this.zzhx) && this.zzia == null) {
            this.zzia = Uri.parse((String)this.zzhx);
        }
        return this.zzia;
    }

    @Override
    @Nullable
    public final String getEmail() {
        return this.zzgh;
    }

    @Override
    @Nullable
    public final String getPhoneNumber() {
        return this.zzhq;
    }

    @Override
    public final boolean isEmailVerified() {
        return this.zzpa;
    }

    @Nullable
    public final String getRawUserInfo() {
        return this.zzpl;
    }

    @Nullable
    public final String zzdz() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.putOpt("userId", (Object)this.zzqq);
            jSONObject.putOpt("providerId", (Object)this.zzgb);
            jSONObject.putOpt("displayName", (Object)this.zzhw);
            jSONObject.putOpt("photoUrl", (Object)this.zzhx);
            jSONObject.putOpt("email", (Object)this.zzgh);
            jSONObject.putOpt("phoneNumber", (Object)this.zzhq);
            jSONObject.putOpt("isEmailVerified", (Object)this.zzpa);
            jSONObject.putOpt("rawUserInfo", (Object)this.zzpl);
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            Log.d((String)"DefaultAuthUserInfo", (String)"Failed to jsonify this object");
            throw new zzaf(jSONException);
        }
    }

    @Nullable
    public static zzh zzcr(@NonNull String string) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            String string2 = jSONObject.optString("userId");
            String string3 = jSONObject.optString("providerId");
            String string4 = jSONObject.optString("email");
            String string5 = jSONObject.optString("phoneNumber");
            String string6 = jSONObject.optString("displayName");
            String string7 = jSONObject.optString("photoUrl");
            boolean bl = jSONObject.optBoolean("isEmailVerified");
            String string8 = jSONObject.optString("rawUserInfo");
            return new zzh(string2, string3, string4, string5, string6, string7, bl, string8);
        }
        catch (JSONException jSONException) {
            Log.d((String)"DefaultAuthUserInfo", (String)"Failed to unpack UserInfo from JSON");
            throw new zzaf(jSONException);
        }
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzh zzh2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)1, (String)zzh2.getUid(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)zzh2.getProviderId(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)zzh2.getDisplayName(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)4, (String)zzh2.zzhx, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)5, (String)zzh2.getEmail(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)6, (String)zzh2.getPhoneNumber(), (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)7, (boolean)zzh2.isEmailVerified());
        SafeParcelWriter.writeString((Parcel)parcel2, (int)8, (String)zzh2.zzpl, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }
}

