/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_auth;

import com.google.android.gms.internal.firebase_auth.zzed;
import com.google.android.gms.internal.firebase_auth.zzfu;
import com.google.android.gms.internal.firebase_auth.zzga;
import com.google.android.gms.internal.firebase_auth.zzhm;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzfp
extends zzed<Float>
implements zzga<Float>,
zzhm,
RandomAccess {
    private static final zzfp zzwu = new zzfp();
    private float[] zzwv;
    private int size;

    zzfp() {
        this(new float[10], 0);
    }

    private zzfp(float[] fArray, int n) {
        this.zzwv = fArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzew();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzwv, n2, this.zzwv, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzfp)) {
            return super.equals(object);
        }
        zzfp zzfp2 = (zzfp)object;
        if (this.size != zzfp2.size) {
            return false;
        }
        float[] fArray = zzfp2.zzwv;
        for (int i = 0; i < this.size; ++i) {
            if (Float.floatToIntBits(this.zzwv[i]) == Float.floatToIntBits(fArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + Float.floatToIntBits(this.zzwv[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzc(float f) {
        this.zzc(this.size, f);
    }

    private final void zzc(int n, float f) {
        this.zzew();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzi(n));
        }
        if (this.size < this.zzwv.length) {
            System.arraycopy(this.zzwv, n, this.zzwv, n + 1, this.size - n);
        } else {
            float[] fArray = new float[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzwv, 0, fArray, 0, n);
            System.arraycopy(this.zzwv, n, fArray, n + 1, this.size - n);
            this.zzwv = fArray;
        }
        this.zzwv[n] = f;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Float> collection) {
        this.zzew();
        zzfu.checkNotNull(collection);
        if (!(collection instanceof zzfp)) {
            return super.addAll(collection);
        }
        zzfp zzfp2 = (zzfp)collection;
        if (zzfp2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzfp2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzfp2.size;
        if (n > this.zzwv.length) {
            this.zzwv = Arrays.copyOf(this.zzwv, n);
        }
        System.arraycopy(zzfp2.zzwv, 0, this.zzwv, this.size, zzfp2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzew();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(Float.valueOf(this.zzwv[i]))) continue;
            System.arraycopy(this.zzwv, i + 1, this.zzwv, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzh(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzi(n));
        }
    }

    private final String zzi(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Float f = (Float)object;
        float f2 = f.floatValue();
        zzfp zzfp2 = this;
        zzfp2.zzew();
        zzfp2.zzh(n);
        float f3 = zzfp2.zzwv[n];
        zzfp2.zzwv[n] = f2;
        return Float.valueOf(f3);
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzfp zzfp2 = this;
        zzfp2.zzew();
        zzfp2.zzh(n);
        float f = zzfp2.zzwv[n];
        if (n < zzfp2.size - 1) {
            System.arraycopy(zzfp2.zzwv, n + 1, zzfp2.zzwv, n, zzfp2.size - n);
        }
        --zzfp2.size;
        ++zzfp2.modCount;
        return Float.valueOf(f);
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Float f = (Float)object;
        this.zzc(n, f.floatValue());
    }

    @Override
    public final /* synthetic */ zzga zzj(int n) {
        int n2 = n;
        zzfp zzfp2 = this;
        if (n2 < zzfp2.size) {
            throw new IllegalArgumentException();
        }
        return new zzfp(Arrays.copyOf(zzfp2.zzwv, n2), zzfp2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzfp zzfp2 = this;
        zzfp2.zzh(n);
        return Float.valueOf(zzfp2.zzwv[n]);
    }

    static {
        zzwu.zzev();
    }
}

