/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appdistribution;

import com.google.api.client.http.HttpResponseException;
import com.google.common.base.Strings;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.google.firebase.appdistribution.ApiService;
import com.google.firebase.appdistribution.AppDistributionException;
import com.google.firebase.appdistribution.AppDistributionLogger;
import com.google.firebase.appdistribution.AppDistributionLoggerHelper;
import com.google.firebase.appdistribution.BinaryType;
import com.google.firebase.appdistribution.FirebaseAppDistributionOptions;
import com.google.firebase.appdistribution.ReleaseLookup;
import com.google.firebase.appdistribution.UploadService;
import com.google.firebase.appdistribution.models.AabState;
import com.google.firebase.appdistribution.models.App;
import com.google.firebase.appdistribution.models.Release;
import com.google.firebase.appdistribution.models.StatusToken;
import com.google.firebase.appdistribution.models.UploadStatus;
import com.google.firebase.appdistribution.models.UploadStatusResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;

public class FirebaseAppDistributionUpload {
    AppDistributionLogger LOGGER = AppDistributionLoggerHelper.getLogger();
    private FirebaseAppDistributionOptions options;
    private ApiService apiService;
    private UploadService uploadService;

    public FirebaseAppDistributionUpload(FirebaseAppDistributionOptions options, ApiService apiService, UploadService uploadService) {
        this.options = options;
        this.apiService = apiService;
        this.uploadService = uploadService;
    }

    public boolean uploadDistribution() {
        boolean success = true;
        Release release = null;
        ApiService.AppView appView = this.options.getBinaryType().equals((Object)BinaryType.AAB) ? ApiService.AppView.FULL : ApiService.AppView.BASIC;
        App app = this.getApp(appView);
        if (app.getContactEmail() == null || app.getContactEmail().isEmpty()) {
            throw new AppDistributionException(AppDistributionException.Reason.GET_APP_NO_CONTACT_EMAIL_ERROR);
        }
        if (this.options.getBinaryType() == BinaryType.AAB && app.getAabState() != AabState.ACTIVE && app.getAabState() != AabState.AAB_STATE_UNAVAILABLE) {
            throw AppDistributionException.forAabState(app.getAabState());
        }
        String binaryName = null;
        try {
            binaryName = String.format("projects/%s/apps/%s/releases/-/binaries/%s", app.getProjectNumber(), this.options.getAppId(), Files.asByteSource((File)this.options.getBinary()).hash(Hashing.sha256()).toString());
        }
        catch (IOException e) {
            throw AppDistributionException.fromIoException(AppDistributionException.Reason.GET_APP_ERROR, e);
        }
        UploadStatusResponse uploadStatusResponse = this.apiService.getUploadStatus(binaryName, this.options.getBinaryType());
        if (uploadStatusResponse.getStatus() == UploadStatus.SUCCESS) {
            release = uploadStatusResponse.getRelease();
            this.LOGGER.info(String.format("This %s has been uploaded before. Skipping upload step.", new Object[]{this.options.getBinaryType()}), new Object[0]);
        } else {
            this.LOGGER.info(String.format("This %s has not been uploaded before.", new Object[]{this.options.getBinaryType()}), new Object[0]);
        }
        if (release == null) {
            Optional<StatusToken> uploadResponse;
            this.LOGGER.info(String.format("Uploading the %s.", new Object[]{this.options.getBinaryType()}), new Object[0]);
            try {
                uploadResponse = this.uploadService.uploadDistribution(this.options.getAppId(), this.options.getBinary());
                success = uploadResponse.isPresent();
            }
            catch (HttpResponseException e) {
                throw AppDistributionException.fromHttpResponseException(AppDistributionException.Reason.uploadBinaryError(this.options.getBinaryType()), e);
            }
            catch (IOException e) {
                throw AppDistributionException.fromIoException(AppDistributionException.Reason.uploadBinaryError(this.options.getBinaryType()), e);
            }
            if (success) {
                ReleaseLookup releaseLookup = new ReleaseLookup();
                UploadStatusResponse releaseUploadResponse = releaseLookup.pollForRelease(this.apiService, uploadResponse.get().getToken(), this.options.getBinaryType());
                if (releaseUploadResponse.getStatus() == UploadStatus.SUCCESS) {
                    release = releaseUploadResponse.getRelease();
                } else if (releaseUploadResponse.getStatus() == UploadStatus.ERROR) {
                    throw new AppDistributionException(AppDistributionException.Reason.processingBinaryError(this.options.getBinaryType()), String.format("%s (Code: %s)", releaseUploadResponse.getMessage(), releaseUploadResponse.getErrorCode()));
                }
            }
        }
        if (success) {
            this.maybePrintAabCertificate(app);
            if (!Strings.isNullOrEmpty((String)this.options.getReleaseNotes())) {
                try {
                    success = this.apiService.createReleaseNotes(release.getId(), this.options.getReleaseNotes());
                }
                catch (HttpResponseException e) {
                    throw AppDistributionException.fromHttpResponseException(AppDistributionException.Reason.UPLOAD_RELEASE_NOTES_ERROR, e);
                }
                catch (IOException e) {
                    throw AppDistributionException.fromIoException(AppDistributionException.Reason.UPLOAD_RELEASE_NOTES_ERROR, e);
                }
            } else {
                this.LOGGER.info("No release notes passed in. Skipping this step.", new Object[0]);
            }
        }
        if (success) {
            if (this.hasTestersOrGroups(this.options.getTesters(), this.options.getGroups())) {
                try {
                    success = this.apiService.enableAccess(release.getId(), this.options.getTesters(), this.options.getGroups());
                }
                catch (HttpResponseException e) {
                    throw AppDistributionException.fromHttpResponseException(AppDistributionException.Reason.UPLOAD_TESTERS_ERROR, e);
                }
                catch (IOException e) {
                    throw AppDistributionException.fromIoException(AppDistributionException.Reason.UPLOAD_TESTERS_ERROR, e);
                }
            } else {
                this.LOGGER.info("No testers or groups passed in. Skipping this step.", new Object[0]);
            }
        }
        return success;
    }

    private App getApp(ApiService.AppView appView) {
        App app;
        try {
            app = this.apiService.getApp(appView);
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 404) {
                throw new AppDistributionException(AppDistributionException.Reason.APP_NOT_ONBOARDED_ERROR);
            }
            throw AppDistributionException.fromHttpResponseException(AppDistributionException.Reason.GET_APP_ERROR, e);
        }
        catch (IOException e) {
            throw AppDistributionException.fromIoException(AppDistributionException.Reason.GET_APP_ERROR, e);
        }
        return app;
    }

    private void maybePrintAabCertificate(App app) {
        App updatedApp;
        if (this.options.getBinaryType().equals((Object)BinaryType.AAB) && app.getAabCertificate() == null && (updatedApp = this.getApp(ApiService.AppView.BASIC)).getAabCertificate() != null) {
            this.LOGGER.info("After you upload an AAB for the first time, App Distribution generates a new test certificate. All AAB uploads are re-signed with this test certificate. Use the certificate fingerprints below to register your app signing key with API providers, such as Google Sign-In and Google Maps.", new Object[0]);
            this.LOGGER.info(String.format("MD5 certificate fingerprint: %s", updatedApp.getAabCertificate().getCertificateHashMd5()), new Object[0]);
            this.LOGGER.info(String.format("SHA-1 certificate fingerprint: %s", updatedApp.getAabCertificate().getCertificateHashSha1()), new Object[0]);
            this.LOGGER.info(String.format("SHA-256 certificate fingerprint: %s", updatedApp.getAabCertificate().getCertificateHashSha256()), new Object[0]);
        }
    }

    private boolean hasTestersOrGroups(List<String> testers, List<String> groups) {
        return testers != null && !testers.isEmpty() || groups != null && !groups.isEmpty();
    }
}

