/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appdistribution;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpTransport;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.firebase.appdistribution.AppDistributionEnvironment;
import com.google.firebase.appdistribution.AppDistributionEnvironmentImpl;
import com.google.firebase.appdistribution.AppDistributionException;
import com.google.firebase.appdistribution.BinaryType;
import com.google.firebase.appdistribution.RefreshToken;
import com.google.firebase.appdistribution.models.ServiceAccountCredentials;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;

public class FirebaseAppDistributionOptions {
    private File binary;
    private String appId;
    private String releaseNotes;
    private List<String> testers;
    private List<String> groups;
    private boolean debug;
    private Credential credentials;

    private FirebaseAppDistributionOptions() {
    }

    public File getBinary() {
        return this.binary;
    }

    public BinaryType getBinaryType() {
        return BinaryType.fromPath(this.binary.getName());
    }

    public String getAppId() {
        return this.appId;
    }

    public Credential getCredentials() {
        return this.credentials;
    }

    public String getReleaseNotes() {
        return this.releaseNotes;
    }

    public List<String> getTesters() {
        return this.testers;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public static Builder newBuilder() {
        try {
            return new Builder();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException("Cannot create secure transport");
        }
    }

    public static Builder newBuilder(HttpTransport transport) {
        return new Builder(transport);
    }

    public static Builder newBuilder(AppDistributionEnvironment appDistributionEnvironment) {
        try {
            return new Builder(appDistributionEnvironment);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException("Cannot create secure transport");
        }
    }

    public static class Builder {
        private final HttpTransport transport;
        private final AppDistributionEnvironment appDistributionEnvironment;
        private File binary;
        private String appId;
        private ServiceAccountCredentials serviceAccountCredentials;
        private String releaseNotes;
        private List<String> testers;
        private List<String> groups;
        private boolean debug = false;

        Builder() throws GeneralSecurityException, IOException {
            this((HttpTransport)GoogleNetHttpTransport.newTrustedTransport(), new AppDistributionEnvironmentImpl());
        }

        Builder(HttpTransport transport) {
            this(transport, new AppDistributionEnvironmentImpl());
        }

        Builder(AppDistributionEnvironment appDistributionEnvironment) throws GeneralSecurityException, IOException {
            this((HttpTransport)GoogleNetHttpTransport.newTrustedTransport(), appDistributionEnvironment);
        }

        Builder(HttpTransport transport, AppDistributionEnvironment appDistributionEnvironment) {
            this.transport = transport;
            this.appDistributionEnvironment = appDistributionEnvironment;
        }

        public FirebaseAppDistributionOptions build() {
            FirebaseAppDistributionOptions options = new FirebaseAppDistributionOptions();
            options.binary = this.binary;
            options.appId = this.appId;
            options.releaseNotes = this.releaseNotes;
            options.testers = this.testers;
            options.groups = this.groups;
            options.debug = this.debug;
            options.credentials = this.getAuthCredential();
            return options;
        }

        public Builder setDistributionFile(String distributionFile) {
            this.binary = this.ensureFile(distributionFile, AppDistributionException.Reason.binaryNotFoundError(BinaryType.fromPath(distributionFile)));
            return this;
        }

        public Builder setServiceAccountCredentialsFile(String serviceAccountCredentialsFile) {
            File serviceCredentialsFile = this.ensureFile(serviceAccountCredentialsFile, AppDistributionException.Reason.SERVICE_CREDENTIALS_NOT_FOUND);
            try {
                this.serviceAccountCredentials = ServiceAccountCredentials.fromFile(serviceCredentialsFile);
            }
            catch (IOException e) {
                throw new AppDistributionException(AppDistributionException.Reason.SERVICE_CREDENTIALS_NOT_FOUND, (Throwable)e);
            }
            return this;
        }

        public Builder setReleaseNotes(String releaseNotes, String releaseNotesFile) {
            this.releaseNotes = this.getValueFromValueOrPath(releaseNotes, releaseNotesFile);
            return this;
        }

        public Builder setTesters(String testers, String testersFile) {
            String testersValue = this.getValueFromValueOrPath(testers, testersFile);
            this.testers = this.extractListFromCommaSeparatedString(testersValue);
            return this;
        }

        public Builder setGroups(String groups, String groupsFile) {
            String groupsValue = this.getValueFromValueOrPath(groups, groupsFile);
            this.groups = this.extractListFromCommaSeparatedString(groupsValue);
            return this;
        }

        public Builder setAppId(String appId) {
            if (Strings.isNullOrEmpty((String)appId)) {
                throw new AppDistributionException(AppDistributionException.Reason.MISSING_APP_ID);
            }
            this.appId = appId;
            return this;
        }

        public Builder setDebug(boolean debug) {
            this.debug = debug;
            return this;
        }

        File ensureFile(String path, AppDistributionException.Reason missingFileReason) {
            File file = new File(path);
            if (!file.exists()) {
                throw new AppDistributionException(missingFileReason);
            }
            return file;
        }

        Credential getAuthCredential() {
            if (this.serviceAccountCredentials != null) {
                return this.serviceAccountCredentials.getGoogleCredential();
            }
            String envRefreshToken = System.getenv("FIREBASE_TOKEN");
            if (envRefreshToken != null) {
                try {
                    System.out.println(String.format("Using credentials token specified by environment variable %s", "FIREBASE_TOKEN"));
                    return new RefreshToken(envRefreshToken, this.transport).generateNewCredential();
                }
                catch (Exception e) {
                    throw new AppDistributionException(AppDistributionException.Reason.REFRESH_TOKEN_ERROR, "The refresh token set as the environment variable FIREBASE_TOKEN is not valid");
                }
            }
            Optional<Credential> firebaseCliLoginCreds = this.appDistributionEnvironment.getFirebaseCliLoginCredentials(this.transport);
            if (firebaseCliLoginCreds.isPresent()) {
                System.out.println("Using cached Firebase CLI credentials");
                return firebaseCliLoginCreds.get();
            }
            String envGoogleCredentials = System.getenv("GOOGLE_APPLICATION_CREDENTIALS");
            if (envGoogleCredentials != null) {
                System.out.println(String.format("Using credentials file specified by environment variable %s: %s", "GOOGLE_APPLICATION_CREDENTIALS", envGoogleCredentials));
                this.setServiceAccountCredentialsFile(envGoogleCredentials);
                return this.serviceAccountCredentials.getGoogleCredential();
            }
            return null;
        }

        List<String> extractListFromCommaSeparatedString(String str) {
            return str == null ? Lists.newArrayList() : Splitter.on((Pattern)Pattern.compile(",|\n")).omitEmptyStrings().trimResults().splitToList((CharSequence)str);
        }

        String getValueFromValueOrPath(String value, String path) {
            if (Strings.isNullOrEmpty((String)value) && !Strings.isNullOrEmpty((String)path)) {
                try {
                    return Files.toString((File)new File(path), (Charset)Charsets.UTF_8);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(String.format("Could not read content from %s", path), e);
                }
            }
            return value;
        }
    }
}

