/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelReader;
import com.google.android.gms.internal.measurement.zzfj;
import com.google.android.gms.internal.measurement.zzfk;
import com.google.android.gms.internal.measurement.zzfl;
import com.google.android.gms.internal.measurement.zzfm;
import com.google.android.gms.internal.measurement.zzfs;
import com.google.android.gms.internal.measurement.zzft;
import com.google.android.gms.internal.measurement.zzfv;
import com.google.android.gms.internal.measurement.zzfw;
import com.google.android.gms.internal.measurement.zzfx;
import com.google.android.gms.internal.measurement.zzfy;
import com.google.android.gms.internal.measurement.zzfz;
import com.google.android.gms.internal.measurement.zzya;
import com.google.android.gms.internal.measurement.zzyc;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzfn;
import com.google.android.gms.measurement.internal.zzfo;
import com.google.android.gms.measurement.internal.zzk;
import com.google.android.gms.measurement.internal.zzn;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class zzfu
extends zzfn {
    zzfu(zzfo zzfo2) {
        super(zzfo2);
    }

    @Override
    protected final boolean zzgy() {
        return false;
    }

    final void zza(zzfz zzfz2, Object object) {
        Preconditions.checkNotNull((Object)object);
        zzfz2.zzaml = null;
        zzfz2.zzaxe = null;
        zzfz2.zzaun = null;
        if (object instanceof String) {
            zzfz2.zzaml = (String)object;
            return;
        }
        if (object instanceof Long) {
            zzfz2.zzaxe = (Long)object;
            return;
        }
        if (object instanceof Double) {
            zzfz2.zzaun = (Double)object;
            return;
        }
        this.zzgt().zzjg().zzg("Ignoring invalid (type) user attribute value", object);
    }

    final void zza(com.google.android.gms.internal.measurement.zzfu zzfu2, Object object) {
        Preconditions.checkNotNull((Object)object);
        zzfu2.zzaml = null;
        zzfu2.zzaxe = null;
        zzfu2.zzaun = null;
        if (object instanceof String) {
            zzfu2.zzaml = (String)object;
            return;
        }
        if (object instanceof Long) {
            zzfu2.zzaxe = (Long)object;
            return;
        }
        if (object instanceof Double) {
            zzfu2.zzaun = (Double)object;
            return;
        }
        this.zzgt().zzjg().zzg("Ignoring invalid (type) event param value", object);
    }

    final byte[] zza(zzfv zzfv2) {
        try {
            byte[] byArray;
            byte[] byArray2 = byArray = new byte[zzfv2.zzvx()];
            zzya zzya2 = zzya.zzk((byte[])byArray, (int)0, (int)byArray2.length);
            zzfv2.zza(zzya2);
            zzya2.zzza();
            return byArray;
        }
        catch (IOException iOException) {
            this.zzgt().zzjg().zzg("Data loss. Failed to serialize batch", (Object)iOException);
            return null;
        }
    }

    static com.google.android.gms.internal.measurement.zzfu zza(zzft zzft2, String string) {
        com.google.android.gms.internal.measurement.zzfu[] zzfuArray = zzft2.zzaxa;
        int n = zzft2.zzaxa.length;
        for (int i = 0; i < n; ++i) {
            com.google.android.gms.internal.measurement.zzfu zzfu2 = zzfuArray[i];
            if (!zzfu2.name.equals(string)) continue;
            return zzfu2;
        }
        return null;
    }

    static Object zzb(zzft zzft2, String string) {
        com.google.android.gms.internal.measurement.zzfu zzfu2 = zzfu.zza(zzft2, string);
        if (zzfu2 != null) {
            if (zzfu2.zzaml != null) {
                return zzfu2.zzaml;
            }
            if (zzfu2.zzaxe != null) {
                return zzfu2.zzaxe;
            }
            if (zzfu2.zzaun != null) {
                return zzfu2.zzaun;
            }
        }
        return null;
    }

    static com.google.android.gms.internal.measurement.zzfu[] zza(com.google.android.gms.internal.measurement.zzfu[] zzfuArray, String string, Object object) {
        com.google.android.gms.internal.measurement.zzfu[] zzfuArray2 = zzfuArray;
        int n = zzfuArray.length;
        for (int i = 0; i < n; ++i) {
            com.google.android.gms.internal.measurement.zzfu zzfu2 = zzfuArray2[i];
            if (!string.equals(zzfu2.name)) continue;
            zzfu2.zzaxe = null;
            zzfu2.zzaml = null;
            zzfu2.zzaun = null;
            if (object instanceof Long) {
                zzfu2.zzaxe = (Long)object;
            } else if (object instanceof String) {
                zzfu2.zzaml = (String)object;
            } else if (object instanceof Double) {
                zzfu2.zzaun = (Double)object;
            }
            return zzfuArray;
        }
        zzfuArray2 = new com.google.android.gms.internal.measurement.zzfu[zzfuArray.length + 1];
        System.arraycopy(zzfuArray, 0, zzfuArray2, 0, zzfuArray.length);
        com.google.android.gms.internal.measurement.zzfu zzfu3 = new com.google.android.gms.internal.measurement.zzfu();
        new com.google.android.gms.internal.measurement.zzfu().name = string;
        if (object instanceof Long) {
            zzfu3.zzaxe = (Long)object;
        } else if (object instanceof String) {
            zzfu3.zzaml = (String)object;
        } else if (object instanceof Double) {
            zzfu3.zzaun = (Double)object;
        }
        zzfuArray2[zzfuArray.length] = zzfu3;
        return zzfuArray2;
    }

    final String zzb(zzfv zzfv2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nbatch {\n");
        if (zzfv2.zzaxf != null) {
            zzfw[] zzfwArray = zzfv2.zzaxf;
            int n = zzfv2.zzaxf.length;
            for (int i = 0; i < n; ++i) {
                Object object;
                int n2;
                int n3;
                Object object2;
                zzfw zzfw2 = zzfwArray[i];
                if (zzfw2 == null) continue;
                zzfw zzfw3 = zzfw2;
                StringBuilder stringBuilder2 = stringBuilder;
                zzfu zzfu2 = this;
                if (zzfw3 == null) continue;
                zzfu.zza(stringBuilder2, 1);
                stringBuilder2.append("bundle {\n");
                zzfu.zza(stringBuilder2, 1, "protocol_version", zzfw3.zzaxh);
                zzfu.zza(stringBuilder2, 1, "platform", zzfw3.zzaxp);
                zzfu.zza(stringBuilder2, 1, "gmp_version", zzfw3.zzaxt);
                zzfu.zza(stringBuilder2, 1, "uploading_gmp_version", zzfw3.zzaxu);
                zzfu.zza(stringBuilder2, 1, "config_version", zzfw3.zzayf);
                zzfu.zza(stringBuilder2, 1, "gmp_app_id", zzfw3.zzafi);
                zzfu.zza(stringBuilder2, 1, "admob_app_id", zzfw3.zzawp);
                zzfu.zza(stringBuilder2, 1, "app_id", zzfw3.zztt);
                zzfu.zza(stringBuilder2, 1, "app_version", zzfw3.zzts);
                zzfu.zza(stringBuilder2, 1, "app_version_major", zzfw3.zzayb);
                zzfu.zza(stringBuilder2, 1, "firebase_instance_id", zzfw3.zzafk);
                zzfu.zza(stringBuilder2, 1, "dev_cert_hash", zzfw3.zzaxx);
                zzfu.zza(stringBuilder2, 1, "app_store", zzfw3.zzafp);
                zzfu.zza(stringBuilder2, 1, "upload_timestamp_millis", zzfw3.zzaxk);
                zzfu.zza(stringBuilder2, 1, "start_timestamp_millis", zzfw3.zzaxl);
                zzfu.zza(stringBuilder2, 1, "end_timestamp_millis", zzfw3.zzaxm);
                zzfu.zza(stringBuilder2, 1, "previous_bundle_start_timestamp_millis", zzfw3.zzaxn);
                zzfu.zza(stringBuilder2, 1, "previous_bundle_end_timestamp_millis", zzfw3.zzaxo);
                zzfu.zza(stringBuilder2, 1, "app_instance_id", zzfw3.zzafh);
                zzfu.zza(stringBuilder2, 1, "resettable_device_id", zzfw3.zzaxv);
                zzfu.zza(stringBuilder2, 1, "device_id", zzfw3.zzaye);
                zzfu.zza(stringBuilder2, 1, "ds_id", zzfw3.zzayh);
                zzfu.zza(stringBuilder2, 1, "limited_ad_tracking", zzfw3.zzaxw);
                zzfu.zza(stringBuilder2, 1, "os_version", zzfw3.zzaxq);
                zzfu.zza(stringBuilder2, 1, "device_model", zzfw3.zzaxr);
                zzfu.zza(stringBuilder2, 1, "user_default_language", zzfw3.zzahr);
                zzfu.zza(stringBuilder2, 1, "time_zone_offset_minutes", zzfw3.zzaxs);
                zzfu.zza(stringBuilder2, 1, "bundle_sequential_index", zzfw3.zzaxy);
                zzfu.zza(stringBuilder2, 1, "service_upload", zzfw3.zzaxz);
                zzfu.zza(stringBuilder2, 1, "health_monitor", zzfw3.zzagm);
                if (zzfw3.zzayg != null && zzfw3.zzayg != 0L) {
                    zzfu.zza(stringBuilder2, 1, "android_id", zzfw3.zzayg);
                }
                if (zzfw3.zzayj != null) {
                    zzfu.zza(stringBuilder2, 1, "retry_counter", zzfw3.zzayj);
                }
                zzyc[] zzycArray = zzfw3.zzaxj;
                StringBuilder stringBuilder3 = stringBuilder2;
                zzfu zzfu3 = zzfu2;
                if (zzycArray != null) {
                    object2 = zzycArray;
                    n3 = zzycArray.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        zzfz zzfz2 = object2[n2];
                        if (zzfz2 == null) continue;
                        zzfu.zza(stringBuilder3, 2);
                        stringBuilder3.append("user_property {\n");
                        zzfu.zza(stringBuilder3, 2, "set_timestamp_millis", zzfz2.zzayu);
                        zzfu.zza(stringBuilder3, 2, "name", zzfu3.zzgq().zzbv(zzfz2.name));
                        zzfu.zza(stringBuilder3, 2, "string_value", zzfz2.zzaml);
                        zzfu.zza(stringBuilder3, 2, "int_value", zzfz2.zzaxe);
                        zzfu.zza(stringBuilder3, 2, "double_value", zzfz2.zzaun);
                        zzfu.zza(stringBuilder3, 2);
                        stringBuilder3.append("}\n");
                    }
                }
                object2 = zzfw3.zztt;
                zzycArray = zzfw3.zzaya;
                stringBuilder3 = stringBuilder2;
                zzfu3 = zzfu2;
                if (zzycArray != null) {
                    zzyc[] zzycArray2 = zzycArray;
                    n2 = zzycArray.length;
                    for (int j = 0; j < n2; ++j) {
                        object = zzycArray2[j];
                        if (object == null) continue;
                        zzfu.zza(stringBuilder3, 2);
                        stringBuilder3.append("audience_membership {\n");
                        zzfu.zza(stringBuilder3, 2, "audience_id", object.zzave);
                        zzfu.zza(stringBuilder3, 2, "new_audience", object.zzawv);
                        zzfu3.zza(stringBuilder3, 2, "current_data", object.zzawt, (String)object2);
                        zzfu3.zza(stringBuilder3, 2, "previous_data", object.zzawu, (String)object2);
                        zzfu.zza(stringBuilder3, 2);
                        stringBuilder3.append("}\n");
                    }
                }
                zzycArray = zzfw3.zzaxi;
                stringBuilder3 = stringBuilder2;
                zzfu3 = zzfu2;
                if (zzycArray != null) {
                    object2 = zzycArray;
                    n3 = zzycArray.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        zzfz zzfz3 = object2[n2];
                        if (zzfz3 == null) continue;
                        zzfu.zza(stringBuilder3, 2);
                        stringBuilder3.append("event {\n");
                        zzfu.zza(stringBuilder3, 2, "name", zzfu3.zzgq().zzbt(((zzft)((Object)zzfz3)).name));
                        zzfu.zza(stringBuilder3, 2, "timestamp_millis", ((zzft)((Object)zzfz3)).zzaxb);
                        zzfu.zza(stringBuilder3, 2, "previous_timestamp_millis", ((zzft)((Object)zzfz3)).zzaxc);
                        zzfu.zza(stringBuilder3, 2, "count", ((zzft)((Object)zzfz3)).count);
                        com.google.android.gms.internal.measurement.zzfu[] zzfuArray = ((zzft)((Object)zzfz3)).zzaxa;
                        StringBuilder stringBuilder4 = stringBuilder3;
                        object = zzfu3;
                        if (zzfuArray != null) {
                            com.google.android.gms.internal.measurement.zzfu[] zzfuArray2 = zzfuArray;
                            int n4 = zzfuArray.length;
                            for (int j = 0; j < n4; ++j) {
                                com.google.android.gms.internal.measurement.zzfu zzfu4 = zzfuArray2[j];
                                if (zzfu4 == null) continue;
                                zzfu.zza(stringBuilder4, 3);
                                stringBuilder4.append("param {\n");
                                zzfu.zza(stringBuilder4, 3, "name", object.zzgq().zzbu(zzfu4.name));
                                zzfu.zza(stringBuilder4, 3, "string_value", zzfu4.zzaml);
                                zzfu.zza(stringBuilder4, 3, "int_value", zzfu4.zzaxe);
                                zzfu.zza(stringBuilder4, 3, "double_value", zzfu4.zzaun);
                                zzfu.zza(stringBuilder4, 3);
                                stringBuilder4.append("}\n");
                            }
                        }
                        zzfu.zza(stringBuilder3, 2);
                        stringBuilder3.append("}\n");
                    }
                }
                zzfu.zza(stringBuilder2, 1);
                stringBuilder2.append("}\n");
            }
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    final String zza(zzfj zzfj2) {
        if (zzfj2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nevent_filter {\n");
        zzfu.zza(stringBuilder, 0, "filter_id", zzfj2.zzavk);
        zzfu.zza(stringBuilder, 0, "event_name", this.zzgq().zzbt(zzfj2.zzavl));
        this.zza(stringBuilder, 1, "event_count_filter", zzfj2.zzavo);
        stringBuilder.append("  filters {\n");
        zzfk[] zzfkArray = zzfj2.zzavm;
        int n = zzfj2.zzavm.length;
        for (int i = 0; i < n; ++i) {
            zzfk zzfk2 = zzfkArray[i];
            this.zza(stringBuilder, 2, zzfk2);
        }
        zzfu.zza(stringBuilder, 1);
        stringBuilder.append("}\n}\n");
        return stringBuilder.toString();
    }

    final String zza(zzfm zzfm2) {
        if (zzfm2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nproperty_filter {\n");
        zzfu.zza(stringBuilder, 0, "filter_id", zzfm2.zzavk);
        zzfu.zza(stringBuilder, 0, "property_name", this.zzgq().zzbv(zzfm2.zzawa));
        this.zza(stringBuilder, 1, zzfm2.zzawb);
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    private final void zza(StringBuilder stringBuilder, int n, String string, zzfx zzfx2, String string2) {
        Object object;
        int n2;
        int n3;
        Object[] objectArray;
        int n4;
        if (zzfx2 == null) {
            return;
        }
        zzfu.zza(stringBuilder, 3);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzfx2.zzayo != null) {
            zzfu.zza(stringBuilder, 4);
            stringBuilder.append("results: ");
            n4 = 0;
            objectArray = zzfx2.zzayo;
            n3 = zzfx2.zzayo.length;
            for (n2 = 0; n2 < n3; ++n2) {
                object = objectArray[n2];
                if (n4++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(object);
            }
            stringBuilder.append('\n');
        }
        if (zzfx2.zzayn != null) {
            zzfu.zza(stringBuilder, 4);
            stringBuilder.append("status: ");
            n4 = 0;
            objectArray = zzfx2.zzayn;
            n3 = zzfx2.zzayn.length;
            for (n2 = 0; n2 < n3; ++n2) {
                object = objectArray[n2];
                if (n4++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(object);
            }
            stringBuilder.append('\n');
        }
        if (this.zzgv().zzbb(string2)) {
            if (zzfx2.zzayp != null) {
                zzfu.zza(stringBuilder, 4);
                stringBuilder.append("dynamic_filter_timestamps: {");
                n4 = 0;
                objectArray = (Object[])zzfx2.zzayp;
                n3 = zzfx2.zzayp.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    object = objectArray[n2];
                    if (n4++ != 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(((zzfs)((Object)object)).zzawx).append(":").append(((zzfs)((Object)object)).zzawy);
                }
                stringBuilder.append("}\n");
            }
            if (zzfx2.zzayq != null) {
                zzfu.zza(stringBuilder, 4);
                stringBuilder.append("sequence_filter_timestamps: {");
                n4 = 0;
                objectArray = (Object[])zzfx2.zzayq;
                n3 = zzfx2.zzayq.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    object = objectArray[n2];
                    if (n4++ != 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(((zzfy)((Object)object)).zzawx).append(": [");
                    int n5 = 0;
                    long[] lArray = ((zzfy)((Object)((Object)object))).zzays;
                    int n6 = ((zzfy)((Object)((Object)object))).zzays.length;
                    for (int i = 0; i < n6; ++i) {
                        long l = lArray[i];
                        if (n5++ != 0) {
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append(l);
                    }
                    stringBuilder.append("]");
                }
                stringBuilder.append("}\n");
            }
        }
        zzfu.zza(stringBuilder, 3);
        stringBuilder.append("}\n");
    }

    private final void zza(StringBuilder stringBuilder, int n, String string, zzfl zzfl2) {
        if (zzfl2 == null) {
            return;
        }
        zzfu.zza(stringBuilder, n);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzfl2.zzavu != null) {
            String string2 = "UNKNOWN_COMPARISON_TYPE";
            switch (zzfl2.zzavu) {
                case 1: {
                    string2 = "LESS_THAN";
                    break;
                }
                case 2: {
                    string2 = "GREATER_THAN";
                    break;
                }
                case 3: {
                    string2 = "EQUAL";
                    break;
                }
                case 4: {
                    string2 = "BETWEEN";
                }
            }
            zzfu.zza(stringBuilder, n, "comparison_type", string2);
        }
        zzfu.zza(stringBuilder, n, "match_as_float", zzfl2.zzavv);
        zzfu.zza(stringBuilder, n, "comparison_value", zzfl2.zzavw);
        zzfu.zza(stringBuilder, n, "min_comparison_value", zzfl2.zzavx);
        zzfu.zza(stringBuilder, n, "max_comparison_value", zzfl2.zzavy);
        zzfu.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private final void zza(StringBuilder stringBuilder, int n, zzfk zzfk2) {
        if (zzfk2 == null) {
            return;
        }
        zzfu.zza(stringBuilder, n);
        stringBuilder.append("filter {\n");
        zzfu.zza(stringBuilder, n, "complement", zzfk2.zzavs);
        zzfu.zza(stringBuilder, n, "param_name", this.zzgq().zzbu(zzfk2.zzavt));
        com.google.android.gms.internal.measurement.zzfn zzfn2 = zzfk2.zzavq;
        String string = "string_filter";
        int n2 = n + 1;
        StringBuilder stringBuilder2 = stringBuilder;
        if (zzfn2 != null) {
            String[] stringArray;
            zzfu.zza(stringBuilder2, n2);
            stringBuilder2.append(string);
            stringBuilder2.append(" {\n");
            if (zzfn2.zzawc != null) {
                stringArray = "UNKNOWN_MATCH_TYPE";
                switch (zzfn2.zzawc) {
                    case 1: {
                        stringArray = "REGEXP";
                        break;
                    }
                    case 2: {
                        stringArray = "BEGINS_WITH";
                        break;
                    }
                    case 3: {
                        stringArray = "ENDS_WITH";
                        break;
                    }
                    case 4: {
                        stringArray = "PARTIAL";
                        break;
                    }
                    case 5: {
                        stringArray = "EXACT";
                        break;
                    }
                    case 6: {
                        stringArray = "IN_LIST";
                    }
                }
                zzfu.zza(stringBuilder2, n2, "match_type", stringArray);
            }
            zzfu.zza(stringBuilder2, n2, "expression", zzfn2.zzawd);
            zzfu.zza(stringBuilder2, n2, "case_sensitive", zzfn2.zzawe);
            if (zzfn2.zzawf.length > 0) {
                zzfu.zza(stringBuilder2, n2 + 1);
                stringBuilder2.append("expression_list {\n");
                stringArray = zzfn2.zzawf;
                int n3 = zzfn2.zzawf.length;
                for (int i = 0; i < n3; ++i) {
                    String string2 = stringArray[i];
                    zzfu.zza(stringBuilder2, n2 + 2);
                    stringBuilder2.append(string2);
                    stringBuilder2.append("\n");
                }
                stringBuilder2.append("}\n");
            }
            zzfu.zza(stringBuilder2, n2);
            stringBuilder2.append("}\n");
        }
        this.zza(stringBuilder, n + 1, "number_filter", zzfk2.zzavr);
        zzfu.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private static void zza(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("  ");
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, Object object) {
        if (object == null) {
            return;
        }
        zzfu.zza(stringBuilder, n + 1);
        stringBuilder.append(string);
        stringBuilder.append(": ");
        stringBuilder.append(object);
        stringBuilder.append('\n');
    }

    final <T extends Parcelable> T zza(byte[] byArray, Parcelable.Creator<T> creator) {
        if (byArray == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        try {
            parcel.unmarshall(byArray, 0, byArray.length);
            parcel.setDataPosition(0);
            Parcelable parcelable = (Parcelable)creator.createFromParcel(parcel);
            return (T)parcelable;
        }
        catch (SafeParcelReader.ParseException parseException) {
            this.zzgt().zzjg().zzby("Failed to load parcelable from buffer");
            return null;
        }
        finally {
            parcel.recycle();
        }
    }

    @WorkerThread
    final boolean zze(zzag zzag2, zzk zzk2) {
        Preconditions.checkNotNull((Object)zzag2);
        Preconditions.checkNotNull((Object)zzk2);
        if (TextUtils.isEmpty((CharSequence)zzk2.zzafi) && TextUtils.isEmpty((CharSequence)zzk2.zzafv)) {
            zzn zzn2 = this.zzgw();
            return false;
        }
        return true;
    }

    static boolean zzcs(String string) {
        return string != null && string.matches("([+-])?([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)") && string.length() <= 310;
    }

    static boolean zza(long[] lArray, int n) {
        if (n >= lArray.length << 6) {
            return false;
        }
        return (lArray[n / 64] & 1L << n % 64) != 0L;
    }

    static long[] zza(BitSet bitSet) {
        int n = (bitSet.length() + 63) / 64;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = 0L;
            for (int j = 0; j < 64 && (i << 6) + j < bitSet.length(); ++j) {
                if (!bitSet.get((i << 6) + j)) continue;
                int n2 = i;
                lArray[n2] = lArray[n2] | 1L << j;
            }
        }
        return lArray;
    }

    final boolean zzb(long l, long l2) {
        if (l == 0L || l2 <= 0L) {
            return true;
        }
        return Math.abs(this.zzbx().currentTimeMillis() - l) > l2;
    }

    final byte[] zza(byte[] byArray) throws IOException {
        try {
            int n;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[1024];
            while ((n = gZIPInputStream.read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            gZIPInputStream.close();
            byteArrayInputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzgt().zzjg().zzg("Failed to ungzip content", (Object)iOException);
            throw iOException;
        }
    }

    final byte[] zzb(byte[] byArray) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzgt().zzjg().zzg("Failed to gzip content", (Object)iOException);
            throw iOException;
        }
    }

    @Nullable
    final int[] zzmi() {
        Map map = zzai.zzm((Context)this.zzamv.getContext());
        if (map == null || map.size() == 0) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = (Integer)zzai.zzakg.get();
        for (Map.Entry entry : map.entrySet()) {
            if (!((String)entry.getKey()).startsWith("measurement.id.")) continue;
            try {
                int n2 = Integer.parseInt((String)entry.getValue());
                if (n2 == 0) continue;
                arrayList.add(n2);
                if (arrayList.size() < n) continue;
                this.zzgt().zzjj().zzg("Too many experiment IDs. Number of IDs", (Object)arrayList.size());
                break;
            }
            catch (NumberFormatException numberFormatException) {
                this.zzgt().zzjj().zzg("Experiment ID NumberFormatException", (Object)numberFormatException);
            }
        }
        if (arrayList.size() == 0) {
            return null;
        }
        Object object = new int[arrayList.size()];
        int n3 = 0;
        ArrayList<Integer> arrayList2 = arrayList;
        int n4 = arrayList2.size();
        for (int i = 0; i < n4; ++i) {
            Object e = arrayList2.get(i);
            Integer n5 = (Integer)e;
            object[n3++] = n5;
        }
        return object;
    }
}

