/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzbw;
import com.google.android.gms.measurement.internal.zzcr;
import com.google.android.gms.measurement.internal.zzcu;
import com.google.android.gms.measurement.internal.zzcw;
import com.google.android.gms.measurement.internal.zzcx;
import com.google.android.gms.measurement.internal.zzcy;
import com.google.android.gms.measurement.internal.zzdb;
import com.google.android.gms.measurement.internal.zzdc;
import com.google.android.gms.measurement.internal.zzdd;
import com.google.android.gms.measurement.internal.zzde;
import com.google.android.gms.measurement.internal.zzdf;
import com.google.android.gms.measurement.internal.zzdg;
import com.google.android.gms.measurement.internal.zzdi;
import com.google.android.gms.measurement.internal.zzdj;
import com.google.android.gms.measurement.internal.zzdk;
import com.google.android.gms.measurement.internal.zzdl;
import com.google.android.gms.measurement.internal.zzdm;
import com.google.android.gms.measurement.internal.zzdn;
import com.google.android.gms.measurement.internal.zzdo;
import com.google.android.gms.measurement.internal.zzdp;
import com.google.android.gms.measurement.internal.zzdq;
import com.google.android.gms.measurement.internal.zzdr;
import com.google.android.gms.measurement.internal.zzds;
import com.google.android.gms.measurement.internal.zzdt;
import com.google.android.gms.measurement.internal.zzdu;
import com.google.android.gms.measurement.internal.zzdx;
import com.google.android.gms.measurement.internal.zzdy;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfv;
import com.google.android.gms.measurement.internal.zzfy;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;

public final class zzda
extends zzf {
    @VisibleForTesting
    protected zzdu zzaqx;
    private zzcx zzaqy;
    private final Set<zzcy> zzaqz = new CopyOnWriteArraySet<zzcy>();
    private boolean zzara;
    private final AtomicReference<String> zzarb = new AtomicReference();
    @VisibleForTesting
    protected boolean zzarc = true;

    protected zzda(zzbw zzbw2) {
        super(zzbw2);
    }

    @Override
    protected final boolean zzgy() {
        return false;
    }

    public final void zzkw() {
        if (((zzcr)this).getContext().getApplicationContext() instanceof Application) {
            zzdu zzdu2 = this.zzaqx;
            ((Application)((zzcr)this).getContext().getApplicationContext()).unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzdu2);
        }
    }

    public final Boolean zzkx() {
        AtomicReference atomicReference = new AtomicReference();
        return (Boolean)((zzcr)this).zzgs().zza(atomicReference, 15000L, "boolean test flag value", new zzdb(this, atomicReference));
    }

    public final String zzky() {
        AtomicReference atomicReference = new AtomicReference();
        return (String)((zzcr)this).zzgs().zza(atomicReference, 15000L, "String test flag value", new zzdl(this, atomicReference));
    }

    public final Long zzkz() {
        AtomicReference atomicReference = new AtomicReference();
        return (Long)((zzcr)this).zzgs().zza(atomicReference, 15000L, "long test flag value", new zzdn(this, atomicReference));
    }

    public final Integer zzla() {
        AtomicReference atomicReference = new AtomicReference();
        return (Integer)((zzcr)this).zzgs().zza(atomicReference, 15000L, "int test flag value", new zzdo(this, atomicReference));
    }

    public final Double zzlb() {
        AtomicReference atomicReference = new AtomicReference();
        return (Double)((zzcr)this).zzgs().zza(atomicReference, 15000L, "double test flag value", new zzdp(this, atomicReference));
    }

    public final void setMeasurementEnabled(boolean bl) {
        this.zzcl();
        ((zzcr)this).zzgg();
        ((zzcr)this).zzgs().zzc(new zzdq(this, bl));
    }

    public final void zzd(boolean bl) {
        this.zzcl();
        ((zzcr)this).zzgg();
        ((zzcr)this).zzgs().zzc(new zzdr(this, bl));
    }

    @WorkerThread
    private final void zzj(boolean bl) {
        ((zzcr)this).zzaf();
        ((zzcr)this).zzgg();
        this.zzcl();
        ((zzcr)this).zzgt().zzjn().zzg("Setting app measurement enabled (FE)", bl);
        ((zzcr)this).zzgu().setMeasurementEnabled(bl);
        this.zzlc();
    }

    @WorkerThread
    private final void zzlc() {
        if (((zzcr)this).zzgv().zzba(((zze)this).zzgk().zzal()) && this.zzada.isEnabled() && this.zzarc) {
            ((zzcr)this).zzgt().zzjn().zzby("Recording app launch after enabling measurement for the first time (FE)");
            this.zzld();
            return;
        }
        ((zzcr)this).zzgt().zzjn().zzby("Updating Scion state (FE)");
        ((zze)this).zzgl().zzlg();
    }

    public final void setMinimumSessionDuration(long l) {
        ((zzcr)this).zzgg();
        ((zzcr)this).zzgs().zzc(new zzds(this, l));
    }

    public final void setSessionTimeoutDuration(long l) {
        ((zzcr)this).zzgg();
        ((zzcr)this).zzgs().zzc(new zzdt(this, l));
    }

    public final void zza(String string, String string2, Bundle bundle, boolean bl) {
        this.logEvent(string, string2, bundle, false, true, ((zzcr)this).zzbx().currentTimeMillis());
    }

    public final void logEvent(String string, String string2, Bundle bundle) {
        this.logEvent(string, string2, bundle, true, true, ((zzcr)this).zzbx().currentTimeMillis());
    }

    @WorkerThread
    final void zza(String string, String string2, Bundle bundle) {
        ((zzcr)this).zzgg();
        ((zzcr)this).zzaf();
        this.zza(string, string2, ((zzcr)this).zzbx().currentTimeMillis(), bundle);
    }

    @WorkerThread
    final void zza(String string, String string2, long l, Bundle bundle) {
        ((zzcr)this).zzgg();
        ((zzcr)this).zzaf();
        boolean bl = this.zzaqy == null || zzfy.zzcy(string2);
        this.zza(string, string2, l, bundle, true, bl, false, null);
    }

    @WorkerThread
    private final void zza(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle2;
        Object object;
        Object object2;
        Object object3;
        zzdx zzdx2;
        zzdx zzdx3;
        Object object4;
        Object object5;
        zzcr zzcr2;
        Preconditions.checkNotEmpty((String)string);
        if (!((zzcr)this).zzgv().zze(string3, zzai.zzalg)) {
            Preconditions.checkNotEmpty((String)string2);
        }
        Preconditions.checkNotNull((Object)bundle);
        ((zzcr)this).zzaf();
        this.zzcl();
        if (!this.zzada.isEnabled()) {
            ((zzcr)this).zzgt().zzjn().zzby("Event not sent since app measurement is disabled");
            return;
        }
        if (!this.zzara) {
            this.zzara = true;
            zzcr2 = this;
            try {
                object5 = Class.forName("com.google.android.gms.tagmanager.TagManagerService");
                Class<?> clazz = object5;
                object4 = zzcr2;
                try {
                    clazz.getDeclaredMethod("initialize", Context.class).invoke(null, ((zzcr)object4).getContext());
                }
                catch (Exception exception) {
                    ((zzcr)object4).zzgt().zzjj().zzg("Failed to invoke Tag Manager's initialize() method", exception);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                zzcr2.zzgt().zzjm().zzby("Tag Manager is not found and thus will not be used");
            }
        }
        if (bl3) {
            object4 = ((zzcr)this).zzgw();
            if (!"_iap".equals(string2)) {
                int n;
                object5 = string2;
                zzcr2 = this.zzada.zzgr();
                if ((!((zzfy)zzcr2).zzs("event", (String)object5) ? 2 : (!((zzfy)zzcr2).zza("event", zzcu.zzaqq, (String)object5) ? 13 : (n = !((zzfy)zzcr2).zza("event", 40, (String)object5) ? 2 : 0))) != 0) {
                    ((zzcr)this).zzgt().zzji().zzg("Invalid public event name. Event will not be logged (FE)", ((zzcr)this).zzgq().zzbt(string2));
                    this.zzada.zzgr();
                    String string4 = zzfy.zza(string2, 40, true);
                    int n2 = string2 != null ? string2.length() : 0;
                    this.zzada.zzgr().zza(n, "_ev", string4, n2);
                    return;
                }
            }
        }
        object4 = ((zzcr)this).zzgw();
        zzdx zzdx4 = ((zze)this).zzgm().zzle();
        if (zzdx4 != null && !bundle.containsKey("_sc")) {
            zzdx4.zzarp = true;
        }
        zzdx zzdx5 = zzdx4;
        zzdy.zza(zzdx5, bundle, bl && bl3);
        boolean bl4 = "am".equals(string);
        boolean bl5 = zzfy.zzcy(string2);
        if (bl && this.zzaqy != null && !bl5 && !bl4) {
            ((zzcr)this).zzgt().zzjn().zze("Passing event to registered event handler (FE)", ((zzcr)this).zzgq().zzbt(string2), ((zzcr)this).zzgq().zzd(bundle));
            this.zzaqy.interceptEvent(string, string2, bundle, l);
            return;
        }
        if (!this.zzada.zzkv()) {
            return;
        }
        int n = ((zzcr)this).zzgr().zzcu(string2);
        if (n != 0) {
            ((zzcr)this).zzgt().zzji().zzg("Invalid event name. Event will not be logged (FE)", ((zzcr)this).zzgq().zzbt(string2));
            ((zzcr)this).zzgr();
            String string5 = zzfy.zza(string2, 40, true);
            int n3 = string2 != null ? string2.length() : 0;
            this.zzada.zzgr().zza(string3, n, "_ev", string5, n3);
            return;
        }
        List list = CollectionUtils.listOf((Object[])new String[]{"_o", "_sn", "_sc", "_si"});
        Bundle bundle3 = ((zzcr)this).zzgr().zza(string3, string2, bundle, list, bl3, true);
        zzcr2 = bundle3;
        if (bundle3 == null || !zzcr2.containsKey("_sc") || !zzcr2.containsKey("_si")) {
            zzdx3 = null;
        } else {
            object5 = zzcr2.getString("_sn");
            String string6 = zzcr2.getString("_sc");
            Long l2 = zzcr2.getLong("_si");
            zzdx3 = zzdx2 = new zzdx((String)object5, string6, l2);
        }
        if (zzdx3 == null) {
            zzdx2 = zzdx5;
        }
        if (((zzcr)this).zzgv().zzbk(string3)) {
            long l3;
            object4 = ((zzcr)this).zzgw();
            if (((zze)this).zzgm().zzle() != null && "_ae".equals(string2) && (l3 = ((zze)this).zzgo().zzlp()) > 0L) {
                ((zzcr)this).zzgr().zza(bundle3, l3);
            }
        }
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        arrayList.add(bundle3);
        long l4 = ((zzcr)this).zzgr().zzmk().nextLong();
        if (((zzcr)this).zzgv().zzbj(((zze)this).zzgk().zzal()) && bundle3.getLong("extend_session", 0L) == 1L) {
            ((zzcr)this).zzgt().zzjo().zzby("EXTEND_SESSION param attached: initiate a new session or extend the current active session");
            this.zzada.zzgo().zza(l, true);
        }
        int n4 = 0;
        Object[] objectArray = bundle3.keySet().toArray(new String[bundle.size()]);
        Arrays.sort(objectArray);
        Object[] objectArray2 = objectArray;
        int n5 = objectArray.length;
        for (int i = 0; i < n5; ++i) {
            object3 = objectArray2[i];
            object2 = bundle3.get((String)object3);
            ((zzcr)this).zzgr();
            object = zzfy.zzf(object2);
            if (object == null) continue;
            bundle3.putInt((String)object3, ((Bundle[])object).length);
            for (int j = 0; j < ((Bundle[])object).length; ++j) {
                Bundle bundle4 = object[j];
                zzdy.zza(zzdx2, bundle4, true);
                bundle2 = ((zzcr)this).zzgr().zza(string3, "_ep", bundle4, list, bl3, false);
                bundle2.putString("_en", string2);
                bundle2.putLong("_eid", l4);
                bundle2.putString("_gn", (String)object3);
                bundle2.putInt("_ll", ((Bundle[])object).length);
                bundle2.putInt("_i", j);
                arrayList.add(bundle2);
            }
            n4 += ((Bundle[])object).length;
        }
        if (n4 != 0) {
            bundle3.putLong("_eid", l4);
            bundle3.putInt("_epc", n4);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Bundle bundle5 = (Bundle)arrayList.get(i);
            object3 = i != 0 ? "_ep" : string2;
            bundle5.putString("_o", string);
            object2 = bl2 ? ((zzcr)this).zzgr().zze(bundle5) : bundle5;
            ((zzcr)this).zzgt().zzjn().zze("Logging event (FE)", ((zzcr)this).zzgq().zzbt(string2), ((zzcr)this).zzgq().zzd((Bundle)object2));
            object = new zzag((String)object3, new zzad((Bundle)object2), string, l);
            ((zze)this).zzgl().zzc((zzag)((Object)object), string3);
            if (bl4) continue;
            for (zzcy zzcy2 : this.zzaqz) {
                bundle2 = new Bundle((Bundle)object2);
                zzcy2.onEvent(string, string2, bundle2, l);
            }
        }
        object4 = ((zzcr)this).zzgw();
        if (((zze)this).zzgm().zzle() != null && "_ae".equals(string2)) {
            ((zze)this).zzgo().zza(true, true);
        }
    }

    public final void logEvent(String string, String string2, Bundle bundle, boolean bl, boolean bl2, long l) {
        ((zzcr)this).zzgg();
        if (string == null) {
            string = "app";
        }
        if (bundle == null) {
            bundle = new Bundle();
        }
        boolean bl3 = !bl2 || this.zzaqy == null || zzfy.zzcy(string2);
        this.zzb(string, string2, l, bundle, bl2, bl3, !bl, null);
    }

    private final void zzb(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle2 = zzfy.zzf(bundle);
        ((zzcr)this).zzgs().zzc(new zzdc(this, string, string2, l, bundle2, bl, bl2, bl3, string3));
    }

    public final void zzb(String string, String string2, Object object, boolean bl) {
        this.zza(string, string2, object, bl, ((zzcr)this).zzbx().currentTimeMillis());
    }

    public final void zza(String string, String string2, Object object, boolean bl, long l) {
        int n;
        int n2;
        if (string == null) {
            string = "app";
        }
        if (bl) {
            n2 = ((zzcr)this).zzgr().zzcv(string2);
        } else {
            String string3 = string2;
            zzfy zzfy2 = ((zzcr)this).zzgr();
            n2 = !zzfy2.zzs("user property", string3) ? 6 : (!zzfy2.zza("user property", zzcw.zzaqu, string3) ? 15 : (n = !zzfy2.zza("user property", 24, string3) ? 6 : 0));
        }
        if (n2 != 0) {
            ((zzcr)this).zzgr();
            String string4 = zzfy.zza(string2, 24, true);
            int n3 = string2 != null ? string2.length() : 0;
            this.zzada.zzgr().zza(n, "_ev", string4, n3);
            return;
        }
        if (object != null) {
            n = ((zzcr)this).zzgr().zzi(string2, object);
            if (n != 0) {
                ((zzcr)this).zzgr();
                String string5 = zzfy.zza(string2, 24, true);
                int n4 = 0;
                if (object instanceof String || object instanceof CharSequence) {
                    n4 = String.valueOf(object).length();
                }
                this.zzada.zzgr().zza(n, "_ev", string5, n4);
                return;
            }
            Object object2 = ((zzcr)this).zzgr().zzj(string2, object);
            if (object2 != null) {
                this.zza(string, string2, l, object2);
            }
            return;
        }
        this.zza(string, string2, l, (Object)null);
    }

    private final void zza(String string, String string2, long l, Object object) {
        ((zzcr)this).zzgs().zzc(new zzdd(this, string, string2, object, l));
    }

    @WorkerThread
    final void zza(String string, String string2, Object object, long l) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        ((zzcr)this).zzaf();
        ((zzcr)this).zzgg();
        this.zzcl();
        if (!this.zzada.isEnabled()) {
            ((zzcr)this).zzgt().zzjn().zzby("User property not set since app measurement is disabled");
            return;
        }
        if (!this.zzada.zzkv()) {
            return;
        }
        ((zzcr)this).zzgt().zzjn().zze("Setting user property (FE)", ((zzcr)this).zzgq().zzbt(string2), object);
        zzfv zzfv2 = new zzfv(string2, l, object, string);
        ((zze)this).zzgl().zzb(zzfv2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<zzfv> zzk(boolean bl) {
        ((zzcr)this).zzgg();
        this.zzcl();
        ((zzcr)this).zzgt().zzjn().zzby("Fetching user attributes (FE)");
        if (((zzcr)this).zzgs().zzkf()) {
            ((zzcr)this).zzgt().zzjg().zzby("Cannot get all user properties from analytics worker thread");
            return Collections.emptyList();
        }
        if (zzn.isMainThread()) {
            ((zzcr)this).zzgt().zzjg().zzby("Cannot get all user properties from main thread");
            return Collections.emptyList();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzada.zzgs().zzc(new zzde(this, atomicReference, bl));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzcr)this).zzgt().zzjj().zzg("Interrupted waiting for get user properties", interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzcr)this).zzgt().zzjj().zzby("Timed out waiting for get user properties");
                return Collections.emptyList();
            }
            return object;
        }
    }

    @Nullable
    public final String zzgc() {
        ((zzcr)this).zzgg();
        return this.zzarb.get();
    }

    @Nullable
    public final String zzag(long l) {
        if (((zzcr)this).zzgs().zzkf()) {
            ((zzcr)this).zzgt().zzjg().zzby("Cannot retrieve app instance id from analytics worker thread");
            return null;
        }
        if (zzn.isMainThread()) {
            ((zzcr)this).zzgt().zzjg().zzby("Cannot retrieve app instance id from main thread");
            return null;
        }
        long l2 = ((zzcr)this).zzbx().elapsedRealtime();
        String string = this.zzah(120000L);
        long l3 = ((zzcr)this).zzbx().elapsedRealtime() - l2;
        if (string == null && l3 < 120000L) {
            string = this.zzah(120000L - l3);
        }
        return string;
    }

    final void zzcp(@Nullable String string) {
        this.zzarb.set(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private final String zzah(long l) {
        AtomicReference atomicReference;
        AtomicReference atomicReference2 = atomicReference = new AtomicReference();
        synchronized (atomicReference) {
            ((zzcr)this).zzgs().zzc(new zzdf(this, atomicReference));
            try {
                atomicReference.wait(l);
            }
            catch (InterruptedException interruptedException) {
                ((zzcr)this).zzgt().zzjj().zzby("Interrupted waiting for app instance id");
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return null;
            }
            return (String)atomicReference.get();
        }
    }

    public final void resetAnalyticsData(long l) {
        if (((zzcr)this).zzgv().zza(zzai.zzalb)) {
            this.zzcp(null);
        }
        ((zzcr)this).zzgs().zzc(new zzdg(this, l));
    }

    @WorkerThread
    public final void zzld() {
        ((zzcr)this).zzaf();
        ((zzcr)this).zzgg();
        this.zzcl();
        if (!this.zzada.zzkv()) {
            return;
        }
        ((zze)this).zzgl().zzld();
        this.zzarc = false;
        String string = ((zzcr)this).zzgu().zzka();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            ((zzcr)this).zzgp().zzcl();
            if (!string.equals(Build.VERSION.RELEASE)) {
                Bundle bundle = new Bundle();
                bundle.putString("_po", string);
                this.logEvent("auto", "_ou", bundle);
            }
        }
    }

    @WorkerThread
    public final void zza(zzcx zzcx2) {
        ((zzcr)this).zzaf();
        ((zzcr)this).zzgg();
        this.zzcl();
        if (zzcx2 != null && zzcx2 != this.zzaqy) {
            Preconditions.checkState((this.zzaqy == null ? 1 : 0) != 0, (Object)"EventInterceptor already set.");
        }
        this.zzaqy = zzcx2;
    }

    public final void zza(zzcy zzcy2) {
        ((zzcr)this).zzgg();
        this.zzcl();
        Preconditions.checkNotNull((Object)zzcy2);
        if (!this.zzaqz.add(zzcy2)) {
            ((zzcr)this).zzgt().zzjj().zzby("OnEventListener already registered");
        }
    }

    public final void zzb(zzcy zzcy2) {
        ((zzcr)this).zzgg();
        this.zzcl();
        Preconditions.checkNotNull((Object)zzcy2);
        if (!this.zzaqz.remove(zzcy2)) {
            ((zzcr)this).zzgt().zzjj().zzby("OnEventListener had not been registered");
        }
    }

    public final void setConditionalUserProperty(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        ((zzcr)this).zzgg();
        AppMeasurement.ConditionalUserProperty conditionalUserProperty2 = new AppMeasurement.ConditionalUserProperty(conditionalUserProperty);
        if (!TextUtils.isEmpty((CharSequence)conditionalUserProperty2.mAppId)) {
            ((zzcr)this).zzgt().zzjj().zzby("Package name should be null when calling setConditionalUserProperty");
        }
        conditionalUserProperty2.mAppId = null;
        this.zza(conditionalUserProperty2);
    }

    public final void setConditionalUserPropertyAs(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mAppId);
        ((zzcr)this).zzgf();
        this.zza(new AppMeasurement.ConditionalUserProperty(conditionalUserProperty));
    }

    private final void zza(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        long l = ((zzcr)this).zzbx().currentTimeMillis();
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mName);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mOrigin);
        Preconditions.checkNotNull((Object)conditionalUserProperty.mValue);
        conditionalUserProperty.mCreationTimestamp = l;
        String string = conditionalUserProperty.mName;
        Object object = conditionalUserProperty.mValue;
        if (((zzcr)this).zzgr().zzcv(string) != 0) {
            ((zzcr)this).zzgt().zzjg().zzg("Invalid conditional user property name", ((zzcr)this).zzgq().zzbv(string));
            return;
        }
        if (((zzcr)this).zzgr().zzi(string, object) != 0) {
            ((zzcr)this).zzgt().zzjg().zze("Invalid conditional user property value", ((zzcr)this).zzgq().zzbv(string), object);
            return;
        }
        Object object2 = ((zzcr)this).zzgr().zzj(string, object);
        if (object2 == null) {
            ((zzcr)this).zzgt().zzjg().zze("Unable to normalize conditional user property value", ((zzcr)this).zzgq().zzbv(string), object);
            return;
        }
        conditionalUserProperty.mValue = object2;
        long l2 = conditionalUserProperty.mTriggerTimeout;
        if (!(TextUtils.isEmpty((CharSequence)conditionalUserProperty.mTriggerEventName) || l2 <= 15552000000L && l2 >= 1L)) {
            ((zzcr)this).zzgt().zzjg().zze("Invalid conditional user property timeout", ((zzcr)this).zzgq().zzbv(string), l2);
            return;
        }
        long l3 = conditionalUserProperty.mTimeToLive;
        if (l3 > 15552000000L || l3 < 1L) {
            ((zzcr)this).zzgt().zzjg().zze("Invalid conditional user property time to live", ((zzcr)this).zzgq().zzbv(string), l3);
            return;
        }
        ((zzcr)this).zzgs().zzc(new zzdi(this, conditionalUserProperty));
    }

    public final void clearConditionalUserProperty(String string, String string2, Bundle bundle) {
        ((zzcr)this).zzgg();
        this.zza(null, string, string2, bundle);
    }

    public final void clearConditionalUserPropertyAs(String string, String string2, String string3, Bundle bundle) {
        Preconditions.checkNotEmpty((String)string);
        ((zzcr)this).zzgf();
        this.zza(string, string2, string3, bundle);
    }

    private final void zza(String string, String string2, String string3, Bundle bundle) {
        long l = ((zzcr)this).zzbx().currentTimeMillis();
        Preconditions.checkNotEmpty((String)string2);
        AppMeasurement.ConditionalUserProperty conditionalUserProperty = new AppMeasurement.ConditionalUserProperty();
        new AppMeasurement.ConditionalUserProperty().mAppId = string;
        conditionalUserProperty.mName = string2;
        conditionalUserProperty.mCreationTimestamp = l;
        if (string3 != null) {
            conditionalUserProperty.mExpiredEventName = string3;
            conditionalUserProperty.mExpiredEventParams = bundle;
        }
        ((zzcr)this).zzgs().zzc(new zzdj(this, conditionalUserProperty));
    }

    @WorkerThread
    private final void zzb(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzag zzag2;
        zzag zzag3;
        zzag zzag4;
        ((zzcr)this).zzaf();
        this.zzcl();
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mName);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mOrigin);
        Preconditions.checkNotNull((Object)conditionalUserProperty.mValue);
        if (!this.zzada.isEnabled()) {
            ((zzcr)this).zzgt().zzjn().zzby("Conditional property not sent since collection is disabled");
            return;
        }
        zzfv zzfv2 = new zzfv(conditionalUserProperty.mName, conditionalUserProperty.mTriggeredTimestamp, conditionalUserProperty.mValue, conditionalUserProperty.mOrigin);
        try {
            zzag4 = ((zzcr)this).zzgr().zza(conditionalUserProperty.mAppId, conditionalUserProperty.mTriggeredEventName, conditionalUserProperty.mTriggeredEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
            zzag3 = ((zzcr)this).zzgr().zza(conditionalUserProperty.mAppId, conditionalUserProperty.mTimedOutEventName, conditionalUserProperty.mTimedOutEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
            zzag2 = ((zzcr)this).zzgr().zza(conditionalUserProperty.mAppId, conditionalUserProperty.mExpiredEventName, conditionalUserProperty.mExpiredEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzo zzo2 = new zzo(conditionalUserProperty.mAppId, conditionalUserProperty.mOrigin, zzfv2, conditionalUserProperty.mCreationTimestamp, false, conditionalUserProperty.mTriggerEventName, zzag3, conditionalUserProperty.mTriggerTimeout, zzag4, conditionalUserProperty.mTimeToLive, zzag2);
        ((zze)this).zzgl().zzd(zzo2);
    }

    @WorkerThread
    private final void zzc(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzag zzag2;
        ((zzcr)this).zzaf();
        this.zzcl();
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mName);
        if (!this.zzada.isEnabled()) {
            ((zzcr)this).zzgt().zzjn().zzby("Conditional property not cleared since collection is disabled");
            return;
        }
        zzfv zzfv2 = new zzfv(conditionalUserProperty.mName, 0L, null, null);
        try {
            zzag2 = ((zzcr)this).zzgr().zza(conditionalUserProperty.mAppId, conditionalUserProperty.mExpiredEventName, conditionalUserProperty.mExpiredEventParams, conditionalUserProperty.mOrigin, conditionalUserProperty.mCreationTimestamp, true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzo zzo2 = new zzo(conditionalUserProperty.mAppId, conditionalUserProperty.mOrigin, zzfv2, conditionalUserProperty.mCreationTimestamp, conditionalUserProperty.mActive, conditionalUserProperty.mTriggerEventName, null, conditionalUserProperty.mTriggerTimeout, null, conditionalUserProperty.mTimeToLive, zzag2);
        ((zze)this).zzgl().zzd(zzo2);
    }

    public final List<AppMeasurement.ConditionalUserProperty> getConditionalUserProperties(String string, String string2) {
        ((zzcr)this).zzgg();
        return this.zzf(null, string, string2);
    }

    public final List<AppMeasurement.ConditionalUserProperty> getConditionalUserPropertiesAs(String string, String string2, String string3) {
        Preconditions.checkNotEmpty((String)string);
        ((zzcr)this).zzgf();
        return this.zzf(string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final List<AppMeasurement.ConditionalUserProperty> zzf(String string, String string2, String string3) {
        if (((zzcr)this).zzgs().zzkf()) {
            ((zzcr)this).zzgt().zzjg().zzby("Cannot get conditional user properties from analytics worker thread");
            return Collections.emptyList();
        }
        if (zzn.isMainThread()) {
            ((zzcr)this).zzgt().zzjg().zzby("Cannot get conditional user properties from main thread");
            return Collections.emptyList();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzada.zzgs().zzc(new zzdk(this, atomicReference, string, string2, string3));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzcr)this).zzgt().zzjj().zze("Interrupted waiting for get conditional user properties", string, interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzcr)this).zzgt().zzjj().zzg("Timed out waiting for get conditional user properties", string);
                return Collections.emptyList();
            }
            ArrayList<AppMeasurement.ConditionalUserProperty> arrayList = new ArrayList<AppMeasurement.ConditionalUserProperty>(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                zzo zzo2 = (zzo)((Object)iterator.next());
                AppMeasurement.ConditionalUserProperty conditionalUserProperty = new AppMeasurement.ConditionalUserProperty();
                new AppMeasurement.ConditionalUserProperty().mAppId = zzo2.packageName;
                conditionalUserProperty.mOrigin = zzo2.origin;
                conditionalUserProperty.mCreationTimestamp = zzo2.creationTimestamp;
                conditionalUserProperty.mName = zzo2.zzags.name;
                conditionalUserProperty.mValue = zzo2.zzags.getValue();
                conditionalUserProperty.mActive = zzo2.active;
                conditionalUserProperty.mTriggerEventName = zzo2.triggerEventName;
                if (zzo2.zzagt != null) {
                    conditionalUserProperty.mTimedOutEventName = zzo2.zzagt.name;
                    if (zzo2.zzagt.zzahu != null) {
                        conditionalUserProperty.mTimedOutEventParams = zzo2.zzagt.zzahu.zziy();
                    }
                }
                conditionalUserProperty.mTriggerTimeout = zzo2.triggerTimeout;
                if (zzo2.zzagu != null) {
                    conditionalUserProperty.mTriggeredEventName = zzo2.zzagu.name;
                    if (zzo2.zzagu.zzahu != null) {
                        conditionalUserProperty.mTriggeredEventParams = zzo2.zzagu.zzahu.zziy();
                    }
                }
                conditionalUserProperty.mTriggeredTimestamp = zzo2.zzags.zzauk;
                conditionalUserProperty.mTimeToLive = zzo2.timeToLive;
                if (zzo2.zzagv != null) {
                    conditionalUserProperty.mExpiredEventName = zzo2.zzagv.name;
                    if (zzo2.zzagv.zzahu != null) {
                        conditionalUserProperty.mExpiredEventParams = zzo2.zzagv.zzahu.zziy();
                    }
                }
                arrayList.add(conditionalUserProperty);
            }
            return arrayList;
        }
    }

    public final Map<String, Object> getUserProperties(String string, String string2, boolean bl) {
        ((zzcr)this).zzgg();
        return this.zzb(null, string, string2, bl);
    }

    public final Map<String, Object> getUserPropertiesAs(String string, String string2, String string3, boolean bl) {
        Preconditions.checkNotEmpty((String)string);
        ((zzcr)this).zzgf();
        return this.zzb(string, string2, string3, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final Map<String, Object> zzb(String string, String string2, String string3, boolean bl) {
        if (((zzcr)this).zzgs().zzkf()) {
            ((zzcr)this).zzgt().zzjg().zzby("Cannot get user properties from analytics worker thread");
            return Collections.emptyMap();
        }
        if (zzn.isMainThread()) {
            ((zzcr)this).zzgt().zzjg().zzby("Cannot get user properties from main thread");
            return Collections.emptyMap();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzada.zzgs().zzc(new zzdm(this, atomicReference, string, string2, string3, bl));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzcr)this).zzgt().zzjj().zzg("Interrupted waiting for get user properties", interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzcr)this).zzgt().zzjj().zzby("Timed out waiting for get user properties");
                return Collections.emptyMap();
            }
            ArrayMap arrayMap = new ArrayMap(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                zzfv zzfv2 = (zzfv)((Object)iterator.next());
                arrayMap.put(zzfv2.name, zzfv2.getValue());
            }
            return arrayMap;
        }
    }

    @Nullable
    public final String getCurrentScreenName() {
        zzdx zzdx2 = this.zzada.zzgm().zzlf();
        if (zzdx2 != null) {
            return zzdx2.zzuw;
        }
        return null;
    }

    @Nullable
    public final String getCurrentScreenClass() {
        zzdx zzdx2 = this.zzada.zzgm().zzlf();
        if (zzdx2 != null) {
            return zzdx2.zzarn;
        }
        return null;
    }

    @Nullable
    public final String getGmpAppId() {
        if (this.zzada.zzko() != null) {
            return this.zzada.zzko();
        }
        try {
            return GoogleServices.getGoogleAppId();
        }
        catch (IllegalStateException illegalStateException) {
            this.zzada.zzgt().zzjg().zzg("getGoogleAppId failed with exception", illegalStateException);
            return null;
        }
    }

    static /* synthetic */ void zza(zzda zzda2, boolean bl) {
        zzda2.zzj(bl);
    }

    static /* synthetic */ void zza(zzda zzda2) {
        zzda2.zzlc();
    }

    static /* synthetic */ void zza(zzda zzda2, String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        zzda2.zza(string, string2, l, bundle, bl, bl2, bl3, string3);
    }

    static /* synthetic */ void zza(zzda zzda2, AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzda2.zzb(conditionalUserProperty);
    }

    static /* synthetic */ void zzb(zzda zzda2, AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzda2.zzc(conditionalUserProperty);
    }
}

