/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.internal.StringResourceValueReader;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.InstantApps;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzbw;
import com.google.android.gms.measurement.internal.zzcr;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzk;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzq;

public final class zzam
extends zzf {
    private String zztt;
    private String zzts;
    private int zzalk;
    private String zzafp;
    private String zztr;
    private long zzall;
    private long zzafs;
    private int zzagp;
    private String zzafi;
    private String zzafv;

    zzam(zzbw zzbw2) {
        super(zzbw2);
    }

    @Override
    protected final boolean zzgy() {
        return true;
    }

    @Override
    protected final void zzgz() {
        Object object;
        PackageInfo packageInfo;
        String string = "unknown";
        String string2 = "Unknown";
        int n = Integer.MIN_VALUE;
        String string3 = "Unknown";
        String string4 = ((zzcr)this).getContext().getPackageName();
        PackageManager packageManager = ((zzcr)this).getContext().getPackageManager();
        if (packageManager == null) {
            ((zzcr)this).zzgt().zzjg().zzg("PackageManager is null, app identity information might be inaccurate. appId", zzas.zzbw(string4));
        } else {
            try {
                string = packageManager.getInstallerPackageName(string4);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ((zzcr)this).zzgt().zzjg().zzg("Error retrieving app installer package name. appId", zzas.zzbw(string4));
            }
            if (string == null) {
                string = "manual_install";
            } else if ("com.android.vending".equals(string)) {
                string = "";
            }
            try {
                packageInfo = packageManager.getPackageInfo(((zzcr)this).getContext().getPackageName(), 0);
                if (packageInfo != null) {
                    CharSequence charSequence = packageManager.getApplicationLabel(packageInfo.applicationInfo);
                    if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                        string3 = charSequence.toString();
                    }
                    string2 = packageInfo.versionName;
                    n = packageInfo.versionCode;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                ((zzcr)this).zzgt().zzjg().zze("Error retrieving package info. appId, appName", zzas.zzbw(string4), string3);
            }
        }
        this.zztt = string4;
        this.zzafp = string;
        this.zzts = string2;
        this.zzalk = n;
        this.zztr = string3;
        this.zzall = 0L;
        zzn zzn2 = ((zzcr)this).zzgw();
        packageInfo = GoogleServices.initialize((Context)((zzcr)this).getContext());
        boolean bl = (packageInfo != null && packageInfo.isSuccess()) | (!TextUtils.isEmpty((CharSequence)this.zzada.zzko()) && "am".equals(this.zzada.zzkp()));
        if (!bl) {
            PackageInfo packageInfo2 = packageInfo;
            zzam zzam2 = this;
            if (packageInfo2 == null) {
                ((zzcr)zzam2).zzgt().zzjg().zzby("GoogleService failed to initialize (no status)");
            } else {
                ((zzcr)zzam2).zzgt().zzjg().zze("GoogleService failed to initialize, status", packageInfo2.getStatusCode(), packageInfo2.getStatusMessage());
            }
        }
        boolean bl2 = false;
        if (bl) {
            object = ((zzcr)this).zzgv().zzia();
            if (((zzcr)this).zzgv().zzhz()) {
                if (this.zzada.zzkn()) {
                    ((zzcr)this).zzgt().zzjm().zzby("Collection disabled with firebase_analytics_collection_deactivated=1");
                }
            } else if (object != null && !((Boolean)object).booleanValue()) {
                if (this.zzada.zzkn()) {
                    ((zzcr)this).zzgt().zzjm().zzby("Collection disabled with firebase_analytics_collection_enabled=0");
                }
            } else if (object == null && GoogleServices.isMeasurementExplicitlyDisabled()) {
                ((zzcr)this).zzgt().zzjm().zzby("Collection disabled with google_app_measurement_enable=0");
            } else {
                bl2 = true;
                ((zzcr)this).zzgt().zzjo().zzby("Collection enabled");
            }
        }
        this.zzafi = "";
        this.zzafv = "";
        this.zzafs = 0L;
        zzn2 = ((zzcr)this).zzgw();
        if (!TextUtils.isEmpty((CharSequence)this.zzada.zzko()) && "am".equals(this.zzada.zzkp())) {
            this.zzafv = this.zzada.zzko();
        }
        try {
            object = GoogleServices.getGoogleAppId();
            Object object2 = this.zzafi = TextUtils.isEmpty((CharSequence)object) ? "" : object;
            if (!TextUtils.isEmpty((CharSequence)object)) {
                StringResourceValueReader stringResourceValueReader = new StringResourceValueReader(((zzcr)this).getContext());
                this.zzafv = stringResourceValueReader.getString("admob_app_id");
            }
            if (bl2) {
                ((zzcr)this).zzgt().zzjo().zze("App package, google app id", this.zztt, this.zzafi);
            }
        }
        catch (IllegalStateException illegalStateException) {
            ((zzcr)this).zzgt().zzjg().zze("getGoogleAppId or isMeasurementEnabled failed with exception. appId", zzas.zzbw(string4), illegalStateException);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            this.zzagp = InstantApps.isInstantApp((Context)((zzcr)this).getContext()) ? 1 : 0;
            return;
        }
        this.zzagp = 0;
    }

    @WorkerThread
    final zzk zzbs(String string) {
        ((zzcr)this).zzaf();
        ((zzcr)this).zzgg();
        String string2 = this.zzal();
        String string3 = this.getGmpAppId();
        zzcr zzcr2 = this;
        ((zzf)zzcr2).zzcl();
        String string4 = ((zzam)zzcr2).zzts;
        long l = this.zzjd();
        zzcr2 = this;
        ((zzf)zzcr2).zzcl();
        String string5 = ((zzam)zzcr2).zzafp;
        long l2 = ((zzcr)this).zzgv().zzhh();
        zzcr2 = this;
        ((zzf)zzcr2).zzcl();
        zzcr2.zzaf();
        if (((zzam)zzcr2).zzall == 0L) {
            ((zzam)zzcr2).zzall = ((zzam)zzcr2).zzada.zzgr().zzd(zzcr2.getContext(), zzcr2.getContext().getPackageName());
        }
        long l3 = ((zzam)zzcr2).zzall;
        boolean bl = this.zzada.isEnabled();
        boolean bl2 = !((zzcr)this).zzgu().zzanq;
        zzcr2 = this;
        zzcr2.zzaf();
        zzcr2.zzgg();
        String string6 = zzcr2.zzgv().zzaz(((zzam)zzcr2).zztt) && !((zzam)zzcr2).zzada.isEnabled() ? null : ((zzam)zzcr2).zzjc();
        zzcr2 = this;
        ((zzf)zzcr2).zzcl();
        long l4 = ((zzam)zzcr2).zzafs;
        long l5 = this.zzada.zzkt();
        int n = this.zzje();
        zzcr2 = ((zzcr)this).zzgv();
        zzcr2.zzgg();
        Boolean bl3 = ((zzq)zzcr2).zzar("google_analytics_adid_collection_enabled");
        boolean bl4 = bl3 == null || bl3 != false;
        zzcr2 = ((zzcr)this).zzgv();
        zzcr2.zzgg();
        bl3 = ((zzq)zzcr2).zzar("google_analytics_ssaid_collection_enabled");
        return new zzk(string2, string3, string4, l, string5, l2, l3, string, bl, bl2, string6, l4, l5, n, bl4, bl3 == null || bl3 != false, ((zzcr)this).zzgu().zzkb(), this.zzhb());
    }

    @WorkerThread
    @VisibleForTesting
    private final String zzjc() {
        Object object;
        Class<?> clazz;
        try {
            clazz = ((zzcr)this).getContext().getClassLoader().loadClass("com.google.firebase.analytics.FirebaseAnalytics");
            if (clazz == null) {
                return null;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        try {
            object = clazz.getDeclaredMethod("getInstance", Context.class).invoke(null, ((zzcr)this).getContext());
            if (object == null) {
                return null;
            }
        }
        catch (Exception exception) {
            ((zzcr)this).zzgt().zzjk().zzby("Failed to obtain Firebase Analytics instance");
            return null;
        }
        try {
            return (String)clazz.getDeclaredMethod("getFirebaseInstanceId", new Class[0]).invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            ((zzcr)this).zzgt().zzjl().zzby("Failed to retrieve Firebase Instance Id");
            return null;
        }
    }

    final String zzal() {
        this.zzcl();
        return this.zztt;
    }

    final String getGmpAppId() {
        this.zzcl();
        return this.zzafi;
    }

    final String zzhb() {
        this.zzcl();
        return this.zzafv;
    }

    final int zzjd() {
        this.zzcl();
        return this.zzalk;
    }

    final int zzje() {
        this.zzcl();
        return this.zzagp;
    }
}

