/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzcii;
import com.google.android.gms.internal.zzciu;
import com.google.android.gms.internal.zzcix;
import com.google.android.gms.internal.zzcke;
import com.google.android.gms.internal.zzckj;
import com.google.android.gms.internal.zzclh;
import com.google.android.gms.internal.zzcli;
import com.google.android.gms.internal.zzcll;
import com.google.android.gms.internal.zzclm;
import com.google.android.gms.internal.zzcln;
import com.google.android.gms.internal.zzclo;
import com.google.android.gms.internal.zzclp;
import com.google.android.gms.internal.zzclq;
import com.google.android.gms.internal.zzclr;
import com.google.android.gms.internal.zzcls;
import com.google.android.gms.internal.zzclt;
import com.google.android.gms.internal.zzclu;
import com.google.android.gms.internal.zzclv;
import com.google.android.gms.internal.zzclw;
import com.google.android.gms.internal.zzclx;
import com.google.android.gms.internal.zzcly;
import com.google.android.gms.internal.zzcma;
import com.google.android.gms.internal.zzcmd;
import com.google.android.gms.internal.zzcnl;
import com.google.android.gms.internal.zzcno;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

public final class zzclk
extends zzcli {
    protected zzcly zzjpt;
    private AppMeasurement.EventInterceptor zzjpu;
    private final Set<AppMeasurement.OnEventListener> zzjpv = new CopyOnWriteArraySet<AppMeasurement.OnEventListener>();
    private boolean zzjpw;
    private final AtomicReference<String> zzjpx = new AtomicReference();

    protected zzclk(zzckj zzckj2) {
        super(zzckj2);
    }

    @Override
    protected final boolean zzazq() {
        return false;
    }

    public final void setMeasurementEnabled(boolean bl) {
        this.zzyk();
        ((zzclh)this).zzayo().zzh(new zzcll(this, bl));
    }

    @WorkerThread
    private final void zzbu(boolean bl) {
        ((zzclh)this).zzwj();
        this.zzyk();
        ((zzclh)this).zzayp().zzbaz().zzj("Setting app measurement enabled (FE)", bl);
        ((zzclh)this).zzayq().setMeasurementEnabled(bl);
        ((zzclh)this).zzayg().zzbci();
    }

    public final void setMinimumSessionDuration(long l) {
        ((zzclh)this).zzayo().zzh(new zzclq(this, l));
    }

    public final void setSessionTimeoutDuration(long l) {
        ((zzclh)this).zzayo().zzh(new zzclr(this, l));
    }

    public final void zza(String string, String string2, Bundle bundle, boolean bl) {
        boolean bl2 = this.zzjpu == null || zzcno.zzkp(string2);
        this.zza(string, string2, bundle, true, bl2, true, null);
    }

    public final void zzd(String string, String string2, Bundle bundle) {
        boolean bl = this.zzjpu == null || zzcno.zzkp(string2);
        this.zza(string, string2, bundle, true, bl, false, null);
    }

    public final void zza(String string, String string2, Bundle bundle, long l) {
        this.zza(string, string2, l, bundle, false, true, true, null);
    }

    private final void zza(String string, String string2, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        this.zza(string, string2, ((zzclh)this).zzxx().currentTimeMillis(), bundle, true, bl2, bl3, null);
    }

    private final void zza(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle2;
        Bundle bundle3 = bundle;
        if (bundle3 == null) {
            bundle2 = new Bundle();
        } else {
            Bundle bundle4 = new Bundle(bundle3);
            for (String string4 : bundle4.keySet()) {
                int n;
                Object object;
                Object object2 = bundle4.get(string4);
                if (object2 instanceof Bundle) {
                    bundle4.putBundle(string4, new Bundle((Bundle)object2));
                    continue;
                }
                if (object2 instanceof Parcelable[]) {
                    object = (Parcelable[])object2;
                    for (n = 0; n < ((Parcelable[])object).length; ++n) {
                        if (!(object[n] instanceof Bundle)) continue;
                        object[n] = new Bundle((Bundle)object[n]);
                    }
                    continue;
                }
                if (!(object2 instanceof ArrayList)) continue;
                object = (ArrayList)object2;
                for (n = 0; n < ((ArrayList)object).size(); ++n) {
                    Object e = ((ArrayList)object).get(n);
                    if (!(e instanceof Bundle)) continue;
                    ((ArrayList)object).set(n, new Bundle((Bundle)e));
                }
            }
            bundle2 = bundle4;
        }
        Bundle bundle5 = bundle2;
        ((zzclh)this).zzayo().zzh(new zzcls(this, string, string2, l, bundle5, bl, bl2, bl3, string3));
    }

    @WorkerThread
    private final void zzb(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle2;
        Object object;
        Object object2;
        Object object3;
        zzcmd zzcmd2;
        zzcmd zzcmd3;
        zzcmd zzcmd4;
        Object object4;
        zzcli zzcli2;
        zzbq.zzgv((String)string);
        zzbq.zzgv((String)string2);
        zzbq.checkNotNull((Object)bundle);
        ((zzclh)this).zzwj();
        this.zzyk();
        if (!this.zzjev.isEnabled()) {
            ((zzclh)this).zzayp().zzbaz().log("Event not sent since app measurement is disabled");
            return;
        }
        if (!this.zzjpw) {
            this.zzjpw = true;
            zzcli2 = this;
            try {
                object4 = Class.forName("com.google.android.gms.tagmanager.TagManagerService");
                Class<?> clazz = object4;
                zzclk zzclk2 = zzcli2;
                try {
                    clazz.getDeclaredMethod("initialize", Context.class).invoke(null, ((zzclh)zzclk2).getContext());
                }
                catch (Exception exception) {
                    ((zzclh)zzclk2).zzayp().zzbaw().zzj("Failed to invoke Tag Manager's initialize() method", exception);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                zzcli2.zzayp().zzbay().log("Tag Manager is not found and thus will not be used");
            }
        }
        if (bl3 && !"_iap".equals(string2)) {
            int n;
            object4 = string2;
            zzcli2 = this.zzjev.zzayl();
            if ((!((zzcno)zzcli2).zzaq("event", (String)object4) ? 2 : (!((zzcno)zzcli2).zza("event", AppMeasurement.Event.zzjew, (String)object4) ? 13 : (n = !((zzcno)zzcli2).zzb("event", 40, (String)object4) ? 2 : 0))) != 0) {
                this.zzjev.zzayl();
                String string4 = zzcno.zza(string2, 40, true);
                int n2 = string2 != null ? string2.length() : 0;
                this.zzjev.zzayl().zza(n, "_ev", string4, n2);
                return;
            }
        }
        if ((zzcmd4 = ((zzclh)this).zzayh().zzbcg()) != null && !bundle.containsKey("_sc")) {
            zzcmd4.zzjra = true;
        }
        zzcmd zzcmd5 = zzcmd4;
        zzcma.zza(zzcmd5, bundle, bl && bl3);
        boolean bl4 = "am".equals(string);
        boolean bl5 = zzcno.zzkp(string2);
        if (bl && this.zzjpu != null && !bl5 && !bl4) {
            ((zzclh)this).zzayp().zzbaz().zze("Passing event to registered event handler (FE)", ((zzclh)this).zzayk().zzjp(string2), ((zzclh)this).zzayk().zzac(bundle));
            this.zzjpu.interceptEvent(string, string2, bundle, l);
            return;
        }
        if (!this.zzjev.zzbbn()) {
            return;
        }
        int n = ((zzclh)this).zzayl().zzki(string2);
        if (n != 0) {
            ((zzclh)this).zzayl();
            String string5 = zzcno.zza(string2, 40, true);
            int n3 = string2 != null ? string2.length() : 0;
            this.zzjev.zzayl().zza(string3, n, "_ev", string5, n3);
            return;
        }
        zzcli2 = new String[]{"_o", "_sn", "_sc", "_si"};
        List<String> list = Collections.unmodifiableList(Arrays.asList(zzcli2));
        Bundle bundle3 = ((zzclh)this).zzayl().zza(string2, bundle, list, bl3, true);
        zzcli2 = bundle3;
        if (bundle3 == null || !zzcli2.containsKey("_sc") || !zzcli2.containsKey("_si")) {
            zzcmd3 = null;
        } else {
            object4 = zzcli2.getString("_sn");
            String string6 = zzcli2.getString("_sc");
            Long l2 = zzcli2.getLong("_si");
            zzcmd3 = zzcmd2 = new zzcmd((String)object4, string6, l2);
        }
        if (zzcmd3 == null) {
            zzcmd2 = zzcmd5;
        }
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        arrayList.add(bundle3);
        long l3 = ((zzclh)this).zzayl().zzbcr().nextLong();
        int n4 = 0;
        Object[] objectArray = bundle3.keySet().toArray(new String[bundle.size()]);
        Arrays.sort(objectArray);
        Object[] objectArray2 = objectArray;
        int n5 = objectArray.length;
        for (int i = 0; i < n5; ++i) {
            object3 = objectArray2[i];
            object2 = bundle3.get((String)object3);
            ((zzclh)this).zzayl();
            object = zzcno.zzaf(object2);
            if (object == null) continue;
            bundle3.putInt((String)object3, ((Bundle[])object).length);
            for (int j = 0; j < ((Bundle[])object).length; ++j) {
                Bundle object5 = object[j];
                zzcma.zza(zzcmd2, object5, true);
                bundle2 = ((zzclh)this).zzayl().zza("_ep", object5, list, bl3, false);
                bundle2.putString("_en", string2);
                bundle2.putLong("_eid", l3);
                bundle2.putString("_gn", (String)object3);
                bundle2.putInt("_ll", ((Bundle[])object).length);
                bundle2.putInt("_i", j);
                arrayList.add(bundle2);
            }
            n4 += ((Bundle[])object).length;
        }
        if (n4 != 0) {
            bundle3.putLong("_eid", l3);
            bundle3.putInt("_epc", n4);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Bundle bundle4 = (Bundle)arrayList.get(i);
            object3 = i != 0 ? "_ep" : string2;
            bundle4.putString("_o", string);
            object2 = bl2 ? ((zzclh)this).zzayl().zzad(bundle4) : bundle4;
            ((zzclh)this).zzayp().zzbaz().zze("Logging event (FE)", ((zzclh)this).zzayk().zzjp(string2), ((zzclh)this).zzayk().zzac((Bundle)object2));
            object = new zzcix((String)object3, new zzciu((Bundle)object2), string, l);
            ((zzclh)this).zzayg().zzc((zzcix)((Object)object), string3);
            if (bl4) continue;
            for (AppMeasurement.OnEventListener onEventListener : this.zzjpv) {
                bundle2 = new Bundle((Bundle)object2);
                onEventListener.onEvent(string, string2, bundle2, l);
            }
        }
        if (((zzclh)this).zzayh().zzbcg() != null && "_ae".equals(string2)) {
            ((zzclh)this).zzayn().zzbx(true);
        }
    }

    public final void zzb(String string, String string2, Object object) {
        zzbq.zzgv((String)string);
        long l = ((zzclh)this).zzxx().currentTimeMillis();
        int n = ((zzclh)this).zzayl().zzkk(string2);
        if (n != 0) {
            ((zzclh)this).zzayl();
            String string3 = zzcno.zza(string2, 24, true);
            int n2 = string2 != null ? string2.length() : 0;
            this.zzjev.zzayl().zza(n, "_ev", string3, n2);
            return;
        }
        if (object != null) {
            n = ((zzclh)this).zzayl().zzl(string2, object);
            if (n != 0) {
                ((zzclh)this).zzayl();
                String string4 = zzcno.zza(string2, 24, true);
                int n3 = 0;
                if (object instanceof String || object instanceof CharSequence) {
                    n3 = String.valueOf(object).length();
                }
                this.zzjev.zzayl().zza(n, "_ev", string4, n3);
                return;
            }
            Object object2 = ((zzclh)this).zzayl().zzm(string2, object);
            if (object2 != null) {
                this.zza(string, string2, l, object2);
            }
            return;
        }
        this.zza(string, string2, l, null);
    }

    private final void zza(String string, String string2, long l, Object object) {
        ((zzclh)this).zzayo().zzh(new zzclt(this, string, string2, object, l));
    }

    @WorkerThread
    private final void zza(String string, String string2, Object object, long l) {
        zzbq.zzgv((String)string);
        zzbq.zzgv((String)string2);
        ((zzclh)this).zzwj();
        this.zzyk();
        if (!this.zzjev.isEnabled()) {
            ((zzclh)this).zzayp().zzbaz().log("User property not set since app measurement is disabled");
            return;
        }
        if (!this.zzjev.zzbbn()) {
            return;
        }
        ((zzclh)this).zzayp().zzbaz().zze("Setting user property (FE)", ((zzclh)this).zzayk().zzjp(string2), object);
        zzcnl zzcnl2 = new zzcnl(string2, l, object, string);
        ((zzclh)this).zzayg().zzb(zzcnl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<zzcnl> zzbv(boolean bl) {
        this.zzyk();
        ((zzclh)this).zzayp().zzbaz().log("Fetching user attributes (FE)");
        if (((zzclh)this).zzayo().zzbbk()) {
            ((zzclh)this).zzayp().zzbau().log("Cannot get all user properties from analytics worker thread");
            return Collections.emptyList();
        }
        ((zzclh)this).zzayo();
        if (zzcke.zzas()) {
            ((zzclh)this).zzayp().zzbau().log("Cannot get all user properties from main thread");
            return Collections.emptyList();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzjev.zzayo().zzh(new zzclu(this, atomicReference, bl));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzclh)this).zzayp().zzbaw().zzj("Interrupted waiting for get user properties", interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzclh)this).zzayp().zzbaw().log("Timed out waiting for get user properties");
                return Collections.emptyList();
            }
            return object;
        }
    }

    public final Task<String> getAppInstanceId() {
        try {
            String string = ((zzclh)this).zzayq().zzbbf();
            if (string != null) {
                return Tasks.forResult((Object)string);
            }
            return Tasks.call((Executor)((zzclh)this).zzayo().zzbbl(), (Callable)new zzclv(this));
        }
        catch (Exception exception) {
            ((zzclh)this).zzayp().zzbaw().log("Failed to schedule task for getAppInstanceId");
            return Tasks.forException((Exception)exception);
        }
    }

    @Nullable
    public final String zzbbf() {
        return this.zzjpx.get();
    }

    final void zzjx(@Nullable String string) {
        this.zzjpx.set(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    final String zzbd(long l) {
        AtomicReference atomicReference;
        AtomicReference atomicReference2 = atomicReference = new AtomicReference();
        synchronized (atomicReference) {
            ((zzclh)this).zzayo().zzh(new zzclw(this, atomicReference));
            try {
                atomicReference.wait(l);
            }
            catch (InterruptedException interruptedException) {
                ((zzclh)this).zzayp().zzbaw().log("Interrupted waiting for app instance id");
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return null;
            }
            return (String)atomicReference.get();
        }
    }

    public final void resetAnalyticsData() {
        ((zzclh)this).zzayo().zzh(new zzclx(this));
    }

    @WorkerThread
    public final void setEventInterceptor(AppMeasurement.EventInterceptor eventInterceptor) {
        ((zzclh)this).zzwj();
        this.zzyk();
        if (eventInterceptor != null && eventInterceptor != this.zzjpu) {
            zzbq.zza((this.zzjpu == null ? 1 : 0) != 0, (Object)"EventInterceptor already set.");
        }
        this.zzjpu = eventInterceptor;
    }

    @Hide
    public final void registerOnMeasurementEventListener(AppMeasurement.OnEventListener onEventListener) {
        this.zzyk();
        zzbq.checkNotNull((Object)onEventListener);
        if (!this.zzjpv.add(onEventListener)) {
            ((zzclh)this).zzayp().zzbaw().log("OnEventListener already registered");
        }
    }

    @Hide
    public final void unregisterOnMeasurementEventListener(AppMeasurement.OnEventListener onEventListener) {
        this.zzyk();
        zzbq.checkNotNull((Object)onEventListener);
        if (!this.zzjpv.remove(onEventListener)) {
            ((zzclh)this).zzayp().zzbaw().log("OnEventListener had not been registered");
        }
    }

    public final void setConditionalUserProperty(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzbq.checkNotNull((Object)conditionalUserProperty);
        AppMeasurement.ConditionalUserProperty conditionalUserProperty2 = new AppMeasurement.ConditionalUserProperty(conditionalUserProperty);
        if (!TextUtils.isEmpty((CharSequence)conditionalUserProperty2.mAppId)) {
            ((zzclh)this).zzayp().zzbaw().log("Package name should be null when calling setConditionalUserProperty");
        }
        conditionalUserProperty2.mAppId = null;
        this.zza(conditionalUserProperty2);
    }

    public final void setConditionalUserPropertyAs(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzbq.checkNotNull((Object)conditionalUserProperty);
        zzbq.zzgv((String)conditionalUserProperty.mAppId);
        ((zzclh)this).zzaxz();
        this.zza(new AppMeasurement.ConditionalUserProperty(conditionalUserProperty));
    }

    private final void zza(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        long l = ((zzclh)this).zzxx().currentTimeMillis();
        zzbq.checkNotNull((Object)conditionalUserProperty);
        zzbq.zzgv((String)conditionalUserProperty.mName);
        zzbq.zzgv((String)conditionalUserProperty.mOrigin);
        zzbq.checkNotNull((Object)conditionalUserProperty.mValue);
        conditionalUserProperty.mCreationTimestamp = l;
        String string = conditionalUserProperty.mName;
        Object object = conditionalUserProperty.mValue;
        if (((zzclh)this).zzayl().zzkk(string) != 0) {
            ((zzclh)this).zzayp().zzbau().zzj("Invalid conditional user property name", ((zzclh)this).zzayk().zzjr(string));
            return;
        }
        if (((zzclh)this).zzayl().zzl(string, object) != 0) {
            ((zzclh)this).zzayp().zzbau().zze("Invalid conditional user property value", ((zzclh)this).zzayk().zzjr(string), object);
            return;
        }
        Object object2 = ((zzclh)this).zzayl().zzm(string, object);
        if (object2 == null) {
            ((zzclh)this).zzayp().zzbau().zze("Unable to normalize conditional user property value", ((zzclh)this).zzayk().zzjr(string), object);
            return;
        }
        conditionalUserProperty.mValue = object2;
        long l2 = conditionalUserProperty.mTriggerTimeout;
        if (!(TextUtils.isEmpty((CharSequence)conditionalUserProperty.mTriggerEventName) || l2 <= 15552000000L && l2 >= 1L)) {
            ((zzclh)this).zzayp().zzbau().zze("Invalid conditional user property timeout", ((zzclh)this).zzayk().zzjr(string), l2);
            return;
        }
        long l3 = conditionalUserProperty.mTimeToLive;
        if (l3 > 15552000000L || l3 < 1L) {
            ((zzclh)this).zzayp().zzbau().zze("Invalid conditional user property time to live", ((zzclh)this).zzayk().zzjr(string), l3);
            return;
        }
        ((zzclh)this).zzayo().zzh(new zzclm(this, conditionalUserProperty));
    }

    public final void clearConditionalUserProperty(String string, String string2, Bundle bundle) {
        this.zza(null, string, string2, bundle);
    }

    public final void clearConditionalUserPropertyAs(String string, String string2, String string3, Bundle bundle) {
        zzbq.zzgv((String)string);
        ((zzclh)this).zzaxz();
        this.zza(string, string2, string3, bundle);
    }

    private final void zza(String string, String string2, String string3, Bundle bundle) {
        long l = ((zzclh)this).zzxx().currentTimeMillis();
        zzbq.zzgv((String)string2);
        AppMeasurement.ConditionalUserProperty conditionalUserProperty = new AppMeasurement.ConditionalUserProperty();
        new AppMeasurement.ConditionalUserProperty().mAppId = string;
        conditionalUserProperty.mName = string2;
        conditionalUserProperty.mCreationTimestamp = l;
        if (string3 != null) {
            conditionalUserProperty.mExpiredEventName = string3;
            conditionalUserProperty.mExpiredEventParams = bundle;
        }
        ((zzclh)this).zzayo().zzh(new zzcln(this, conditionalUserProperty));
    }

    @WorkerThread
    private final void zzb(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzcix zzcix2;
        zzcix zzcix3;
        zzcix zzcix4;
        ((zzclh)this).zzwj();
        this.zzyk();
        zzbq.checkNotNull((Object)conditionalUserProperty);
        zzbq.zzgv((String)conditionalUserProperty.mName);
        zzbq.zzgv((String)conditionalUserProperty.mOrigin);
        zzbq.checkNotNull((Object)conditionalUserProperty.mValue);
        if (!this.zzjev.isEnabled()) {
            ((zzclh)this).zzayp().zzbaz().log("Conditional property not sent since Firebase Analytics is disabled");
            return;
        }
        zzcnl zzcnl2 = new zzcnl(conditionalUserProperty.mName, conditionalUserProperty.mTriggeredTimestamp, conditionalUserProperty.mValue, conditionalUserProperty.mOrigin);
        try {
            zzcix4 = ((zzclh)this).zzayl().zza(conditionalUserProperty.mTriggeredEventName, conditionalUserProperty.mTriggeredEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
            zzcix3 = ((zzclh)this).zzayl().zza(conditionalUserProperty.mTimedOutEventName, conditionalUserProperty.mTimedOutEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
            zzcix2 = ((zzclh)this).zzayl().zza(conditionalUserProperty.mExpiredEventName, conditionalUserProperty.mExpiredEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzcii zzcii2 = new zzcii(conditionalUserProperty.mAppId, conditionalUserProperty.mOrigin, zzcnl2, conditionalUserProperty.mCreationTimestamp, false, conditionalUserProperty.mTriggerEventName, zzcix3, conditionalUserProperty.mTriggerTimeout, zzcix4, conditionalUserProperty.mTimeToLive, zzcix2);
        ((zzclh)this).zzayg().zzf(zzcii2);
    }

    @WorkerThread
    private final void zzc(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzcix zzcix2;
        ((zzclh)this).zzwj();
        this.zzyk();
        zzbq.checkNotNull((Object)conditionalUserProperty);
        zzbq.zzgv((String)conditionalUserProperty.mName);
        if (!this.zzjev.isEnabled()) {
            ((zzclh)this).zzayp().zzbaz().log("Conditional property not cleared since Firebase Analytics is disabled");
            return;
        }
        zzcnl zzcnl2 = new zzcnl(conditionalUserProperty.mName, 0L, null, null);
        try {
            zzcix2 = ((zzclh)this).zzayl().zza(conditionalUserProperty.mExpiredEventName, conditionalUserProperty.mExpiredEventParams, conditionalUserProperty.mOrigin, conditionalUserProperty.mCreationTimestamp, true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzcii zzcii2 = new zzcii(conditionalUserProperty.mAppId, conditionalUserProperty.mOrigin, zzcnl2, conditionalUserProperty.mCreationTimestamp, conditionalUserProperty.mActive, conditionalUserProperty.mTriggerEventName, null, conditionalUserProperty.mTriggerTimeout, null, conditionalUserProperty.mTimeToLive, zzcix2);
        ((zzclh)this).zzayg().zzf(zzcii2);
    }

    public final List<AppMeasurement.ConditionalUserProperty> getConditionalUserProperties(String string, String string2) {
        return this.zzl(null, string, string2);
    }

    public final List<AppMeasurement.ConditionalUserProperty> getConditionalUserPropertiesAs(String string, String string2, String string3) {
        zzbq.zzgv((String)string);
        ((zzclh)this).zzaxz();
        return this.zzl(string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<AppMeasurement.ConditionalUserProperty> zzl(String string, String string2, String string3) {
        if (((zzclh)this).zzayo().zzbbk()) {
            ((zzclh)this).zzayp().zzbau().log("Cannot get conditional user properties from analytics worker thread");
            return Collections.emptyList();
        }
        ((zzclh)this).zzayo();
        if (zzcke.zzas()) {
            ((zzclh)this).zzayp().zzbau().log("Cannot get conditional user properties from main thread");
            return Collections.emptyList();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzjev.zzayo().zzh(new zzclo(this, atomicReference, string, string2, string3));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzclh)this).zzayp().zzbaw().zze("Interrupted waiting for get conditional user properties", string, interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzclh)this).zzayp().zzbaw().zzj("Timed out waiting for get conditional user properties", string);
                return Collections.emptyList();
            }
            ArrayList<AppMeasurement.ConditionalUserProperty> arrayList = new ArrayList<AppMeasurement.ConditionalUserProperty>(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                zzcii zzcii2 = (zzcii)((Object)iterator.next());
                AppMeasurement.ConditionalUserProperty conditionalUserProperty = new AppMeasurement.ConditionalUserProperty();
                new AppMeasurement.ConditionalUserProperty().mAppId = string;
                conditionalUserProperty.mOrigin = string2;
                conditionalUserProperty.mCreationTimestamp = zzcii2.zzjgo;
                conditionalUserProperty.mName = zzcii2.zzjgn.name;
                conditionalUserProperty.mValue = zzcii2.zzjgn.getValue();
                conditionalUserProperty.mActive = zzcii2.zzjgp;
                conditionalUserProperty.mTriggerEventName = zzcii2.zzjgq;
                if (zzcii2.zzjgr != null) {
                    conditionalUserProperty.mTimedOutEventName = zzcii2.zzjgr.name;
                    if (zzcii2.zzjgr.zzjhr != null) {
                        conditionalUserProperty.mTimedOutEventParams = zzcii2.zzjgr.zzjhr.zzbao();
                    }
                }
                conditionalUserProperty.mTriggerTimeout = zzcii2.zzjgs;
                if (zzcii2.zzjgt != null) {
                    conditionalUserProperty.mTriggeredEventName = zzcii2.zzjgt.name;
                    if (zzcii2.zzjgt.zzjhr != null) {
                        conditionalUserProperty.mTriggeredEventParams = zzcii2.zzjgt.zzjhr.zzbao();
                    }
                }
                conditionalUserProperty.mTriggeredTimestamp = zzcii2.zzjgn.zzjsi;
                conditionalUserProperty.mTimeToLive = zzcii2.zzjgu;
                if (zzcii2.zzjgv != null) {
                    conditionalUserProperty.mExpiredEventName = zzcii2.zzjgv.name;
                    if (zzcii2.zzjgv.zzjhr != null) {
                        conditionalUserProperty.mExpiredEventParams = zzcii2.zzjgv.zzjhr.zzbao();
                    }
                }
                arrayList.add(conditionalUserProperty);
            }
            return arrayList;
        }
    }

    public final Map<String, Object> getUserProperties(String string, String string2, boolean bl) {
        return this.zzb(null, string, string2, bl);
    }

    public final Map<String, Object> getUserPropertiesAs(String string, String string2, String string3, boolean bl) {
        zzbq.zzgv((String)string);
        ((zzclh)this).zzaxz();
        return this.zzb(string, string2, string3, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, Object> zzb(String string, String string2, String string3, boolean bl) {
        if (((zzclh)this).zzayo().zzbbk()) {
            ((zzclh)this).zzayp().zzbau().log("Cannot get user properties from analytics worker thread");
            return Collections.emptyMap();
        }
        ((zzclh)this).zzayo();
        if (zzcke.zzas()) {
            ((zzclh)this).zzayp().zzbau().log("Cannot get user properties from main thread");
            return Collections.emptyMap();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzjev.zzayo().zzh(new zzclp(this, atomicReference, string, string2, string3, bl));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzclh)this).zzayp().zzbaw().zzj("Interrupted waiting for get user properties", interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzclh)this).zzayp().zzbaw().log("Timed out waiting for get user properties");
                return Collections.emptyMap();
            }
            ArrayMap arrayMap = new ArrayMap(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                zzcnl zzcnl2 = (zzcnl)((Object)iterator.next());
                arrayMap.put(zzcnl2.name, zzcnl2.getValue());
            }
            return arrayMap;
        }
    }

    static /* synthetic */ void zza(zzclk zzclk2, boolean bl) {
        zzclk2.zzbu(bl);
    }

    static /* synthetic */ void zza(zzclk zzclk2, String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        zzclk2.zzb(string, string2, l, bundle, bl, bl2, bl3, string3);
    }

    static /* synthetic */ void zza(zzclk zzclk2, String string, String string2, Object object, long l) {
        zzclk2.zza(string, string2, object, l);
    }

    static /* synthetic */ void zza(zzclk zzclk2, AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzclk2.zzb(conditionalUserProperty);
    }

    static /* synthetic */ void zzb(zzclk zzclk2, AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzclk2.zzc(conditionalUserProperty);
    }
}

