/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Binder;
import android.support.annotation.BinderThread;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzz;
import com.google.android.gms.common.zzs;
import com.google.android.gms.common.zzt;
import com.google.android.gms.internal.zzcif;
import com.google.android.gms.internal.zzcii;
import com.google.android.gms.internal.zzcix;
import com.google.android.gms.internal.zzcjc;
import com.google.android.gms.internal.zzcjj;
import com.google.android.gms.internal.zzckj;
import com.google.android.gms.internal.zzckp;
import com.google.android.gms.internal.zzckq;
import com.google.android.gms.internal.zzckr;
import com.google.android.gms.internal.zzcks;
import com.google.android.gms.internal.zzckt;
import com.google.android.gms.internal.zzcku;
import com.google.android.gms.internal.zzckv;
import com.google.android.gms.internal.zzckw;
import com.google.android.gms.internal.zzckx;
import com.google.android.gms.internal.zzcky;
import com.google.android.gms.internal.zzckz;
import com.google.android.gms.internal.zzcla;
import com.google.android.gms.internal.zzclb;
import com.google.android.gms.internal.zzclc;
import com.google.android.gms.internal.zzcld;
import com.google.android.gms.internal.zzcle;
import com.google.android.gms.internal.zzclf;
import com.google.android.gms.internal.zzclg;
import com.google.android.gms.internal.zzcnl;
import com.google.android.gms.internal.zzcnn;
import com.google.android.gms.internal.zzcno;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class zzcko
extends zzcjc {
    private final zzckj zzjev;
    private Boolean zzjph;
    @Nullable
    private String zzjpi;

    public zzcko(zzckj zzckj2) {
        this(zzckj2, null);
    }

    private zzcko(zzckj zzckj2, @Nullable String string) {
        zzbq.checkNotNull((Object)zzckj2);
        this.zzjev = zzckj2;
        this.zzjpi = null;
    }

    @Override
    @BinderThread
    public final void zzb(zzcif zzcif2) {
        this.zzb(zzcif2, false);
        this.zzjev.zzayo().zzh(new zzckp(this, zzcif2));
    }

    @Override
    @BinderThread
    public final void zza(zzcix zzcix2, zzcif zzcif2) {
        zzbq.checkNotNull((Object)((Object)zzcix2));
        this.zzb(zzcif2, false);
        this.zzjev.zzayo().zzh(new zzckz(this, zzcix2, zzcif2));
    }

    @Override
    @BinderThread
    public final void zza(zzcix zzcix2, String string, String string2) {
        zzbq.checkNotNull((Object)((Object)zzcix2));
        zzbq.zzgv((String)string);
        this.zzg(string, true);
        this.zzjev.zzayo().zzh(new zzcla(this, zzcix2, string));
    }

    @Override
    @BinderThread
    public final byte[] zza(zzcix zzcix2, String string) {
        zzbq.zzgv((String)string);
        zzbq.checkNotNull((Object)((Object)zzcix2));
        this.zzg(string, true);
        this.zzjev.zzayp().zzbaz().zzj("Log and bundle. event", this.zzjev.zzayk().zzjp(zzcix2.name));
        long l = this.zzjev.zzxx().nanoTime() / 1000000L;
        Future<byte[]> future = this.zzjev.zzayo().zzd(new zzclb(this, zzcix2, string));
        try {
            byte[] byArray = future.get();
            if (byArray == null) {
                this.zzjev.zzayp().zzbau().zzj("Log and bundle returned null. appId", zzcjj.zzjs(string));
                byArray = new byte[]{};
            }
            long l2 = this.zzjev.zzxx().nanoTime() / 1000000L;
            this.zzjev.zzayp().zzbaz().zzd("Log and bundle processed. event, size, time_ms", this.zzjev.zzayk().zzjp(zzcix2.name), byArray.length, l2 - l);
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzjev.zzayp().zzbau().zzd("Failed to log and bundle. appId, event, error", zzcjj.zzjs(string), this.zzjev.zzayk().zzjp(zzcix2.name), exception);
            return null;
        }
    }

    @Override
    @BinderThread
    public final void zza(zzcnl zzcnl2, zzcif zzcif2) {
        zzbq.checkNotNull((Object)((Object)zzcnl2));
        this.zzb(zzcif2, false);
        if (zzcnl2.getValue() == null) {
            this.zzjev.zzayo().zzh(new zzclc(this, zzcnl2, zzcif2));
            return;
        }
        this.zzjev.zzayo().zzh(new zzcld(this, zzcnl2, zzcif2));
    }

    @Override
    @BinderThread
    public final List<zzcnl> zza(zzcif zzcif2, boolean bl) {
        this.zzb(zzcif2, false);
        Future<List<zzcnn>> future = this.zzjev.zzayo().zzc(new zzcle(this, zzcif2));
        try {
            List<zzcnn> list = future.get();
            ArrayList<zzcnl> arrayList = new ArrayList<zzcnl>(list.size());
            for (zzcnn zzcnn2 : list) {
                if (!bl && zzcno.zzkp(zzcnn2.name)) continue;
                arrayList.add(new zzcnl(zzcnn2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzjev.zzayp().zzbau().zze("Failed to get user attributes. appId", zzcjj.zzjs(zzcif2.packageName), exception);
            return null;
        }
    }

    @Override
    @BinderThread
    public final void zza(zzcif zzcif2) {
        this.zzb(zzcif2, false);
        zzclf zzclf2 = new zzclf(this, zzcif2);
        if (this.zzjev.zzayo().zzbbk()) {
            zzclf2.run();
            return;
        }
        this.zzjev.zzayo().zzh(zzclf2);
    }

    @BinderThread
    private final void zzb(zzcif zzcif2, boolean bl) {
        zzbq.checkNotNull((Object)((Object)zzcif2));
        this.zzg(zzcif2.packageName, false);
        this.zzjev.zzayl().zzkn(zzcif2.zzjfl);
    }

    @BinderThread
    private final void zzg(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzjev.zzayp().zzbau().log("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            block10: {
                zzcko zzcko2;
                String string2;
                block9: {
                    boolean bl2 = bl;
                    string2 = string;
                    zzcko2 = this;
                    if (!bl2) break block9;
                    if (zzcko2.zzjph == null) {
                        zzcko2.zzjph = "com.google.android.gms".equals(zzcko2.zzjpi) || zzz.zze((Context)zzcko2.zzjev.getContext(), (int)Binder.getCallingUid()) || zzt.zzcj((Context)zzcko2.zzjev.getContext()).zzbp(Binder.getCallingUid());
                    }
                    if (zzcko2.zzjph.booleanValue()) break block10;
                }
                if (zzcko2.zzjpi == null && zzs.zzb((Context)zzcko2.zzjev.getContext(), (int)Binder.getCallingUid(), (String)string2)) {
                    zzcko2.zzjpi = string2;
                }
                if (!string2.equals(zzcko2.zzjpi)) {
                    throw new SecurityException(String.format("Unknown calling package name '%s'.", string2));
                }
            }
            return;
        }
        catch (SecurityException securityException) {
            this.zzjev.zzayp().zzbau().zzj("Measurement Service called with invalid calling package. appId", zzcjj.zzjs(string));
            throw securityException;
        }
    }

    @Override
    @BinderThread
    public final void zza(long l, String string, String string2, String string3) {
        this.zzjev.zzayo().zzh(new zzclg(this, string2, string3, string, l));
    }

    @Override
    @BinderThread
    public final String zzc(zzcif zzcif2) {
        this.zzb(zzcif2, false);
        return this.zzjev.zzkf(zzcif2.packageName);
    }

    @Override
    @BinderThread
    public final void zza(zzcii zzcii2, zzcif zzcif2) {
        zzbq.checkNotNull((Object)((Object)zzcii2));
        zzbq.checkNotNull((Object)((Object)zzcii2.zzjgn));
        this.zzb(zzcif2, false);
        zzcii zzcii3 = new zzcii(zzcii2);
        new zzcii(zzcii2).packageName = zzcif2.packageName;
        if (zzcii2.zzjgn.getValue() == null) {
            this.zzjev.zzayo().zzh(new zzckq(this, zzcii3, zzcif2));
            return;
        }
        this.zzjev.zzayo().zzh(new zzckr(this, zzcii3, zzcif2));
    }

    @Override
    @BinderThread
    public final void zzb(zzcii zzcii2) {
        zzbq.checkNotNull((Object)((Object)zzcii2));
        zzbq.checkNotNull((Object)((Object)zzcii2.zzjgn));
        this.zzg(zzcii2.packageName, true);
        zzcii zzcii3 = new zzcii(zzcii2);
        if (zzcii2.zzjgn.getValue() == null) {
            this.zzjev.zzayo().zzh(new zzcks(this, zzcii3));
            return;
        }
        this.zzjev.zzayo().zzh(new zzckt(this, zzcii3));
    }

    @Override
    @BinderThread
    public final List<zzcnl> zza(String string, String string2, boolean bl, zzcif zzcif2) {
        this.zzb(zzcif2, false);
        Future<List<zzcnn>> future = this.zzjev.zzayo().zzc(new zzcku(this, zzcif2, string, string2));
        try {
            List<zzcnn> list = future.get();
            ArrayList<zzcnl> arrayList = new ArrayList<zzcnl>(list.size());
            for (zzcnn zzcnn2 : list) {
                if (!bl && zzcno.zzkp(zzcnn2.name)) continue;
                arrayList.add(new zzcnl(zzcnn2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzjev.zzayp().zzbau().zze("Failed to get user attributes. appId", zzcjj.zzjs(zzcif2.packageName), exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final List<zzcnl> zza(String string, String string2, String string3, boolean bl) {
        this.zzg(string, true);
        Future<List<zzcnn>> future = this.zzjev.zzayo().zzc(new zzckv(this, string, string2, string3));
        try {
            List<zzcnn> list = future.get();
            ArrayList<zzcnl> arrayList = new ArrayList<zzcnl>(list.size());
            for (zzcnn zzcnn2 : list) {
                if (!bl && zzcno.zzkp(zzcnn2.name)) continue;
                arrayList.add(new zzcnl(zzcnn2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzjev.zzayp().zzbau().zze("Failed to get user attributes. appId", zzcjj.zzjs(string), exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final List<zzcii> zza(String string, String string2, zzcif zzcif2) {
        this.zzb(zzcif2, false);
        Future<List<zzcii>> future = this.zzjev.zzayo().zzc(new zzckw(this, zzcif2, string, string2));
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzjev.zzayp().zzbau().zzj("Failed to get conditional user properties", exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final List<zzcii> zzk(String string, String string2, String string3) {
        this.zzg(string, true);
        Future<List<zzcii>> future = this.zzjev.zzayo().zzc(new zzckx(this, string, string2, string3));
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzjev.zzayp().zzbau().zzj("Failed to get conditional user properties", exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final void zzd(zzcif zzcif2) {
        this.zzg(zzcif2.packageName, false);
        this.zzjev.zzayo().zzh(new zzcky(this, zzcif2));
    }

    static /* synthetic */ zzckj zza(zzcko zzcko2) {
        return zzcko2.zzjev;
    }
}

