/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Application;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.api.internal.zzbz;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzb;
import com.google.android.gms.common.util.zze;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbih;
import com.google.android.gms.internal.zzcia;
import com.google.android.gms.internal.zzcie;
import com.google.android.gms.internal.zzcif;
import com.google.android.gms.internal.zzcih;
import com.google.android.gms.internal.zzcii;
import com.google.android.gms.internal.zzcik;
import com.google.android.gms.internal.zzcil;
import com.google.android.gms.internal.zzcin;
import com.google.android.gms.internal.zzcir;
import com.google.android.gms.internal.zzcis;
import com.google.android.gms.internal.zzcit;
import com.google.android.gms.internal.zzciu;
import com.google.android.gms.internal.zzcix;
import com.google.android.gms.internal.zzciz;
import com.google.android.gms.internal.zzcje;
import com.google.android.gms.internal.zzcjf;
import com.google.android.gms.internal.zzcjh;
import com.google.android.gms.internal.zzcjj;
import com.google.android.gms.internal.zzcjl;
import com.google.android.gms.internal.zzcjn;
import com.google.android.gms.internal.zzcjr;
import com.google.android.gms.internal.zzcjs;
import com.google.android.gms.internal.zzcju;
import com.google.android.gms.internal.zzcka;
import com.google.android.gms.internal.zzckd;
import com.google.android.gms.internal.zzcke;
import com.google.android.gms.internal.zzckk;
import com.google.android.gms.internal.zzckl;
import com.google.android.gms.internal.zzckm;
import com.google.android.gms.internal.zzckn;
import com.google.android.gms.internal.zzclh;
import com.google.android.gms.internal.zzcli;
import com.google.android.gms.internal.zzclj;
import com.google.android.gms.internal.zzclk;
import com.google.android.gms.internal.zzcly;
import com.google.android.gms.internal.zzcma;
import com.google.android.gms.internal.zzcme;
import com.google.android.gms.internal.zzcmy;
import com.google.android.gms.internal.zzcnd;
import com.google.android.gms.internal.zzcnj;
import com.google.android.gms.internal.zzcnl;
import com.google.android.gms.internal.zzcnn;
import com.google.android.gms.internal.zzcno;
import com.google.android.gms.internal.zzcny;
import com.google.android.gms.internal.zzcoa;
import com.google.android.gms.internal.zzcob;
import com.google.android.gms.internal.zzcoc;
import com.google.android.gms.internal.zzcod;
import com.google.android.gms.internal.zzcoe;
import com.google.android.gms.internal.zzcog;
import com.google.android.gms.internal.zzflj;
import com.google.android.gms.internal.zzflk;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.firebase.analytics.FirebaseAnalytics;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public class zzckj {
    private static volatile zzckj zzjnr;
    private final Context zzaiq;
    private final zzcik zzjns;
    private final zzcju zzjnt;
    private final zzcjj zzjnu;
    private final zzcke zzjnv;
    private final zzcnd zzjnw;
    private final zzckd zzjnx;
    private final AppMeasurement zzjny;
    private final FirebaseAnalytics zzjnz;
    private final zzcno zzjoa;
    private final zzcjh zzjob;
    private final zzcjn zzjoc;
    private final zze zzdir;
    private final zzcma zzjod;
    private final zzclk zzjoe;
    private final zzcia zzjof;
    private zzcil zzjog;
    private zzcjf zzjoh;
    private zzcme zzjoi;
    private zzcir zzjoj;
    private zzcje zzjok;
    private zzcjs zzjol;
    private zzcnj zzjom;
    private zzcih zzjon;
    private boolean initialized = false;
    private boolean zzjoo;
    private Boolean zzjop;
    private long zzjoq;
    private FileLock zzjor;
    private FileChannel zzjos;
    private List<Long> zzjot;
    private List<Runnable> zzjou;
    private int zzjov;
    private int zzjow;
    private long zzjox;
    private long zzjoy;
    private boolean zzjoz;
    private boolean zzjpa;
    private boolean zzjpb;
    private final long zzjgk;

    private zzckj(zzclj zzclj2) {
        zzcia zzcia2;
        zzbq.checkNotNull((Object)zzclj2);
        this.zzaiq = zzclj2.zzaiq;
        this.zzjox = -1L;
        this.zzdir = zzi.zzanq();
        this.zzjgk = this.zzdir.currentTimeMillis();
        zzckj zzckj2 = this;
        this.zzjns = new zzcik(zzckj2);
        zzckj2 = this;
        zzcju zzcju2 = new zzcju(zzckj2);
        zzcju2.initialize();
        this.zzjnt = zzcju2;
        zzckj2 = this;
        zzcjj zzcjj2 = new zzcjj(zzckj2);
        zzcjj2.initialize();
        this.zzjnu = zzcjj2;
        zzckj2 = this;
        zzcno zzcno2 = new zzcno(zzckj2);
        zzcno2.initialize();
        this.zzjoa = zzcno2;
        zzckj2 = this;
        zzcjh zzcjh2 = new zzcjh(zzckj2);
        zzcjh2.initialize();
        this.zzjob = zzcjh2;
        zzckj2 = this;
        this.zzjof = zzcia2 = new zzcia(zzckj2);
        zzckj2 = this;
        zzcjn zzcjn2 = new zzcjn(zzckj2);
        zzcjn2.initialize();
        this.zzjoc = zzcjn2;
        zzckj2 = this;
        zzcma zzcma2 = new zzcma(zzckj2);
        zzcma2.initialize();
        this.zzjod = zzcma2;
        zzckj2 = this;
        zzclk zzclk2 = new zzclk(zzckj2);
        zzclk2.initialize();
        this.zzjoe = zzclk2;
        zzckj2 = this;
        this.zzjny = new AppMeasurement(zzckj2);
        zzckj2 = this;
        this.zzjnz = new FirebaseAnalytics(zzckj2);
        zzckj2 = this;
        zzcnd zzcnd2 = new zzcnd(zzckj2);
        zzcnd2.initialize();
        this.zzjnw = zzcnd2;
        zzckj2 = this;
        zzckd zzckd2 = new zzckd(zzckj2);
        zzckd2.initialize();
        this.zzjnx = zzckd2;
        zzckj2 = this;
        zzcke zzcke2 = new zzcke(zzckj2);
        zzcke2.initialize();
        this.zzjnv = zzcke2;
        zzckj2 = this;
        if (zzckj2.zzaiq.getApplicationContext() instanceof Application) {
            zzclk zzclk3 = zzckj2.zzayd();
            if (((zzclh)zzclk3).getContext().getApplicationContext() instanceof Application) {
                Application application = (Application)((zzclh)zzclk3).getContext().getApplicationContext();
                if (zzclk3.zzjpt == null) {
                    zzclk3.zzjpt = new zzcly(zzclk3, null);
                }
                application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzclk3.zzjpt);
                application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzclk3.zzjpt);
                ((zzclh)zzclk3).zzayp().zzbba().log("Registered activity lifecycle callback");
            }
        } else {
            zzckj2.zzayp().zzbaw().log("Application context is not an Application");
        }
        this.zzjnv.zzh(new zzckk(this, zzclj2));
    }

    final void zzyk() {
        if (!this.initialized) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
    }

    @WorkerThread
    protected final boolean zzbbn() {
        this.zzyk();
        ((zzclh)this.zzayo()).zzwj();
        if (this.zzjop == null || this.zzjoq == 0L || this.zzjop != null && !this.zzjop.booleanValue() && Math.abs(this.zzdir.elapsedRealtime() - this.zzjoq) > 1000L) {
            this.zzjoq = this.zzdir.elapsedRealtime();
            this.zzjop = this.zzayl().zzeh("android.permission.INTERNET") && this.zzayl().zzeh("android.permission.ACCESS_NETWORK_STATE") && (zzbih.zzdd((Context)this.zzaiq).zzaoe() || zzcka.zzbj(this.zzaiq) && zzcmy.zzg(this.zzaiq, false));
            if (this.zzjop.booleanValue()) {
                this.zzjop = this.zzayl().zzkn(this.zzaye().getGmpAppId());
            }
        }
        return this.zzjop;
    }

    @WorkerThread
    private final void zza(zzclj zzclj2) {
        String string;
        zzcjl zzcjl2;
        ((zzclh)this.zzayo()).zzwj();
        zzckj zzckj2 = this;
        zzcir zzcir2 = new zzcir(zzckj2);
        zzcir2.initialize();
        this.zzjoj = zzcir2;
        zzckj2 = this;
        zzcje zzcje2 = new zzcje(zzckj2);
        zzcje2.initialize();
        this.zzjok = zzcje2;
        zzckj2 = this;
        zzcil zzcil2 = new zzcil(zzckj2);
        zzcil2.initialize();
        this.zzjog = zzcil2;
        zzckj2 = this;
        zzcjf zzcjf2 = new zzcjf(zzckj2);
        zzcjf2.initialize();
        this.zzjoh = zzcjf2;
        zzckj2 = this;
        zzcih zzcih2 = new zzcih(zzckj2);
        zzcih2.initialize();
        this.zzjon = zzcih2;
        zzckj2 = this;
        zzcme zzcme2 = new zzcme(zzckj2);
        zzcme2.initialize();
        this.zzjoi = zzcme2;
        zzckj2 = this;
        zzcnj zzcnj2 = new zzcnj(zzckj2);
        zzcnj2.initialize();
        this.zzjom = zzcnj2;
        zzckj2 = this;
        this.zzjol = new zzcjs(zzckj2);
        this.zzjoa.zzbcf();
        this.zzjnt.zzbcf();
        this.zzjok.zzbcf();
        this.zzayp().zzbay().zzj("App measurement is starting up, version", 12211L);
        this.zzayp().zzbay().log("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        String string2 = zzcje2.getAppId();
        if (this.zzayl().zzkq(string2)) {
            zzcjl2 = this.zzayp().zzbay();
            string = "Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.";
        } else {
            zzcjl2 = this.zzayp().zzbay();
            String string3 = String.valueOf(string2);
            string = string3.length() != 0 ? "To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ".concat(string3) : new String("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ");
        }
        zzcjl2.log(string);
        this.zzayp().zzbaz().log("Debug-level message logging enabled");
        if (this.zzjov != this.zzjow) {
            this.zzayp().zzbau().zze("Not all components initialized", this.zzjov, this.zzjow);
        }
        this.initialized = true;
    }

    @WorkerThread
    protected final void start() {
        ((zzclh)this.zzayo()).zzwj();
        this.zzayj().zzazy();
        if (this.zzayq().zzjln.get() == 0L) {
            this.zzayq().zzjln.set(this.zzdir.currentTimeMillis());
        }
        if (Long.valueOf(this.zzayq().zzjls.get()) == 0L) {
            this.zzayp().zzbba().zzj("Persisting first open", this.zzjgk);
            this.zzayq().zzjls.set(this.zzjgk);
        }
        if (!this.zzbbn()) {
            if (this.isEnabled()) {
                if (!this.zzayl().zzeh("android.permission.INTERNET")) {
                    this.zzayp().zzbau().log("App is missing INTERNET permission");
                }
                if (!this.zzayl().zzeh("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzayp().zzbau().log("App is missing ACCESS_NETWORK_STATE permission");
                }
                if (!zzbih.zzdd((Context)this.zzaiq).zzaoe()) {
                    if (!zzcka.zzbj(this.zzaiq)) {
                        this.zzayp().zzbau().log("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzcmy.zzg(this.zzaiq, false)) {
                        this.zzayp().zzbau().log("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzayp().zzbau().log("Uploading is not possible. App measurement disabled");
            }
        } else {
            if (!TextUtils.isEmpty((CharSequence)this.zzaye().getGmpAppId())) {
                String string = this.zzayq().zzbbe();
                if (string == null) {
                    this.zzayq().zzjw(this.zzaye().getGmpAppId());
                } else if (!string.equals(this.zzaye().getGmpAppId())) {
                    this.zzayp().zzbay().log("Rechecking which service to use due to a GMP App Id change");
                    this.zzayq().zzbbh();
                    this.zzjoi.disconnect();
                    this.zzjoi.zzzh();
                    this.zzayq().zzjw(this.zzaye().getGmpAppId());
                    this.zzayq().zzjls.set(this.zzjgk);
                    this.zzayq().zzjlt.zzjy(null);
                }
            }
            this.zzayd().zzjx(this.zzayq().zzjlt.zzbbj());
            if (!TextUtils.isEmpty((CharSequence)this.zzaye().getGmpAppId())) {
                zzclk zzclk2 = this.zzayd();
                ((zzclh)zzclk2).zzwj();
                zzclk2.zzyk();
                if (zzclk2.zzjev.zzbbn()) {
                    ((zzclh)zzclk2).zzayg().zzbcj();
                    String string = ((zzclh)zzclk2).zzayq().zzbbi();
                    if (!TextUtils.isEmpty((CharSequence)string)) {
                        ((zzclh)zzclk2).zzayf().zzyk();
                        if (!string.equals(Build.VERSION.RELEASE)) {
                            Bundle bundle = new Bundle();
                            bundle.putString("_po", string);
                            zzclk2.zzd("auto", "_ou", bundle);
                        }
                    }
                }
                this.zzayg().zza(new AtomicReference<String>());
            }
        }
        this.zzbca();
    }

    public final zzcik zzayr() {
        return this.zzjns;
    }

    public final zzcju zzayq() {
        zzckj.zza((zzclh)this.zzjnt);
        return this.zzjnt;
    }

    public final zzcjj zzayp() {
        zzckj.zza(this.zzjnu);
        return this.zzjnu;
    }

    public final zzcjj zzbbo() {
        if (this.zzjnu != null && this.zzjnu.isInitialized()) {
            return this.zzjnu;
        }
        return null;
    }

    public final zzcke zzayo() {
        zzckj.zza(this.zzjnv);
        return this.zzjnv;
    }

    public final zzcnd zzayn() {
        zzckj.zza(this.zzjnw);
        return this.zzjnw;
    }

    public final zzckd zzaym() {
        zzckj.zza(this.zzjnx);
        return this.zzjnx;
    }

    final zzcke zzbbp() {
        return this.zzjnv;
    }

    public final zzclk zzayd() {
        zzckj.zza(this.zzjoe);
        return this.zzjoe;
    }

    public final AppMeasurement zzbbq() {
        return this.zzjny;
    }

    public final FirebaseAnalytics zzbbr() {
        return this.zzjnz;
    }

    public final zzcno zzayl() {
        zzckj.zza((zzclh)this.zzjoa);
        return this.zzjoa;
    }

    public final zzcjh zzayk() {
        zzckj.zza((zzclh)this.zzjob);
        return this.zzjob;
    }

    public final zzcil zzayj() {
        zzckj.zza(this.zzjog);
        return this.zzjog;
    }

    public final zzcjf zzayi() {
        zzckj.zza(this.zzjoh);
        return this.zzjoh;
    }

    public final zzcjn zzbbs() {
        zzckj.zza(this.zzjoc);
        return this.zzjoc;
    }

    public final Context getContext() {
        return this.zzaiq;
    }

    public final zze zzxx() {
        return this.zzdir;
    }

    public final zzcma zzayh() {
        zzckj.zza(this.zzjod);
        return this.zzjod;
    }

    public final zzcme zzayg() {
        zzckj.zza(this.zzjoi);
        return this.zzjoi;
    }

    public final zzcir zzayf() {
        zzckj.zza(this.zzjoj);
        return this.zzjoj;
    }

    public final zzcje zzaye() {
        zzckj.zza(this.zzjok);
        return this.zzjok;
    }

    private final zzcjs zzbbt() {
        if (this.zzjol == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zzjol;
    }

    private final zzcnj zzbbu() {
        zzckj.zza(this.zzjom);
        return this.zzjom;
    }

    public final zzcih zzayc() {
        zzckj.zza(this.zzjon);
        return this.zzjon;
    }

    public final zzcia zzayb() {
        zzckj.zza(this.zzjof);
        return this.zzjof;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzckj zzed(Context context) {
        zzbq.checkNotNull((Object)context);
        zzbq.checkNotNull((Object)context.getApplicationContext());
        if (zzjnr != null) return zzjnr;
        Class<zzckj> clazz = zzckj.class;
        synchronized (zzckj.class) {
            if (zzjnr != null) return zzjnr;
            zzclj zzclj2 = new zzclj(context);
            zzjnr = new zzckj(zzclj2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzjnr;
        }
    }

    final void zzd(zzcif zzcif2) {
        this.zzayj().zzjj(zzcif2.packageName);
        String string = zzcif2.packageName;
        zzcil zzcil2 = this.zzayj();
        zzbq.zzgv((String)string);
        zzcil2.zzwj();
        zzcil2.zzyk();
        try {
            SQLiteDatabase sQLiteDatabase = zzcil2.getWritableDatabase();
            String[] stringArray = new String[]{string};
            int n = 0 + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("queue", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray) + sQLiteDatabase.delete("main_event_params", "app_id=?", stringArray);
            if (n > 0) {
                zzcil2.zzayp().zzbba().zze("Reset analytics data. app, records", string, n);
            }
        }
        catch (SQLiteException sQLiteException) {
            zzcil2.zzayp().zzbau().zze("Error resetting analytics data. appId, error", zzcjj.zzjs(string), (Object)sQLiteException);
        }
        zzcif zzcif3 = this.zza(this.zzaiq, zzcif2.packageName, zzcif2.zzjfl, zzcif2.zzjfv, zzcif2.zzjfx);
        this.zzf(zzcif3);
    }

    private final zzcif zza(Context context, String string, String string2, boolean bl, boolean bl2) {
        String string3 = "Unknown";
        String string4 = "Unknown";
        int n = Integer.MIN_VALUE;
        String string5 = "Unknown";
        PackageManager packageManager = context.getPackageManager();
        if (packageManager == null) {
            this.zzayp().zzbau().log("PackageManager is null, can not log app install information");
            return null;
        }
        try {
            string3 = packageManager.getInstallerPackageName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzayp().zzbau().zzj("Error retrieving installer package name. appId", zzcjj.zzjs(string));
        }
        if (string3 == null) {
            string3 = "manual_install";
        } else if ("com.android.vending".equals(string3)) {
            string3 = "";
        }
        try {
            PackageInfo packageInfo = zzbih.zzdd((Context)context).getPackageInfo(string, 0);
            if (packageInfo != null) {
                CharSequence charSequence = zzbih.zzdd((Context)context).zzhc(string);
                if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                    string5 = charSequence.toString();
                }
                string4 = packageInfo.versionName;
                n = packageInfo.versionCode;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzayp().zzbau().zze("Error retrieving newly installed package info. appId, appName", zzcjj.zzjs(string), string5);
            return null;
        }
        return new zzcif(string, string2, string4, n, string3, 12211L, this.zzayl().zzab(context, string), null, bl, false, "", 0L, 0L, 0, bl2);
    }

    private static void zza(zzcli zzcli2) {
        if (zzcli2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzcli2.isInitialized()) {
            String string = String.valueOf(zzcli2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zza(zzclh zzclh2) {
        if (zzclh2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    private final boolean zzbbv() {
        ((zzclh)this.zzayo()).zzwj();
        String string = "google_app_measurement.db";
        File file = this.zzaiq.getFilesDir();
        File file2 = new File(file, string);
        try {
            this.zzjos = new RandomAccessFile(file2, "rw").getChannel();
            this.zzjor = this.zzjos.tryLock();
            if (this.zzjor != null) {
                this.zzayp().zzbba().log("Storage concurrent access okay");
                return true;
            }
            this.zzayp().zzbau().log("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzayp().zzbau().zzj("Failed to acquire storage lock", fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzayp().zzbau().zzj("Failed to access storage lock file", iOException);
        }
        return false;
    }

    @WorkerThread
    private final int zza(FileChannel fileChannel) {
        ((zzclh)this.zzayo()).zzwj();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzayp().zzbau().log("Bad channel to read from");
            return 0;
        }
        int n = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n2 = fileChannel.read(byteBuffer);
            if (n2 != 4) {
                if (n2 != -1) {
                    this.zzayp().zzbaw().zzj("Unexpected data length. Bytes read", n2);
                }
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzayp().zzbau().zzj("Failed to read from channel", iOException);
        }
        return n;
    }

    @WorkerThread
    private final boolean zza(int n, FileChannel fileChannel) {
        ((zzclh)this.zzayo()).zzwj();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzayp().zzbau().log("Bad channel to read from");
            return false;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzayp().zzbau().zzj("Error writing to channel. Bytes written", fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzayp().zzbau().zzj("Failed to write to channel", iOException);
            return false;
        }
    }

    @WorkerThread
    public final boolean isEnabled() {
        ((zzclh)this.zzayo()).zzwj();
        this.zzyk();
        if (this.zzjns.zzazr()) {
            return false;
        }
        Boolean bl = this.zzjns.zzjf("firebase_analytics_collection_enabled");
        boolean bl2 = bl != null ? bl : !zzbz.zzakr();
        return this.zzayq().zzbs(bl2);
    }

    final void zze(zzcif zzcif2) {
        ((zzclh)this.zzayo()).zzwj();
        this.zzyk();
        zzbq.zzgv((String)zzcif2.packageName);
        this.zzg(zzcif2);
    }

    final long zzbbw() {
        Long l = this.zzayq().zzjls.get();
        if (l == 0L) {
            return this.zzjgk;
        }
        return Math.min(this.zzjgk, l);
    }

    private final long zzbbx() {
        long l = this.zzdir.currentTimeMillis();
        zzcju zzcju2 = this.zzayq();
        zzcju2.zzyk();
        zzcju2.zzwj();
        long l2 = zzcju2.zzjlr.get();
        if (l2 == 0L) {
            l2 = 1 + zzcju2.zzayl().zzbcr().nextInt(86400000);
            zzcju2.zzjlr.set(l2);
        }
        return (l + l2) / 1000L / 60L / 60L / 24L;
    }

    @WorkerThread
    private final zzcif zzke(String string) {
        zzcie zzcie2 = this.zzayj().zzjj(string);
        if (zzcie2 == null || TextUtils.isEmpty((CharSequence)zzcie2.zzwo())) {
            this.zzayp().zzbaz().zzj("No app data available; dropping", string);
            return null;
        }
        Boolean bl = this.zzc(zzcie2);
        if (bl != null && !bl.booleanValue()) {
            this.zzayp().zzbau().zzj("App version does not match; dropping. appId", zzcjj.zzjs(string));
            return null;
        }
        return new zzcif(string, zzcie2.getGmpAppId(), zzcie2.zzwo(), zzcie2.zzayx(), zzcie2.zzayy(), zzcie2.zzayz(), zzcie2.zzaza(), null, zzcie2.zzazb(), false, zzcie2.zzayu(), zzcie2.zzazo(), 0L, 0, zzcie2.zzazp());
    }

    @WorkerThread
    final void zzb(zzcix zzcix2, String string) {
        zzcie zzcie2 = this.zzayj().zzjj(string);
        if (zzcie2 == null || TextUtils.isEmpty((CharSequence)zzcie2.zzwo())) {
            this.zzayp().zzbaz().zzj("No app data available; dropping event", string);
            return;
        }
        Boolean bl = this.zzc(zzcie2);
        if (bl == null) {
            if (!"_ui".equals(zzcix2.name)) {
                this.zzayp().zzbaw().zzj("Could not find package. appId", zzcjj.zzjs(string));
            }
        } else if (!bl.booleanValue()) {
            this.zzayp().zzbau().zzj("App version does not match; dropping event. appId", zzcjj.zzjs(string));
            return;
        }
        zzcif zzcif2 = new zzcif(string, zzcie2.getGmpAppId(), zzcie2.zzwo(), zzcie2.zzayx(), zzcie2.zzayy(), zzcie2.zzayz(), zzcie2.zzaza(), null, zzcie2.zzazb(), false, zzcie2.zzayu(), zzcie2.zzazo(), 0L, 0, zzcie2.zzazp());
        this.zzb(zzcix2, zzcif2);
    }

    @WorkerThread
    final void zzb(zzcix zzcix2, zzcif zzcif2) {
        zzbq.checkNotNull((Object)((Object)zzcif2));
        zzbq.zzgv((String)zzcif2.packageName);
        ((zzclh)this.zzayo()).zzwj();
        this.zzyk();
        String string = zzcif2.packageName;
        long l = zzcix2.zzjib;
        this.zzayl();
        if (!zzcno.zzd(zzcix2, zzcif2)) {
            return;
        }
        if (!zzcif2.zzjfv) {
            this.zzg(zzcif2);
            return;
        }
        this.zzayj().beginTransaction();
        try {
            zzbgl zzbgl2;
            List<Object> list;
            Object object;
            List<Object> list2;
            Object object22;
            Object object3;
            String string2;
            List list3;
            long l2 = l;
            String string3 = string;
            zzcil zzcil2 = this.zzayj();
            zzbq.zzgv((String)string3);
            zzcil2.zzwj();
            zzcil2.zzyk();
            if (l2 < 0L) {
                zzcil2.zzayp().zzbaw().zze("Invalid time querying timed out conditional properties", zzcjj.zzjs(string3), l2);
                list3 = Collections.emptyList();
            } else {
                string2 = "active=0 and app_id=? and abs(? - creation_timestamp) > trigger_timeout";
                object3 = new String[]{string3, String.valueOf(l2)};
                list3 = zzcil2.zzd(string2, (String[])object3);
            }
            for (Object object22 : list3) {
                if (object22 == null) continue;
                this.zzayp().zzbaz().zzd("User property timed out", object22.packageName, this.zzayk().zzjr(object22.zzjgn.name), object22.zzjgn.getValue());
                if (object22.zzjgr != null) {
                    this.zzc(new zzcix(object22.zzjgr, l), zzcif2);
                }
                this.zzayj().zzai(string, object22.zzjgn.name);
            }
            l2 = l;
            string3 = string;
            zzcil2 = this.zzayj();
            zzbq.zzgv((String)string3);
            zzcil2.zzwj();
            zzcil2.zzyk();
            if (l2 < 0L) {
                zzcil2.zzayp().zzbaw().zze("Invalid time querying expired conditional properties", zzcjj.zzjs(string3), l2);
                list2 = Collections.emptyList();
            } else {
                string2 = "active<>0 and app_id=? and abs(? - triggered_timestamp) > time_to_live";
                object3 = new String[]{string3, String.valueOf(l2)};
                list2 = zzcil2.zzd(string2, (String[])object3);
            }
            List list4 = list2;
            object22 = new ArrayList(list4.size());
            Object object4 = list4.iterator();
            while (object4.hasNext()) {
                object = (zzcii)((Object)object4.next());
                if (object == null) continue;
                this.zzayp().zzbaz().zzd("User property expired", object.packageName, this.zzayk().zzjr(object.zzjgn.name), object.zzjgn.getValue());
                this.zzayj().zzaf(string, object.zzjgn.name);
                if (object.zzjgv != null) {
                    object22.add(object.zzjgv);
                }
                this.zzayj().zzai(string, object.zzjgn.name);
            }
            ArrayList arrayList = (ArrayList)object22;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                object = (zzcix)((Object)e);
                this.zzc(new zzcix((zzcix)((Object)object), l), zzcif2);
            }
            long l3 = l;
            String string4 = zzcix2.name;
            string3 = string;
            zzcil2 = this.zzayj();
            zzbq.zzgv((String)string3);
            zzbq.zzgv((String)string4);
            zzcil2.zzwj();
            zzcil2.zzyk();
            if (l3 < 0L) {
                zzcil2.zzayp().zzbaw().zzd("Invalid time querying triggered conditional properties", zzcjj.zzjs(string3), zzcil2.zzayk().zzjp(string4), l3);
                list = Collections.emptyList();
            } else {
                object3 = "active=0 and app_id=? and trigger_event_name=? and abs(? - creation_timestamp) <= trigger_timeout";
                String[] stringArray = new String[]{string3, string4, String.valueOf(l3)};
                list = zzcil2.zzd((String)object3, stringArray);
            }
            object4 = list;
            object = new ArrayList(object4.size());
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                zzbgl2 = (zzcii)((Object)iterator.next());
                if (zzbgl2 == null) continue;
                zzcnl zzcnl2 = zzbgl2.zzjgn;
                zzcnn zzcnn2 = new zzcnn(zzbgl2.packageName, zzbgl2.zzjgm, zzcnl2.name, l, zzcnl2.getValue());
                if (this.zzayj().zza(zzcnn2)) {
                    this.zzayp().zzbaz().zzd("User property triggered", zzbgl2.packageName, this.zzayk().zzjr(zzcnn2.name), zzcnn2.value);
                } else {
                    this.zzayp().zzbau().zzd("Too many active user properties, ignoring", zzcjj.zzjs(zzbgl2.packageName), this.zzayk().zzjr(zzcnn2.name), zzcnn2.value);
                }
                if (zzbgl2.zzjgt != null) {
                    object.add(zzbgl2.zzjgt);
                }
                zzbgl2.zzjgn = new zzcnl(zzcnn2);
                zzbgl2.zzjgp = true;
                this.zzayj().zza((zzcii)zzbgl2);
            }
            this.zzc(zzcix2, zzcif2);
            ArrayList arrayList2 = (ArrayList)object;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList2.get(i);
                zzbgl2 = (zzcix)((Object)e);
                this.zzc(new zzcix((zzcix)zzbgl2, l), zzcif2);
            }
            this.zzayj().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzayj().endTransaction();
        }
    }

    /*
     * Unable to fully structure code
     */
    @WorkerThread
    private final void zzc(zzcix var1_1, zzcif var2_2) {
        zzbq.checkNotNull((Object)var2_2);
        zzbq.zzgv((String)var2_2.packageName);
        var3_3 = System.nanoTime();
        this.zzayo().zzwj();
        this.zzyk();
        var5_4 = var2_2.packageName;
        this.zzayl();
        if (!zzcno.zzd(var1_1, var2_2)) {
            return;
        }
        if (!var2_2.zzjfv) {
            this.zzg(var2_2);
            return;
        }
        if (this.zzaym().zzan(var5_4, var1_1.name)) {
            this.zzayp().zzbaw().zze("Dropping blacklisted event. appId", zzcjj.zzjs(var5_4), this.zzayk().zzjp(var1_1.name));
            var6_5 = this.zzayl().zzks(var5_4) != false || this.zzayl().zzkt(var5_4) != false;
            if (!var6_5 && !"_err".equals(var1_1.name)) {
                this.zzayl().zza(var5_4, 11, "_ev", var1_1.name, 0);
            }
            if (var6_5 && (var7_7 = this.zzayj().zzjj(var5_4)) != null) {
                var8_9 = Math.max(var7_7.zzaze(), var7_7.zzazd());
                if (Math.abs(this.zzdir.currentTimeMillis() - var8_9) > zzciz.zzjjm.get()) {
                    this.zzayp().zzbaz().log("Fetching config for blacklisted app");
                    this.zzb(var7_7);
                }
            }
            return;
        }
        if (this.zzayp().zzae(2)) {
            this.zzayp().zzbba().zzj("Logging event", this.zzayk().zzb(var1_1));
        }
        this.zzayj().beginTransaction();
        try {
            block45: {
                block46: {
                    this.zzg(var2_2);
                    if (("_iap".equals(var1_1.name) || "ecommerce_purchase".equals(var1_1.name)) && !this.zza(var5_4, var1_1)) {
                        this.zzayj().setTransactionSuccessful();
                        return;
                    }
                    var6_6 = zzcno.zzkh(var1_1.name);
                    var7_8 = "_err".equals(var1_1.name);
                    var8_10 = this.zzayj().zza(this.zzbbx(), var5_4, true, var6_6, false, var7_8, false);
                    var9_11 = var8_10.zzjhf - (long)zzciz.zzjix.get().intValue();
                    if (var9_11 > 0L) {
                        if (var9_11 % 1000L == 1L) {
                            this.zzayp().zzbau().zze("Data loss. Too many events logged. appId, count", zzcjj.zzjs(var5_4), var8_10.zzjhf);
                        }
                        this.zzayj().setTransactionSuccessful();
                        return;
                    }
                    if (var6_6 && (var9_11 = var8_10.zzjhe - (long)zzciz.zzjiz.get().intValue()) > 0L) {
                        if (var9_11 % 1000L == 1L) {
                            this.zzayp().zzbau().zze("Data loss. Too many public events logged. appId, count", zzcjj.zzjs(var5_4), var8_10.zzjhe);
                        }
                        this.zzayl().zza(var5_4, 16, "_ev", var1_1.name, 0);
                        this.zzayj().setTransactionSuccessful();
                        return;
                    }
                    if (var7_8) {
                        var19_12 = var2_2.packageName;
                        var20_13 = this.zzjns.zzb((String)var19_12, zzciz.zzjiy);
                        var9_11 = var8_10.zzjhh - (long)Math.max(0, var20_13 = Math.min(1000000, var20_13));
                        if (var9_11 > 0L) {
                            if (var9_11 == 1L) {
                                this.zzayp().zzbau().zze("Too many error events logged. appId, count", zzcjj.zzjs(var5_4), var8_10.zzjhh);
                            }
                            this.zzayj().setTransactionSuccessful();
                            return;
                        }
                    }
                    var11_15 = var1_1.zzjhr.zzbao();
                    this.zzayl().zza(var11_15, "_o", (Object)var1_1.zzjgm);
                    if (this.zzayl().zzkq(var5_4)) {
                        this.zzayl().zza(var11_15, "_dbg", 1L);
                        this.zzayl().zza(var11_15, "_r", 1L);
                    }
                    if ((var12_16 = this.zzayj().zzjk(var5_4)) > 0L) {
                        this.zzayp().zzbaw().zze("Data lost. Too many events stored on disk, deleted. appId", zzcjj.zzjs(var5_4), var12_16);
                    }
                    var14_17 = new zzcis(this, var1_1.zzjgm, var5_4, var1_1.name, var1_1.zzjib, 0L, var11_15);
                    var15_18 = this.zzayj().zzae(var5_4, var14_17.name);
                    if (var15_18 == null) {
                        if (this.zzayj().zzjn(var5_4) >= 500L && var6_6) {
                            this.zzayp().zzbau().zzd("Too many event names used, ignoring event. appId, name, supported count", zzcjj.zzjs(var5_4), this.zzayk().zzjp(var14_17.name), 500);
                            this.zzayl().zza(var5_4, 8, null, null, 0);
                            return;
                        }
                        var16_19 = new zzcit(var5_4, var14_17.name, 0L, 0L, var14_17.timestamp, 0L, null, null, null);
                    } else {
                        var14_17 = var14_17.zza(this, var15_18.zzjhu);
                        var16_19 = var15_18.zzbb(var14_17.timestamp);
                    }
                    this.zzayj().zza(var16_19);
                    var20_14 = var2_2;
                    var19_12 = var14_17;
                    var18_20 = this;
                    var18_20.zzayo().zzwj();
                    var18_20.zzyk();
                    zzbq.checkNotNull((Object)var19_12);
                    zzbq.checkNotNull((Object)var20_14);
                    zzbq.zzgv((String)var19_12.zzcm);
                    zzbq.checkArgument((boolean)var19_12.zzcm.equals(var20_14.packageName));
                    var21_21 = new zzcoe();
                    new zzcoe().zzjup = 1;
                    var21_21.zzjux = "android";
                    var21_21.zzcm = var20_14.packageName;
                    var21_21.zzjfs = var20_14.zzjfs;
                    var21_21.zzina = var20_14.zzina;
                    var21_21.zzjvi = var20_14.zzjfr == -2147483648L ? null : Integer.valueOf((int)var20_14.zzjfr);
                    var21_21.zzjva = var20_14.zzjft;
                    var21_21.zzjfl = var20_14.zzjfl;
                    var21_21.zzjve = var20_14.zzjfu == 0L ? null : Long.valueOf(var20_14.zzjfu);
                    var22_22 = var18_20.zzayq().zzju(var20_14.packageName);
                    if (var22_22 != null && !TextUtils.isEmpty((CharSequence)((CharSequence)var22_22.first))) {
                        if (var20_14.zzjfx) {
                            var21_21.zzjvc = (String)var22_22.first;
                            var21_21.zzjvd = (Boolean)var22_22.second;
                        }
                    } else if (!var18_20.zzayf().zzec(var18_20.zzaiq)) {
                        var23_23 = Settings.Secure.getString((ContentResolver)var18_20.zzaiq.getContentResolver(), (String)"android_id");
                        if (var23_23 == null) {
                            var18_20.zzayp().zzbaw().zzj("null secure ID. appId", zzcjj.zzjs(var21_21.zzcm));
                            var23_23 = "null";
                        } else if (var23_23.isEmpty()) {
                            var18_20.zzayp().zzbaw().zzj("empty secure ID. appId", zzcjj.zzjs(var21_21.zzcm));
                        }
                        var21_21.zzjvl = var23_23;
                    }
                    var18_20.zzayf().zzyk();
                    var21_21.zzjuy = Build.MODEL;
                    var18_20.zzayf().zzyk();
                    var21_21.zzda = Build.VERSION.RELEASE;
                    var21_21.zzjuz = (int)var18_20.zzayf().zzbal();
                    var21_21.zzjho = var18_20.zzayf().zzbam();
                    var21_21.zzjvb = null;
                    var21_21.zzjus = null;
                    var21_21.zzjut = null;
                    var21_21.zzjuu = null;
                    var21_21.zzfqm = var20_14.zzjfw;
                    if (var18_20.isEnabled() && zzcik.zzazv()) {
                        var21_21.zzjvn = null;
                    }
                    if ((var23_23 = var18_20.zzayj().zzjj(var20_14.packageName)) == null) {
                        var23_23 = new zzcie(var18_20, var20_14.packageName);
                        var23_23.zziy(var18_20.zzaye().zzbaq());
                        var23_23.zzjb(var20_14.zzjfn);
                        var23_23.zziz(var20_14.zzjfl);
                        var23_23.zzja(var18_20.zzayq().zzjv(var20_14.packageName));
                        var23_23.zzaq(0L);
                        var23_23.zzal(0L);
                        var23_23.zzam(0L);
                        var23_23.setAppVersion(var20_14.zzina);
                        var23_23.zzan(var20_14.zzjfr);
                        var23_23.zzjc(var20_14.zzjfs);
                        var23_23.zzao(var20_14.zzjft);
                        var23_23.zzap(var20_14.zzjfu);
                        var23_23.setMeasurementEnabled(var20_14.zzjfv);
                        var23_23.zzaz(var20_14.zzjfw);
                        var18_20.zzayj().zza((zzcie)var23_23);
                    }
                    var21_21.zzjfk = var23_23.getAppInstanceId();
                    var21_21.zzjfn = var23_23.zzayu();
                    var24_24 = var18_20.zzayj().zzji(var20_14.packageName);
                    var21_21.zzjur = new zzcog[var24_24.size()];
                    for (var25_25 = 0; var25_25 < var24_24.size(); ++var25_25) {
                        var21_21.zzjur[var25_25] = var26_27 = new zzcog();
                        var26_27.name = var24_24.get((int)var25_25).name;
                        var26_27.zzjvr = var24_24.get((int)var25_25).zzjsi;
                        var18_20.zzayl().zza(var26_27, var24_24.get((int)var25_25).value);
                    }
                    try {
                        var25_26 = var18_20.zzayj().zza(var21_21);
                    }
                    catch (IOException var27_28) {
                        var18_20.zzayp().zzbau().zze("Data loss. Failed to insert raw event metadata. appId", zzcjj.zzjs(var21_21.zzcm), var27_28);
                        break block45;
                    }
                    v0 = var18_20.zzayj();
                    var29_29 = var19_12;
                    var28_30 = var18_20;
                    if (var29_29.zzjhr == null) ** GOTO lbl-1000
                    for (Object var31_33 : var29_29.zzjhr) {
                        if (!"_r".equals(var31_33)) continue;
                        v1 = true;
                        break block46;
                    }
                    var30_32 = var28_30.zzaym().zzao(var29_29.zzcm, var29_29.name);
                    var31_33 = var28_30.zzayj().zza(var28_30.zzbbx(), var29_29.zzcm, false, false, false, false, false);
                    if (var30_32 && var31_33.zzjhi < (long)var28_30.zzjns.zzje(var29_29.zzcm)) {
                        v1 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = false;
                    }
                }
                if (v0.zza((zzcis)var19_12, var25_26, v1)) {
                    var18_20.zzjoy = 0L;
                }
            }
            this.zzayj().setTransactionSuccessful();
            if (this.zzayp().zzae(2)) {
                this.zzayp().zzbba().zzj("Event recorded", this.zzayk().zza(var14_17));
            }
        }
        finally {
            this.zzayj().endTransaction();
        }
        this.zzbca();
        this.zzayp().zzbba().zzj("Background event processing time, ms", (System.nanoTime() - var3_3 + 500000L) / 1000000L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean zza(String string, zzcix zzcix2) {
        long l;
        String string2;
        block10: {
            string2 = zzcix2.zzjhr.getString("currency");
            if ("ecommerce_purchase".equals(zzcix2.name)) {
                double d = zzcix2.zzjhr.getDouble("value") * 1000000.0;
                if (d == 0.0) {
                    d = (double)zzcix2.zzjhr.getLong("value").longValue() * 1000000.0;
                }
                if (d <= 9.223372036854776E18 && d >= -9.223372036854776E18) {
                    l = Math.round(d);
                    break block10;
                } else {
                    this.zzayp().zzbaw().zze("Data lost. Currency value is too big. appId", zzcjj.zzjs(string), d);
                    return false;
                }
            }
            l = zzcix2.zzjhr.getLong("value");
        }
        if (!TextUtils.isEmpty((CharSequence)string2) && (string2 = string2.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
            String string3 = String.valueOf("_ltv_");
            String string4 = String.valueOf(string2);
            String string5 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
            zzcnn zzcnn2 = this.zzayj().zzag(string, string5);
            if (zzcnn2 == null || !(zzcnn2.value instanceof Long)) {
                String string6 = string;
                int n = this.zzjns.zzb(string6, zzciz.zzjjr) - 1;
                string6 = string;
                zzcil zzcil2 = this.zzayj();
                zzbq.zzgv((String)string6);
                zzcil2.zzwj();
                zzcil2.zzyk();
                try {
                    zzcil2.getWritableDatabase().execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '_ltv_%' order by set_timestamp desc limit ?,10);", (Object[])new String[]{string6, string6, String.valueOf(n)});
                }
                catch (SQLiteException sQLiteException) {
                    zzcil2.zzayp().zzbau().zze("Error pruning currencies. appId", zzcjj.zzjs(string6), (Object)sQLiteException);
                }
                zzcnn2 = new zzcnn(string, zzcix2.zzjgm, string5, this.zzdir.currentTimeMillis(), l);
            } else {
                long l2 = (Long)zzcnn2.value;
                zzcnn2 = new zzcnn(string, zzcix2.zzjgm, string5, this.zzdir.currentTimeMillis(), l2 + l);
            }
            if (!this.zzayj().zza(zzcnn2)) {
                this.zzayp().zzbau().zzd("Too many unique user properties are set. Ignoring user property. appId", zzcjj.zzjs(string), this.zzayk().zzjr(zzcnn2.name), zzcnn2.value);
                this.zzayl().zza(string, 9, null, null, 0);
            }
        }
        return true;
    }

    @WorkerThread
    final void zzd(zzcii zzcii2) {
        zzcif zzcif2 = this.zzke(zzcii2.packageName);
        if (zzcif2 != null) {
            this.zzb(zzcii2, zzcif2);
        }
    }

    @WorkerThread
    final void zzb(zzcii zzcii2, zzcif zzcif2) {
        zzbq.checkNotNull((Object)((Object)zzcii2));
        zzbq.zzgv((String)zzcii2.packageName);
        zzbq.checkNotNull((Object)zzcii2.zzjgm);
        zzbq.checkNotNull((Object)((Object)zzcii2.zzjgn));
        zzbq.zzgv((String)zzcii2.zzjgn.name);
        ((zzclh)this.zzayo()).zzwj();
        this.zzyk();
        if (TextUtils.isEmpty((CharSequence)zzcif2.zzjfl)) {
            return;
        }
        if (!zzcif2.zzjfv) {
            this.zzg(zzcif2);
            return;
        }
        zzcii zzcii3 = new zzcii(zzcii2);
        new zzcii(zzcii2).zzjgp = false;
        this.zzayj().beginTransaction();
        try {
            boolean bl = false;
            zzcii zzcii4 = this.zzayj().zzah(zzcii3.packageName, zzcii3.zzjgn.name);
            if (zzcii4 != null && !zzcii4.zzjgm.equals(zzcii3.zzjgm)) {
                this.zzayp().zzbaw().zzd("Updating a conditional user property with different origin. name, origin, origin (from DB)", this.zzayk().zzjr(zzcii3.zzjgn.name), zzcii3.zzjgm, zzcii4.zzjgm);
            }
            if (zzcii4 != null && zzcii4.zzjgp) {
                zzcii3.zzjgm = zzcii4.zzjgm;
                zzcii3.zzjgo = zzcii4.zzjgo;
                zzcii3.zzjgs = zzcii4.zzjgs;
                zzcii3.zzjgq = zzcii4.zzjgq;
                zzcii3.zzjgt = zzcii4.zzjgt;
                zzcii3.zzjgp = zzcii4.zzjgp;
                zzcii3.zzjgn = new zzcnl(zzcii3.zzjgn.name, zzcii4.zzjgn.zzjsi, zzcii3.zzjgn.getValue(), zzcii4.zzjgn.zzjgm);
            } else if (TextUtils.isEmpty((CharSequence)zzcii3.zzjgq)) {
                zzcii3.zzjgn = new zzcnl(zzcii3.zzjgn.name, zzcii3.zzjgo, zzcii3.zzjgn.getValue(), zzcii3.zzjgn.zzjgm);
                zzcii3.zzjgp = true;
                bl = true;
            }
            if (zzcii3.zzjgp) {
                zzcnl zzcnl2 = zzcii3.zzjgn;
                zzcnn zzcnn2 = new zzcnn(zzcii3.packageName, zzcii3.zzjgm, zzcnl2.name, zzcnl2.zzjsi, zzcnl2.getValue());
                if (this.zzayj().zza(zzcnn2)) {
                    this.zzayp().zzbaz().zzd("User property updated immediately", zzcii3.packageName, this.zzayk().zzjr(zzcnn2.name), zzcnn2.value);
                } else {
                    this.zzayp().zzbau().zzd("(2)Too many active user properties, ignoring", zzcjj.zzjs(zzcii3.packageName), this.zzayk().zzjr(zzcnn2.name), zzcnn2.value);
                }
                if (bl && zzcii3.zzjgt != null) {
                    zzcix zzcix2 = new zzcix(zzcii3.zzjgt, zzcii3.zzjgo);
                    this.zzc(zzcix2, zzcif2);
                }
            }
            if (this.zzayj().zza(zzcii3)) {
                this.zzayp().zzbaz().zzd("Conditional property added", zzcii3.packageName, this.zzayk().zzjr(zzcii3.zzjgn.name), zzcii3.zzjgn.getValue());
            } else {
                this.zzayp().zzbau().zzd("Too many conditional properties, ignoring", zzcjj.zzjs(zzcii3.packageName), this.zzayk().zzjr(zzcii3.zzjgn.name), zzcii3.zzjgn.getValue());
            }
            this.zzayj().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzayj().endTransaction();
        }
    }

    @WorkerThread
    final void zze(zzcii zzcii2) {
        zzcif zzcif2 = this.zzke(zzcii2.packageName);
        if (zzcif2 != null) {
            this.zzc(zzcii2, zzcif2);
        }
    }

    @WorkerThread
    final void zzc(zzcii zzcii2, zzcif zzcif2) {
        zzbq.checkNotNull((Object)((Object)zzcii2));
        zzbq.zzgv((String)zzcii2.packageName);
        zzbq.checkNotNull((Object)((Object)zzcii2.zzjgn));
        zzbq.zzgv((String)zzcii2.zzjgn.name);
        ((zzclh)this.zzayo()).zzwj();
        this.zzyk();
        if (TextUtils.isEmpty((CharSequence)zzcif2.zzjfl)) {
            return;
        }
        if (!zzcif2.zzjfv) {
            this.zzg(zzcif2);
            return;
        }
        this.zzayj().beginTransaction();
        try {
            this.zzg(zzcif2);
            zzcii zzcii3 = this.zzayj().zzah(zzcii2.packageName, zzcii2.zzjgn.name);
            if (zzcii3 != null) {
                this.zzayp().zzbaz().zze("Removing conditional user property", zzcii2.packageName, this.zzayk().zzjr(zzcii2.zzjgn.name));
                this.zzayj().zzai(zzcii2.packageName, zzcii2.zzjgn.name);
                if (zzcii3.zzjgp) {
                    this.zzayj().zzaf(zzcii2.packageName, zzcii2.zzjgn.name);
                }
                if (zzcii2.zzjgv != null) {
                    Bundle bundle = null;
                    if (zzcii2.zzjgv.zzjhr != null) {
                        bundle = zzcii2.zzjgv.zzjhr.zzbao();
                    }
                    zzcix zzcix2 = this.zzayl().zza(zzcii2.zzjgv.name, bundle, zzcii3.zzjgm, zzcii2.zzjgv.zzjib, true, false);
                    this.zzc(zzcix2, zzcif2);
                }
            } else {
                this.zzayp().zzbaw().zze("Conditional user property doesn't exist", zzcjj.zzjs(zzcii2.packageName), this.zzayk().zzjr(zzcii2.zzjgn.name));
            }
            this.zzayj().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzayj().endTransaction();
        }
    }

    @WorkerThread
    public final byte[] zza(@NonNull zzcix zzcix2, @Size(min=1L) String string) {
        Long l;
        this.zzyk();
        ((zzclh)this.zzayo()).zzwj();
        zzckj.zzaxz();
        zzbq.checkNotNull((Object)((Object)zzcix2));
        zzbq.zzgv((String)string);
        zzcod zzcod2 = new zzcod();
        this.zzayj().beginTransaction();
        try {
            zzcit zzcit2;
            long l2;
            Object object;
            zzcie zzcie2 = this.zzayj().zzjj(string);
            if (zzcie2 == null) {
                this.zzayp().zzbaz().zzj("Log and bundle not available. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            if (!zzcie2.zzazb()) {
                this.zzayp().zzbaz().zzj("Log and bundle disabled. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            if (("_iap".equals(zzcix2.name) || "ecommerce_purchase".equals(zzcix2.name)) && !this.zza(string, zzcix2)) {
                this.zzayp().zzbaw().zzj("Failed to handle purchase event at single event bundle creation. appId", zzcjj.zzjs(string));
            }
            boolean bl = this.zzjns.zzjh(string);
            l = 0L;
            if (bl && "_e".equals(zzcix2.name)) {
                if (zzcix2.zzjhr == null || zzcix2.zzjhr.size() == 0) {
                    this.zzayp().zzbaw().zzj("The engagement event does not contain any parameters. appId", zzcjj.zzjs(string));
                } else if (zzcix2.zzjhr.getLong("_et") == null) {
                    this.zzayp().zzbaw().zzj("The engagement event does not include duration. appId", zzcjj.zzjs(string));
                } else {
                    l = zzcix2.zzjhr.getLong("_et");
                }
            }
            zzcoe zzcoe2 = new zzcoe();
            zzcod2.zzjun = new zzcoe[]{zzcoe2};
            zzcoe2.zzjup = 1;
            zzcoe2.zzjux = "android";
            zzcoe2.zzcm = zzcie2.getAppId();
            zzcoe2.zzjfs = zzcie2.zzayy();
            zzcoe2.zzina = zzcie2.zzwo();
            long l3 = zzcie2.zzayx();
            zzcoe2.zzjvi = l3 == Integer.MIN_VALUE ? null : Integer.valueOf((int)l3);
            zzcoe2.zzjva = zzcie2.zzayz();
            zzcoe2.zzjfl = zzcie2.getGmpAppId();
            zzcoe2.zzjve = zzcie2.zzaza();
            if (this.isEnabled() && zzcik.zzazv() && this.zzjns.zzjg(zzcoe2.zzcm)) {
                zzcoe2.zzjvn = null;
            }
            Pair<String, Boolean> pair = this.zzayq().zzju(zzcie2.getAppId());
            if (zzcie2.zzazp() && pair != null && !TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
                zzcoe2.zzjvc = (String)pair.first;
                zzcoe2.zzjvd = (Boolean)pair.second;
            }
            this.zzayf().zzyk();
            zzcoe2.zzjuy = Build.MODEL;
            this.zzayf().zzyk();
            zzcoe2.zzda = Build.VERSION.RELEASE;
            zzcoe2.zzjuz = (int)this.zzayf().zzbal();
            zzcoe2.zzjho = this.zzayf().zzbam();
            zzcoe2.zzjfk = zzcie2.getAppInstanceId();
            zzcoe2.zzjfn = zzcie2.zzayu();
            List<zzcnn> list = this.zzayj().zzji(zzcie2.getAppId());
            zzcoe2.zzjur = new zzcog[list.size()];
            zzcnn zzcnn2 = null;
            if (bl) {
                zzcnn2 = this.zzayj().zzag(zzcoe2.zzcm, "_lte");
                if (zzcnn2 == null || zzcnn2.value == null) {
                    zzcnn2 = new zzcnn(zzcoe2.zzcm, "auto", "_lte", this.zzdir.currentTimeMillis(), l);
                } else if (l > 0L) {
                    zzcnn2 = new zzcnn(zzcoe2.zzcm, "auto", "_lte", this.zzdir.currentTimeMillis(), (Long)zzcnn2.value + l);
                }
            }
            zzcog zzcog2 = null;
            for (int i = 0; i < list.size(); ++i) {
                object = new zzcog();
                zzcoe2.zzjur[i] = object;
                ((zzcog)((Object)object)).name = list.get((int)i).name;
                ((zzcog)((Object)object)).zzjvr = list.get((int)i).zzjsi;
                this.zzayl().zza((zzcog)((Object)object), list.get((int)i).value);
                if (!bl || !"_lte".equals(((zzcog)((Object)object)).name)) continue;
                zzcog2 = object;
                ((zzcog)((Object)object)).zzjum = (Long)zzcnn2.value;
                zzcog2.zzjvr = this.zzdir.currentTimeMillis();
            }
            if (bl && zzcog2 == null) {
                zzcog2 = new zzcog();
                new zzcog().name = "_lte";
                zzcog2.zzjvr = this.zzdir.currentTimeMillis();
                zzcog2.zzjum = (Long)zzcnn2.value;
                zzcoe2.zzjur = Arrays.copyOf(zzcoe2.zzjur, zzcoe2.zzjur.length + 1);
                zzcoe2.zzjur[zzcoe2.zzjur.length - 1] = zzcog2;
            }
            if (l > 0L) {
                this.zzayj().zza(zzcnn2);
            }
            Bundle bundle = zzcix2.zzjhr.zzbao();
            if ("_iap".equals(zzcix2.name)) {
                bundle.putLong("_c", 1L);
                this.zzayp().zzbaz().log("Marking in-app purchase as real-time");
                bundle.putLong("_r", 1L);
            }
            bundle.putString("_o", zzcix2.zzjgm);
            if (this.zzayl().zzkq(zzcoe2.zzcm)) {
                this.zzayl().zza(bundle, "_dbg", 1L);
                this.zzayl().zza(bundle, "_r", 1L);
            }
            if ((object = this.zzayj().zzae(string, zzcix2.name)) == null) {
                l2 = 0L;
                zzcit2 = new zzcit(string, zzcix2.name, 1L, 0L, zzcix2.zzjib, 0L, null, null, null);
                this.zzayj().zza(zzcit2);
            } else {
                l2 = ((zzcit)object).zzjhu;
                zzcit2 = ((zzcit)object).zzbb(zzcix2.zzjib).zzban();
                this.zzayj().zza(zzcit2);
            }
            zzcis zzcis2 = new zzcis(this, zzcix2.zzjgm, string, zzcix2.name, zzcix2.zzjib, l2, bundle);
            zzcob zzcob2 = new zzcob();
            zzcoe2.zzjuq = new zzcob[]{zzcob2};
            zzcob2.zzjuj = zzcis2.timestamp;
            zzcob2.name = zzcis2.name;
            zzcob2.zzjuk = zzcis2.zzjhq;
            zzcob2.zzjui = new zzcoc[zzcis2.zzjhr.size()];
            int n = 0;
            for (String string2 : zzcis2.zzjhr) {
                zzcoc zzcoc2 = new zzcoc();
                zzcob2.zzjui[n++] = zzcoc2;
                zzcoc2.name = string2;
                Object object2 = zzcis2.zzjhr.get(string2);
                this.zzayl().zza(zzcoc2, object2);
            }
            zzcoe2.zzjvh = this.zza(zzcie2.getAppId(), zzcoe2.zzjur, zzcoe2.zzjuq);
            zzcoe2.zzjut = zzcob2.zzjuj;
            zzcoe2.zzjuu = zzcob2.zzjuj;
            long l4 = zzcie2.zzayw();
            zzcoe2.zzjuw = l4 != 0L ? Long.valueOf(l4) : null;
            long l5 = zzcie2.zzayv();
            if (l5 == 0L) {
                l5 = l4;
            }
            zzcoe2.zzjuv = l5 != 0L ? Long.valueOf(l5) : null;
            zzcie2.zzazf();
            zzcoe2.zzjvf = (int)zzcie2.zzazc();
            zzcoe2.zzjvb = 12211L;
            zzcoe2.zzjus = this.zzdir.currentTimeMillis();
            zzcoe2.zzjvg = Boolean.TRUE;
            zzcie2.zzal(zzcoe2.zzjut);
            zzcie2.zzam(zzcoe2.zzjuu);
            this.zzayj().zza(zzcie2);
            this.zzayj().setTransactionSuccessful();
        }
        finally {
            this.zzayj().endTransaction();
        }
        try {
            byte[] byArray;
            byte[] byArray2 = byArray = new byte[zzcod2.zzhs()];
            l = zzflk.zzp((byte[])byArray, (int)0, (int)byArray2.length);
            zzcod2.zza((zzflk)l);
            l.zzcyx();
            return this.zzayl().zzr(byArray);
        }
        catch (IOException iOException) {
            this.zzayp().zzbau().zze("Data loss. Failed to bundle and serialize. appId", zzcjj.zzjs(string), iOException);
            return null;
        }
    }

    public final String zzkf(String string) {
        Future<String> future = this.zzayo().zzc(new zzckl(this, string));
        try {
            return future.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zzayp().zzbau().zze("Failed to get app instance id. appId", zzcjj.zzjs(string), exception);
            return null;
        }
    }

    private static boolean zza(zzcob zzcob2, String string, Object object) {
        if (TextUtils.isEmpty((CharSequence)string) || object == null) {
            return false;
        }
        zzcoc[] zzcocArray = zzcob2.zzjui;
        int n = zzcob2.zzjui.length;
        for (int i = 0; i < n; ++i) {
            zzcoc zzcoc2 = zzcocArray[i];
            if (!string.equals(zzcoc2.name)) continue;
            return object instanceof Long && object.equals(zzcoc2.zzjum) || object instanceof String && object.equals(zzcoc2.zzgim) || object instanceof Double && object.equals(zzcoc2.zzjsl);
        }
        return false;
    }

    static void zzaxz() {
        throw new IllegalStateException("Unexpected call on client side");
    }

    @WorkerThread
    final void zzb(zzcnl zzcnl2, zzcif zzcif2) {
        ((zzclh)this.zzayo()).zzwj();
        this.zzyk();
        if (TextUtils.isEmpty((CharSequence)zzcif2.zzjfl)) {
            return;
        }
        if (!zzcif2.zzjfv) {
            this.zzg(zzcif2);
            return;
        }
        int n = this.zzayl().zzkk(zzcnl2.name);
        if (n != 0) {
            this.zzayl();
            String string = zzcno.zza(zzcnl2.name, 24, true);
            int n2 = zzcnl2.name != null ? zzcnl2.name.length() : 0;
            this.zzayl().zza(zzcif2.packageName, n, "_ev", string, n2);
            return;
        }
        n = this.zzayl().zzl(zzcnl2.name, zzcnl2.getValue());
        if (n != 0) {
            this.zzayl();
            String string = zzcno.zza(zzcnl2.name, 24, true);
            Object object = zzcnl2.getValue();
            int n3 = 0;
            if (object != null && (object instanceof String || object instanceof CharSequence)) {
                n3 = String.valueOf(object).length();
            }
            this.zzayl().zza(zzcif2.packageName, n, "_ev", string, n3);
            return;
        }
        Object object = this.zzayl().zzm(zzcnl2.name, zzcnl2.getValue());
        if (object == null) {
            return;
        }
        zzcnn zzcnn2 = new zzcnn(zzcif2.packageName, zzcnl2.zzjgm, zzcnl2.name, zzcnl2.zzjsi, object);
        this.zzayp().zzbaz().zze("Setting user property", this.zzayk().zzjr(zzcnn2.name), object);
        this.zzayj().beginTransaction();
        try {
            this.zzg(zzcif2);
            boolean bl = this.zzayj().zza(zzcnn2);
            this.zzayj().setTransactionSuccessful();
            if (bl) {
                this.zzayp().zzbaz().zze("User property set", this.zzayk().zzjr(zzcnn2.name), zzcnn2.value);
            } else {
                this.zzayp().zzbau().zze("Too many unique user properties are set. Ignoring user property", this.zzayk().zzjr(zzcnn2.name), zzcnn2.value);
                this.zzayl().zza(zzcif2.packageName, 9, null, null, 0);
            }
            return;
        }
        finally {
            this.zzayj().endTransaction();
        }
    }

    @WorkerThread
    final void zzc(zzcnl zzcnl2, zzcif zzcif2) {
        ((zzclh)this.zzayo()).zzwj();
        this.zzyk();
        if (TextUtils.isEmpty((CharSequence)zzcif2.zzjfl)) {
            return;
        }
        if (!zzcif2.zzjfv) {
            this.zzg(zzcif2);
            return;
        }
        this.zzayp().zzbaz().zzj("Removing user property", this.zzayk().zzjr(zzcnl2.name));
        this.zzayj().beginTransaction();
        try {
            this.zzg(zzcif2);
            this.zzayj().zzaf(zzcif2.packageName, zzcnl2.name);
            this.zzayj().setTransactionSuccessful();
            this.zzayp().zzbaz().zzj("User property removed", this.zzayk().zzjr(zzcnl2.name));
            return;
        }
        finally {
            this.zzayj().endTransaction();
        }
    }

    @WorkerThread
    public final void zzbby() {
        ((zzclh)this.zzayo()).zzwj();
        this.zzyk();
        this.zzjpb = true;
        try {
            String string;
            Boolean bl = this.zzayg().zzbck();
            if (bl == null) {
                this.zzayp().zzbaw().log("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzayp().zzbau().log("Upload called in the client side when service should be used");
                return;
            }
            if (this.zzjoy > 0L) {
                this.zzbca();
                return;
            }
            Object object = this;
            ((zzclh)((zzckj)object).zzayo()).zzwj();
            if (((zzckj)object).zzjot != null) {
                this.zzayp().zzbba().log("Uploading requested multiple times");
                return;
            }
            if (!this.zzbbs().zzaax()) {
                this.zzayp().zzbba().log("Network not connected, ignoring upload request");
                this.zzbca();
                return;
            }
            long l = this.zzdir.currentTimeMillis();
            long l2 = l - zzcik.zzazt();
            this.zzg(null, l2);
            long l3 = this.zzayq().zzjln.get();
            if (l3 != 0L) {
                this.zzayp().zzbaz().zzj("Uploading events. Elapsed time since last upload attempt (ms)", Math.abs(l - l3));
            }
            if (!TextUtils.isEmpty((CharSequence)(string = this.zzayj().zzazw()))) {
                if (this.zzjox == -1L) {
                    this.zzjox = this.zzayj().zzbad();
                }
                Object object2 = string;
                int n = this.zzjns.zzb((String)object2, zzciz.zzjit);
                object2 = string;
                object = this.zzjns;
                int n2 = Math.max(0, ((zzcik)object).zzb((String)object2, zzciz.zzjiu));
                List<Pair<zzcoe, Long>> list = this.zzayj().zzl(string, n, n2);
                if (!list.isEmpty()) {
                    Object object3;
                    String string2 = null;
                    Object object4 = list.iterator();
                    while (object4.hasNext()) {
                        zzcoe zzcoe2 = (zzcoe)((Object)object4.next().first);
                        if (TextUtils.isEmpty((CharSequence)zzcoe2.zzjvc)) continue;
                        string2 = zzcoe2.zzjvc;
                        break;
                    }
                    if (string2 != null) {
                        for (int i = 0; i < list.size(); ++i) {
                            object3 = (zzcoe)((Object)list.get((int)i).first);
                            if (TextUtils.isEmpty((CharSequence)((zzcoe)((Object)object3)).zzjvc) || ((zzcoe)((Object)object3)).zzjvc.equals(string2)) continue;
                            list = list.subList(0, i);
                            break;
                        }
                    }
                    object4 = new zzcod();
                    new zzcod().zzjun = new zzcoe[list.size()];
                    object3 = new ArrayList(list.size());
                    boolean bl2 = zzcik.zzazv() && this.zzjns.zzjg(string);
                    for (int i = 0; i < ((zzcod)((Object)object4)).zzjun.length; ++i) {
                        ((zzcod)((Object)object4)).zzjun[i] = (zzcoe)((Object)list.get((int)i).first);
                        object3.add((Long)list.get((int)i).second);
                        ((zzcod)((Object)object4)).zzjun[i].zzjvb = 12211L;
                        ((zzcod)((Object)object4)).zzjun[i].zzjus = l;
                        ((zzcod)((Object)object4)).zzjun[i].zzjvg = false;
                        if (bl2) continue;
                        ((zzcod)((Object)object4)).zzjun[i].zzjvn = null;
                    }
                    String string3 = null;
                    if (this.zzayp().zzae(2)) {
                        string3 = this.zzayk().zza((zzcod)((Object)object4));
                    }
                    byte[] byArray = this.zzayl().zzb((zzcod)((Object)object4));
                    String string4 = zzciz.zzjjd.get();
                    try {
                        URL uRL = new URL(string4);
                        object2 = object3;
                        object = this;
                        zzbq.checkArgument((!object2.isEmpty() ? 1 : 0) != 0);
                        if (((zzckj)object).zzjot != null) {
                            ((zzckj)object).zzayp().zzbau().log("Set uploading progress before finishing the previous upload");
                        } else {
                            ((zzckj)object).zzjot = new ArrayList<Long>((Collection<Long>)object2);
                        }
                        this.zzayq().zzjlo.set(l);
                        String string5 = "?";
                        if (((zzcod)((Object)object4)).zzjun.length > 0) {
                            string5 = ((zzcod)((Object)object4)).zzjun[0].zzcm;
                        }
                        this.zzayp().zzbba().zzd("Uploading data. app, uncompressed size, data", string5, byArray.length, string3);
                        this.zzjpa = true;
                        zzckm zzckm2 = new zzckm(this);
                        byte[] byArray2 = byArray;
                        URL uRL2 = uRL;
                        object2 = string;
                        object = this.zzbbs();
                        ((zzclh)object).zzwj();
                        ((zzcli)object).zzyk();
                        zzbq.checkNotNull((Object)uRL2);
                        zzbq.checkNotNull((Object)byArray2);
                        zzbq.checkNotNull((Object)zzckm2);
                        ((zzclh)object).zzayo().zzi(new zzcjr((zzcjn)object, (String)object2, uRL2, byArray2, null, zzckm2));
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.zzayp().zzbau().zze("Failed to parse upload URL. Not uploading. appId", zzcjj.zzjs(string), string4);
                    }
                }
            } else {
                zzcie zzcie2;
                this.zzjox = -1L;
                String string6 = this.zzayj().zzba(l - zzcik.zzazt());
                if (!TextUtils.isEmpty((CharSequence)string6) && (zzcie2 = this.zzayj().zzjj(string6)) != null) {
                    this.zzb(zzcie2);
                }
            }
            return;
        }
        finally {
            this.zzjpb = false;
            this.zzbce();
        }
    }

    @WorkerThread
    private final void zzb(zzcie zzcie2) {
        ((zzclh)this.zzayo()).zzwj();
        if (TextUtils.isEmpty((CharSequence)zzcie2.getGmpAppId())) {
            this.zzb(zzcie2.getAppId(), 204, null, null, null);
            return;
        }
        Object object = zzcie2.getAppInstanceId();
        String string = zzcie2.getGmpAppId();
        Uri.Builder builder = new Uri.Builder();
        String string2 = String.valueOf(string);
        builder.scheme(zzciz.zzjir.get()).encodedAuthority(zzciz.zzjis.get()).path(string2.length() != 0 ? "config/app/".concat(string2) : new String("config/app/")).appendQueryParameter("app_instance_id", (String)object).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", "12211");
        String string3 = builder.build().toString();
        try {
            URL uRL = new URL(string3);
            this.zzayp().zzbba().zzj("Fetching remote configuration", zzcie2.getAppId());
            zzcny zzcny2 = this.zzaym().zzka(zzcie2.getAppId());
            ArrayMap arrayMap = null;
            String string4 = this.zzaym().zzkb(zzcie2.getAppId());
            if (zzcny2 != null && !TextUtils.isEmpty((CharSequence)string4)) {
                arrayMap = new ArrayMap();
                arrayMap.put("If-Modified-Since", string4);
            }
            this.zzjoz = true;
            zzckn zzckn2 = new zzckn(this);
            builder = arrayMap;
            object = uRL;
            string = zzcie2.getAppId();
            zzcjn zzcjn2 = this.zzbbs();
            ((zzclh)zzcjn2).zzwj();
            zzcjn2.zzyk();
            zzbq.checkNotNull((Object)object);
            zzbq.checkNotNull((Object)zzckn2);
            ((zzclh)zzcjn2).zzayo().zzi(new zzcjr(zzcjn2, string, (URL)object, null, (Map)builder, zzckn2));
            return;
        }
        catch (MalformedURLException malformedURLException) {
            this.zzayp().zzbau().zze("Failed to parse config URL. Not fetching. appId", zzcjj.zzjs(zzcie2.getAppId()), string3);
            return;
        }
    }

    @WorkerThread
    private final boolean zzg(String string, long l) {
        this.zzayj().beginTransaction();
        try {
            block94: {
                zzcoc[] zzcocArray;
                Object object;
                int n2;
                int n3;
                Object object2;
                String string2;
                zza zza2;
                block93: {
                    zza zza3 = zza2 = new zza(this, null);
                    long l2 = this.zzjox;
                    long l3 = l;
                    string2 = null;
                    object2 = this.zzayj();
                    zzbq.checkNotNull((Object)zza3);
                    ((zzclh)object2).zzwj();
                    ((zzcli)object2).zzyk();
                    try (Cursor cursor = null;){
                        String[] stringArray;
                        String string3;
                        String string4;
                        String string5;
                        String[] stringArray2;
                        SQLiteDatabase sQLiteDatabase = ((zzcil)object2).getWritableDatabase();
                        if (TextUtils.isEmpty(null)) {
                            stringArray2 = l2 != -1L ? new String[]{String.valueOf(l2), String.valueOf(l3)} : new String[]{String.valueOf(l3)};
                            string5 = l2 != -1L ? "rowid <= ? and " : "";
                            cursor = sQLiteDatabase.rawQuery(new StringBuilder(148 + String.valueOf(string5).length()).append("select app_id, metadata_fingerprint from raw_events where ").append(string5).append("app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;").toString(), stringArray2);
                            if (!cursor.moveToFirst()) break block93;
                            string2 = cursor.getString(0);
                            string4 = cursor.getString(1);
                            cursor.close();
                        } else {
                            stringArray2 = l2 != -1L ? new String[]{null, String.valueOf(l2)} : new String[]{null};
                            string5 = l2 != -1L ? " and rowid <= ?" : "";
                            cursor = sQLiteDatabase.rawQuery(new StringBuilder(84 + String.valueOf(string5).length()).append("select metadata_fingerprint from raw_events where app_id = ?").append(string5).append(" order by rowid limit 1;").toString(), stringArray2);
                            if (!cursor.moveToFirst()) break block93;
                            string4 = cursor.getString(0);
                            cursor.close();
                        }
                        cursor = sQLiteDatabase.query("raw_events_metadata", new String[]{"metadata"}, "app_id = ? and metadata_fingerprint = ?", new String[]{string2, string4}, null, null, "rowid", "2");
                        if (!cursor.moveToFirst()) {
                            ((zzclh)object2).zzayp().zzbau().zzj("Raw event metadata record is missing. appId", zzcjj.zzjs(string2));
                            break block93;
                        }
                        byte[] byArray = cursor.getBlob(0);
                        string5 = zzflj.zzo((byte[])byArray, (int)0, (int)byArray.length);
                        zzcoe zzcoe2 = new zzcoe();
                        try {
                            zzcoe2.zza((zzflj)string5);
                        }
                        catch (IOException iOException) {
                            ((zzclh)object2).zzayp().zzbau().zze("Data loss. Failed to merge raw event metadata. appId", zzcjj.zzjs(string2), iOException);
                            if (cursor != null) {
                                cursor.close();
                            }
                            break block93;
                        }
                        if (cursor.moveToNext()) {
                            ((zzclh)object2).zzayp().zzbaw().zzj("Get multiple raw event metadata records, expected one. appId", zzcjj.zzjs(string2));
                        }
                        cursor.close();
                        zza3.zzb(zzcoe2);
                        if (l2 != -1L) {
                            string3 = "app_id = ? and metadata_fingerprint = ? and rowid <= ?";
                            stringArray = new String[]{string2, string4, String.valueOf(l2)};
                        } else {
                            string3 = "app_id = ? and metadata_fingerprint = ?";
                            stringArray = new String[]{string2, string4};
                        }
                        cursor = sQLiteDatabase.query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, string3, stringArray, null, null, "rowid", null);
                        if (!cursor.moveToFirst()) {
                            ((zzclh)object2).zzayp().zzbaw().zzj("Raw event data disappeared while in transaction. appId", zzcjj.zzjs(string2));
                            break block93;
                        }
                        do {
                            long l4 = cursor.getLong(0);
                            byArray = cursor.getBlob(3);
                            string5 = zzflj.zzo((byte[])byArray, (int)0, (int)byArray.length);
                            zzcob zzcob2 = new zzcob();
                            try {
                                zzcob2.zza((zzflj)string5);
                            }
                            catch (IOException iOException) {
                                ((zzclh)object2).zzayp().zzbau().zze("Data loss. Failed to merge raw event. appId", zzcjj.zzjs(string2), iOException);
                                continue;
                            }
                            zzcob2.name = cursor.getString(1);
                            zzcob2.zzjuj = cursor.getLong(2);
                            if (!zza3.zza(l4, zzcob2)) break;
                        } while (cursor.moveToNext());
                    }
                }
                object2 = zza2;
                if (((zza)object2).zzaoz == null || ((zza)object2).zzaoz.isEmpty()) break block94;
                boolean bl = false;
                zzcoe zzcoe3 = zza2.zzjpe;
                zza2.zzjpe.zzjuq = new zzcob[zza2.zzaoz.size()];
                int n4 = 0;
                long l5 = 0L;
                boolean bl2 = this.zzjns.zzjh(zzcoe3.zzcm);
                for (n3 = 0; n3 < zza2.zzaoz.size(); ++n3) {
                    zzcob zzcob3;
                    block96: {
                        int zzcocArray3;
                        boolean bl3;
                        block95: {
                            bl3 = bl;
                            zzcob3 = zza2.zzaoz.get(n3);
                            if (this.zzaym().zzan(zza2.zzjpe.zzcm, zzcob3.name)) {
                                this.zzayp().zzbaw().zze("Dropping blacklisted raw event. appId", zzcjj.zzjs(zza2.zzjpe.zzcm), this.zzayk().zzjp(zzcob3.name));
                                if (this.zzayl().zzks(zza2.zzjpe.zzcm) || this.zzayl().zzkt(zza2.zzjpe.zzcm) || "_err".equals(zzcob3.name)) continue;
                                this.zzayl().zza(zza2.zzjpe.zzcm, 11, "_ev", zzcob3.name, 0);
                                continue;
                            }
                            n2 = this.zzaym().zzao(zza2.zzjpe.zzcm, zzcob3.name);
                            if (n2 != 0) break block95;
                            this.zzayl();
                            if (!zzcno.zzku(zzcob3.name)) break block96;
                        }
                        boolean bl4 = false;
                        boolean n = false;
                        if (zzcob3.zzjui == null) {
                            zzcob3.zzjui = new zzcoc[0];
                        }
                        zzcoc[] i = zzcob3.zzjui;
                        int zzcoc2 = zzcob3.zzjui.length;
                        for (zzcocArray3 = 0; zzcocArray3 < zzcoc2; ++zzcocArray3) {
                            object = i[zzcocArray3];
                            if ("_c".equals(((zzcoc)((Object)object)).name)) {
                                ((zzcoc)((Object)object)).zzjum = 1L;
                                bl4 = true;
                                continue;
                            }
                            if (!"_r".equals(((zzcoc)((Object)object)).name)) continue;
                            ((zzcoc)((Object)object)).zzjum = 1L;
                            n = true;
                        }
                        if (!bl4 && n2 != 0) {
                            this.zzayp().zzbba().zzj("Marking event as conversion", this.zzayk().zzjp(zzcob3.name));
                            i = Arrays.copyOf(zzcob3.zzjui, zzcob3.zzjui.length + 1);
                            zzcoc zzcoc3 = new zzcoc();
                            new zzcoc().name = "_c";
                            zzcoc3.zzjum = 1L;
                            i[i.length - 1] = zzcoc3;
                            zzcob3.zzjui = i;
                        }
                        if (!n) {
                            this.zzayp().zzbba().zzj("Marking event as real-time", this.zzayk().zzjp(zzcob3.name));
                            i = Arrays.copyOf(zzcob3.zzjui, zzcob3.zzjui.length + 1);
                            zzcoc zzcob4 = new zzcoc();
                            new zzcoc().name = "_r";
                            zzcob4.zzjum = 1L;
                            i[i.length - 1] = zzcob4;
                            zzcob3.zzjui = i;
                        }
                        bl = true;
                        if (this.zzayj().zza((long)this.zzbbx(), (String)zza2.zzjpe.zzcm, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true).zzjhi > (long)this.zzjns.zzje(zza2.zzjpe.zzcm)) {
                            for (zzcoc2 = 0; zzcoc2 < zzcob3.zzjui.length; ++zzcoc2) {
                                if (!"_r".equals(zzcob3.zzjui[zzcoc2].name)) continue;
                                zzcoc[] string6 = new zzcoc[zzcob3.zzjui.length - 1];
                                if (zzcoc2 > 0) {
                                    System.arraycopy(zzcob3.zzjui, 0, string6, 0, zzcoc2);
                                }
                                if (zzcoc2 < string6.length) {
                                    System.arraycopy(zzcob3.zzjui, zzcoc2 + 1, string6, zzcoc2, string6.length - zzcoc2);
                                }
                                zzcob3.zzjui = string6;
                                break;
                            }
                            bl = bl3;
                        }
                        if (zzcno.zzkh(zzcob3.name) && n2 != 0 && this.zzayj().zza((long)this.zzbbx(), (String)zza2.zzjpe.zzcm, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false).zzjhg > (long)this.zzjns.zzb(string2 = zza2.zzjpe.zzcm, zzciz.zzjja)) {
                            this.zzayp().zzbaw().zzj("Too many conversions. Not logging as conversion. appId", zzcjj.zzjs(zza2.zzjpe.zzcm));
                            zzcocArray3 = 0;
                            object = null;
                            zzcocArray = zzcob3.zzjui;
                            int bl6 = zzcob3.zzjui.length;
                            for (int j = 0; j < bl6; ++j) {
                                zzcoc zzcoc3 = zzcocArray[j];
                                if ("_c".equals(zzcoc3.name)) {
                                    object = zzcoc3;
                                    continue;
                                }
                                if (!"_err".equals(zzcoc3.name)) continue;
                                zzcocArray3 = 1;
                            }
                            if (zzcocArray3 != 0 && object != null) {
                                zzcob3.zzjui = (zzcoc[])zzb.zza((Object[])zzcob3.zzjui, (Object[])new zzcoc[]{object});
                            } else if (object != null) {
                                ((zzcoc)((Object)object)).name = "_err";
                                ((zzcoc)((Object)object)).zzjum = 10L;
                            } else {
                                this.zzayp().zzbau().zzj("Did not find conversion parameter. appId", zzcjj.zzjs(zza2.zzjpe.zzcm));
                            }
                        }
                    }
                    if (bl2 && "_e".equals(zzcob3.name)) {
                        if (zzcob3.zzjui == null || zzcob3.zzjui.length == 0) {
                            this.zzayp().zzbaw().zzj("Engagement event does not contain any parameters. appId", zzcjj.zzjs(zza2.zzjpe.zzcm));
                        } else {
                            this.zzayl();
                            Long l6 = (Long)zzcno.zzb(zzcob3, "_et");
                            if (l6 == null) {
                                this.zzayp().zzbaw().zzj("Engagement event does not include duration. appId", zzcjj.zzjs(zza2.zzjpe.zzcm));
                            } else {
                                l5 += l6.longValue();
                            }
                        }
                    }
                    zzcoe3.zzjuq[n4++] = zzcob3;
                }
                if (n4 < zza2.zzaoz.size()) {
                    zzcoe3.zzjuq = Arrays.copyOf(zzcoe3.zzjuq, n4);
                }
                if (bl2) {
                    zzcnn zzcnn2 = this.zzayj().zzag(zzcoe3.zzcm, "_lte");
                    zzcnn2 = zzcnn2 == null || zzcnn2.value == null ? new zzcnn(zzcoe3.zzcm, "auto", "_lte", this.zzdir.currentTimeMillis(), l5) : new zzcnn(zzcoe3.zzcm, "auto", "_lte", this.zzdir.currentTimeMillis(), (Long)zzcnn2.value + l5);
                    zzcog zzcog2 = new zzcog();
                    new zzcog().name = "_lte";
                    zzcog2.zzjvr = this.zzdir.currentTimeMillis();
                    zzcog2.zzjum = (Long)zzcnn2.value;
                    boolean bl5 = false;
                    for (n2 = 0; n2 < zzcoe3.zzjur.length; ++n2) {
                        if (!"_lte".equals(zzcoe3.zzjur[n2].name)) continue;
                        zzcoe3.zzjur[n2] = zzcog2;
                        bl5 = true;
                        break;
                    }
                    if (!bl5) {
                        zzcoe3.zzjur = Arrays.copyOf(zzcoe3.zzjur, zzcoe3.zzjur.length + 1);
                        zzcoe3.zzjur[zza2.zzjpe.zzjur.length - 1] = zzcog2;
                    }
                    if (l5 > 0L) {
                        this.zzayj().zza(zzcnn2);
                        this.zzayp().zzbaz().zzj("Updated lifetime engagement user property with value. Value", zzcnn2.value);
                    }
                }
                zzcoe3.zzjvh = this.zza(zzcoe3.zzcm, zzcoe3.zzjur, zzcoe3.zzjuq);
                if (zzciz.zzjim.get().booleanValue()) {
                    string2 = zza2.zzjpe.zzcm;
                    object2 = this.zzjns;
                    if ("1".equals(((zzclh)object2).zzaym().zzam(string2, "measurement.event_sampling_enabled"))) {
                        HashMap<String, Object> hashMap = new HashMap<String, Object>();
                        zzcob[] zzcobArray = new zzcob[zzcoe3.zzjuq.length];
                        int n8 = 0;
                        SecureRandom secureRandom = this.zzayl().zzbcr();
                        zzcob[] zzcobArray2 = zzcoe3.zzjuq;
                        int n = zzcoe3.zzjuq.length;
                        for (int i = 0; i < n; ++i) {
                            zzcob zzcob2 = zzcobArray2[i];
                            if (zzcob2.name.equals("_ep")) {
                                this.zzayl();
                                String n9 = (String)zzcno.zzb(zzcob2, "_en");
                                object = (zzcit)hashMap.get(n9);
                                if (object == null) {
                                    object = this.zzayj().zzae(zza2.zzjpe.zzcm, n9);
                                    hashMap.put(n9, object);
                                }
                                if (((zzcit)object).zzjhw != null) continue;
                                if (((zzcit)object).zzjhx > 1L) {
                                    this.zzayl();
                                    zzcob2.zzjui = zzcno.zza(zzcob2.zzjui, "_sr", ((zzcit)object).zzjhx);
                                }
                                if (((zzcit)object).zzjhy != null && ((zzcit)object).zzjhy.booleanValue()) {
                                    this.zzayl();
                                    zzcob2.zzjui = zzcno.zza(zzcob2.zzjui, "_efs", 1L);
                                }
                                zzcobArray[n8++] = zzcob2;
                                continue;
                            }
                            int n5 = 1;
                            if (!zzckj.zza(zzcob2, "_dbg", 1L)) {
                                n5 = this.zzaym().zzap(zza2.zzjpe.zzcm, zzcob2.name);
                            }
                            if (n5 <= 0) {
                                this.zzayp().zzbaw().zze("Sample rate must be positive. event, rate", zzcob2.name, n5);
                                zzcobArray[n8++] = zzcob2;
                                continue;
                            }
                            object = (zzcit)hashMap.get(zzcob2.name);
                            if (object == null && (object = this.zzayj().zzae(zza2.zzjpe.zzcm, zzcob2.name)) == null) {
                                this.zzayp().zzbaw().zze("Event being bundled has no eventAggregate. appId, eventName", zza2.zzjpe.zzcm, zzcob2.name);
                                object = new zzcit(zza2.zzjpe.zzcm, zzcob2.name, 1L, 1L, zzcob2.zzjuj, 0L, null, null, null);
                            }
                            this.zzayl();
                            zzcocArray = (zzcoc[])zzcno.zzb(zzcob2, "_eid");
                            Boolean bl3 = zzcocArray != null;
                            if (n5 == 1) {
                                zzcobArray[n8++] = zzcob2;
                                if (!bl3.booleanValue() || ((zzcit)object).zzjhw == null && ((zzcit)object).zzjhx == null && ((zzcit)object).zzjhy == null) continue;
                                object = ((zzcit)object).zza(null, null, null);
                                hashMap.put(zzcob2.name, object);
                                continue;
                            }
                            if (secureRandom.nextInt(n5) == 0) {
                                this.zzayl();
                                zzcob2.zzjui = zzcno.zza(zzcob2.zzjui, "_sr", n5);
                                zzcobArray[n8++] = zzcob2;
                                if (bl3.booleanValue()) {
                                    object = ((zzcit)object).zza(null, Long.valueOf(n5), null);
                                }
                                hashMap.put(zzcob2.name, ((zzcit)object).zzbc(zzcob2.zzjuj));
                                continue;
                            }
                            long l2 = ((zzcit)object).zzjhv;
                            if (Math.abs(zzcob2.zzjuj - l2) >= 86400000L) {
                                this.zzayl();
                                zzcob2.zzjui = zzcno.zza(zzcob2.zzjui, "_efs", 1L);
                                this.zzayl();
                                zzcob2.zzjui = zzcno.zza(zzcob2.zzjui, "_sr", n5);
                                zzcobArray[n8++] = zzcob2;
                                if (bl3.booleanValue()) {
                                    object = ((zzcit)object).zza(null, Long.valueOf(n5), true);
                                }
                                hashMap.put(zzcob2.name, ((zzcit)object).zzbc(zzcob2.zzjuj));
                                continue;
                            }
                            if (!bl3.booleanValue()) continue;
                            hashMap.put(zzcob2.name, ((zzcit)object).zza((Long)zzcocArray, null, null));
                        }
                        if (n8 < zzcoe3.zzjuq.length) {
                            zzcoe3.zzjuq = Arrays.copyOf(zzcobArray, n8);
                        }
                        for (Map.Entry entry : hashMap.entrySet()) {
                            this.zzayj().zza((zzcit)entry.getValue());
                        }
                    }
                }
                zzcoe3.zzjut = Long.MAX_VALUE;
                zzcoe3.zzjuu = Long.MIN_VALUE;
                for (n3 = 0; n3 < zzcoe3.zzjuq.length; ++n3) {
                    zzcob zzcob5 = zzcoe3.zzjuq[n3];
                    if (zzcob5.zzjuj < zzcoe3.zzjut) {
                        zzcoe3.zzjut = zzcob5.zzjuj;
                    }
                    if (zzcob5.zzjuj <= zzcoe3.zzjuu) continue;
                    zzcoe3.zzjuu = zzcob5.zzjuj;
                }
                String string7 = zza2.zzjpe.zzcm;
                zzcie zzcie2 = this.zzayj().zzjj(string7);
                if (zzcie2 == null) {
                    this.zzayp().zzbau().zzj("Bundling raw events w/o app info. appId", zzcjj.zzjs(zza2.zzjpe.zzcm));
                } else if (zzcoe3.zzjuq.length > 0) {
                    long l8 = zzcie2.zzayw();
                    zzcoe3.zzjuw = l8 != 0L ? Long.valueOf(l8) : null;
                    long l9 = zzcie2.zzayv();
                    if (l9 == 0L) {
                        l9 = l8;
                    }
                    zzcoe3.zzjuv = l9 != 0L ? Long.valueOf(l9) : null;
                    zzcie2.zzazf();
                    zzcoe3.zzjvf = (int)zzcie2.zzazc();
                    zzcie2.zzal(zzcoe3.zzjut);
                    zzcie2.zzam(zzcoe3.zzjuu);
                    zzcoe3.zzjgi = zzcie2.zzazn();
                    this.zzayj().zza(zzcie2);
                }
                if (zzcoe3.zzjuq.length > 0) {
                    zzcny zzcny2 = this.zzaym().zzka(zza2.zzjpe.zzcm);
                    if (zzcny2 == null || zzcny2.zzjtx == null) {
                        if (TextUtils.isEmpty((CharSequence)zza2.zzjpe.zzjfl)) {
                            zzcoe3.zzjvm = -1L;
                        } else {
                            this.zzayp().zzbaw().zzj("Did not find measurement config or missing version info. appId", zzcjj.zzjs(zza2.zzjpe.zzcm));
                        }
                    } else {
                        zzcoe3.zzjvm = zzcny2.zzjtx;
                    }
                    this.zzayj().zza(zzcoe3, bl);
                }
                this.zzayj().zzai(zza2.zzjpf);
                string2 = string7;
                object2 = this.zzayj();
                SQLiteDatabase sQLiteDatabase = ((zzcil)object2).getWritableDatabase();
                try {
                    sQLiteDatabase.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", (Object[])new String[]{string2, string2});
                }
                catch (SQLiteException sQLiteException) {
                    ((zzclh)object2).zzayp().zzbau().zze("Failed to remove unused event metadata. appId", zzcjj.zzjs(string2), (Object)sQLiteException);
                }
                this.zzayj().setTransactionSuccessful();
                return true;
            }
            this.zzayj().setTransactionSuccessful();
            return false;
        }
        finally {
            this.zzayj().endTransaction();
        }
    }

    private final zzcoa[] zza(String string, zzcog[] zzcogArray, zzcob[] zzcobArray) {
        zzbq.zzgv((String)string);
        return this.zzayc().zza(string, zzcobArray, zzcogArray);
    }

    @WorkerThread
    final void zzb(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
        ((zzclh)this.zzayo()).zzwj();
        this.zzyk();
        zzbq.zzgv((String)string);
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            this.zzayp().zzbba().zzj("onConfigFetched. Response size", byArray.length);
            this.zzayj().beginTransaction();
            try {
                boolean bl;
                zzcie zzcie2 = this.zzayj().zzjj(string);
                boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
                if (zzcie2 == null) {
                    this.zzayp().zzbaw().zzj("App does not exist in onConfigFetched. appId", zzcjj.zzjs(string));
                } else if (bl || n == 404) {
                    String string2;
                    List<String> list = map != null ? map.get("Last-Modified") : null;
                    String string3 = string2 = list != null && list.size() > 0 ? list.get(0) : null;
                    if (n == 404 || n == 304 ? this.zzaym().zzka(string) == null && !this.zzaym().zzb(string, null, null) : !this.zzaym().zzb(string, byArray, string2)) {
                        return;
                    }
                    zzcie2.zzar(this.zzdir.currentTimeMillis());
                    this.zzayj().zza(zzcie2);
                    if (n == 404) {
                        this.zzayp().zzbax().zzj("Config not found. Using empty config. appId", string);
                    } else {
                        this.zzayp().zzbba().zze("Successfully fetched config. Got network response. code, size", n, byArray.length);
                    }
                    if (this.zzbbs().zzaax() && this.zzbbz()) {
                        this.zzbby();
                    } else {
                        this.zzbca();
                    }
                } else {
                    zzcie2.zzas(this.zzdir.currentTimeMillis());
                    this.zzayj().zza(zzcie2);
                    this.zzayp().zzbba().zze("Fetching config failed. code, error", n, throwable);
                    this.zzaym().zzkc(string);
                    this.zzayq().zzjlo.set(this.zzdir.currentTimeMillis());
                    if (n == 503 || n == 429) {
                        this.zzayq().zzjlp.set(this.zzdir.currentTimeMillis());
                    }
                    this.zzbca();
                }
                this.zzayj().setTransactionSuccessful();
            }
            finally {
                this.zzayj().endTransaction();
            }
            return;
        }
        finally {
            this.zzjoz = false;
            this.zzbce();
        }
    }

    @WorkerThread
    protected final void zza(int n, Throwable throwable, byte[] byArray) {
        ((zzclh)this.zzayo()).zzwj();
        this.zzyk();
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            List<Long> list = this.zzjot;
            this.zzjot = null;
            if ((n == 200 || n == 204) && throwable == null) {
                try {
                    this.zzayq().zzjln.set(this.zzdir.currentTimeMillis());
                    this.zzayq().zzjlo.set(0L);
                    this.zzbca();
                    this.zzayp().zzbba().zze("Successful upload. Got network response. code, size", n, byArray.length);
                    this.zzayj().beginTransaction();
                    try {
                        for (Long l : list) {
                            long l2 = l;
                            zzcil zzcil2 = this.zzayj();
                            zzcil2.zzwj();
                            zzcil2.zzyk();
                            SQLiteDatabase sQLiteDatabase = zzcil2.getWritableDatabase();
                            String[] stringArray = new String[]{String.valueOf(l2)};
                            try {
                                if (sQLiteDatabase.delete("queue", "rowid=?", stringArray) == 1) continue;
                                throw new SQLiteException("Deleted fewer rows from queue than expected");
                            }
                            catch (SQLiteException sQLiteException) {
                                zzcil2.zzayp().zzbau().zzj("Failed to delete a bundle in a queue table", (Object)sQLiteException);
                                throw sQLiteException;
                            }
                        }
                        this.zzayj().setTransactionSuccessful();
                    }
                    finally {
                        this.zzayj().endTransaction();
                    }
                    if (this.zzbbs().zzaax() && this.zzbbz()) {
                        this.zzbby();
                    } else {
                        this.zzjox = -1L;
                        this.zzbca();
                    }
                    this.zzjoy = 0L;
                }
                catch (SQLiteException sQLiteException) {
                    this.zzayp().zzbau().zzj("Database error while trying to delete uploaded bundles", (Object)sQLiteException);
                    this.zzjoy = this.zzdir.elapsedRealtime();
                    this.zzayp().zzbba().zzj("Disable upload, time", this.zzjoy);
                }
            } else {
                this.zzayp().zzbba().zze("Network upload failed. Will retry later. code, error", n, throwable);
                this.zzayq().zzjlo.set(this.zzdir.currentTimeMillis());
                if (n == 503 || n == 429) {
                    this.zzayq().zzjlp.set(this.zzdir.currentTimeMillis());
                }
                this.zzbca();
            }
            return;
        }
        finally {
            this.zzjpa = false;
            this.zzbce();
        }
    }

    private final boolean zzbbz() {
        ((zzclh)this.zzayo()).zzwj();
        this.zzyk();
        return this.zzayj().zzbab() || !TextUtils.isEmpty((CharSequence)this.zzayj().zzazw());
    }

    @WorkerThread
    private final void zzbca() {
        long l;
        long l2;
        long l3;
        block15: {
            String string;
            ((zzclh)this.zzayo()).zzwj();
            this.zzyk();
            if (!this.zzbcd()) {
                return;
            }
            if (this.zzjoy > 0L) {
                l3 = this.zzdir.elapsedRealtime();
                l2 = 3600000L - Math.abs(l3 - this.zzjoy);
                if (l2 > 0L) {
                    this.zzayp().zzbba().zzj("Upload has been suspended. Will update scheduling later in approximately ms", l2);
                    this.zzbbt().unregister();
                    this.zzbbu().cancel();
                    return;
                }
                this.zzjoy = 0L;
            }
            if (!this.zzbbn() || !this.zzbbz()) {
                this.zzayp().zzbba().log("Nothing to upload or uploading impossible");
                this.zzbbt().unregister();
                this.zzbbu().cancel();
                return;
            }
            zzckj zzckj2 = this;
            long l4 = zzckj2.zzdir.currentTimeMillis();
            long l5 = Math.max(0L, zzciz.zzjjn.get());
            boolean bl = zzckj2.zzayj().zzbac() || zzckj2.zzayj().zzazx();
            long l6 = bl ? (!TextUtils.isEmpty((CharSequence)(string = zzckj2.zzjns.zzazu())) && !".none.".equals(string) ? Math.max(0L, zzciz.zzjji.get()) : Math.max(0L, zzciz.zzjjh.get())) : Math.max(0L, zzciz.zzjjg.get());
            long l7 = zzckj2.zzayq().zzjln.get();
            long l8 = zzckj2.zzayq().zzjlo.get();
            long l9 = zzckj2.zzayj().zzazz();
            long l10 = zzckj2.zzayj().zzbaa();
            long l11 = Math.max(l9, l10);
            if (l11 == 0L) {
                l = 0L;
            } else {
                l11 = l4 - Math.abs(l11 - l4);
                l7 = l4 - Math.abs(l7 - l4);
                l8 = l4 - Math.abs(l8 - l4);
                long l12 = Math.max(l7, l8);
                long l13 = l11 + l5;
                if (bl && l12 > 0L) {
                    l13 = Math.min(l11, l12) + l6;
                }
                if (!zzckj2.zzayl().zzf(l12, l6)) {
                    l13 = l12 + l6;
                }
                if (l8 != 0L && l8 >= l11) {
                    long l14 = l13;
                    for (int i = 0; i < Math.min(20, Math.max(0, zzciz.zzjjp.get())); ++i) {
                        long l15 = 1 << i;
                        if ((l14 += Math.max(0L, zzciz.zzjjo.get()) * l15) <= l8) continue;
                        l = l14;
                        break block15;
                    }
                    l = 0L;
                } else {
                    l = l3 = l13;
                }
            }
        }
        if (l == 0L) {
            this.zzayp().zzbba().log("Next upload time is 0");
            this.zzbbt().unregister();
            this.zzbbu().cancel();
            return;
        }
        if (!this.zzbbs().zzaax()) {
            this.zzayp().zzbba().log("No network");
            this.zzbbt().zzaau();
            this.zzbbu().cancel();
            return;
        }
        l2 = this.zzayq().zzjlp.get();
        long l16 = Math.max(0L, zzciz.zzjje.get());
        if (!this.zzayl().zzf(l2, l16)) {
            l3 = Math.max(l3, l2 + l16);
        }
        this.zzbbt().unregister();
        long l17 = l3 - this.zzdir.currentTimeMillis();
        if (l17 <= 0L) {
            l17 = Math.max(0L, zzciz.zzjjj.get());
            this.zzayq().zzjln.set(this.zzdir.currentTimeMillis());
        }
        this.zzayp().zzbba().zzj("Upload scheduled in approximately ms", l17);
        this.zzbbu().zzs(l17);
    }

    public final void zzbt(boolean bl) {
        this.zzbca();
    }

    final void zzb(zzcli zzcli2) {
        ++this.zzjov;
    }

    final void zzbcb() {
        ++this.zzjow;
    }

    @WorkerThread
    public final void zzf(zzcif zzcif2) {
        int n;
        ((zzclh)this.zzayo()).zzwj();
        this.zzyk();
        zzbq.checkNotNull((Object)((Object)zzcif2));
        zzbq.zzgv((String)zzcif2.packageName);
        if (TextUtils.isEmpty((CharSequence)zzcif2.zzjfl)) {
            return;
        }
        zzcie zzcie2 = this.zzayj().zzjj(zzcif2.packageName);
        if (zzcie2 != null && TextUtils.isEmpty((CharSequence)zzcie2.getGmpAppId()) && !TextUtils.isEmpty((CharSequence)zzcif2.zzjfl)) {
            zzcie2.zzar(0L);
            this.zzayj().zza(zzcie2);
            this.zzaym().zzkd(zzcif2.packageName);
        }
        if (!zzcif2.zzjfv) {
            this.zzg(zzcif2);
            return;
        }
        long l = zzcif2.zzjgk;
        if (l == 0L) {
            l = this.zzdir.currentTimeMillis();
        }
        if ((n = zzcif2.zzjgl) != 0 && n != 1) {
            this.zzayp().zzbaw().zze("Incorrect app type, assuming installed app. appId, appType", zzcjj.zzjs(zzcif2.packageName), n);
            n = 0;
        }
        this.zzayj().beginTransaction();
        try {
            zzcix zzcix2;
            Object object;
            long l2 = l;
            zzcif zzcif3 = zzcif2;
            zzckj zzckj2 = this;
            zzcie zzcie3 = zzckj2.zzayj().zzjj(zzcif3.packageName);
            if (zzcie3 != null && zzcie3.getGmpAppId() != null && !zzcie3.getGmpAppId().equals(zzcif3.zzjfl)) {
                zzckj2.zzayp().zzbaw().zzj("New GMP App Id passed in. Removing cached database data. appId", zzcjj.zzjs(zzcie3.getAppId()));
                String string = zzcie3.getAppId();
                zzcil zzcil2 = zzckj2.zzayj();
                zzcil2.zzyk();
                zzcil2.zzwj();
                zzbq.zzgv((String)string);
                try {
                    SQLiteDatabase sQLiteDatabase = zzcil2.getWritableDatabase();
                    String[] stringArray = new String[]{string};
                    int n2 = 0 + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("event_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("property_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray);
                    if (n2 > 0) {
                        zzcil2.zzayp().zzbba().zze("Deleted application data. app, records", string, n2);
                    }
                }
                catch (SQLiteException sQLiteException) {
                    zzcil2.zzayp().zzbau().zze("Error deleting application data. appId, error", zzcjj.zzjs(string), (Object)sQLiteException);
                }
                zzcie3 = null;
            }
            if (zzcie3 != null) {
                if (zzcie3.zzayx() != Integer.MIN_VALUE) {
                    if (zzcie3.zzayx() != zzcif3.zzjfr) {
                        object = new Bundle();
                        object.putString("_pv", zzcie3.zzwo());
                        zzcix2 = new zzcix("_au", new zzciu((Bundle)object), "auto", l2);
                        zzckj2.zzb(zzcix2, zzcif3);
                    }
                } else if (zzcie3.zzwo() != null && !zzcie3.zzwo().equals(zzcif3.zzina)) {
                    object = new Bundle();
                    object.putString("_pv", zzcie3.zzwo());
                    zzcix2 = new zzcix("_au", new zzciu((Bundle)object), "auto", l2);
                    zzckj2.zzb(zzcix2, zzcif3);
                }
            }
            this.zzg(zzcif2);
            zzcit zzcit2 = null;
            if (n == 0) {
                zzcit2 = this.zzayj().zzae(zzcif2.packageName, "_f");
            } else if (n == 1) {
                zzcit2 = this.zzayj().zzae(zzcif2.packageName, "_v");
            }
            if (zzcit2 == null) {
                long l3 = (1L + l / 3600000L) * 3600000L;
                if (n == 0) {
                    zzbgl zzbgl2;
                    zzcnl zzcnl2 = new zzcnl("_fot", l, l3, "auto");
                    this.zzb(zzcnl2, zzcif2);
                    l2 = l;
                    zzcif3 = zzcif2;
                    zzckj2 = this;
                    ((zzclh)zzckj2.zzayo()).zzwj();
                    zzckj2.zzyk();
                    zzcie3 = new Bundle();
                    zzcie3.putLong("_c", 1L);
                    zzcie3.putLong("_r", 1L);
                    zzcie3.putLong("_uwa", 0L);
                    zzcie3.putLong("_pfo", 0L);
                    zzcie3.putLong("_sys", 0L);
                    zzcie3.putLong("_sysu", 0L);
                    if (zzckj2.zzaiq.getPackageManager() == null) {
                        zzckj2.zzayp().zzbau().zzj("PackageManager is null, first open report might be inaccurate. appId", zzcjj.zzjs(zzcif3.packageName));
                    } else {
                        zzcix2 = null;
                        try {
                            zzcix2 = zzbih.zzdd((Context)zzckj2.zzaiq).getPackageInfo(zzcif3.packageName, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzckj2.zzayp().zzbau().zze("Package info is null, first open report might be inaccurate. appId", zzcjj.zzjs(zzcif3.packageName), (Object)nameNotFoundException);
                        }
                        if (zzcix2 != null && ((PackageInfo)zzcix2).firstInstallTime != 0L) {
                            boolean bl = false;
                            if (((PackageInfo)zzcix2).firstInstallTime != ((PackageInfo)zzcix2).lastUpdateTime) {
                                zzcie3.putLong("_uwa", 1L);
                            } else {
                                bl = true;
                            }
                            zzbgl2 = new zzcnl("_fi", l2, bl ? 1L : 0L, "auto");
                            zzckj2.zzb((zzcnl)zzbgl2, zzcif3);
                        }
                        ApplicationInfo applicationInfo = null;
                        try {
                            applicationInfo = zzbih.zzdd((Context)zzckj2.zzaiq).getApplicationInfo(zzcif3.packageName, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzckj2.zzayp().zzbau().zze("Application info is null, first open report might be inaccurate. appId", zzcjj.zzjs(zzcif3.packageName), (Object)nameNotFoundException);
                        }
                        if (applicationInfo != null) {
                            if ((applicationInfo.flags & 1) != 0) {
                                zzcie3.putLong("_sys", 1L);
                            }
                            if ((applicationInfo.flags & 0x80) != 0) {
                                zzcie3.putLong("_sysu", 1L);
                            }
                        }
                    }
                    String string = zzcif3.packageName;
                    zzcil zzcil3 = zzckj2.zzayj();
                    zzbq.zzgv((String)string);
                    zzcil3.zzwj();
                    zzcil3.zzyk();
                    long l4 = zzcil3.zzal(string, "first_open_count");
                    if (l4 >= 0L) {
                        zzcie3.putLong("_pfo", l4);
                    }
                    zzbgl2 = new zzcix("_f", new zzciu((Bundle)zzcie3), "auto", l2);
                    zzckj2.zzb((zzcix)zzbgl2, zzcif3);
                } else if (n == 1) {
                    zzcnl zzcnl3 = new zzcnl("_fvt", l, l3, "auto");
                    this.zzb(zzcnl3, zzcif2);
                    l2 = l;
                    zzcif3 = zzcif2;
                    zzckj2 = this;
                    ((zzclh)zzckj2.zzayo()).zzwj();
                    zzckj2.zzyk();
                    zzcie3 = new Bundle();
                    zzcie3.putLong("_c", 1L);
                    zzcie3.putLong("_r", 1L);
                    object = new zzcix("_v", new zzciu((Bundle)zzcie3), "auto", l2);
                    zzckj2.zzb((zzcix)((Object)object), zzcif3);
                }
                l2 = l;
                zzcif3 = zzcif2;
                zzckj2 = this;
                zzcie3 = new Bundle();
                zzcie3.putLong("_et", 1L);
                object = new zzcix("_e", new zzciu((Bundle)zzcie3), "auto", l2);
                zzckj2.zzb((zzcix)((Object)object), zzcif3);
            } else if (zzcif2.zzjgj) {
                l2 = l;
                zzcif3 = zzcif2;
                zzckj2 = this;
                zzcie3 = new Bundle();
                object = new zzcix("_cd", new zzciu((Bundle)zzcie3), "auto", l2);
                zzckj2.zzb((zzcix)((Object)object), zzcif3);
            }
            this.zzayj().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzayj().endTransaction();
        }
    }

    @WorkerThread
    private final void zzg(zzcif zzcif2) {
        ((zzclh)this.zzayo()).zzwj();
        this.zzyk();
        zzbq.checkNotNull((Object)((Object)zzcif2));
        zzbq.zzgv((String)zzcif2.packageName);
        zzcie zzcie2 = this.zzayj().zzjj(zzcif2.packageName);
        String string = this.zzayq().zzjv(zzcif2.packageName);
        boolean bl = false;
        if (zzcie2 == null) {
            zzcie2 = new zzcie(this, zzcif2.packageName);
            zzcie2.zziy(this.zzaye().zzbaq());
            zzcie2.zzja(string);
            bl = true;
        } else if (!string.equals(zzcie2.zzayt())) {
            zzcie2.zzja(string);
            zzcie2.zziy(this.zzaye().zzbaq());
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzcif2.zzjfl) && !zzcif2.zzjfl.equals(zzcie2.getGmpAppId())) {
            zzcie2.zziz(zzcif2.zzjfl);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzcif2.zzjfn) && !zzcif2.zzjfn.equals(zzcie2.zzayu())) {
            zzcie2.zzjb(zzcif2.zzjfn);
            bl = true;
        }
        if (zzcif2.zzjft != 0L && zzcif2.zzjft != zzcie2.zzayz()) {
            zzcie2.zzao(zzcif2.zzjft);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzcif2.zzina) && !zzcif2.zzina.equals(zzcie2.zzwo())) {
            zzcie2.setAppVersion(zzcif2.zzina);
            bl = true;
        }
        if (zzcif2.zzjfr != zzcie2.zzayx()) {
            zzcie2.zzan(zzcif2.zzjfr);
            bl = true;
        }
        if (zzcif2.zzjfs != null && !zzcif2.zzjfs.equals(zzcie2.zzayy())) {
            zzcie2.zzjc(zzcif2.zzjfs);
            bl = true;
        }
        if (zzcif2.zzjfu != zzcie2.zzaza()) {
            zzcie2.zzap(zzcif2.zzjfu);
            bl = true;
        }
        if (zzcif2.zzjfv != zzcie2.zzazb()) {
            zzcie2.setMeasurementEnabled(zzcif2.zzjfv);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzcif2.zzjgi) && !zzcif2.zzjgi.equals(zzcie2.zzazm())) {
            zzcie2.zzjd(zzcif2.zzjgi);
            bl = true;
        }
        if (zzcif2.zzjfw != zzcie2.zzazo()) {
            zzcie2.zzaz(zzcif2.zzjfw);
            bl = true;
        }
        if (zzcif2.zzjfx != zzcie2.zzazp()) {
            zzcie2.zzbq(zzcif2.zzjfx);
            bl = true;
        }
        if (bl) {
            this.zzayj().zza(zzcie2);
        }
    }

    @WorkerThread
    final void zzbcc() {
        ((zzclh)this.zzayo()).zzwj();
        this.zzyk();
        if (!this.zzjoo) {
            this.zzayp().zzbay().log("This instance being marked as an uploader");
            zzckj zzckj2 = this;
            ((zzclh)zzckj2.zzayo()).zzwj();
            zzckj2.zzyk();
            if (zzckj2.zzbcd() && zzckj2.zzbbv()) {
                int n;
                int n2 = zzckj2.zza(zzckj2.zzjos);
                int n3 = n = zzckj2.zzaye().zzbar();
                int n4 = n2;
                zzckj zzckj3 = zzckj2;
                ((zzclh)zzckj3.zzayo()).zzwj();
                if (n4 > n3) {
                    zzckj3.zzayp().zzbau().zze("Panic: can't downgrade version. Previous, current version", n4, n3);
                } else if (n4 < n3) {
                    if (zzckj3.zza(n3, zzckj3.zzjos)) {
                        zzckj3.zzayp().zzbba().zze("Storage version upgraded. Previous, current version", n4, n3);
                    } else {
                        zzckj3.zzayp().zzbau().zze("Storage version upgrade failed. Previous, current version", n4, n3);
                    }
                }
            }
            this.zzjoo = true;
            this.zzbca();
        }
    }

    @WorkerThread
    private final boolean zzbcd() {
        ((zzclh)this.zzayo()).zzwj();
        this.zzyk();
        return this.zzjoo;
    }

    @WorkerThread
    final void zzj(Runnable runnable) {
        ((zzclh)this.zzayo()).zzwj();
        if (this.zzjou == null) {
            this.zzjou = new ArrayList<Runnable>();
        }
        this.zzjou.add(runnable);
    }

    @WorkerThread
    private final void zzbce() {
        ((zzclh)this.zzayo()).zzwj();
        if (this.zzjoz || this.zzjpa || this.zzjpb) {
            this.zzayp().zzbba().zzd("Not stopping services. fetch, network, upload", this.zzjoz, this.zzjpa, this.zzjpb);
            return;
        }
        this.zzayp().zzbba().log("Stopping uploading service(s)");
        if (this.zzjou == null) {
            return;
        }
        Iterator<Runnable> iterator = this.zzjou.iterator();
        while (iterator.hasNext()) {
            iterator.next().run();
        }
        this.zzjou.clear();
    }

    @WorkerThread
    private final Boolean zzc(zzcie zzcie2) {
        try {
            if (zzcie2.zzayx() != Integer.MIN_VALUE) {
                int n = zzbih.zzdd((Context)this.zzaiq).getPackageInfo((String)zzcie2.getAppId(), (int)0).versionCode;
                if (zzcie2.zzayx() == (long)n) {
                    return true;
                }
            } else {
                String string = zzbih.zzdd((Context)this.zzaiq).getPackageInfo((String)zzcie2.getAppId(), (int)0).versionName;
                if (zzcie2.zzwo() != null && zzcie2.zzwo().equals(string)) {
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
        return false;
    }

    static /* synthetic */ void zza(zzckj zzckj2, zzclj zzclj2) {
        zzckj2.zza(zzclj2);
    }

    final class zza
    implements zzcin {
        zzcoe zzjpe;
        List<Long> zzjpf;
        List<zzcob> zzaoz;
        private long zzjpg;
        private /* synthetic */ zzckj zzjpd;

        private zza(zzckj zzckj2) {
            this.zzjpd = zzckj2;
        }

        @Override
        public final void zzb(zzcoe zzcoe2) {
            zzbq.checkNotNull((Object)((Object)zzcoe2));
            this.zzjpe = zzcoe2;
        }

        @Override
        public final boolean zza(long l, zzcob zzcob2) {
            zzbq.checkNotNull((Object)((Object)zzcob2));
            if (this.zzaoz == null) {
                this.zzaoz = new ArrayList<zzcob>();
            }
            if (this.zzjpf == null) {
                this.zzjpf = new ArrayList<Long>();
            }
            if (this.zzaoz.size() > 0 && zza.zza(this.zzaoz.get(0)) != zza.zza(zzcob2)) {
                return false;
            }
            long l2 = this.zzjpg + (long)zzcob2.zzhs();
            if (l2 >= (long)Math.max(0, zzciz.zzjiv.get())) {
                return false;
            }
            this.zzjpg = l2;
            this.zzaoz.add(zzcob2);
            this.zzjpf.add(l);
            return this.zzaoz.size() < Math.max(1, zzciz.zzjiw.get());
        }

        private static long zza(zzcob zzcob2) {
            return zzcob2.zzjuj / 1000L / 60L / 60L;
        }

        /* synthetic */ zza(zzckj zzckj2, zzckk zzckk2) {
            this(zzckj2);
        }
    }
}

