/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Looper;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzckg;
import com.google.android.gms.internal.zzckh;
import com.google.android.gms.internal.zzcki;
import com.google.android.gms.internal.zzckj;
import com.google.android.gms.internal.zzclh;
import com.google.android.gms.internal.zzcli;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class zzcke
extends zzcli {
    private ExecutorService executor;
    private zzcki zzjnb;
    private zzcki zzjnc;
    private final PriorityBlockingQueue<zzckh<?>> zzjnd;
    private final BlockingQueue<zzckh<?>> zzjne;
    private final Thread.UncaughtExceptionHandler zzjnf;
    private final Thread.UncaughtExceptionHandler zzjng;
    private final Object zzjnh = new Object();
    private final Semaphore zzjni = new Semaphore(2);
    private volatile boolean zzjnj;
    private static final AtomicLong zzjnk = new AtomicLong(Long.MIN_VALUE);

    zzcke(zzckj zzckj2) {
        super(zzckj2);
        this.zzjnd = new PriorityBlockingQueue();
        this.zzjne = new LinkedBlockingQueue();
        this.zzjnf = new zzckg(this, "Thread death: Uncaught exception on worker thread");
        this.zzjng = new zzckg(this, "Thread death: Uncaught exception on network thread");
    }

    @Override
    protected final boolean zzazq() {
        return false;
    }

    @Override
    public final void zzwj() {
        if (Thread.currentThread() != this.zzjnb) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public final void zzaya() {
        if (Thread.currentThread() != this.zzjnc) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public static boolean zzas() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public final boolean zzbbk() {
        return Thread.currentThread() == this.zzjnb;
    }

    public final <V> Future<V> zzc(Callable<V> callable) throws IllegalStateException {
        this.zzyk();
        zzbq.checkNotNull(callable);
        zzckh zzckh2 = new zzckh(this, callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzjnb) {
            if (!this.zzjnd.isEmpty()) {
                ((zzclh)this).zzayp().zzbaw().log("Callable skipped the worker queue.");
            }
            zzckh2.run();
        } else {
            this.zza(zzckh2);
        }
        return zzckh2;
    }

    public final <V> Future<V> zzd(Callable<V> callable) throws IllegalStateException {
        this.zzyk();
        zzbq.checkNotNull(callable);
        zzckh zzckh2 = new zzckh(this, callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzjnb) {
            zzckh2.run();
        } else {
            this.zza(zzckh2);
        }
        return zzckh2;
    }

    public final void zzh(Runnable runnable) throws IllegalStateException {
        this.zzyk();
        zzbq.checkNotNull((Object)runnable);
        this.zza(new zzckh(this, runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzckh<?> zzckh2) {
        Object object = this.zzjnh;
        synchronized (object) {
            this.zzjnd.add(zzckh2);
            if (this.zzjnb == null) {
                this.zzjnb = new zzcki(this, "Measurement Worker", this.zzjnd);
                this.zzjnb.setUncaughtExceptionHandler(this.zzjnf);
                this.zzjnb.start();
            } else {
                this.zzjnb.zzsl();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzi(Runnable runnable) throws IllegalStateException {
        this.zzyk();
        zzbq.checkNotNull((Object)runnable);
        zzckh zzckh2 = new zzckh(this, runnable, false, "Task exception on network thread");
        zzcke zzcke2 = this;
        Object object = zzcke2.zzjnh;
        synchronized (object) {
            zzcke2.zzjne.add(zzckh2);
            if (zzcke2.zzjnc == null) {
                zzcke2.zzjnc = new zzcki(zzcke2, "Measurement Network", zzcke2.zzjne);
                zzcke2.zzjnc.setUncaughtExceptionHandler(zzcke2.zzjng);
                zzcke2.zzjnc.start();
            } else {
                zzcke2.zzjnc.zzsl();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ExecutorService zzbbl() {
        Object object = this.zzjnh;
        synchronized (object) {
            if (this.executor == null) {
                this.executor = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100));
            }
            return this.executor;
        }
    }

    static /* synthetic */ Semaphore zza(zzcke zzcke2) {
        return zzcke2.zzjni;
    }

    static /* synthetic */ boolean zzb(zzcke zzcke2) {
        return zzcke2.zzjnj;
    }

    static /* synthetic */ Object zzc(zzcke zzcke2) {
        return zzcke2.zzjnh;
    }

    static /* synthetic */ zzcki zzd(zzcke zzcke2) {
        return zzcke2.zzjnb;
    }

    static /* synthetic */ zzcki zza(zzcke zzcke2, zzcki zzcki2) {
        zzcke2.zzjnb = null;
        return null;
    }

    static /* synthetic */ zzcki zze(zzcke zzcke2) {
        return zzcke2.zzjnc;
    }

    static /* synthetic */ zzcki zzb(zzcke zzcke2, zzcki zzcki2) {
        zzcke2.zzjnc = null;
        return null;
    }

    static /* synthetic */ AtomicLong zzbbm() {
        return zzjnk;
    }
}

