/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.MainThread;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzcjj;
import com.google.android.gms.internal.zzckb;
import com.google.android.gms.internal.zzckc;
import com.google.android.gms.internal.zzckj;

public final class zzcka {
    private final zzckc zzjmp;

    public zzcka(zzckc zzckc2) {
        zzbq.checkNotNull((Object)zzckc2);
        this.zzjmp = zzckc2;
    }

    @Hide
    public static boolean zzbj(Context context) {
        zzbq.checkNotNull((Object)context);
        try {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return false;
            }
            ActivityInfo activityInfo = packageManager.getReceiverInfo(new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementReceiver"), 0);
            if (activityInfo != null && activityInfo.enabled) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return false;
    }

    @MainThread
    public final void onReceive(Context context, Intent intent) {
        zzckj zzckj2 = zzckj.zzed(context);
        zzcjj zzcjj2 = zzckj2.zzayp();
        if (intent == null) {
            zzcjj2.zzbaw().log("Receiver called with null intent");
            return;
        }
        String string = intent.getAction();
        zzcjj2.zzbba().zzj("Local receiver got", string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            Intent intent2 = new Intent().setClassName(context, "com.google.android.gms.measurement.AppMeasurementService");
            intent2.setAction("com.google.android.gms.measurement.UPLOAD");
            zzcjj2.zzbba().log("Starting wakeful intent.");
            this.zzjmp.doStartService(context, intent2);
            return;
        }
        if ("com.android.vending.INSTALL_REFERRER".equals(string)) {
            BroadcastReceiver.PendingResult pendingResult = this.zzjmp.doGoAsync();
            String string2 = intent.getStringExtra("referrer");
            if (string2 == null) {
                zzcjj2.zzbba().log("Install referrer extras are null");
                if (pendingResult != null) {
                    pendingResult.finish();
                }
                return;
            }
            zzcjj2.zzbay().zzj("Install referrer extras are", string2);
            if (!string2.contains("?")) {
                String string3 = String.valueOf(string2);
                string2 = string3.length() != 0 ? "?".concat(string3) : new String("?");
            }
            Uri uri = Uri.parse((String)string2);
            Bundle bundle = zzckj2.zzayl().zzp(uri);
            if (bundle == null) {
                zzcjj2.zzbba().log("No campaign defined in install referrer broadcast");
                if (pendingResult != null) {
                    pendingResult.finish();
                    return;
                }
            } else {
                long l = intent.getLongExtra("referrer_timestamp_seconds", 0L) * 1000L;
                if (l == 0L) {
                    zzcjj2.zzbaw().log("Install referrer is missing timestamp");
                }
                zzckj2.zzayo().zzh(new zzckb(this, zzckj2, l, bundle, context, zzcjj2, pendingResult));
            }
        }
    }
}

