/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.api.internal.zzbz;
import com.google.android.gms.internal.zzbif;
import com.google.android.gms.internal.zzcif;
import com.google.android.gms.internal.zzcjj;
import com.google.android.gms.internal.zzckj;
import com.google.android.gms.internal.zzclh;
import com.google.android.gms.internal.zzcli;
import com.google.firebase.iid.FirebaseInstanceId;
import java.math.BigInteger;
import java.util.Locale;

public final class zzcje
extends zzcli {
    private String zzcm;
    private String zzina;
    private int zzjjy;
    private String zzjfs;
    private String zziqn;
    private long zzjjz;
    private long zzjfw;
    private int zzjgl;
    private String zzjfl;

    zzcje(zzckj zzckj2) {
        super(zzckj2);
    }

    @Override
    protected final boolean zzazq() {
        return true;
    }

    @Override
    protected final void zzbap() {
        Object object;
        PackageInfo packageInfo;
        String string = "unknown";
        String string2 = "Unknown";
        int n = Integer.MIN_VALUE;
        String string3 = "Unknown";
        String string4 = ((zzclh)this).getContext().getPackageName();
        PackageManager packageManager = ((zzclh)this).getContext().getPackageManager();
        if (packageManager == null) {
            ((zzclh)this).zzayp().zzbau().zzj("PackageManager is null, app identity information might be inaccurate. appId", zzcjj.zzjs(string4));
        } else {
            try {
                string = packageManager.getInstallerPackageName(string4);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ((zzclh)this).zzayp().zzbau().zzj("Error retrieving app installer package name. appId", zzcjj.zzjs(string4));
            }
            if (string == null) {
                string = "manual_install";
            } else if ("com.android.vending".equals(string)) {
                string = "";
            }
            try {
                packageInfo = packageManager.getPackageInfo(((zzclh)this).getContext().getPackageName(), 0);
                if (packageInfo != null) {
                    CharSequence charSequence = packageManager.getApplicationLabel(packageInfo.applicationInfo);
                    if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                        string3 = charSequence.toString();
                    }
                    string2 = packageInfo.versionName;
                    n = packageInfo.versionCode;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                ((zzclh)this).zzayp().zzbau().zze("Error retrieving package info. appId, appName", zzcjj.zzjs(string4), string3);
            }
        }
        this.zzcm = string4;
        this.zzjfs = string;
        this.zzina = string2;
        this.zzjjy = n;
        this.zziqn = string3;
        this.zzjjz = 0L;
        packageInfo = zzbz.zzcl((Context)((zzclh)this).getContext());
        boolean bl = packageInfo != null && packageInfo.isSuccess();
        if (!bl) {
            PackageInfo packageInfo2 = packageInfo;
            zzcje zzcje2 = this;
            if (packageInfo2 == null) {
                ((zzclh)zzcje2).zzayp().zzbau().log("GoogleService failed to initialize (no status)");
            } else {
                ((zzclh)zzcje2).zzayp().zzbau().zze("GoogleService failed to initialize, status", packageInfo2.getStatusCode(), packageInfo2.getStatusMessage());
            }
        }
        boolean bl2 = false;
        if (bl) {
            object = ((zzclh)this).zzayr().zzjf("firebase_analytics_collection_enabled");
            if (((zzclh)this).zzayr().zzazr()) {
                ((zzclh)this).zzayp().zzbay().log("Collection disabled with firebase_analytics_collection_deactivated=1");
            } else if (object != null && !((Boolean)object).booleanValue()) {
                ((zzclh)this).zzayp().zzbay().log("Collection disabled with firebase_analytics_collection_enabled=0");
            } else if (object == null && zzbz.zzakr()) {
                ((zzclh)this).zzayp().zzbay().log("Collection disabled with google_app_measurement_enable=0");
            } else {
                bl2 = true;
                ((zzclh)this).zzayp().zzbba().log("Collection enabled");
            }
        }
        this.zzjfl = "";
        this.zzjfw = 0L;
        try {
            object = zzbz.zzakq();
            Object object2 = this.zzjfl = TextUtils.isEmpty((CharSequence)object) ? "" : object;
            if (bl2) {
                ((zzclh)this).zzayp().zzbba().zze("App package, google app id", this.zzcm, this.zzjfl);
            }
        }
        catch (IllegalStateException illegalStateException) {
            ((zzclh)this).zzayp().zzbau().zze("getGoogleAppId or isMeasurementEnabled failed with exception. appId", zzcjj.zzjs(string4), illegalStateException);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            this.zzjgl = zzbif.zzdb((Context)((zzclh)this).getContext()) ? 1 : 0;
            return;
        }
        this.zzjgl = 0;
    }

    @WorkerThread
    final zzcif zzjo(String string) {
        ((zzclh)this).zzwj();
        String string2 = this.getAppId();
        String string3 = this.getGmpAppId();
        zzcje zzcje2 = this;
        zzcje2.zzyk();
        String string4 = zzcje2.zzina;
        long l = this.zzbar();
        zzcje2 = this;
        zzcje2.zzyk();
        String string5 = zzcje2.zzjfs;
        zzcje2 = this;
        zzcje2.zzyk();
        ((zzclh)zzcje2).zzwj();
        if (zzcje2.zzjjz == 0L) {
            zzcje2.zzjjz = zzcje2.zzjev.zzayl().zzab(((zzclh)zzcje2).getContext(), ((zzclh)zzcje2).getContext().getPackageName());
        }
        long l2 = zzcje2.zzjjz;
        boolean bl = this.zzjev.isEnabled();
        boolean bl2 = !((zzclh)this).zzayq().zzjmf;
        String string6 = this.zzayu();
        this.zzyk();
        Boolean bl3 = ((zzclh)this).zzayr().zzjf("google_analytics_adid_collection_enabled");
        return new zzcif(string2, string3, string4, l, string5, 12211L, l2, string, bl, bl2, string6, 0L, this.zzjev.zzbbw(), this.zzbas(), bl3 == null || bl3 != false);
    }

    @WorkerThread
    final String zzbaq() {
        byte[] byArray = new byte[16];
        ((zzclh)this).zzayl().zzbcr().nextBytes(byArray);
        return String.format(Locale.US, "%032x", new BigInteger(1, byArray));
    }

    @WorkerThread
    private final String zzayu() {
        ((zzclh)this).zzwj();
        try {
            return FirebaseInstanceId.getInstance().getId();
        }
        catch (IllegalStateException illegalStateException) {
            ((zzclh)this).zzayp().zzbaw().log("Failed to retrieve Firebase Instance Id");
            return null;
        }
    }

    final String getAppId() {
        this.zzyk();
        return this.zzcm;
    }

    final String getGmpAppId() {
        this.zzyk();
        return this.zzjfl;
    }

    final int zzbar() {
        this.zzyk();
        return this.zzjjy;
    }

    final int zzbas() {
        this.zzyk();
        return this.zzjgl;
    }
}

