/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzu;
import com.google.android.gms.internal.zzbih;
import com.google.android.gms.internal.zzciz;
import com.google.android.gms.internal.zzcja;
import com.google.android.gms.internal.zzckj;
import com.google.android.gms.internal.zzclh;
import java.lang.reflect.InvocationTargetException;

@Hide
public final class zzcik
extends zzclh {
    private Boolean zzeba;

    zzcik(zzckj zzckj2) {
        super(zzckj2);
    }

    public final int zzje(@Size(min=1L) String string) {
        return this.zzb(string, zzciz.zzjjb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzzu() {
        if (this.zzeba == null) {
            zzcik zzcik2 = this;
            synchronized (zzcik2) {
                if (this.zzeba == null) {
                    ApplicationInfo applicationInfo = ((zzclh)this).getContext().getApplicationInfo();
                    String string = zzu.zzany();
                    if (applicationInfo != null) {
                        String string2 = applicationInfo.processName;
                        this.zzeba = string2 != null && string2.equals(string);
                    }
                    if (this.zzeba == null) {
                        this.zzeba = Boolean.TRUE;
                        ((zzclh)this).zzayp().zzbau().log("My process not in the list of running processes");
                    }
                }
            }
        }
        return this.zzeba;
    }

    public final long zza(String string, zzcja<Long> zzcja2) {
        if (string == null) {
            return zzcja2.get();
        }
        String string2 = ((zzclh)this).zzaym().zzam(string, zzcja2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzcja2.get();
        }
        try {
            long l = Long.valueOf(string2);
            return zzcja2.get(l);
        }
        catch (NumberFormatException numberFormatException) {
            return zzcja2.get();
        }
    }

    public final int zzb(String string, zzcja<Integer> zzcja2) {
        if (string == null) {
            return zzcja2.get();
        }
        String string2 = ((zzclh)this).zzaym().zzam(string, zzcja2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzcja2.get();
        }
        try {
            int n = Integer.valueOf(string2);
            return zzcja2.get(n);
        }
        catch (NumberFormatException numberFormatException) {
            return zzcja2.get();
        }
    }

    public final boolean zzc(String string, zzcja<Boolean> zzcja2) {
        if (string == null) {
            return zzcja2.get();
        }
        String string2 = ((zzclh)this).zzaym().zzam(string, zzcja2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzcja2.get();
        }
        boolean bl = Boolean.parseBoolean(string2);
        return zzcja2.get(bl);
    }

    @Nullable
    final Boolean zzjf(@Size(min=1L) String string) {
        zzbq.zzgv((String)string);
        try {
            if (((zzclh)this).getContext().getPackageManager() == null) {
                ((zzclh)this).zzayp().zzbau().log("Failed to load metadata: PackageManager is null");
                return null;
            }
            ApplicationInfo applicationInfo = zzbih.zzdd((Context)((zzclh)this).getContext()).getApplicationInfo(((zzclh)this).getContext().getPackageName(), 128);
            if (applicationInfo == null) {
                ((zzclh)this).zzayp().zzbau().log("Failed to load metadata: ApplicationInfo is null");
                return null;
            }
            if (applicationInfo.metaData == null) {
                ((zzclh)this).zzayp().zzbau().log("Failed to load metadata: Metadata bundle is null");
                return null;
            }
            if (!applicationInfo.metaData.containsKey(string)) {
                return null;
            }
            return applicationInfo.metaData.getBoolean(string);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            ((zzclh)this).zzayp().zzbau().zzj("Failed to load metadata: Package name not found", (Object)nameNotFoundException);
            return null;
        }
    }

    public final boolean zzazr() {
        Boolean bl = this.zzjf("firebase_analytics_collection_deactivated");
        return bl != null && bl != false;
    }

    public static long zzazs() {
        return zzciz.zzjjq.get();
    }

    public static long zzazt() {
        return zzciz.zzjiq.get();
    }

    public final String zzazu() {
        try {
            return (String)Class.forName("android.os.SystemProperties").getMethod("get", String.class, String.class).invoke(null, "debug.firebase.analytics.app", "");
        }
        catch (ClassNotFoundException classNotFoundException) {
            ((zzclh)this).zzayp().zzbau().zzj("Could not find SystemProperties class", classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ((zzclh)this).zzayp().zzbau().zzj("Could not find SystemProperties.get() method", noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            ((zzclh)this).zzayp().zzbau().zzj("Could not access SystemProperties.get()", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ((zzclh)this).zzayp().zzbau().zzj("SystemProperties.get() threw an exception", invocationTargetException);
        }
        return "";
    }

    public static boolean zzazv() {
        return zzciz.zzjil.get();
    }

    public final boolean zzjg(String string) {
        return "1".equals(((zzclh)this).zzaym().zzam(string, "gaia_collection_enabled"));
    }

    final boolean zzjh(String string) {
        return this.zzc(string, zzciz.zzjju);
    }
}

