/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.api.client.json.JsonFactory;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import com.google.firebase.auth.UserMetadata;
import com.google.firebase.auth.UserProvider;
import com.google.firebase.auth.UserRecord;
import com.google.firebase.internal.NonNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ImportUserRecord {
    private final Map<String, Object> properties;

    private ImportUserRecord(Map<String, Object> properties) {
        this.properties = ImmutableMap.copyOf(properties);
    }

    Map<String, Object> getProperties(JsonFactory jsonFactory) {
        HashMap<String, Object> copy = new HashMap<String, Object>(this.properties);
        if (copy.containsKey("customAttributes")) {
            Map customClaims = (Map)copy.remove("customAttributes");
            copy.put("customAttributes", UserRecord.serializeCustomClaims(customClaims, jsonFactory));
        }
        return ImmutableMap.copyOf(copy);
    }

    boolean hasPassword() {
        return this.properties.containsKey("passwordHash");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String uid;
        private String email;
        private Boolean emailVerified;
        private String displayName;
        private String phoneNumber;
        private String photoUrl;
        private Boolean disabled;
        private UserMetadata userMetadata;
        private byte[] passwordHash;
        private byte[] passwordSalt;
        private final List<UserProvider> userProviders = new ArrayList<UserProvider>();
        private final Map<String, Object> customClaims = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder setUid(String uid) {
            this.uid = uid;
            return this;
        }

        public Builder setEmail(String email) {
            this.email = email;
            return this;
        }

        public Builder setEmailVerified(boolean emailVerified) {
            this.emailVerified = emailVerified;
            return this;
        }

        public Builder setDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public Builder setPhotoUrl(String photoUrl) {
            this.photoUrl = photoUrl;
            return this;
        }

        public Builder setDisabled(boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public Builder setUserMetadata(UserMetadata userMetadata) {
            this.userMetadata = userMetadata;
            return this;
        }

        public Builder setPasswordHash(byte[] passwordHash) {
            this.passwordHash = passwordHash;
            return this;
        }

        public Builder setPasswordSalt(byte[] passwordSalt) {
            this.passwordSalt = passwordSalt;
            return this;
        }

        public Builder addUserProvider(@NonNull UserProvider provider) {
            this.userProviders.add(provider);
            return this;
        }

        public Builder addAllUserProviders(List<UserProvider> providers) {
            this.userProviders.addAll(providers);
            return this;
        }

        public Builder putCustomClaim(String key, Object value) {
            this.customClaims.put(key, value);
            return this;
        }

        public Builder putAllCustomClaims(Map<String, Object> customClaims) {
            this.customClaims.putAll(customClaims);
            return this;
        }

        public ImportUserRecord build() {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            UserRecord.checkUid(this.uid);
            properties.put("localId", this.uid);
            if (!Strings.isNullOrEmpty((String)this.email)) {
                UserRecord.checkEmail(this.email);
                properties.put("email", this.email);
            }
            if (!Strings.isNullOrEmpty((String)this.photoUrl)) {
                UserRecord.checkUrl(this.photoUrl);
                properties.put("photoUrl", this.photoUrl);
            }
            if (!Strings.isNullOrEmpty((String)this.phoneNumber)) {
                UserRecord.checkPhoneNumber(this.phoneNumber);
                properties.put("phoneNumber", this.phoneNumber);
            }
            if (!Strings.isNullOrEmpty((String)this.displayName)) {
                properties.put("displayName", this.displayName);
            }
            if (this.userMetadata != null) {
                if (this.userMetadata.getCreationTimestamp() > 0L) {
                    properties.put("createdAt", this.userMetadata.getCreationTimestamp());
                }
                if (this.userMetadata.getLastSignInTimestamp() > 0L) {
                    properties.put("lastLoginAt", this.userMetadata.getLastSignInTimestamp());
                }
            }
            if (this.passwordHash != null) {
                properties.put("passwordHash", BaseEncoding.base64Url().encode(this.passwordHash));
            }
            if (this.passwordSalt != null) {
                properties.put("salt", BaseEncoding.base64Url().encode(this.passwordSalt));
            }
            if (this.userProviders.size() > 0) {
                properties.put("providerUserInfo", ImmutableList.copyOf(this.userProviders));
            }
            if (this.customClaims.size() > 0) {
                ImmutableMap mergedClaims = ImmutableMap.copyOf(this.customClaims);
                UserRecord.checkCustomClaims((Map<String, Object>)mergedClaims);
                properties.put("customAttributes", mergedClaims);
            }
            if (this.emailVerified != null) {
                properties.put("emailVerified", this.emailVerified);
            }
            if (this.disabled != null) {
                properties.put("disabled", this.disabled);
            }
            return new ImportUserRecord(properties);
        }
    }
}

