/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import com.google.common.collect.ImmutableList;
import com.google.firebase.internal.NonNull;
import com.google.firebase.messaging.SendResponse;
import java.util.List;

public final class BatchResponse {
    private final List<SendResponse> responses;
    private final int successCount;

    BatchResponse(List<SendResponse> responses) {
        this.responses = ImmutableList.copyOf(responses);
        int successCount = 0;
        for (SendResponse response : this.responses) {
            if (!response.isSuccessful()) continue;
            ++successCount;
        }
        this.successCount = successCount;
    }

    @NonNull
    public List<SendResponse> getResponses() {
        return this.responses;
    }

    public int getSuccessCount() {
        return this.successCount;
    }

    public int getFailureCount() {
        return this.responses.size() - this.successCount;
    }
}

