/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.projectmanagement;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ascii;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.firebase.projectmanagement.ShaCertificateType;
import java.util.regex.Pattern;

public class ShaCertificate {
    private static final Pattern SHA1_PATTERN = Pattern.compile("[0-9a-fA-F]{40}");
    private static final Pattern SHA256_PATTERN = Pattern.compile("[0-9a-fA-F]{64}");
    private final String name;
    private final String shaHash;
    private final ShaCertificateType certType;

    private ShaCertificate(String name, String shaHash, ShaCertificateType certType) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Null name");
        this.shaHash = (String)Preconditions.checkNotNull((Object)shaHash, (Object)"Null shaHash");
        this.certType = (ShaCertificateType)((Object)Preconditions.checkNotNull((Object)((Object)certType), (Object)"Null certType"));
    }

    public static ShaCertificate create(String shaHash) {
        return new ShaCertificate("", shaHash, ShaCertificate.getTypeFromHash(shaHash));
    }

    static ShaCertificate create(String name, String shaHash) {
        return new ShaCertificate(name, shaHash, ShaCertificate.getTypeFromHash(shaHash));
    }

    @VisibleForTesting
    static ShaCertificateType getTypeFromHash(String shaHash) {
        Preconditions.checkNotNull((Object)shaHash, (Object)"Null shaHash");
        shaHash = Ascii.toLowerCase((String)shaHash);
        if (SHA1_PATTERN.matcher(shaHash).matches()) {
            return ShaCertificateType.SHA_1;
        }
        if (SHA256_PATTERN.matcher(shaHash).matches()) {
            return ShaCertificateType.SHA_256;
        }
        throw new IllegalArgumentException("Invalid SHA hash, it is neither SHA-1 nor SHA-256.");
    }

    public String getName() {
        return this.name;
    }

    public String getShaHash() {
        return this.shaHash;
    }

    public ShaCertificateType getCertType() {
        return this.certType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ShaCertificate) {
            ShaCertificate that = (ShaCertificate)o;
            return this.name.equals(that.getName()) && this.shaHash.equals(that.getShaHash()) && this.certType.equals((Object)that.getCertType());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ShaCertificate").add("name", (Object)this.name).add("shaHash", (Object)this.shaHash).add("certType", (Object)this.certType).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.shaHash, this.certType});
    }
}

