/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.firebase.internal.GaeThreadFactory;
import com.google.firebase.internal.RevivingScheduledExecutor;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

class GaeExecutorService
implements ExecutorService {
    private final AtomicReference<ExecutorService> executor = new AtomicReference();
    private final String threadName;
    private final ThreadFactory threadFactory;
    private boolean shutdown;

    GaeExecutorService(String threadName) {
        this(threadName, GaeThreadFactory.getInstance());
    }

    GaeExecutorService(String threadName, ThreadFactory threadFactory) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)threadName) ? 1 : 0) != 0);
        this.threadName = threadName;
        this.threadFactory = threadFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService ensureExecutorService() {
        ExecutorService executorService = this.executor.get();
        if (executorService == null) {
            AtomicReference<ExecutorService> atomicReference = this.executor;
            synchronized (atomicReference) {
                Preconditions.checkState((!this.shutdown ? 1 : 0) != 0);
                executorService = this.executor.get();
                if (executorService == null) {
                    executorService = GaeExecutorService.newExecutorService(this.threadFactory, this.threadName);
                    this.executor.compareAndSet(null, executorService);
                }
            }
        }
        return executorService;
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.ensureExecutorService().submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.ensureExecutorService().submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.ensureExecutorService().submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.ensureExecutorService().invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.ensureExecutorService().invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.ensureExecutorService().invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.ensureExecutorService().invokeAny(tasks, timeout, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        AtomicReference<ExecutorService> atomicReference = this.executor;
        synchronized (atomicReference) {
            ExecutorService executorService = this.executor.get();
            if (executorService != null && !this.shutdown) {
                executorService.shutdown();
            }
            this.shutdown = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        AtomicReference<ExecutorService> atomicReference = this.executor;
        synchronized (atomicReference) {
            ExecutorService executorService = this.executor.get();
            Object result = executorService != null && !this.shutdown ? executorService.shutdownNow() : ImmutableList.of();
            this.shutdown = true;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isShutdown() {
        AtomicReference<ExecutorService> atomicReference = this.executor;
        synchronized (atomicReference) {
            return this.shutdown;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTerminated() {
        AtomicReference<ExecutorService> atomicReference = this.executor;
        synchronized (atomicReference) {
            if (!this.shutdown) {
                return false;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
            ExecutorService executorService = this.executor.get();
            return executorService == null || executorService.isTerminated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        ExecutorService executorService;
        AtomicReference<ExecutorService> atomicReference = this.executor;
        synchronized (atomicReference) {
            executorService = this.executor.get();
        }
        return executorService == null || executorService.awaitTermination(timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.ensureExecutorService().execute(command);
    }

    private static ExecutorService newExecutorService(ThreadFactory threadFactory, String threadName) {
        boolean background;
        boolean bl = background = threadFactory instanceof GaeThreadFactory && ((GaeThreadFactory)threadFactory).isUsingBackgroundThreads();
        if (background) {
            return new RevivingScheduledExecutor(threadFactory, threadName, true);
        }
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
    }
}

