/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import com.google.api.client.googleapis.util.Utils;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.firebase.ThreadManager;
import com.google.firebase.auth.FirebaseCredential;
import com.google.firebase.auth.internal.BaseCredential;
import com.google.firebase.auth.internal.FirebaseCredentialsAdapter;
import com.google.firebase.internal.FirebaseThreadManagers;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.Nullable;
import java.util.HashMap;
import java.util.Map;

public final class FirebaseOptions {
    private final String databaseUrl;
    private final String storageBucket;
    private final GoogleCredentials credentials;
    private final Map<String, Object> databaseAuthVariableOverride;
    private final String projectId;
    private final HttpTransport httpTransport;
    private final JsonFactory jsonFactory;
    private final ThreadManager threadManager;

    private FirebaseOptions(@NonNull Builder builder) {
        this.credentials = ((GoogleCredentials)Preconditions.checkNotNull((Object)builder.credentials, (Object)"FirebaseOptions must be initialized with setCredentials().")).createScoped(BaseCredential.FIREBASE_SCOPES);
        this.databaseUrl = builder.databaseUrl;
        this.databaseAuthVariableOverride = builder.databaseAuthVariableOverride;
        this.projectId = builder.projectId;
        this.storageBucket = builder.storageBucket;
        this.httpTransport = (HttpTransport)Preconditions.checkNotNull((Object)builder.httpTransport, (Object)"FirebaseOptions must be initialized with a non-null HttpTransport.");
        this.jsonFactory = (JsonFactory)Preconditions.checkNotNull((Object)builder.jsonFactory, (Object)"FirebaseOptions must be initialized with a non-null JsonFactory.");
        this.threadManager = (ThreadManager)Preconditions.checkNotNull((Object)builder.threadManager, (Object)"FirebaseOptions must be initialized with a non-null ThreadManager");
    }

    public String getDatabaseUrl() {
        return this.databaseUrl;
    }

    public String getStorageBucket() {
        return this.storageBucket;
    }

    GoogleCredentials getCredentials() {
        return this.credentials;
    }

    public Map<String, Object> getDatabaseAuthVariableOverride() {
        return this.databaseAuthVariableOverride;
    }

    public String getProjectId() {
        return this.projectId;
    }

    @NonNull
    public HttpTransport getHttpTransport() {
        return this.httpTransport;
    }

    @NonNull
    public JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    @NonNull
    ThreadManager getThreadManager() {
        return this.threadManager;
    }

    public static final class Builder {
        @Key(value="databaseAuthVariableOverride")
        private Map<String, Object> databaseAuthVariableOverride = new HashMap<String, Object>();
        @Key(value="databaseUrl")
        private String databaseUrl;
        @Key(value="projectId")
        private String projectId;
        @Key(value="storageBucket")
        private String storageBucket;
        private GoogleCredentials credentials;
        private HttpTransport httpTransport = Utils.getDefaultTransport();
        private JsonFactory jsonFactory = Utils.getDefaultJsonFactory();
        private ThreadManager threadManager = FirebaseThreadManagers.DEFAULT_THREAD_MANAGER;

        public Builder() {
        }

        public Builder(FirebaseOptions options) {
            this.databaseUrl = options.databaseUrl;
            this.storageBucket = options.storageBucket;
            this.credentials = options.credentials;
            this.databaseAuthVariableOverride = options.databaseAuthVariableOverride;
            this.projectId = options.projectId;
            this.httpTransport = options.httpTransport;
            this.jsonFactory = options.jsonFactory;
            this.threadManager = options.threadManager;
        }

        public Builder setDatabaseUrl(@Nullable String databaseUrl) {
            this.databaseUrl = databaseUrl;
            return this;
        }

        public Builder setStorageBucket(String storageBucket) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)storageBucket) ? 1 : 0) != 0, (Object)"Storage bucket must not be null or empty");
            this.storageBucket = storageBucket;
            return this;
        }

        public Builder setCredentials(GoogleCredentials credentials) {
            this.credentials = (GoogleCredentials)Preconditions.checkNotNull((Object)credentials);
            return this;
        }

        public Builder setCredential(@NonNull FirebaseCredential credential) {
            Preconditions.checkNotNull((Object)credential);
            this.credentials = credential instanceof BaseCredential ? ((BaseCredential)credential).getGoogleCredentials() : new FirebaseCredentialsAdapter(credential);
            return this;
        }

        public Builder setDatabaseAuthVariableOverride(@Nullable Map<String, Object> databaseAuthVariableOverride) {
            this.databaseAuthVariableOverride = databaseAuthVariableOverride;
            return this;
        }

        public Builder setProjectId(@NonNull String projectId) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0, (Object)"Project ID must not be null or empty");
            this.projectId = projectId;
            return this;
        }

        public Builder setHttpTransport(HttpTransport httpTransport) {
            this.httpTransport = httpTransport;
            return this;
        }

        public Builder setJsonFactory(JsonFactory jsonFactory) {
            this.jsonFactory = jsonFactory;
            return this;
        }

        public Builder setThreadManager(ThreadManager threadManager) {
            this.threadManager = threadManager;
            return this;
        }

        public FirebaseOptions build() {
            return new FirebaseOptions(this);
        }
    }
}

