/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.api.core.ApiFuture;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.core.Path;
import com.google.firebase.database.core.Repo;
import com.google.firebase.database.core.ValidationPath;
import com.google.firebase.database.snapshot.Node;
import com.google.firebase.database.snapshot.NodeUtilities;
import com.google.firebase.database.snapshot.PriorityUtilities;
import com.google.firebase.database.utilities.Pair;
import com.google.firebase.database.utilities.Utilities;
import com.google.firebase.database.utilities.Validation;
import com.google.firebase.database.utilities.encoding.CustomClassMapper;
import com.google.firebase.internal.TaskToApiFuture;
import com.google.firebase.tasks.Task;
import java.util.Map;

public class OnDisconnect {
    private Repo repo;
    private Path path;

    OnDisconnect(Repo repo, Path path) {
        this.repo = repo;
        this.path = path;
    }

    public Task<Void> setValue(Object value) {
        return this.onDisconnectSetInternal(value, PriorityUtilities.NullPriority(), null);
    }

    public Task<Void> setValue(Object value, String priority) {
        return this.onDisconnectSetInternal(value, PriorityUtilities.parsePriority(priority), null);
    }

    public Task<Void> setValue(Object value, double priority) {
        return this.onDisconnectSetInternal(value, PriorityUtilities.parsePriority(priority), null);
    }

    public void setValue(Object value, DatabaseReference.CompletionListener listener) {
        this.onDisconnectSetInternal(value, PriorityUtilities.NullPriority(), listener);
    }

    public void setValue(Object value, String priority, DatabaseReference.CompletionListener listener) {
        this.onDisconnectSetInternal(value, PriorityUtilities.parsePriority(priority), listener);
    }

    public void setValue(Object value, double priority, DatabaseReference.CompletionListener listener) {
        this.onDisconnectSetInternal(value, PriorityUtilities.parsePriority(priority), listener);
    }

    public void setValue(Object value, Map priority, DatabaseReference.CompletionListener listener) {
        this.onDisconnectSetInternal(value, PriorityUtilities.parsePriority(priority), listener);
    }

    public ApiFuture<Void> setValueAsync(Object value) {
        return new TaskToApiFuture<Void>(this.setValue(value));
    }

    public ApiFuture<Void> setValueAsync(Object value, String priority) {
        return new TaskToApiFuture<Void>(this.setValue(value, priority));
    }

    public ApiFuture<Void> setValueAsync(Object value, double priority) {
        return new TaskToApiFuture<Void>(this.setValue(value, priority));
    }

    private Task<Void> onDisconnectSetInternal(Object value, Node priority, DatabaseReference.CompletionListener optListener) {
        Validation.validateWritablePath(this.path);
        ValidationPath.validateWithObject(this.path, value);
        Object bouncedValue = CustomClassMapper.convertToPlainJavaTypes(value);
        Validation.validateWritableObject(bouncedValue);
        final Node node = NodeUtilities.NodeFromJSON(bouncedValue, priority);
        final Pair<Task<Void>, DatabaseReference.CompletionListener> wrapped = Utilities.wrapOnComplete(optListener);
        this.repo.scheduleNow(new Runnable(){

            @Override
            public void run() {
                OnDisconnect.this.repo.onDisconnectSetValue(OnDisconnect.this.path, node, (DatabaseReference.CompletionListener)wrapped.getSecond());
            }
        });
        return wrapped.getFirst();
    }

    public Task<Void> updateChildren(Map<String, Object> update) {
        return this.updateChildrenInternal(update, null);
    }

    public void updateChildren(Map<String, Object> update, DatabaseReference.CompletionListener listener) {
        this.updateChildrenInternal(update, listener);
    }

    public ApiFuture<Void> updateChildrenAsync(Map<String, Object> update) {
        return new TaskToApiFuture<Void>(this.updateChildren(update));
    }

    private Task<Void> updateChildrenInternal(final Map<String, Object> update, DatabaseReference.CompletionListener optListener) {
        final Map<Path, Node> parsedUpdate = Validation.parseAndValidateUpdate(this.path, update);
        final Pair<Task<Void>, DatabaseReference.CompletionListener> wrapped = Utilities.wrapOnComplete(optListener);
        this.repo.scheduleNow(new Runnable(){

            @Override
            public void run() {
                OnDisconnect.this.repo.onDisconnectUpdate(OnDisconnect.this.path, parsedUpdate, (DatabaseReference.CompletionListener)wrapped.getSecond(), update);
            }
        });
        return wrapped.getFirst();
    }

    public Task<Void> removeValue() {
        return this.setValue(null);
    }

    public void removeValue(DatabaseReference.CompletionListener listener) {
        this.setValue(null, listener);
    }

    public ApiFuture<Void> removeValueAsync() {
        return new TaskToApiFuture<Void>(this.removeValue());
    }

    public Task<Void> cancel() {
        return this.cancelInternal(null);
    }

    public void cancel(DatabaseReference.CompletionListener listener) {
        this.cancelInternal(listener);
    }

    public ApiFuture<Void> cancelAsync() {
        return new TaskToApiFuture<Void>(this.cancel());
    }

    private Task<Void> cancelInternal(DatabaseReference.CompletionListener optListener) {
        final Pair<Task<Void>, DatabaseReference.CompletionListener> wrapped = Utilities.wrapOnComplete(optListener);
        this.repo.scheduleNow(new Runnable(){

            @Override
            public void run() {
                OnDisconnect.this.repo.onDisconnectCancel(OnDisconnect.this.path, (DatabaseReference.CompletionListener)wrapped.getSecond());
            }
        });
        return wrapped.getFirst();
    }
}

