/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.firebase.auth.FirebaseCredential;
import com.google.firebase.auth.GoogleOAuthAccessToken;
import com.google.firebase.tasks.Task;
import com.google.firebase.tasks.Tasks;
import java.util.List;

public abstract class BaseCredential
implements FirebaseCredential {
    public static final List<String> FIREBASE_SCOPES = ImmutableList.of((Object)"https://www.googleapis.com/auth/firebase.database", (Object)"https://www.googleapis.com/auth/userinfo.email", (Object)"https://www.googleapis.com/auth/identitytoolkit", (Object)"https://www.googleapis.com/auth/devstorage.full_control");
    private final GoogleCredentials googleCredentials;

    public BaseCredential(GoogleCredentials googleCredentials) {
        this.googleCredentials = ((GoogleCredentials)Preconditions.checkNotNull((Object)googleCredentials)).createScoped(FIREBASE_SCOPES);
    }

    public final GoogleCredentials getGoogleCredentials() {
        return this.googleCredentials;
    }

    @Override
    public Task<GoogleOAuthAccessToken> getAccessToken() {
        try {
            AccessToken accessToken = this.googleCredentials.refreshAccessToken();
            GoogleOAuthAccessToken googleToken = new GoogleOAuthAccessToken(accessToken.getTokenValue(), accessToken.getExpirationTime().getTime());
            return Tasks.forResult(googleToken);
        }
        catch (Exception e) {
            return Tasks.forException(e);
        }
    }
}

