/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core;

import com.google.common.base.Preconditions;
import com.google.firebase.database.core.EventTarget;
import com.google.firebase.database.core.ThreadInitializer;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ThreadPoolEventTarget
implements EventTarget,
Thread.UncaughtExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(ThreadPoolEventTarget.class);
    private final ThreadPoolExecutor executor;
    private Thread.UncaughtExceptionHandler exceptionHandler;

    public ThreadPoolEventTarget(final ThreadFactory wrappedFactory, final ThreadInitializer threadInitializer) {
        int poolSize = 1;
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
        this.executor = new ThreadPoolExecutor(poolSize, poolSize, 3L, TimeUnit.SECONDS, queue, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = wrappedFactory.newThread(r);
                threadInitializer.setName(thread, "FirebaseDatabaseEventTarget");
                threadInitializer.setDaemon(thread, true);
                threadInitializer.setUncaughtExceptionHandler(thread, ThreadPoolEventTarget.this);
                return thread;
            }
        });
    }

    public ThreadPoolEventTarget(ThreadPoolExecutor executor) {
        this.executor = (ThreadPoolExecutor)Preconditions.checkNotNull((Object)executor);
    }

    @Override
    public void postEvent(Runnable r) {
        this.executor.execute(r);
    }

    @Override
    public void shutdown() {
        this.executor.setCorePoolSize(0);
    }

    @Override
    public void restart() {
        this.executor.setCorePoolSize(1);
    }

    synchronized Thread.UncaughtExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    synchronized void setExceptionHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncaughtException(Thread t, Throwable e) {
        try {
            Thread.UncaughtExceptionHandler delegate;
            ThreadPoolEventTarget threadPoolEventTarget = this;
            synchronized (threadPoolEventTarget) {
                delegate = this.exceptionHandler;
            }
            if (delegate != null) {
                delegate.uncaughtException(t, e);
            }
        }
        finally {
            logger.error("Event handler threw an exception", e);
        }
    }
}

