/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.connection;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.firebase.database.connection.WebsocketConnection;
import com.google.firebase.internal.GaeThreadFactory;
import com.google.firebase.internal.RevivingScheduledExecutor;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.EOFException;
import java.net.URI;
import java.security.KeyStore;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.TrustManagerFactory;

class NettyWebSocketClient
implements WebsocketConnection.WSClient {
    private static final int DEFAULT_WSS_PORT = 443;
    private final URI uri;
    private final WebsocketConnection.WSClientEventHandler eventHandler;
    private final ChannelHandler channelHandler;
    private final ExecutorService executorService;
    private final EventLoopGroup group;
    private Channel channel;

    NettyWebSocketClient(URI uri, String userAgent, ThreadFactory threadFactory, WebsocketConnection.WSClientEventHandler eventHandler) {
        this.uri = (URI)Preconditions.checkNotNull((Object)uri, (Object)"uri must not be null");
        this.eventHandler = (WebsocketConnection.WSClientEventHandler)Preconditions.checkNotNull((Object)eventHandler, (Object)"event handler must not be null");
        this.channelHandler = new WebSocketClientHandler(uri, userAgent, eventHandler);
        this.executorService = new RevivingScheduledExecutor(threadFactory, "firebase-websocket-worker", GaeThreadFactory.isAvailable());
        this.group = new NioEventLoopGroup(1, (Executor)this.executorService);
    }

    @Override
    public void connect() {
        Preconditions.checkState((this.channel == null ? 1 : 0) != 0, (Object)"channel already initialized");
        try {
            TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustFactory.init((KeyStore)null);
            final SslContext sslContext = SslContextBuilder.forClient().trustManager(trustFactory).build();
            Bootstrap bootstrap = new Bootstrap();
            final int port = this.uri.getPort() != -1 ? this.uri.getPort() : 443;
            ((Bootstrap)((Bootstrap)bootstrap.group(this.group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new ChannelHandler[]{sslContext.newHandler(ch.alloc(), NettyWebSocketClient.this.uri.getHost(), port)});
                    p.addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(32768), NettyWebSocketClient.this.channelHandler});
                }
            });
            ChannelFuture channelFuture = bootstrap.connect(this.uri.getHost(), port);
            this.channel = channelFuture.channel();
            channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        NettyWebSocketClient.this.eventHandler.onError(future.cause());
                    }
                }
            });
        }
        catch (Exception e) {
            this.eventHandler.onError(e);
        }
    }

    @Override
    public void close() {
        Preconditions.checkState((this.channel != null ? 1 : 0) != 0, (Object)"channel not initialized");
        try {
            this.channel.close();
        }
        finally {
            this.group.shutdownGracefully();
            this.executorService.shutdown();
        }
    }

    @Override
    public void send(String msg) {
        Preconditions.checkState((this.channel != null ? 1 : 0) != 0, (Object)"Channel not initialized");
        if (!this.channel.isActive()) {
            this.eventHandler.onError(new EOFException("WebSocket channel became inactive"));
        } else {
            this.channel.writeAndFlush((Object)new TextWebSocketFrame(msg));
        }
    }

    private static class WebSocketClientHandler
    extends SimpleChannelInboundHandler<Object> {
        private final WebsocketConnection.WSClientEventHandler delegate;
        private final WebSocketClientHandshaker handshaker;

        WebSocketClientHandler(URI uri, String userAgent, WebsocketConnection.WSClientEventHandler delegate) {
            this.delegate = (WebsocketConnection.WSClientEventHandler)Preconditions.checkNotNull((Object)delegate, (Object)"delegate must not be null");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)userAgent) ? 1 : 0) != 0, (Object)"user agent must not be null or empty");
            this.handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)uri, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)true, (HttpHeaders)new DefaultHttpHeaders().add("User-Agent", (Object)userAgent));
        }

        public void handlerAdded(ChannelHandlerContext context) {
        }

        public void channelActive(ChannelHandlerContext context) {
            this.handshaker.handshake(context.channel());
        }

        public void channelInactive(ChannelHandlerContext context) {
            this.delegate.onClose();
        }

        public void channelRead0(ChannelHandlerContext context, Object message) throws Exception {
            Channel channel = context.channel();
            if (message instanceof FullHttpResponse) {
                Preconditions.checkState((!this.handshaker.isHandshakeComplete() ? 1 : 0) != 0);
                try {
                    this.handshaker.finishHandshake(channel, (FullHttpResponse)message);
                    this.delegate.onOpen();
                }
                catch (WebSocketHandshakeException e) {
                    this.delegate.onError(e);
                }
            } else if (message instanceof TextWebSocketFrame) {
                this.delegate.onMessage(((TextWebSocketFrame)message).text());
            } else {
                Preconditions.checkState((boolean)(message instanceof CloseWebSocketFrame));
                this.delegate.onClose();
            }
        }

        public void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
            this.delegate.onError(cause);
        }
    }
}

