/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import com.google.api.client.googleapis.auth.oauth2.GooglePublicKeysManager;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.util.Clock;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.firebase.FirebaseApp;
import com.google.firebase.internal.NonNull;

public class KeyManagers {
    private final GooglePublicKeysManager idTokenKeysManager;
    private final GooglePublicKeysManager sessionCookieKeysManager;

    private KeyManagers(GooglePublicKeysManager idTokenKeysManager, GooglePublicKeysManager sessionCookieKeysManager) {
        this.idTokenKeysManager = (GooglePublicKeysManager)Preconditions.checkNotNull((Object)idTokenKeysManager);
        this.sessionCookieKeysManager = (GooglePublicKeysManager)Preconditions.checkNotNull((Object)sessionCookieKeysManager);
    }

    GooglePublicKeysManager getIdTokenKeysManager() {
        return this.idTokenKeysManager;
    }

    GooglePublicKeysManager getSessionCookieKeysManager() {
        return this.sessionCookieKeysManager;
    }

    public static KeyManagers getDefault(@NonNull FirebaseApp app, @NonNull Clock clock) {
        HttpTransport transport = app.getOptions().getHttpTransport();
        return KeyManagers.getDefault(transport, clock);
    }

    @VisibleForTesting
    static KeyManagers getDefault(HttpTransport transport, Clock clock) {
        return new KeyManagers(KeyManagers.createPublicKeysManager(transport, clock, "https://www.googleapis.com/robot/v1/metadata/x509/securetoken@system.gserviceaccount.com"), KeyManagers.createPublicKeysManager(transport, clock, "https://www.googleapis.com/identitytoolkit/v3/relyingparty/publicKeys"));
    }

    private static GooglePublicKeysManager createPublicKeysManager(HttpTransport transport, Clock clock, String certUrl) {
        return new GooglePublicKeysManager.Builder(transport, (JsonFactory)new GsonFactory()).setClock(clock).setPublicCertsEncodedUrl(certUrl).build();
    }
}

