/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core;

import com.google.firebase.database.core.EventTarget;
import com.google.firebase.database.core.ThreadInitializer;
import com.google.firebase.internal.Preconditions;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class ThreadPoolEventTarget
implements EventTarget {
    private final ThreadPoolExecutor executor;

    public ThreadPoolEventTarget(final ThreadFactory wrappedFactory, final ThreadInitializer threadInitializer) {
        int poolSize = 1;
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
        this.executor = new ThreadPoolExecutor(poolSize, poolSize, 3L, TimeUnit.SECONDS, queue, new ThreadFactory(this){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = wrappedFactory.newThread(r);
                threadInitializer.setName(thread, "FirebaseDatabaseEventTarget");
                threadInitializer.setDaemon(thread, true);
                return thread;
            }
        });
    }

    public ThreadPoolEventTarget(ThreadPoolExecutor executor) {
        Preconditions.checkNotNull(executor);
        this.executor = executor;
    }

    @Override
    public void postEvent(Runnable r) {
        this.executor.execute(r);
    }

    @Override
    public void shutdown() {
        this.executor.setCorePoolSize(0);
    }

    @Override
    public void restart() {
        this.executor.setCorePoolSize(1);
    }
}

