/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core;

import com.google.firebase.FirebaseApp;
import com.google.firebase.ImplFirebaseTrampolines;
import com.google.firebase.database.core.AuthTokenProvider;
import com.google.firebase.database.util.GAuthToken;
import com.google.firebase.internal.AuthStateListener;
import com.google.firebase.internal.GetTokenResult;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.Preconditions;
import com.google.firebase.tasks.OnCompleteListener;
import com.google.firebase.tasks.Task;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;

public class JvmAuthTokenProvider
implements AuthTokenProvider {
    private final ScheduledExecutorService executorService;
    private final FirebaseApp firebaseApp;

    public JvmAuthTokenProvider(FirebaseApp firebaseApp, ScheduledExecutorService executorService) {
        this.executorService = executorService;
        this.firebaseApp = firebaseApp;
    }

    @Override
    public void getToken(boolean forceRefresh, final AuthTokenProvider.GetTokenCompletionListener listener) {
        ImplFirebaseTrampolines.getToken(this.firebaseApp, forceRefresh).addOnCompleteListener(this.executorService, new OnCompleteListener<GetTokenResult>(){

            @Override
            public void onComplete(@NonNull Task<GetTokenResult> task) {
                if (task.isSuccessful()) {
                    listener.onSuccess(JvmAuthTokenProvider.wrapOAuthToken(JvmAuthTokenProvider.this.firebaseApp, task.getResult()));
                } else {
                    listener.onError(task.getException().toString());
                }
            }
        });
    }

    @Override
    public void addTokenChangeListener(AuthTokenProvider.TokenChangeListener listener) {
        ImplFirebaseTrampolines.addAuthStateChangeListener(this.firebaseApp, this.wrap(listener));
    }

    @Override
    public void removeTokenChangeListener(AuthTokenProvider.TokenChangeListener listener) {
        ImplFirebaseTrampolines.removeAuthStateChangeListener(this.firebaseApp, this.wrap(listener));
    }

    private AuthStateListener wrap(AuthTokenProvider.TokenChangeListener listener) {
        return new TokenChangeListenerWrapper(listener, this.firebaseApp, this.executorService);
    }

    private static String wrapOAuthToken(FirebaseApp firebaseApp, GetTokenResult result) {
        String oauthToken = result.getToken();
        if (oauthToken == null) {
            return null;
        }
        Map<String, Object> authVariable = firebaseApp.getOptions().getDatabaseAuthVariableOverride();
        GAuthToken gAuthToken = new GAuthToken(oauthToken, authVariable);
        return gAuthToken.serializeToString();
    }

    private static class TokenChangeListenerWrapper
    implements AuthStateListener {
        private final AuthTokenProvider.TokenChangeListener listener;
        private final FirebaseApp firebaseApp;
        private final ScheduledExecutorService executorService;

        TokenChangeListenerWrapper(AuthTokenProvider.TokenChangeListener listener, FirebaseApp firebaseApp, ScheduledExecutorService executorService) {
            this.listener = Preconditions.checkNotNull(listener, "Listener must not be null");
            this.firebaseApp = Preconditions.checkNotNull(firebaseApp, "FirebaseApp must not be null");
            this.executorService = Preconditions.checkNotNull(executorService, "ExecutorService must not be null");
        }

        @Override
        public void onAuthStateChanged(final GetTokenResult tokenResult) {
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    TokenChangeListenerWrapper.this.listener.onTokenChange(JvmAuthTokenProvider.wrapOAuthToken(TokenChangeListenerWrapper.this.firebaseApp, tokenResult));
                }
            });
        }

        public int hashCode() {
            return this.listener.hashCode();
        }

        public boolean equals(Object obj) {
            return obj != null && obj instanceof TokenChangeListenerWrapper && ((TokenChangeListenerWrapper)obj).listener.equals(this.listener);
        }
    }
}

