/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.internal;

import com.google.firebase.internal.GaeScheduledExecutorService;
import com.google.firebase.internal.Log;
import com.google.firebase.internal.Nullable;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class GaeThreadFactory
implements ThreadFactory {
    private static final String TAG = "GaeThreadFactory";
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private ThreadFactory threadFactory;
    private boolean usesBackgroundThreads;
    public static final ScheduledExecutorService DEFAULT_EXECUTOR = new GaeScheduledExecutorService("FirebaseDefault");

    GaeThreadFactory() {
    }

    boolean usesBackgroundThreads() {
        return this.usesBackgroundThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static GaeThreadFactory tryCreate(boolean useBackgroundThreads) {
        GaeThreadFactory factory = new GaeThreadFactory();
        try {
            factory.lock.writeLock().lock();
            if (useBackgroundThreads) {
                factory.threadFactory = GaeThreadFactory.createBackgroundFactory();
                factory.usesBackgroundThreads = true;
            } else {
                factory.threadFactory = GaeThreadFactory.createRequestScopedFactory();
                factory.usesBackgroundThreads = false;
            }
            GaeThreadFactory gaeThreadFactory = factory;
            return gaeThreadFactory;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException ignore) {
            GaeThreadFactory gaeThreadFactory = null;
            return gaeThreadFactory;
        }
        finally {
            factory.lock.writeLock().unlock();
        }
    }

    public static boolean isAvailable() {
        try {
            Class.forName("com.google.appengine.api.ThreadManager");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Thread newThread(Runnable r) {
        Thread thread;
        ThreadFactory threadFactory;
        boolean usesBackgroundThreads = false;
        try {
            this.lock.readLock().lock();
            threadFactory = this.threadFactory;
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (threadFactory != null) {
            return threadFactory.newThread(r);
        }
        try {
            try {
                threadFactory = GaeThreadFactory.createBackgroundFactory();
                thread = threadFactory.newThread(r);
                usesBackgroundThreads = true;
            }
            catch (IllegalStateException e) {
                Log.w(TAG, "Falling back to GAE's request-scoped threads. Firebase requires manually-scaled instances for most operations.");
                threadFactory = GaeThreadFactory.createRequestScopedFactory();
                thread = threadFactory.newThread(r);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Log.w(TAG, "Failed to spawn thread on App Engine, falling back to default thread factory");
            threadFactory = Executors.defaultThreadFactory();
            thread = threadFactory.newThread(r);
        }
        try {
            this.lock.writeLock().lock();
            this.threadFactory = threadFactory;
            this.usesBackgroundThreads = usesBackgroundThreads;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return thread;
    }

    private static ThreadFactory createBackgroundFactory() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> gaeThreadManager = Class.forName("com.google.appengine.api.ThreadManager");
        return (ThreadFactory)gaeThreadManager.getMethod("backgroundThreadFactory", new Class[0]).invoke(null, new Object[0]);
    }

    private static ThreadFactory createRequestScopedFactory() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> gaeThreadManager = Class.forName("com.google.appengine.api.ThreadManager");
        return (ThreadFactory)gaeThreadManager.getMethod("currentRequestThreadFactory", new Class[0]).invoke(null, new Object[0]);
    }
}

