/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.util.Utils;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.firebase.auth.FirebaseCredential;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.Preconditions;
import com.google.firebase.tasks.Continuation;
import com.google.firebase.tasks.Task;
import com.google.firebase.tasks.Tasks;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.json.JSONException;
import org.json.JSONObject;

public class FirebaseCredentials {
    private static final List<String> FIREBASE_SCOPES = Arrays.asList("https://www.googleapis.com/auth/firebase.database", "https://www.googleapis.com/auth/userinfo.email");

    private static String streamToString(InputStream inputStream) throws IOException {
        int length;
        StringBuilder stringBuilder = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        char[] buffer = new char[256];
        while ((length = reader.read(buffer)) != -1) {
            stringBuilder.append(buffer, 0, length);
        }
        inputStream.close();
        return stringBuilder.toString();
    }

    @NonNull
    public static FirebaseCredential applicationDefault() {
        return DefaultCredentialsHolder.INSTANCE;
    }

    @VisibleForTesting
    static FirebaseCredential applicationDefault(HttpTransport transport, JsonFactory jsonFactory) {
        return new ApplicationDefaultCredential(transport, jsonFactory);
    }

    @NonNull
    public static FirebaseCredential fromCertificate(InputStream serviceAccount) {
        Preconditions.checkNotNull(serviceAccount);
        return FirebaseCredentials.fromCertificate(serviceAccount, Utils.getDefaultTransport(), Utils.getDefaultJsonFactory());
    }

    @VisibleForTesting
    static FirebaseCredential fromCertificate(InputStream serviceAccount, HttpTransport transport, JsonFactory jsonFactory) {
        return new CertCredential(serviceAccount, transport, jsonFactory);
    }

    @NonNull
    public static FirebaseCredential fromRefreshToken(InputStream refreshToken) {
        Preconditions.checkNotNull(refreshToken);
        return FirebaseCredentials.fromRefreshToken(refreshToken, Utils.getDefaultTransport(), Utils.getDefaultJsonFactory());
    }

    @VisibleForTesting
    static FirebaseCredential fromRefreshToken(InputStream refreshToken, HttpTransport transport, JsonFactory jsonFactory) {
        return new RefreshTokenCredential(refreshToken, transport, jsonFactory);
    }

    private static class DefaultCredentialsHolder {
        static final FirebaseCredential INSTANCE = FirebaseCredentials.applicationDefault(Utils.getDefaultTransport(), Utils.getDefaultJsonFactory());

        private DefaultCredentialsHolder() {
        }
    }

    static class RefreshTokenCredential
    extends BaseCredential {
        private String jsonData;
        private Exception streamException;

        RefreshTokenCredential(InputStream inputStream, HttpTransport transport, JsonFactory jsonFactory) {
            super(transport, jsonFactory);
            try {
                this.jsonData = FirebaseCredentials.streamToString(inputStream);
            }
            catch (IOException e) {
                this.streamException = new IOException("Failed to read refresh token", e);
            }
        }

        @Override
        GoogleCredential fetchCredential() throws Exception {
            if (this.streamException != null) {
                throw this.streamException;
            }
            GoogleCredential credential = GoogleCredential.fromStream((InputStream)new ByteArrayInputStream(this.jsonData.getBytes("UTF-8")), (HttpTransport)this.transport, (JsonFactory)this.jsonFactory);
            if (credential.getServiceAccountId() != null) {
                throw new IOException("Error reading credentials from stream, 'type' value 'authorized_user' not recognized. Expecting 'service_account'.");
            }
            return credential;
        }

        @Override
        String fetchToken(GoogleCredential credential) throws Exception {
            if (this.streamException != null) {
                throw this.streamException;
            }
            credential.refreshToken();
            String accessToken = credential.getAccessToken();
            if (accessToken == null) {
                throw new AssertionError((Object)"Access token should not be null after refresh.");
            }
            return accessToken;
        }
    }

    static class ApplicationDefaultCredential
    extends BaseCredential {
        ApplicationDefaultCredential(HttpTransport transport, JsonFactory jsonFactory) {
            super(transport, jsonFactory);
        }

        @Override
        GoogleCredential fetchCredential() throws Exception {
            GoogleCredential scopedCredential = GoogleCredential.getApplicationDefault((HttpTransport)this.transport, (JsonFactory)this.jsonFactory).createScoped((Collection)FIREBASE_SCOPES);
            return scopedCredential;
        }

        @Override
        String fetchToken(GoogleCredential credential) throws Exception {
            credential.refreshToken();
            String accessToken = credential.getAccessToken();
            if (accessToken == null) {
                throw new AssertionError((Object)"Access token should not be null after refresh.");
            }
            return accessToken;
        }
    }

    static class CertCredential
    extends BaseCredential {
        private String jsonData;
        private String projectId;
        private Exception streamException;

        CertCredential(InputStream inputStream, HttpTransport transport, JsonFactory jsonFactory) {
            super(transport, jsonFactory);
            try {
                this.jsonData = FirebaseCredentials.streamToString(inputStream);
                JSONObject jsonObject = new JSONObject(this.jsonData);
                this.projectId = jsonObject.getString("project_id");
            }
            catch (IOException e) {
                this.streamException = new IOException("Failed to read service account", e);
            }
            catch (JSONException e) {
                this.streamException = new JSONException("Failed to parse service account: 'project_id' must be set");
            }
        }

        @Override
        GoogleCredential fetchCredential() throws Exception {
            if (this.streamException != null) {
                throw this.streamException;
            }
            GoogleCredential firebaseCredential = GoogleCredential.fromStream((InputStream)new ByteArrayInputStream(this.jsonData.getBytes("UTF-8")), (HttpTransport)this.transport, (JsonFactory)this.jsonFactory);
            if (firebaseCredential.getServiceAccountId() == null) {
                throw new IOException("Error reading credentials from stream, 'type' value 'service_account' not recognized. Expecting 'authorized_user'.");
            }
            return firebaseCredential.createScoped((Collection)FIREBASE_SCOPES);
        }

        @Override
        String fetchToken(GoogleCredential credential) throws Exception {
            if (this.streamException != null) {
                throw this.streamException;
            }
            credential.refreshToken();
            String accessToken = credential.getAccessToken();
            if (accessToken == null) {
                throw new AssertionError((Object)"Access token should not be null after refresh.");
            }
            return accessToken;
        }

        Task<String> getProjectId(boolean forceRefresh) {
            if (this.streamException != null) {
                return Tasks.forException(this.streamException);
            }
            return Tasks.forResult(this.projectId);
        }
    }

    private static abstract class BaseCredential
    implements FirebaseCredential {
        final HttpTransport transport;
        final JsonFactory jsonFactory;
        String accessToken;
        GoogleCredential googleCredential;

        BaseCredential(HttpTransport transport, JsonFactory jsonFactory) {
            this.transport = transport;
            this.jsonFactory = jsonFactory;
        }

        abstract GoogleCredential fetchCredential() throws Exception;

        abstract String fetchToken(GoogleCredential var1) throws Exception;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Task<GoogleCredential> getCertificate(boolean forceRefresh) {
            if (!forceRefresh) {
                BaseCredential baseCredential = this;
                synchronized (baseCredential) {
                    if (this.googleCredential != null) {
                        return Tasks.forResult(this.googleCredential);
                    }
                }
            }
            return Tasks.call(new Callable<GoogleCredential>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public GoogleCredential call() throws Exception {
                    GoogleCredential credential = BaseCredential.this.fetchCredential();
                    BaseCredential baseCredential = BaseCredential.this;
                    synchronized (baseCredential) {
                        BaseCredential.this.googleCredential = credential;
                    }
                    return credential;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Task<String> getAccessToken(boolean forceRefresh) {
            if (!forceRefresh) {
                BaseCredential baseCredential = this;
                synchronized (baseCredential) {
                    if (this.accessToken != null) {
                        return Tasks.forResult(this.accessToken);
                    }
                }
            }
            return this.getCertificate(forceRefresh).continueWith(new Continuation<GoogleCredential, String>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public String then(@NonNull Task<GoogleCredential> task) throws Exception {
                    String token = BaseCredential.this.fetchToken(task.getResult());
                    BaseCredential baseCredential = BaseCredential.this;
                    synchronized (baseCredential) {
                        BaseCredential.this.accessToken = token;
                    }
                    return token;
                }
            });
        }
    }
}

