/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core;

import com.google.firebase.database.core.CompoundWrite;
import com.google.firebase.database.core.Path;
import com.google.firebase.database.core.UserWriteRecord;
import com.google.firebase.database.core.WriteTreeRef;
import com.google.firebase.database.core.utilities.Predicate;
import com.google.firebase.database.core.view.CacheNode;
import com.google.firebase.database.snapshot.ChildKey;
import com.google.firebase.database.snapshot.EmptyNode;
import com.google.firebase.database.snapshot.Index;
import com.google.firebase.database.snapshot.NamedNode;
import com.google.firebase.database.snapshot.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class WriteTree {
    private CompoundWrite visibleWrites = CompoundWrite.emptyWrite();
    private List<UserWriteRecord> allWrites = new ArrayList<UserWriteRecord>();
    private Long lastWriteId = -1L;
    private static final Predicate<UserWriteRecord> DEFAULT_FILTER = new Predicate<UserWriteRecord>(){

        @Override
        public boolean evaluate(UserWriteRecord write) {
            return write.isVisible();
        }
    };

    public WriteTreeRef childWrites(Path path) {
        return new WriteTreeRef(path, this);
    }

    public void addOverwrite(Path path, Node snap, Long writeId, boolean visible) {
        assert (writeId > this.lastWriteId);
        this.allWrites.add(new UserWriteRecord(writeId, path, snap, visible));
        if (visible) {
            this.visibleWrites = this.visibleWrites.addWrite(path, snap);
        }
        this.lastWriteId = writeId;
    }

    public void addMerge(Path path, CompoundWrite changedChildren, Long writeId) {
        assert (writeId > this.lastWriteId);
        this.allWrites.add(new UserWriteRecord(writeId, path, changedChildren));
        this.visibleWrites = this.visibleWrites.addWrites(path, changedChildren);
        this.lastWriteId = writeId;
    }

    public UserWriteRecord getWrite(long writeId) {
        for (UserWriteRecord record : this.allWrites) {
            if (record.getWriteId() != writeId) continue;
            return record;
        }
        return null;
    }

    public List<UserWriteRecord> purgeAllWrites() {
        ArrayList<UserWriteRecord> purgedWrites = new ArrayList<UserWriteRecord>(this.allWrites);
        this.visibleWrites = CompoundWrite.emptyWrite();
        this.allWrites = new ArrayList<UserWriteRecord>();
        return purgedWrites;
    }

    public boolean removeWrite(long writeId) {
        UserWriteRecord writeToRemove = null;
        int idx = 0;
        for (UserWriteRecord record : this.allWrites) {
            if (record.getWriteId() == writeId) {
                writeToRemove = record;
                break;
            }
            ++idx;
        }
        assert (writeToRemove != null) : "removeWrite called with nonexistent writeId";
        this.allWrites.remove(writeToRemove);
        boolean removedWriteWasVisible = writeToRemove.isVisible();
        boolean removedWriteOverlapsWithOtherWrites = false;
        for (int i = this.allWrites.size() - 1; removedWriteWasVisible && i >= 0; --i) {
            UserWriteRecord currentWrite = this.allWrites.get(i);
            if (!currentWrite.isVisible()) continue;
            if (i >= idx && this.recordContainsPath(currentWrite, writeToRemove.getPath())) {
                removedWriteWasVisible = false;
                continue;
            }
            if (!writeToRemove.getPath().contains(currentWrite.getPath())) continue;
            removedWriteOverlapsWithOtherWrites = true;
        }
        if (!removedWriteWasVisible) {
            return false;
        }
        if (removedWriteOverlapsWithOtherWrites) {
            this.resetTree();
            return true;
        }
        if (writeToRemove.isOverwrite()) {
            this.visibleWrites = this.visibleWrites.removeWrite(writeToRemove.getPath());
        } else {
            for (Map.Entry<Path, Node> entry : writeToRemove.getMerge()) {
                Path path = entry.getKey();
                this.visibleWrites = this.visibleWrites.removeWrite(writeToRemove.getPath().child(path));
            }
        }
        return true;
    }

    public Node getCompleteWriteData(Path path) {
        return this.visibleWrites.getCompleteNode(path);
    }

    public Node calcCompleteEventCache(Path treePath, Node completeServerCache) {
        return this.calcCompleteEventCache(treePath, completeServerCache, new ArrayList<Long>());
    }

    public Node calcCompleteEventCache(Path treePath, Node completeServerCache, List<Long> writeIdsToExclude) {
        return this.calcCompleteEventCache(treePath, completeServerCache, writeIdsToExclude, false);
    }

    public Node calcCompleteEventCache(final Path treePath, Node completeServerCache, final List<Long> writeIdsToExclude, final boolean includeHiddenWrites) {
        if (writeIdsToExclude.isEmpty() && !includeHiddenWrites) {
            Node shadowingNode = this.visibleWrites.getCompleteNode(treePath);
            if (shadowingNode != null) {
                return shadowingNode;
            }
            CompoundWrite subMerge = this.visibleWrites.childCompoundWrite(treePath);
            if (subMerge.isEmpty()) {
                return completeServerCache;
            }
            if (completeServerCache == null && !subMerge.hasCompleteWrite(Path.getEmptyPath())) {
                return null;
            }
            Node layeredCache = completeServerCache != null ? completeServerCache : EmptyNode.Empty();
            return subMerge.apply(layeredCache);
        }
        CompoundWrite merge = this.visibleWrites.childCompoundWrite(treePath);
        if (!includeHiddenWrites && merge.isEmpty()) {
            return completeServerCache;
        }
        if (!includeHiddenWrites && completeServerCache == null && !merge.hasCompleteWrite(Path.getEmptyPath())) {
            return null;
        }
        Predicate<UserWriteRecord> filter = new Predicate<UserWriteRecord>(this){

            @Override
            public boolean evaluate(UserWriteRecord write) {
                return !(!write.isVisible() && !includeHiddenWrites || writeIdsToExclude.contains(write.getWriteId()) || !write.getPath().contains(treePath) && !treePath.contains(write.getPath()));
            }
        };
        CompoundWrite mergeAtPath = WriteTree.layerTree(this.allWrites, filter, treePath);
        Node layeredCache = completeServerCache != null ? completeServerCache : EmptyNode.Empty();
        return mergeAtPath.apply(layeredCache);
    }

    public Node calcCompleteEventChildren(Path treePath, Node completeServerChildren) {
        Node completeChildren = EmptyNode.Empty();
        Node topLevelSet = this.visibleWrites.getCompleteNode(treePath);
        if (topLevelSet != null) {
            if (!topLevelSet.isLeafNode()) {
                for (NamedNode childEntry : topLevelSet) {
                    completeChildren = completeChildren.updateImmediateChild(childEntry.getName(), childEntry.getNode());
                }
            }
            return completeChildren;
        }
        CompoundWrite merge = this.visibleWrites.childCompoundWrite(treePath);
        for (NamedNode entry : completeServerChildren) {
            Node node = merge.childCompoundWrite(new Path(entry.getName())).apply(entry.getNode());
            completeChildren = completeChildren.updateImmediateChild(entry.getName(), node);
        }
        for (NamedNode node : merge.getCompleteChildren()) {
            completeChildren = completeChildren.updateImmediateChild(node.getName(), node.getNode());
        }
        return completeChildren;
    }

    public Node calcEventCacheAfterServerOverwrite(Path treePath, Path childPath, Node existingEventSnap, Node existingServerSnap) {
        assert (existingEventSnap != null || existingServerSnap != null) : "Either existingEventSnap or existingServerSnap must exist";
        Path path = treePath.child(childPath);
        if (this.visibleWrites.hasCompleteWrite(path)) {
            return null;
        }
        CompoundWrite childMerge = this.visibleWrites.childCompoundWrite(path);
        if (childMerge.isEmpty()) {
            return existingServerSnap.getChild(childPath);
        }
        return childMerge.apply(existingServerSnap.getChild(childPath));
    }

    public Node calcCompleteChild(Path treePath, ChildKey childKey, CacheNode existingServerSnap) {
        Path path = treePath.child(childKey);
        Node shadowingNode = this.visibleWrites.getCompleteNode(path);
        if (shadowingNode != null) {
            return shadowingNode;
        }
        if (existingServerSnap.isCompleteForChild(childKey)) {
            CompoundWrite childMerge = this.visibleWrites.childCompoundWrite(path);
            return childMerge.apply(existingServerSnap.getNode().getImmediateChild(childKey));
        }
        return null;
    }

    public Node shadowingWrite(Path path) {
        return this.visibleWrites.getCompleteNode(path);
    }

    public NamedNode calcNextNodeAfterPost(Path treePath, Node completeServerData, NamedNode post, boolean reverse, Index index) {
        Node toIterate;
        CompoundWrite merge = this.visibleWrites.childCompoundWrite(treePath);
        Node shadowingNode = merge.getCompleteNode(Path.getEmptyPath());
        if (shadowingNode != null) {
            toIterate = shadowingNode;
        } else if (completeServerData != null) {
            toIterate = merge.apply(completeServerData);
        } else {
            return null;
        }
        NamedNode currentNext = null;
        for (NamedNode node : toIterate) {
            if (index.compare(node, post, reverse) <= 0 || currentNext != null && index.compare(node, currentNext, reverse) >= 0) continue;
            currentNext = node;
        }
        return currentNext;
    }

    private boolean recordContainsPath(UserWriteRecord writeRecord, Path path) {
        if (writeRecord.isOverwrite()) {
            return writeRecord.getPath().contains(path);
        }
        for (Map.Entry<Path, Node> entry : writeRecord.getMerge()) {
            if (!writeRecord.getPath().child(entry.getKey()).contains(path)) continue;
            return true;
        }
        return false;
    }

    private void resetTree() {
        this.visibleWrites = WriteTree.layerTree(this.allWrites, DEFAULT_FILTER, Path.getEmptyPath());
        this.lastWriteId = this.allWrites.size() > 0 ? Long.valueOf(this.allWrites.get(this.allWrites.size() - 1).getWriteId()) : Long.valueOf(-1L);
    }

    private static CompoundWrite layerTree(List<UserWriteRecord> writes, Predicate<UserWriteRecord> filter, Path treeRoot) {
        CompoundWrite compoundWrite = CompoundWrite.emptyWrite();
        for (UserWriteRecord write : writes) {
            Path relativePath;
            if (!filter.evaluate(write)) continue;
            Path writePath = write.getPath();
            if (write.isOverwrite()) {
                if (treeRoot.contains(writePath)) {
                    relativePath = Path.getRelative(treeRoot, writePath);
                    compoundWrite = compoundWrite.addWrite(relativePath, write.getOverwrite());
                    continue;
                }
                if (!writePath.contains(treeRoot)) continue;
                compoundWrite = compoundWrite.addWrite(Path.getEmptyPath(), write.getOverwrite().getChild(Path.getRelative(writePath, treeRoot)));
                continue;
            }
            if (treeRoot.contains(writePath)) {
                relativePath = Path.getRelative(treeRoot, writePath);
                compoundWrite = compoundWrite.addWrites(relativePath, write.getMerge());
                continue;
            }
            if (!writePath.contains(treeRoot)) continue;
            relativePath = Path.getRelative(writePath, treeRoot);
            if (relativePath.isEmpty()) {
                compoundWrite = compoundWrite.addWrites(Path.getEmptyPath(), write.getMerge());
                continue;
            }
            Node deepNode = write.getMerge().getCompleteNode(relativePath);
            if (deepNode == null) continue;
            compoundWrite = compoundWrite.addWrite(Path.getEmptyPath(), deepNode);
        }
        return compoundWrite;
    }
}

