/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.collection;

import com.google.firebase.database.collection.LLRBBlackValueNode;
import com.google.firebase.database.collection.LLRBEmptyNode;
import com.google.firebase.database.collection.LLRBNode;
import com.google.firebase.database.collection.LLRBRedValueNode;
import java.util.Comparator;

public abstract class LLRBValueNode<K, V>
implements LLRBNode<K, V> {
    private final K key;
    private final V value;
    private LLRBNode<K, V> left;
    private final LLRBNode<K, V> right;

    private static LLRBNode.Color oppositeColor(LLRBNode node) {
        return node.isRed() ? LLRBNode.Color.BLACK : LLRBNode.Color.RED;
    }

    LLRBValueNode(K key, V value, LLRBNode<K, V> left, LLRBNode<K, V> right) {
        this.key = key;
        this.value = value;
        this.left = left == null ? LLRBEmptyNode.getInstance() : left;
        this.right = right == null ? LLRBEmptyNode.getInstance() : right;
    }

    @Override
    public LLRBNode<K, V> getLeft() {
        return this.left;
    }

    @Override
    public LLRBNode<K, V> getRight() {
        return this.right;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    protected abstract LLRBNode.Color getColor();

    protected abstract LLRBValueNode<K, V> copy(K var1, V var2, LLRBNode<K, V> var3, LLRBNode<K, V> var4);

    @Override
    public LLRBValueNode<K, V> copy(K key, V value, LLRBNode.Color color, LLRBNode<K, V> left, LLRBNode<K, V> right) {
        LLRBNode<K, V> newRight;
        K newKey = key == null ? this.key : key;
        V newValue = value == null ? this.value : value;
        LLRBNode<K, V> newLeft = left == null ? this.left : left;
        LLRBNode<K, V> lLRBNode = newRight = right == null ? this.right : right;
        if (color == LLRBNode.Color.RED) {
            return new LLRBRedValueNode<K, V>(newKey, newValue, newLeft, newRight);
        }
        return new LLRBBlackValueNode<K, V>(newKey, newValue, newLeft, newRight);
    }

    @Override
    public LLRBNode<K, V> insert(K key, V value, Comparator<K> comparator) {
        LLRBValueNode<Object, Object> n;
        int cmp = comparator.compare(key, this.key);
        if (cmp < 0) {
            LLRBNode<K, V> newLeft = this.left.insert(key, value, comparator);
            n = this.copy(null, null, newLeft, null);
        } else if (cmp == 0) {
            n = this.copy(key, value, null, null);
        } else {
            LLRBNode<K, V> newRight = this.right.insert(key, value, comparator);
            n = this.copy(null, null, null, newRight);
        }
        return super.fixUp();
    }

    @Override
    public LLRBNode<K, V> remove(K key, Comparator<K> comparator) {
        LLRBValueNode<Object, Object> n = this;
        if (comparator.compare(key, n.key) < 0) {
            if (!(n.left.isEmpty() || n.left.isRed() || ((LLRBValueNode)n.left).left.isRed())) {
                n = super.moveRedLeft();
            }
            n = n.copy(null, null, n.left.remove(key, comparator), null);
        } else {
            if (n.left.isRed()) {
                n = n.rotateRight();
            }
            if (!(n.right.isEmpty() || n.right.isRed() || ((LLRBValueNode)n.right).left.isRed())) {
                n = super.moveRedRight();
            }
            if (comparator.compare(key, n.key) == 0) {
                if (n.right.isEmpty()) {
                    return LLRBEmptyNode.getInstance();
                }
                LLRBNode<K, V> smallest = n.right.getMin();
                n = n.copy(smallest.getKey(), smallest.getValue(), null, ((LLRBValueNode)n.right).removeMin());
            }
            n = n.copy(null, null, null, n.right.remove(key, comparator));
        }
        return super.fixUp();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public LLRBNode<K, V> getMin() {
        if (this.left.isEmpty()) {
            return this;
        }
        return this.left.getMin();
    }

    @Override
    public LLRBNode<K, V> getMax() {
        if (this.right.isEmpty()) {
            return this;
        }
        return this.right.getMax();
    }

    @Override
    public int count() {
        return this.left.count() + 1 + this.right.count();
    }

    @Override
    public void inOrderTraversal(LLRBNode.NodeVisitor<K, V> visitor) {
        this.left.inOrderTraversal(visitor);
        visitor.visitEntry(this.key, this.value);
        this.right.inOrderTraversal(visitor);
    }

    @Override
    public boolean shortCircuitingInOrderTraversal(LLRBNode.ShortCircuitingNodeVisitor<K, V> visitor) {
        if (this.left.shortCircuitingInOrderTraversal(visitor) && visitor.shouldContinue(this.key, this.value)) {
            return this.right.shortCircuitingInOrderTraversal(visitor);
        }
        return false;
    }

    @Override
    public boolean shortCircuitingReverseOrderTraversal(LLRBNode.ShortCircuitingNodeVisitor<K, V> visitor) {
        if (this.right.shortCircuitingReverseOrderTraversal(visitor) && visitor.shouldContinue(this.key, this.value)) {
            return this.left.shortCircuitingReverseOrderTraversal(visitor);
        }
        return false;
    }

    void setLeft(LLRBNode<K, V> left) {
        this.left = left;
    }

    private LLRBNode<K, V> removeMin() {
        if (this.left.isEmpty()) {
            return LLRBEmptyNode.getInstance();
        }
        LLRBValueNode<Object, Object> n = this;
        if (!n.getLeft().isRed() && !n.getLeft().getLeft().isRed()) {
            n = n.moveRedLeft();
        }
        n = n.copy(null, null, ((LLRBValueNode)n.left).removeMin(), null);
        return super.fixUp();
    }

    private LLRBValueNode<K, V> moveRedLeft() {
        LLRBValueNode<Object, Object> n = this.colorFlip();
        if (n.getRight().getLeft().isRed()) {
            n = n.copy(null, null, null, ((LLRBValueNode)n.getRight()).rotateRight());
            n = super.rotateLeft();
            n = super.colorFlip();
        }
        return n;
    }

    private LLRBValueNode<K, V> moveRedRight() {
        LLRBValueNode<K, V> n = this.colorFlip();
        if (n.getLeft().getLeft().isRed()) {
            n = super.rotateRight();
            n = super.colorFlip();
        }
        return n;
    }

    private LLRBValueNode<K, V> fixUp() {
        LLRBValueNode<K, V> n = this;
        if (n.right.isRed() && !n.left.isRed()) {
            n = n.rotateLeft();
        }
        if (n.left.isRed() && ((LLRBValueNode)n.left).left.isRed()) {
            n = super.rotateRight();
        }
        if (n.left.isRed() && n.right.isRed()) {
            n = super.colorFlip();
        }
        return n;
    }

    private LLRBValueNode<K, V> rotateLeft() {
        LLRBNode newLeft = this.copy((Object)null, (Object)null, LLRBNode.Color.RED, (LLRBNode)null, (LLRBNode)((LLRBValueNode)this.right).left);
        return (LLRBValueNode)this.right.copy(null, null, this.getColor(), newLeft, null);
    }

    private LLRBValueNode<K, V> rotateRight() {
        LLRBNode newRight = this.copy((Object)null, (Object)null, LLRBNode.Color.RED, (LLRBNode)((LLRBValueNode)this.left).right, (LLRBNode)null);
        return (LLRBValueNode)this.left.copy(null, null, this.getColor(), null, newRight);
    }

    private LLRBValueNode<K, V> colorFlip() {
        LLRBNode<Object, Object> newLeft = this.left.copy(null, null, LLRBValueNode.oppositeColor(this.left), null, null);
        LLRBNode<Object, Object> newRight = this.right.copy(null, null, LLRBValueNode.oppositeColor(this.right), null, null);
        return this.copy((Object)null, (Object)null, LLRBValueNode.oppositeColor(this), (LLRBNode)newLeft, (LLRBNode)newRight);
    }
}

