/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.abt;

import android.text.TextUtils;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.abt.AbtException;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class AbtExperimentInfo {
    @VisibleForTesting
    static final String EXPERIMENT_ID_KEY = "experimentId";
    @VisibleForTesting
    static final String VARIANT_ID_KEY = "variantId";
    @VisibleForTesting
    static final String TRIGGER_EVENT_KEY = "triggerEvent";
    @VisibleForTesting
    static final String EXPERIMENT_START_TIME_KEY = "experimentStartTime";
    @VisibleForTesting
    static final String TRIGGER_TIMEOUT_KEY = "triggerTimeoutMillis";
    @VisibleForTesting
    static final String TIME_TO_LIVE_KEY = "timeToLiveMillis";
    private static final String[] ALL_REQUIRED_KEYS = new String[]{"experimentId", "experimentStartTime", "timeToLiveMillis", "triggerTimeoutMillis", "variantId"};
    @VisibleForTesting
    static final DateFormat protoTimestampStringParser = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US);
    private final String experimentId;
    private final String variantId;
    private final String triggerEventName;
    private final Date experimentStartTime;
    private final long triggerTimeoutInMillis;
    private final long timeToLiveInMillis;

    public AbtExperimentInfo(String experimentId, String variantId, String triggerEventName, Date experimentStartTime, long triggerTimeoutInMillis, long timeToLiveInMillis) {
        this.experimentId = experimentId;
        this.variantId = variantId;
        this.triggerEventName = triggerEventName;
        this.experimentStartTime = experimentStartTime;
        this.triggerTimeoutInMillis = triggerTimeoutInMillis;
        this.timeToLiveInMillis = timeToLiveInMillis;
    }

    static AbtExperimentInfo fromMap(Map<String, String> experimentInfoMap) throws AbtException {
        AbtExperimentInfo.validateExperimentInfoMap(experimentInfoMap);
        try {
            Date experimentStartTime = protoTimestampStringParser.parse(experimentInfoMap.get(EXPERIMENT_START_TIME_KEY));
            long triggerTimeoutInMillis = Long.parseLong(experimentInfoMap.get(TRIGGER_TIMEOUT_KEY));
            long timeToLiveInMillis = Long.parseLong(experimentInfoMap.get(TIME_TO_LIVE_KEY));
            return new AbtExperimentInfo(experimentInfoMap.get(EXPERIMENT_ID_KEY), experimentInfoMap.get(VARIANT_ID_KEY), experimentInfoMap.containsKey(TRIGGER_EVENT_KEY) ? experimentInfoMap.get(TRIGGER_EVENT_KEY) : "", experimentStartTime, triggerTimeoutInMillis, timeToLiveInMillis);
        }
        catch (ParseException e) {
            throw new AbtException("Could not process experiment: parsing experiment start time failed.", e);
        }
        catch (NumberFormatException e) {
            throw new AbtException("Could not process experiment: one of the durations could not be converted into a long.", e);
        }
    }

    String getExperimentId() {
        return this.experimentId;
    }

    String getVariantId() {
        return this.variantId;
    }

    String getTriggerEventName() {
        return this.triggerEventName;
    }

    long getStartTimeInMillisSinceEpoch() {
        return this.experimentStartTime.getTime();
    }

    long getTriggerTimeoutInMillis() {
        return this.triggerTimeoutInMillis;
    }

    long getTimeToLiveInMillis() {
        return this.timeToLiveInMillis;
    }

    private static void validateExperimentInfoMap(Map<String, String> experimentInfoMap) throws AbtException {
        ArrayList<String> missingKeys = new ArrayList<String>();
        for (String key : ALL_REQUIRED_KEYS) {
            if (experimentInfoMap.containsKey(key)) continue;
            missingKeys.add(key);
        }
        if (!missingKeys.isEmpty()) {
            throw new AbtException(String.format("The following keys are missing from the experiment info map: %s", missingKeys));
        }
    }

    static void validateAbtExperimentInfo(AbtExperimentInfo experimentInfo) throws AbtException {
        AbtExperimentInfo.validateExperimentInfoMap(experimentInfo.toStringMap());
    }

    @VisibleForTesting
    Map<String, String> toStringMap() {
        HashMap<String, String> experimentInfoMap = new HashMap<String, String>();
        experimentInfoMap.put(EXPERIMENT_ID_KEY, this.experimentId);
        experimentInfoMap.put(VARIANT_ID_KEY, this.variantId);
        experimentInfoMap.put(TRIGGER_EVENT_KEY, this.triggerEventName);
        experimentInfoMap.put(EXPERIMENT_START_TIME_KEY, protoTimestampStringParser.format(this.experimentStartTime));
        experimentInfoMap.put(TRIGGER_TIMEOUT_KEY, Long.toString(this.triggerTimeoutInMillis));
        experimentInfoMap.put(TIME_TO_LIVE_KEY, Long.toString(this.timeToLiveInMillis));
        return experimentInfoMap;
    }

    AnalyticsConnector.ConditionalUserProperty toConditionalUserProperty(String originService) {
        AnalyticsConnector.ConditionalUserProperty conditionalUserProperty = new AnalyticsConnector.ConditionalUserProperty();
        conditionalUserProperty.origin = originService;
        conditionalUserProperty.creationTimestamp = this.getStartTimeInMillisSinceEpoch();
        conditionalUserProperty.name = this.experimentId;
        conditionalUserProperty.value = this.variantId;
        conditionalUserProperty.triggerEventName = TextUtils.isEmpty((CharSequence)this.triggerEventName) ? null : this.triggerEventName;
        conditionalUserProperty.triggerTimeout = this.triggerTimeoutInMillis;
        conditionalUserProperty.timeToLive = this.timeToLiveInMillis;
        return conditionalUserProperty;
    }

    static AbtExperimentInfo fromConditionalUserProperty(AnalyticsConnector.ConditionalUserProperty conditionalUserProperty) {
        String triggerEventName = "";
        if (conditionalUserProperty.triggerEventName != null) {
            triggerEventName = conditionalUserProperty.triggerEventName;
        }
        return new AbtExperimentInfo(conditionalUserProperty.name, String.valueOf(conditionalUserProperty.value), triggerEventName, new Date(conditionalUserProperty.creationTimestamp), conditionalUserProperty.triggerTimeout, conditionalUserProperty.timeToLive);
    }
}

