/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.abt.component;

import android.content.Context;
import androidx.annotation.GuardedBy;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.abt.FirebaseABTesting;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.inject.Provider;
import java.util.HashMap;
import java.util.Map;

public class AbtComponent {
    @GuardedBy(value="this")
    private final Map<String, FirebaseABTesting> abtOriginInstances = new HashMap<String, FirebaseABTesting>();
    private final Context appContext;
    private final Provider<AnalyticsConnector> analyticsConnector;

    @VisibleForTesting(otherwise=3)
    protected AbtComponent(Context appContext, Provider<AnalyticsConnector> analyticsConnector) {
        this.appContext = appContext;
        this.analyticsConnector = analyticsConnector;
    }

    public synchronized FirebaseABTesting get(String originService) {
        if (!this.abtOriginInstances.containsKey(originService)) {
            this.abtOriginInstances.put(originService, this.createAbtInstance(originService));
        }
        return this.abtOriginInstances.get(originService);
    }

    @VisibleForTesting
    protected FirebaseABTesting createAbtInstance(String originService) {
        return new FirebaseABTesting(this.appContext, this.analyticsConnector, originService);
    }
}

