package com.google.api.servicecontrol.v1;

import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;

/**
 * <pre>
 * [Google Quota Control API](/service-control/overview)
 * (-- See //google/api/servicecontrol/doc/overview.md for details. --)
 * Allows clients to allocate and release quota against
 * a [managed service][google.api.servicemanagement.v1.ManagedService].
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 0.15.0)",
    comments = "Source: google/api/servicecontrol/v1/quota_controller.proto")
public class QuotaControllerGrpc {

  private QuotaControllerGrpc() {}

  public static final String SERVICE_NAME = "google.api.servicecontrol.v1.QuotaController";

  // Static method descriptors that strictly reflect the proto.
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<com.google.api.servicecontrol.v1.AllocateQuotaRequest,
      com.google.api.servicecontrol.v1.AllocateQuotaResponse> METHOD_ALLOCATE_QUOTA =
      io.grpc.MethodDescriptor.create(
          io.grpc.MethodDescriptor.MethodType.UNARY,
          generateFullMethodName(
              "google.api.servicecontrol.v1.QuotaController", "AllocateQuota"),
          io.grpc.protobuf.ProtoUtils.marshaller(com.google.api.servicecontrol.v1.AllocateQuotaRequest.getDefaultInstance()),
          io.grpc.protobuf.ProtoUtils.marshaller(com.google.api.servicecontrol.v1.AllocateQuotaResponse.getDefaultInstance()));

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static QuotaControllerStub newStub(io.grpc.Channel channel) {
    return new QuotaControllerStub(channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static QuotaControllerBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    return new QuotaControllerBlockingStub(channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary and streaming output calls on the service
   */
  public static QuotaControllerFutureStub newFutureStub(
      io.grpc.Channel channel) {
    return new QuotaControllerFutureStub(channel);
  }

  /**
   * <pre>
   * [Google Quota Control API](/service-control/overview)
   * (-- See //google/api/servicecontrol/doc/overview.md for details. --)
   * Allows clients to allocate and release quota against
   * a [managed service][google.api.servicemanagement.v1.ManagedService].
   * </pre>
   */
  @java.lang.Deprecated public static interface QuotaController {

    /**
     * <pre>
     * Attempts to allocate quota for the specified consumer. It should be called
     * before the operation is executed.
     * This method requires the `servicemanagement.services.quota`
     * permission on the specified service. For more information, see
     * [Google Cloud IAM](https://cloud.google.com/iam).
     * </pre>
     */
    public void allocateQuota(com.google.api.servicecontrol.v1.AllocateQuotaRequest request,
        io.grpc.stub.StreamObserver<com.google.api.servicecontrol.v1.AllocateQuotaResponse> responseObserver);
  }

  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1469")
  public static abstract class QuotaControllerImplBase implements QuotaController, io.grpc.BindableService {

    @java.lang.Override
    public void allocateQuota(com.google.api.servicecontrol.v1.AllocateQuotaRequest request,
        io.grpc.stub.StreamObserver<com.google.api.servicecontrol.v1.AllocateQuotaResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_ALLOCATE_QUOTA, responseObserver);
    }

    @java.lang.Override public io.grpc.ServerServiceDefinition bindService() {
      return QuotaControllerGrpc.bindService(this);
    }
  }

  /**
   * <pre>
   * [Google Quota Control API](/service-control/overview)
   * (-- See //google/api/servicecontrol/doc/overview.md for details. --)
   * Allows clients to allocate and release quota against
   * a [managed service][google.api.servicemanagement.v1.ManagedService].
   * </pre>
   */
  @java.lang.Deprecated public static interface QuotaControllerBlockingClient {

    /**
     * <pre>
     * Attempts to allocate quota for the specified consumer. It should be called
     * before the operation is executed.
     * This method requires the `servicemanagement.services.quota`
     * permission on the specified service. For more information, see
     * [Google Cloud IAM](https://cloud.google.com/iam).
     * </pre>
     */
    public com.google.api.servicecontrol.v1.AllocateQuotaResponse allocateQuota(com.google.api.servicecontrol.v1.AllocateQuotaRequest request);
  }

  /**
   * <pre>
   * [Google Quota Control API](/service-control/overview)
   * (-- See //google/api/servicecontrol/doc/overview.md for details. --)
   * Allows clients to allocate and release quota against
   * a [managed service][google.api.servicemanagement.v1.ManagedService].
   * </pre>
   */
  @java.lang.Deprecated public static interface QuotaControllerFutureClient {

    /**
     * <pre>
     * Attempts to allocate quota for the specified consumer. It should be called
     * before the operation is executed.
     * This method requires the `servicemanagement.services.quota`
     * permission on the specified service. For more information, see
     * [Google Cloud IAM](https://cloud.google.com/iam).
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.google.api.servicecontrol.v1.AllocateQuotaResponse> allocateQuota(
        com.google.api.servicecontrol.v1.AllocateQuotaRequest request);
  }

  public static class QuotaControllerStub extends io.grpc.stub.AbstractStub<QuotaControllerStub>
      implements QuotaController {
    private QuotaControllerStub(io.grpc.Channel channel) {
      super(channel);
    }

    private QuotaControllerStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected QuotaControllerStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new QuotaControllerStub(channel, callOptions);
    }

    @java.lang.Override
    public void allocateQuota(com.google.api.servicecontrol.v1.AllocateQuotaRequest request,
        io.grpc.stub.StreamObserver<com.google.api.servicecontrol.v1.AllocateQuotaResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_ALLOCATE_QUOTA, getCallOptions()), request, responseObserver);
    }
  }

  public static class QuotaControllerBlockingStub extends io.grpc.stub.AbstractStub<QuotaControllerBlockingStub>
      implements QuotaControllerBlockingClient {
    private QuotaControllerBlockingStub(io.grpc.Channel channel) {
      super(channel);
    }

    private QuotaControllerBlockingStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected QuotaControllerBlockingStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new QuotaControllerBlockingStub(channel, callOptions);
    }

    @java.lang.Override
    public com.google.api.servicecontrol.v1.AllocateQuotaResponse allocateQuota(com.google.api.servicecontrol.v1.AllocateQuotaRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_ALLOCATE_QUOTA, getCallOptions(), request);
    }
  }

  public static class QuotaControllerFutureStub extends io.grpc.stub.AbstractStub<QuotaControllerFutureStub>
      implements QuotaControllerFutureClient {
    private QuotaControllerFutureStub(io.grpc.Channel channel) {
      super(channel);
    }

    private QuotaControllerFutureStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected QuotaControllerFutureStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new QuotaControllerFutureStub(channel, callOptions);
    }

    @java.lang.Override
    public com.google.common.util.concurrent.ListenableFuture<com.google.api.servicecontrol.v1.AllocateQuotaResponse> allocateQuota(
        com.google.api.servicecontrol.v1.AllocateQuotaRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_ALLOCATE_QUOTA, getCallOptions()), request);
    }
  }

  @java.lang.Deprecated public static abstract class AbstractQuotaController extends QuotaControllerImplBase {}

  private static final int METHODID_ALLOCATE_QUOTA = 0;

  private static class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final QuotaController serviceImpl;
    private final int methodId;

    public MethodHandlers(QuotaController serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_ALLOCATE_QUOTA:
          serviceImpl.allocateQuota((com.google.api.servicecontrol.v1.AllocateQuotaRequest) request,
              (io.grpc.stub.StreamObserver<com.google.api.servicecontrol.v1.AllocateQuotaResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    return new io.grpc.ServiceDescriptor(SERVICE_NAME,
        METHOD_ALLOCATE_QUOTA);
  }

  @java.lang.Deprecated public static io.grpc.ServerServiceDefinition bindService(
      final QuotaController serviceImpl) {
    return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
        .addMethod(
          METHOD_ALLOCATE_QUOTA,
          asyncUnaryCall(
            new MethodHandlers<
              com.google.api.servicecontrol.v1.AllocateQuotaRequest,
              com.google.api.servicecontrol.v1.AllocateQuotaResponse>(
                serviceImpl, METHODID_ALLOCATE_QUOTA)))
        .build();
  }
}
