/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.config;

import com.google.api.Service;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.config.Environment;
import com.google.api.config.ServiceConfigException;
import com.google.api.services.servicemanagement.ServiceManagement;
import com.google.api.services.servicemanagement.model.ListServiceConfigsResponse;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import javax.annotation.Nullable;

public final class ServiceConfigSupplier
implements Supplier<Service> {
    private static final String SERVICE_NAME_KEY = "ENDPOINTS_SERVICE_NAME";
    private static final String SERVICE_VERSION_KEY = "ENDPOINTS_SERVICE_VERSION";
    private static final List<String> SCOPES = ImmutableList.of((Object)"https://www.googleapis.com/auth/cloud-platform");
    private static final String FIELD_MASKS = Joiner.on((char)',').join((Object)"authentication", (Object)"http", new Object[]{"id", "logging", "logs", "metrics", "monitored_resources", "monitoring", "name", "producer_project_id", "quota", "system_parameters", "usage"});
    private final Environment environment;
    private final ServiceManagement serviceManagement;

    @VisibleForTesting
    ServiceConfigSupplier(Environment environment, HttpTransport httpTransport, JsonFactory jsonFactory, final GoogleCredential credential) {
        this.environment = environment;
        HttpRequestInitializer requestInitializer = new HttpRequestInitializer(){

            public void initialize(HttpRequest request) throws IOException {
                request.setThrowExceptionOnExecuteError(false);
                credential.initialize(request);
            }
        };
        this.serviceManagement = new ServiceManagement.Builder(httpTransport, jsonFactory, requestInitializer).setApplicationName("Endpoints Frameworks Java").build();
    }

    public Service get() {
        String serviceName = this.environment.getVariable(SERVICE_NAME_KEY);
        if (Strings.isNullOrEmpty((String)serviceName)) {
            String errorMessage = String.format("Environment variable '%s' is not set", SERVICE_NAME_KEY);
            throw new IllegalArgumentException(errorMessage);
        }
        String serviceVersion = this.environment.getVariable(SERVICE_VERSION_KEY);
        return this.fetch(serviceName, serviceVersion);
    }

    private Service fetch(String serviceName, @Nullable String serviceVersion) {
        HttpResponse httpResponse;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)serviceName) ? 1 : 0) != 0, (Object)"service name must be specified");
        if (serviceVersion == null) {
            serviceVersion = this.fetchLatestServiceVersion(serviceName);
        }
        try {
            httpResponse = this.serviceManagement.services().configs().get(serviceName, serviceVersion).setFields(FIELD_MASKS).executeUnparsed();
        }
        catch (IOException exception) {
            throw new ServiceConfigException(exception);
        }
        int statusCode = httpResponse.getStatusCode();
        if (statusCode != 200) {
            String message = MessageFormat.format("Failed to fetch service config (status code {0})", statusCode);
            throw new ServiceConfigException(message);
        }
        Service service = ServiceConfigSupplier.parseHttpResponse(httpResponse);
        ServiceConfigSupplier.validateServiceConfig(service, serviceName, serviceVersion);
        return service;
    }

    private String fetchLatestServiceVersion(String serviceName) {
        try {
            ListServiceConfigsResponse response = (ListServiceConfigsResponse)this.serviceManagement.services().configs().list(serviceName).execute();
            if (response.getServiceConfigs() == null || response.getServiceConfigs().isEmpty()) {
                throw new ServiceConfigException(MessageFormat.format("Failed to fetch default config version for service ''{0}''. No versions exist!", serviceName));
            }
            return ((com.google.api.services.servicemanagement.model.Service)response.getServiceConfigs().get(0)).getId();
        }
        catch (IOException e) {
            throw new ServiceConfigException(e);
        }
    }

    private static Service parseHttpResponse(HttpResponse httpResponse) {
        try {
            Service.Builder builder = Service.newBuilder();
            JsonFormat.parser().merge(httpResponse.parseAsString(), (Message.Builder)builder);
            return builder.build();
        }
        catch (IOException exception) {
            throw new ServiceConfigException("Failed to parse the HTTP response as service configuration", exception);
        }
    }

    private static void validateServiceConfig(Service service, String expectedServiceName, @Nullable String expectedServiceVersion) {
        String serviceName = service.getName();
        if (!expectedServiceName.equals(serviceName)) {
            throw new ServiceConfigException("Unexpected service name in service config: " + serviceName);
        }
        String serviceVersion = service.getId();
        if (expectedServiceVersion != null && !expectedServiceVersion.equals(serviceVersion)) {
            throw new ServiceConfigException("Unexpected service version in service config: " + serviceVersion);
        }
    }

    public static ServiceConfigSupplier create() {
        GoogleCredential credential;
        NetHttpTransport httpTransport = new NetHttpTransport();
        JacksonFactory jsonFactory = new JacksonFactory();
        try {
            credential = GoogleCredential.getApplicationDefault((HttpTransport)httpTransport, (JsonFactory)jsonFactory).createScoped(SCOPES);
        }
        catch (IOException e) {
            throw new IllegalStateException("could not get credentials for fetching service config!");
        }
        return new ServiceConfigSupplier(new SystemEnvironment(), (HttpTransport)httpTransport, (JsonFactory)jsonFactory, credential);
    }

    private static final class SystemEnvironment
    implements Environment {
        private SystemEnvironment() {
        }

        @Override
        public String getVariable(String variableName) {
            return System.getenv(variableName);
        }
    }
}

