/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.response;

import com.google.api.server.spi.ServiceException;
import com.google.api.server.spi.config.model.ApiSerializationConfig;
import com.google.api.server.spi.response.ErrorMap;
import com.google.api.server.spi.response.ServletResponseResultWriter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;

public class RestResponseResultWriter
extends ServletResponseResultWriter {
    private final boolean enableExceptionCompatibility;

    public RestResponseResultWriter(HttpServletResponse servletResponse, ApiSerializationConfig serializationConfig, boolean prettyPrint, boolean enableExceptionCompatibility) {
        super(servletResponse, serializationConfig, prettyPrint);
        this.enableExceptionCompatibility = enableExceptionCompatibility;
    }

    @Override
    public void writeError(ServiceException e) throws IOException {
        ErrorMap errorMap = new ErrorMap(this.enableExceptionCompatibility);
        int code = errorMap.getHttpStatus(e.getStatusCode());
        String reason = !Strings.isNullOrEmpty((String)e.getReason()) ? e.getReason() : errorMap.getReason(e.getStatusCode());
        String domain = !Strings.isNullOrEmpty((String)e.getDomain()) ? e.getDomain() : errorMap.getDomain(e.getStatusCode());
        this.write(code, e.getHeaders(), this.writeValueAsString(this.createError(code, reason, domain, e.getMessage())));
    }

    private Object createError(int code, String reason, String domain, String message) {
        return ImmutableMap.of((Object)"error", (Object)ImmutableMap.of((Object)"errors", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"domain", (Object)domain, (Object)"reason", (Object)reason, (Object)"message", (Object)message)), (Object)"code", (Object)code, (Object)"message", (Object)message));
    }
}

