/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.handlers;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CorsHandler {
    private static final Set<String> ALLOWED_METHODS = ImmutableSortedSet.of((Comparable)((Object)"HEAD"), (Comparable)((Object)"DELETE"), (Comparable)((Object)"GET"), (Comparable)((Object)"PATCH"), (Comparable)((Object)"POST"), (Comparable)((Object)"PUT"), (Comparable[])new String[0]);
    public static final String ALLOWED_METHODS_STRING = Joiner.on((char)',').join(ALLOWED_METHODS);
    private static final String NULL_ORIGIN = "null";

    public void handle(HttpServletRequest request, HttpServletResponse response) {
        if (this.isValidMethod(request)) {
            CorsHandler.allowOrigin(request, response);
            this.allowMethods(response);
            this.allowHeaders(request, response);
            this.setMaxAge(response);
            CorsHandler.setAccessControlAllowCredentials(response);
        }
    }

    public static void allowOrigin(HttpServletRequest request, HttpServletResponse response) {
        String origin = request.getHeader("Origin");
        origin = NULL_ORIGIN.equals(origin) ? "*" : origin;
        response.setHeader("Access-Control-Allow-Origin", origin);
    }

    public static void setAccessControlAllowCredentials(HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Credentials", "true");
    }

    private void setMaxAge(HttpServletResponse response) {
        response.setHeader("Access-Control-Max-Age", "3600");
    }

    private void allowHeaders(HttpServletRequest request, HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Headers", request.getHeader("Access-Control-Request-Headers"));
    }

    private void allowMethods(HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Methods", ALLOWED_METHODS_STRING);
    }

    private boolean isValidMethod(HttpServletRequest request) {
        return ALLOWED_METHODS.contains(request.getHeader("Access-Control-Request-Method"));
    }
}

